/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecordingErrorListener
implements AnalysisErrorListener {
    private Map<Source, HashSet<AnalysisError>> errors = new HashMap<Source, HashSet<AnalysisError>>();

    public void addAll(RecordingErrorListener recordingErrorListener) {
        for (AnalysisError analysisError : recordingErrorListener.getErrors()) {
            this.onError(analysisError);
        }
    }

    public AnalysisError[] getErrors() {
        Set<Map.Entry<Source, HashSet<AnalysisError>>> set = this.errors.entrySet();
        int n = set.size();
        if (n == 0) {
            return AnalysisError.NO_ERRORS;
        }
        ArrayList arrayList = new ArrayList(n);
        for (Map.Entry entry : set) {
            arrayList.addAll((Collection)entry.getValue());
        }
        return arrayList.toArray(new AnalysisError[arrayList.size()]);
    }

    public AnalysisError[] getErrorsForSource(Source source) {
        HashSet<AnalysisError> hashSet = this.errors.get(source);
        if (hashSet == null) {
            return AnalysisError.NO_ERRORS;
        }
        return hashSet.toArray(new AnalysisError[hashSet.size()]);
    }

    @Override
    public void onError(AnalysisError analysisError) {
        Source source = analysisError.getSource();
        HashSet<AnalysisError> hashSet = this.errors.get(source);
        if (this.errors.get(source) == null) {
            hashSet = new HashSet();
            this.errors.put(source, hashSet);
        }
        hashSet.add(analysisError);
    }
}

