/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContentStatistics;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisErrorInfo;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.context.AnalysisOptions;
import com.google.dart.engine.context.AnalysisResult;
import com.google.dart.engine.context.ChangeSet;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.internal.context.DelegatingAnalysisContextImpl;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.context.TimestampedData;
import com.google.dart.engine.internal.element.angular.AngularApplication;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;
import com.google.dart.engine.source.SourceFactory;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.instrumentation.InstrumentationBuilder;
import com.google.dart.engine.utilities.source.LineInfo;
import com.google.dart.engine.utilities.translation.DartBlockBody;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class InstrumentedAnalysisContextImpl
implements InternalAnalysisContext {
    @DartOmit
    private static Thread uiThread;
    private final String contextId = UUID.randomUUID().toString();
    private final InternalAnalysisContext basis;

    @DartOmit
    public static void setUIThread(Thread thread) {
        uiThread = thread;
    }

    @DartBlockBody(value={})
    private static void checkThread(InstrumentationBuilder instrumentationBuilder) {
        if (Thread.currentThread() == uiThread) {
            instrumentationBuilder.metric("isUIThread", true);
            String string = "Call to analysis on UI thread";
            AnalysisEngine.getInstance().getLogger().logInformation(string, new RuntimeException(string));
        }
    }

    private static void recordAnalysisException(InstrumentationBuilder instrumentationBuilder, AnalysisException analysisException) {
        instrumentationBuilder.record(analysisException);
    }

    public InstrumentedAnalysisContextImpl() {
        this(new DelegatingAnalysisContextImpl());
    }

    public InstrumentedAnalysisContextImpl(InternalAnalysisContext internalAnalysisContext) {
        this.basis = internalAnalysisContext;
    }

    @Override
    public void addSourceInfo(Source source, SourceEntry sourceEntry) {
        this.basis.addSourceInfo(source, sourceEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChanges(ChangeSet changeSet) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-applyChanges");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.applyChanges(changeSet);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String computeDocumentationComment(Element element) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-computeDocumentationComment");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            String string = this.basis.computeDocumentationComment(element);
            return string;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisError[] computeErrors(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-computeErrors");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            AnalysisError[] analysisErrorArray = this.basis.computeErrors(source);
            instrumentationBuilder.metric("Errors-count", analysisErrorArray.length);
            AnalysisError[] analysisErrorArray2 = analysisErrorArray;
            return analysisErrorArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public Source[] computeExportedLibraries(Source source) throws AnalysisException {
        return this.basis.computeExportedLibraries(source);
    }

    @Override
    public HtmlElement computeHtmlElement(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-computeHtmlElement");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            HtmlElement htmlElement = this.basis.computeHtmlElement(source);
            return htmlElement;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public Source[] computeImportedLibraries(Source source) throws AnalysisException {
        return this.basis.computeImportedLibraries(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceKind computeKindOf(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-computeKindOf");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            SourceKind sourceKind = this.basis.computeKindOf(source);
            return sourceKind;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public LibraryElement computeLibraryElement(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-computeLibraryElement");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            LibraryElement libraryElement = this.basis.computeLibraryElement(source);
            return libraryElement;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public LineInfo computeLineInfo(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-computeLineInfo");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            LineInfo lineInfo = this.basis.computeLineInfo(source);
            return lineInfo;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public ResolvableCompilationUnit computeResolvableCompilationUnit(Source source) throws AnalysisException {
        return this.basis.computeResolvableCompilationUnit(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-dispose");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.dispose();
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-exists");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            boolean bl = this.basis.exists(source);
            return bl;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisContext extractContext(SourceContainer sourceContainer) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-extractContext");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            InstrumentedAnalysisContextImpl instrumentedAnalysisContextImpl = new InstrumentedAnalysisContextImpl();
            this.basis.extractContextInto(sourceContainer, instrumentedAnalysisContextImpl.basis);
            InstrumentedAnalysisContextImpl instrumentedAnalysisContextImpl2 = instrumentedAnalysisContextImpl;
            return instrumentedAnalysisContextImpl2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public InternalAnalysisContext extractContextInto(SourceContainer sourceContainer, InternalAnalysisContext internalAnalysisContext) {
        return this.basis.extractContextInto(sourceContainer, internalAnalysisContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisOptions getAnalysisOptions() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getAnalysisOptions");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            AnalysisOptions analysisOptions = this.basis.getAnalysisOptions();
            return analysisOptions;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AngularApplication getAngularApplicationWithHtml(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getAngularApplication");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            AngularApplication angularApplication = this.basis.getAngularApplicationWithHtml(source);
            return angularApplication;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    public AnalysisContext getBasis() {
        return this.basis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnitElement getCompilationUnitElement(Source source, Source source2) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getCompilationUnitElement");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            CompilationUnitElement compilationUnitElement = this.basis.getCompilationUnitElement(source, source2);
            return compilationUnitElement;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public TimestampedData<CharSequence> getContents(Source source) throws Exception {
        return this.basis.getContents(source);
    }

    @Override
    @DartOmit
    public void getContentsToReceiver(Source source, Source.ContentReceiver contentReceiver) throws Exception {
        this.basis.getContentsToReceiver(source, contentReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getElement(ElementLocation elementLocation) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getElement");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Element element = this.basis.getElement(elementLocation);
            return element;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisErrorInfo getErrors(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getErrors");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            AnalysisErrorInfo analysisErrorInfo = this.basis.getErrors(source);
            if (analysisErrorInfo != null) {
                instrumentationBuilder.metric("Errors-count", analysisErrorInfo.getErrors().length);
            }
            AnalysisErrorInfo analysisErrorInfo2 = analysisErrorInfo;
            return analysisErrorInfo2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlElement getHtmlElement(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getHtmlElement");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            HtmlElement htmlElement = this.basis.getHtmlElement(source);
            return htmlElement;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getHtmlFilesReferencing(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getHtmlFilesReferencing");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getHtmlFilesReferencing(source);
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getHtmlSources() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getHtmlSources");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getHtmlSources();
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceKind getKindOf(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getKindOf");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            SourceKind sourceKind = this.basis.getKindOf(source);
            return sourceKind;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLaunchableClientLibrarySources() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLaunchableClientLibrarySources");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getLaunchableClientLibrarySources();
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLaunchableServerLibrarySources() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLaunchableServerLibrarySources");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getLaunchableServerLibrarySources();
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLibrariesContaining(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLibrariesContaining");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getLibrariesContaining(source);
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLibrariesDependingOn(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLibrariesDependingOn");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getLibrariesDependingOn(source);
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLibrariesReferencedFromHtml(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLibrariesReferencedFromHtml");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getLibrariesReferencedFromHtml(source);
            return sourceArray;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LibraryElement getLibraryElement(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLibraryElement");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            LibraryElement libraryElement = this.basis.getLibraryElement(source);
            return libraryElement;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLibrarySources() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLibrarySources");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getLibrarySources();
            if (sourceArray != null) {
                instrumentationBuilder.metric("Source-count", sourceArray.length);
            }
            Source[] sourceArray2 = sourceArray;
            return sourceArray2;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LineInfo getLineInfo(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getLineInfo");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            LineInfo lineInfo = this.basis.getLineInfo(source);
            return lineInfo;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationStamp(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getModificationStamp");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            long l = this.basis.getModificationStamp(source);
            return l;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public Namespace getPublicNamespace(LibraryElement libraryElement) {
        return this.basis.getPublicNamespace(libraryElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getRefactoringUnsafeSources() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getRefactoringUnsafeSources");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            Source[] sourceArray = this.basis.getRefactoringUnsafeSources();
            return sourceArray;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit getResolvedCompilationUnit(Source source, LibraryElement libraryElement) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getResolvedCompilationUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            CompilationUnit compilationUnit = this.basis.getResolvedCompilationUnit(source, libraryElement);
            return compilationUnit;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompilationUnit getResolvedCompilationUnit(Source source, Source source2) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getResolvedCompilationUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            CompilationUnit compilationUnit = this.basis.getResolvedCompilationUnit(source, source2);
            return compilationUnit;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HtmlUnit getResolvedHtmlUnit(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getResolvedHtmlUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            HtmlUnit htmlUnit = this.basis.getResolvedHtmlUnit(source);
            return htmlUnit;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SourceFactory getSourceFactory() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-getSourceFactory");
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            SourceFactory sourceFactory = this.basis.getSourceFactory();
            return sourceFactory;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    @Override
    public AnalysisContentStatistics getStatistics() {
        return this.basis.getStatistics();
    }

    @Override
    public TypeProvider getTypeProvider() throws AnalysisException {
        return this.basis.getTypeProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClientLibrary(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-isClientLibrary");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            boolean bl = this.basis.isClientLibrary(source);
            return bl;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDisposed() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-isDisposed");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            boolean bl = this.basis.isDisposed();
            return bl;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServerLibrary(Source source) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-isServerLibrary");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            boolean bl = this.basis.isServerLibrary(source);
            return bl;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeContext(AnalysisContext analysisContext) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-mergeContext");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            if (analysisContext instanceof InstrumentedAnalysisContextImpl) {
                analysisContext = ((InstrumentedAnalysisContextImpl)analysisContext).basis;
            }
            this.basis.mergeContext(analysisContext);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public CompilationUnit parseCompilationUnit(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-parseCompilationUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            CompilationUnit compilationUnit = this.basis.parseCompilationUnit(source);
            return compilationUnit;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public HtmlUnit parseHtmlUnit(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-parseHtmlUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            HtmlUnit htmlUnit = this.basis.parseHtmlUnit(source);
            return htmlUnit;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisResult performAnalysisTask() {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-performAnalysisTask");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            AnalysisResult analysisResult = this.basis.performAnalysisTask();
            if (analysisResult.getChangeNotices() != null) {
                instrumentationBuilder.metric("ChangeNotice-count", analysisResult.getChangeNotices().length);
            }
            AnalysisResult analysisResult2 = analysisResult;
            return analysisResult2;
        }
        finally {
            instrumentationBuilder.log(2);
        }
    }

    @Override
    public void recordLibraryElements(Map<Source, LibraryElement> map) {
        this.basis.recordLibraryElements(map);
    }

    @Override
    public CompilationUnit resolveCompilationUnit(Source source, LibraryElement libraryElement) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-resolveCompilationUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            CompilationUnit compilationUnit = this.basis.resolveCompilationUnit(source, libraryElement);
            return compilationUnit;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public CompilationUnit resolveCompilationUnit(Source source, Source source2) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-resolveCompilationUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            CompilationUnit compilationUnit = this.basis.resolveCompilationUnit(source, source2);
            return compilationUnit;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    @Override
    public HtmlUnit resolveHtmlUnit(Source source) throws AnalysisException {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-resolveHtmlUnit");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            HtmlUnit htmlUnit = this.basis.resolveHtmlUnit(source);
            return htmlUnit;
        }
        catch (AnalysisException analysisException) {
            InstrumentedAnalysisContextImpl.recordAnalysisException(instrumentationBuilder, analysisException);
            throw analysisException;
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnalysisOptions(AnalysisOptions analysisOptions) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-setAnalysisOptions");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.setAnalysisOptions(analysisOptions);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnalysisPriorityOrder(List<Source> list) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-setAnalysisPriorityOrder");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.setAnalysisPriorityOrder(list);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangedContents(Source source, String string, int n, int n2, int n3) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-setChangedContents");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.setChangedContents(source, string, n, n2, n3);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(Source source, String string) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-setContents");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.setContents(source, string);
        }
        finally {
            instrumentationBuilder.log();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSourceFactory(SourceFactory sourceFactory) {
        InstrumentationBuilder instrumentationBuilder = Instrumentation.builder("Analysis-setSourceFactory");
        InstrumentedAnalysisContextImpl.checkThread(instrumentationBuilder);
        try {
            instrumentationBuilder.metric("contextId", this.contextId);
            this.basis.setSourceFactory(sourceFactory);
        }
        finally {
            instrumentationBuilder.log();
        }
    }
}

