/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.internal.cache.DartEntry;
import com.google.dart.engine.internal.cache.DartEntryImpl;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.ast.AstComparator;

public class IncrementalAnalysisCache {
    private final Source librarySource;
    private final Source source;
    private final String oldContents;
    private final CompilationUnit resolvedUnit;
    private String newContents;
    private int offset;
    private int oldLength;
    private int newLength;

    public static IncrementalAnalysisCache cacheResult(IncrementalAnalysisCache incrementalAnalysisCache, CompilationUnit compilationUnit) {
        if (incrementalAnalysisCache != null && compilationUnit != null) {
            return new IncrementalAnalysisCache(incrementalAnalysisCache.librarySource, incrementalAnalysisCache.source, compilationUnit, incrementalAnalysisCache.newContents, incrementalAnalysisCache.newContents, 0, 0, 0);
        }
        return null;
    }

    public static IncrementalAnalysisCache clear(IncrementalAnalysisCache incrementalAnalysisCache, Source source) {
        if (incrementalAnalysisCache == null || ((Object)incrementalAnalysisCache.getSource()).equals(source)) {
            return null;
        }
        return incrementalAnalysisCache;
    }

    public static IncrementalAnalysisCache update(IncrementalAnalysisCache incrementalAnalysisCache, Source source, String string, String string2, int n, int n2, int n3, SourceEntry sourceEntry) {
        DartEntryImpl dartEntryImpl;
        Source[] sourceArray;
        Source source2 = null;
        CompilationUnit compilationUnit = null;
        if (sourceEntry instanceof DartEntryImpl && (sourceArray = (dartEntryImpl = (DartEntryImpl)sourceEntry).getLibrariesContaining()).length == 1 && (source2 = sourceArray[0]) != null) {
            compilationUnit = dartEntryImpl.getValueInLibrary(DartEntry.RESOLVED_UNIT, source2);
        }
        if (incrementalAnalysisCache == null || !((Object)incrementalAnalysisCache.getSource()).equals(source) || compilationUnit != null) {
            if (compilationUnit == null) {
                return null;
            }
            if (string == null) {
                if (n2 != 0) {
                    return null;
                }
                string = string2.substring(0, n) + string2.substring(n + n3);
            }
            return new IncrementalAnalysisCache(source2, source, compilationUnit, string, string2, n, n2, n3);
        }
        if (incrementalAnalysisCache.oldLength == 0 && incrementalAnalysisCache.newLength == 0) {
            incrementalAnalysisCache.offset = n;
            incrementalAnalysisCache.oldLength = n2;
            incrementalAnalysisCache.newLength = n3;
        } else {
            if (incrementalAnalysisCache.offset > n || n > incrementalAnalysisCache.offset + incrementalAnalysisCache.newLength) {
                return null;
            }
            incrementalAnalysisCache.newLength += n3 - n2;
        }
        incrementalAnalysisCache.newContents = string2;
        return incrementalAnalysisCache;
    }

    public static IncrementalAnalysisCache verifyStructure(IncrementalAnalysisCache incrementalAnalysisCache, Source source, CompilationUnit compilationUnit) {
        if (incrementalAnalysisCache != null && compilationUnit != null && ((Object)incrementalAnalysisCache.source).equals(source) && !AstComparator.equalUnits(incrementalAnalysisCache.resolvedUnit, compilationUnit)) {
            return null;
        }
        return incrementalAnalysisCache;
    }

    public IncrementalAnalysisCache(Source source, Source source2, CompilationUnit compilationUnit, String string, String string2, int n, int n2, int n3) {
        this.librarySource = source;
        this.source = source2;
        this.resolvedUnit = compilationUnit;
        this.oldContents = string;
        this.newContents = string2;
        this.offset = n;
        this.oldLength = n2;
        this.newLength = n3;
    }

    public Source getLibrarySource() {
        return this.librarySource;
    }

    public String getNewContents() {
        return this.newContents;
    }

    public int getNewLength() {
        return this.newLength;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOldContents() {
        return this.oldContents;
    }

    public int getOldLength() {
        return this.oldLength;
    }

    public CompilationUnit getResolvedUnit() {
        return this.resolvedUnit;
    }

    public Source getSource() {
        return this.source;
    }

    public boolean hasWork() {
        return this.oldLength > 0 || this.newLength > 0;
    }
}

