/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisErrorInfo;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.internal.context.AnalysisContextImpl;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.sdk.DartSdk;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceFactory;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.utilities.source.LineInfo;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class DelegatingAnalysisContextImpl
extends AnalysisContextImpl {
    private InternalAnalysisContext sdkAnalysisContext;

    @Override
    public void addSourceInfo(Source source, SourceEntry sourceEntry) {
        if (source.isInSystemLibrary()) {
            this.sdkAnalysisContext.addSourceInfo(source, sourceEntry);
        } else {
            super.addSourceInfo(source, sourceEntry);
        }
    }

    @Override
    public AnalysisError[] computeErrors(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeErrors(source);
        }
        return super.computeErrors(source);
    }

    @Override
    public Source[] computeExportedLibraries(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeExportedLibraries(source);
        }
        return super.computeExportedLibraries(source);
    }

    @Override
    public HtmlElement computeHtmlElement(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeHtmlElement(source);
        }
        return super.computeHtmlElement(source);
    }

    @Override
    public Source[] computeImportedLibraries(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeImportedLibraries(source);
        }
        return super.computeImportedLibraries(source);
    }

    @Override
    public SourceKind computeKindOf(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeKindOf(source);
        }
        return super.computeKindOf(source);
    }

    @Override
    public LibraryElement computeLibraryElement(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeLibraryElement(source);
        }
        return super.computeLibraryElement(source);
    }

    @Override
    public LineInfo computeLineInfo(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeLineInfo(source);
        }
        return super.computeLineInfo(source);
    }

    @Override
    public ResolvableCompilationUnit computeResolvableCompilationUnit(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.computeResolvableCompilationUnit(source);
        }
        return super.computeResolvableCompilationUnit(source);
    }

    @Override
    public AnalysisErrorInfo getErrors(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getErrors(source);
        }
        return super.getErrors(source);
    }

    @Override
    public HtmlElement getHtmlElement(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getHtmlElement(source);
        }
        return super.getHtmlElement(source);
    }

    @Override
    public Source[] getHtmlFilesReferencing(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getHtmlFilesReferencing(source);
        }
        return super.getHtmlFilesReferencing(source);
    }

    @Override
    public SourceKind getKindOf(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getKindOf(source);
        }
        return super.getKindOf(source);
    }

    @Override
    public Source[] getLibrariesContaining(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getLibrariesContaining(source);
        }
        return super.getLibrariesContaining(source);
    }

    @Override
    public Source[] getLibrariesDependingOn(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getLibrariesDependingOn(source);
        }
        return super.getLibrariesDependingOn(source);
    }

    @Override
    public LibraryElement getLibraryElement(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getLibraryElement(source);
        }
        return super.getLibraryElement(source);
    }

    @Override
    public Source[] getLibrarySources() {
        return ArrayUtils.addAll(super.getLibrarySources(), this.sdkAnalysisContext.getLibrarySources());
    }

    @Override
    public LineInfo getLineInfo(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getLineInfo(source);
        }
        return super.getLineInfo(source);
    }

    @Override
    public Namespace getPublicNamespace(LibraryElement libraryElement) {
        Source source = libraryElement.getSource();
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getPublicNamespace(libraryElement);
        }
        return super.getPublicNamespace(libraryElement);
    }

    @Override
    public CompilationUnit getResolvedCompilationUnit(Source source, LibraryElement libraryElement) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getResolvedCompilationUnit(source, libraryElement);
        }
        return super.getResolvedCompilationUnit(source, libraryElement);
    }

    @Override
    public CompilationUnit getResolvedCompilationUnit(Source source, Source source2) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.getResolvedCompilationUnit(source, source2);
        }
        return super.getResolvedCompilationUnit(source, source2);
    }

    @Override
    public boolean isClientLibrary(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.isClientLibrary(source);
        }
        return super.isClientLibrary(source);
    }

    @Override
    public boolean isServerLibrary(Source source) {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.isServerLibrary(source);
        }
        return super.isServerLibrary(source);
    }

    @Override
    public CompilationUnit parseCompilationUnit(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.parseCompilationUnit(source);
        }
        return super.parseCompilationUnit(source);
    }

    @Override
    public HtmlUnit parseHtmlUnit(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.parseHtmlUnit(source);
        }
        return super.parseHtmlUnit(source);
    }

    @Override
    public void recordLibraryElements(Map<Source, LibraryElement> map) {
        if (map.isEmpty()) {
            return;
        }
        Source source = map.keySet().iterator().next();
        if (source.isInSystemLibrary()) {
            this.sdkAnalysisContext.recordLibraryElements(map);
        } else {
            super.recordLibraryElements(map);
        }
    }

    @Override
    public CompilationUnit resolveCompilationUnit(Source source, LibraryElement libraryElement) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.resolveCompilationUnit(source, libraryElement);
        }
        return super.resolveCompilationUnit(source, libraryElement);
    }

    @Override
    public CompilationUnit resolveCompilationUnit(Source source, Source source2) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.resolveCompilationUnit(source, source2);
        }
        return super.resolveCompilationUnit(source, source2);
    }

    @Override
    public HtmlUnit resolveHtmlUnit(Source source) throws AnalysisException {
        if (source.isInSystemLibrary()) {
            return this.sdkAnalysisContext.resolveHtmlUnit(source);
        }
        return super.resolveHtmlUnit(source);
    }

    @Override
    public void setChangedContents(Source source, String string, int n, int n2, int n3) {
        if (source.isInSystemLibrary()) {
            this.sdkAnalysisContext.setChangedContents(source, string, n, n2, n3);
        } else {
            super.setChangedContents(source, string, n, n2, n3);
        }
    }

    @Override
    public void setContents(Source source, String string) {
        if (source.isInSystemLibrary()) {
            this.sdkAnalysisContext.setContents(source, string);
        } else {
            super.setContents(source, string);
        }
    }

    @Override
    public void setSourceFactory(SourceFactory sourceFactory) {
        super.setSourceFactory(sourceFactory);
        DartSdk dartSdk = sourceFactory.getDartSdk();
        if (dartSdk != null) {
            this.sdkAnalysisContext = (InternalAnalysisContext)dartSdk.getContext();
            if (this.sdkAnalysisContext instanceof DelegatingAnalysisContextImpl) {
                this.sdkAnalysisContext = null;
                throw new IllegalStateException("The context provided by an SDK cannot itself be a delegating analysis context");
            }
        } else {
            throw new IllegalStateException("SourceFactorys provided to DelegatingAnalysisContextImpls must have a DartSdk associated with the provided SourceFactory.");
        }
    }
}

