/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.ChangeNotice;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;

public class ChangeNoticeImpl
implements ChangeNotice {
    private Source source;
    private CompilationUnit compilationUnit;
    private HtmlUnit htmlUnit;
    private AnalysisError[] errors;
    private LineInfo lineInfo;
    public static final ChangeNoticeImpl[] EMPTY_ARRAY = new ChangeNoticeImpl[0];

    public ChangeNoticeImpl(Source source) {
        this.source = source;
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    @Override
    public AnalysisError[] getErrors() {
        return this.errors;
    }

    @Override
    public HtmlUnit getHtmlUnit() {
        return this.htmlUnit;
    }

    @Override
    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    @Override
    public Source getSource() {
        return this.source;
    }

    public void setCompilationUnit(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public void setErrors(AnalysisError[] analysisErrorArray, LineInfo lineInfo) {
        this.errors = analysisErrorArray;
        this.lineInfo = lineInfo;
        if (lineInfo == null) {
            AnalysisEngine.getInstance().getLogger().logInformation("No line info: " + this.source, new Exception());
        }
    }

    public void setHtmlUnit(HtmlUnit htmlUnit) {
        this.htmlUnit = htmlUnit;
    }

    public String toString() {
        return "Changes for " + this.source.getFullName();
    }
}

