/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AnnotatedNode;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.visitor.NodeLocator;
import com.google.dart.engine.context.AnalysisContentStatistics;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisErrorInfo;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.context.AnalysisOptions;
import com.google.dart.engine.context.AnalysisResult;
import com.google.dart.engine.context.ChangeNotice;
import com.google.dart.engine.context.ChangeSet;
import com.google.dart.engine.context.ObsoleteSourceAnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.element.angular.AngularElement;
import com.google.dart.engine.element.angular.AngularHasTemplateElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.cache.AnalysisCache;
import com.google.dart.engine.internal.cache.CacheRetentionPolicy;
import com.google.dart.engine.internal.cache.CacheState;
import com.google.dart.engine.internal.cache.DartEntry;
import com.google.dart.engine.internal.cache.DartEntryImpl;
import com.google.dart.engine.internal.cache.DataDescriptor;
import com.google.dart.engine.internal.cache.HtmlEntry;
import com.google.dart.engine.internal.cache.HtmlEntryImpl;
import com.google.dart.engine.internal.cache.RetentionPriority;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.internal.cache.SourceEntryImpl;
import com.google.dart.engine.internal.context.AnalysisContentStatisticsImpl;
import com.google.dart.engine.internal.context.AnalysisErrorInfoImpl;
import com.google.dart.engine.internal.context.AnalysisOptionsImpl;
import com.google.dart.engine.internal.context.ChangeNoticeImpl;
import com.google.dart.engine.internal.context.IncrementalAnalysisCache;
import com.google.dart.engine.internal.context.InstrumentedAnalysisContextImpl;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.context.ResolvableCompilationUnit;
import com.google.dart.engine.internal.context.SourcePriority;
import com.google.dart.engine.internal.context.TimestampedData;
import com.google.dart.engine.internal.context.WorkManager;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.ElementLocationImpl;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.element.angular.AngularApplication;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.LibraryResolver;
import com.google.dart.engine.internal.resolver.LibraryResolver2;
import com.google.dart.engine.internal.resolver.ResolvableLibrary;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.internal.resolver.TypeProviderImpl;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.internal.scope.NamespaceBuilder;
import com.google.dart.engine.internal.task.AnalysisTask;
import com.google.dart.engine.internal.task.AnalysisTaskVisitor;
import com.google.dart.engine.internal.task.GenerateDartErrorsTask;
import com.google.dart.engine.internal.task.GenerateDartHintsTask;
import com.google.dart.engine.internal.task.GetContentTask;
import com.google.dart.engine.internal.task.IncrementalAnalysisTask;
import com.google.dart.engine.internal.task.ParseDartTask;
import com.google.dart.engine.internal.task.ParseHtmlTask;
import com.google.dart.engine.internal.task.ResolveAngularComponentTemplateTask;
import com.google.dart.engine.internal.task.ResolveAngularEntryHtmlTask;
import com.google.dart.engine.internal.task.ResolveDartLibraryCycleTask;
import com.google.dart.engine.internal.task.ResolveDartLibraryTask;
import com.google.dart.engine.internal.task.ResolveDartUnitTask;
import com.google.dart.engine.internal.task.ResolveHtmlTask;
import com.google.dart.engine.internal.task.ScanDartTask;
import com.google.dart.engine.internal.task.WaitForAsyncTask;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.source.ContentCache;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;
import com.google.dart.engine.source.SourceFactory;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.utilities.collection.DirectedGraph;
import com.google.dart.engine.utilities.collection.ListUtilities;
import com.google.dart.engine.utilities.io.PrintStringWriter;
import com.google.dart.engine.utilities.os.OSUtilities;
import com.google.dart.engine.utilities.source.LineInfo;
import com.google.dart.engine.utilities.translation.DartOmit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisContextImpl
implements InternalAnalysisContext {
    private static final int PRIORITY_ORDER_SIZE_DELTA = 4;
    private static final boolean TRACE_PERFORM_TASK = false;
    private AnalysisOptionsImpl options = new AnalysisOptionsImpl();
    boolean generateSdkErrors = true;
    private boolean disposed;
    private ContentCache contentCache = new ContentCache();
    private SourceFactory sourceFactory;
    private Source coreLibrarySource;
    private final AnalysisCache cache;
    private Source[] priorityOrder = Source.EMPTY_ARRAY;
    private HashSet<Source> neededForResolution = null;
    private HashMap<Source, ChangeNoticeImpl> pendingNotices = new HashMap();
    private HashSet<String> recentTasks = new HashSet();
    private Object cacheLock = new Object();
    private AnalysisTaskResultRecorder resultRecorder;
    private IncrementalAnalysisCache incrementalAnalysisCache;
    private WorkManager workManager = new WorkManager();
    private final Set<AngularApplication> angularApplications = Sets.newHashSet();

    public AnalysisContextImpl() {
        this.resultRecorder = new AnalysisTaskResultRecorder();
        this.cache = new AnalysisCache(64, new ContextRetentionPolicy());
    }

    @Override
    public void addSourceInfo(Source source, SourceEntry sourceEntry) {
        this.cache.put(source, sourceEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void applyChanges(ChangeSet changeSet) {
        if (changeSet.isEmpty()) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            this.recentTasks.clear();
            ArrayList<Source> arrayList = new ArrayList<Source>(changeSet.getRemovedSources());
            for (SourceContainer object2 : changeSet.getRemovedContainers()) {
                this.addSourcesInContainer(arrayList, object2);
            }
            boolean bl = false;
            for (Source source : changeSet.getAddedSources()) {
                if (!this.sourceAvailable(source)) continue;
                bl = true;
            }
            for (Source source : changeSet.getChangedSources()) {
                this.sourceChanged(source);
            }
            for (Source source : arrayList) {
                this.sourceRemoved(source);
            }
            if (bl) {
                void var7_20;
                SourceEntry sourceEntry;
                Source source;
                ArrayList<Source> arrayList2 = new ArrayList<Source>();
                for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                    source = entry.getKey();
                    sourceEntry = entry.getValue();
                    if (source.isInSystemLibrary() || !(sourceEntry instanceof DartEntry)) continue;
                    arrayList2.add(source);
                }
                int n = arrayList2.size();
                boolean bl2 = false;
                while (var7_20 < n) {
                    source = (Source)arrayList2.get((int)var7_20);
                    sourceEntry = this.getReadableDartEntry(source);
                    this.removeFromParts(source, (DartEntry)sourceEntry);
                    DartEntryImpl dartEntryImpl = sourceEntry.getWritableCopy();
                    dartEntryImpl.invalidateAllResolutionInformation();
                    this.cache.put(source, dartEntryImpl);
                    SourcePriority sourcePriority = SourcePriority.UNKNOWN;
                    SourceKind sourceKind = dartEntryImpl.getKind();
                    if (sourceKind == SourceKind.LIBRARY) {
                        sourcePriority = SourcePriority.LIBRARY;
                    } else if (sourceKind == SourceKind.PART) {
                        sourcePriority = SourcePriority.NORMAL_PART;
                    }
                    this.workManager.add(source, sourcePriority);
                    ++var7_20;
                }
            }
        }
    }

    @Override
    public String computeDocumentationComment(Element element) throws AnalysisException {
        if (element == null) {
            return null;
        }
        Source source = element.getSource();
        if (source == null) {
            return null;
        }
        CompilationUnit compilationUnit = this.parseCompilationUnit(source);
        if (compilationUnit == null) {
            return null;
        }
        NodeLocator nodeLocator = new NodeLocator(element.getNameOffset());
        for (AstNode astNode = nodeLocator.searchWithin(compilationUnit); astNode != null; astNode = astNode.getParent()) {
            if (!(astNode instanceof AnnotatedNode)) continue;
            Comment comment = ((AnnotatedNode)astNode).getDocumentationComment();
            if (comment == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            Token[] tokenArray = comment.getTokens();
            for (int i = 0; i < tokenArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(OSUtilities.LINE_SEPARATOR);
                }
                stringBuilder.append(tokenArray[i].getLexeme());
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public AnalysisError[] computeErrors(Source source) throws AnalysisException {
        boolean bl = this.options.getHint();
        SourceEntry sourceEntry = this.getReadableSourceEntry(source);
        if (sourceEntry instanceof DartEntry) {
            ArrayList arrayList = new ArrayList();
            try {
                DartEntry dartEntry = (DartEntry)sourceEntry;
                ListUtilities.addAll(arrayList, (Object[])this.getDartScanData(source, dartEntry, DartEntry.SCAN_ERRORS));
                dartEntry = this.getReadableDartEntry(source);
                ListUtilities.addAll(arrayList, (Object[])this.getDartParseData(source, dartEntry, DartEntry.PARSE_ERRORS));
                dartEntry = this.getReadableDartEntry(source);
                if (dartEntry.getValue(DartEntry.SOURCE_KIND) == SourceKind.LIBRARY) {
                    ListUtilities.addAll(arrayList, (Object[])this.getDartResolutionData(source, source, dartEntry, DartEntry.RESOLUTION_ERRORS));
                    dartEntry = this.getReadableDartEntry(source);
                    ListUtilities.addAll(arrayList, (Object[])this.getDartVerificationData(source, source, dartEntry, DartEntry.VERIFICATION_ERRORS));
                    if (bl) {
                        dartEntry = this.getReadableDartEntry(source);
                        ListUtilities.addAll(arrayList, (Object[])this.getDartHintData(source, source, dartEntry, DartEntry.HINTS));
                    }
                } else {
                    Source[] sourceArray;
                    for (Source source2 : sourceArray = this.getLibrariesContaining(source)) {
                        ListUtilities.addAll(arrayList, (Object[])this.getDartResolutionData(source, source2, dartEntry, DartEntry.RESOLUTION_ERRORS));
                        dartEntry = this.getReadableDartEntry(source);
                        ListUtilities.addAll(arrayList, (Object[])this.getDartVerificationData(source, source2, dartEntry, DartEntry.VERIFICATION_ERRORS));
                        if (!bl) continue;
                        dartEntry = this.getReadableDartEntry(source);
                        ListUtilities.addAll(arrayList, (Object[])this.getDartHintData(source, source2, dartEntry, DartEntry.HINTS));
                    }
                }
            }
            catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
                AnalysisEngine.getInstance().getLogger().logInformation("Could not compute errors", obsoleteSourceAnalysisException);
            }
            if (arrayList.isEmpty()) {
                return AnalysisError.NO_ERRORS;
            }
            return arrayList.toArray(new AnalysisError[arrayList.size()]);
        }
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            try {
                return this.getHtmlResolutionData(source, htmlEntry, HtmlEntry.RESOLUTION_ERRORS);
            }
            catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
                AnalysisEngine.getInstance().getLogger().logInformation("Could not compute errors", obsoleteSourceAnalysisException);
            }
        }
        return AnalysisError.NO_ERRORS;
    }

    @Override
    public Source[] computeExportedLibraries(Source source) throws AnalysisException {
        return this.getDartParseData(source, DartEntry.EXPORTED_LIBRARIES, Source.EMPTY_ARRAY);
    }

    @Override
    public HtmlElement computeHtmlElement(Source source) throws AnalysisException {
        return this.getHtmlResolutionData(source, HtmlEntry.ELEMENT, null);
    }

    @Override
    public Source[] computeImportedLibraries(Source source) throws AnalysisException {
        return this.getDartParseData(source, DartEntry.IMPORTED_LIBRARIES, Source.EMPTY_ARRAY);
    }

    @Override
    public SourceKind computeKindOf(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntry(source);
        if (sourceEntry == null) {
            return SourceKind.UNKNOWN;
        }
        if (sourceEntry instanceof DartEntry) {
            try {
                return this.getDartParseData(source, (DartEntry)sourceEntry, DartEntry.SOURCE_KIND);
            }
            catch (AnalysisException analysisException) {
                return SourceKind.UNKNOWN;
            }
        }
        return sourceEntry.getKind();
    }

    @Override
    public LibraryElement computeLibraryElement(Source source) throws AnalysisException {
        return this.getDartResolutionData(source, source, DartEntry.ELEMENT, null);
    }

    @Override
    public LineInfo computeLineInfo(Source source) throws AnalysisException {
        SourceEntry sourceEntry = this.getReadableSourceEntry(source);
        try {
            if (sourceEntry instanceof HtmlEntry) {
                return this.getHtmlParseData(source, SourceEntry.LINE_INFO, null);
            }
            if (sourceEntry instanceof DartEntry) {
                return this.getDartScanData(source, SourceEntry.LINE_INFO, null);
            }
        }
        catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
            AnalysisEngine.getInstance().getLogger().logInformation("Could not compute " + SourceEntry.LINE_INFO.toString(), obsoleteSourceAnalysisException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResolvableCompilationUnit computeResolvableCompilationUnit(Source source) throws AnalysisException {
        Object object = this.cacheLock;
        synchronized (object) {
            DartEntry dartEntry = this.getReadableDartEntry(source);
            if (dartEntry == null) {
                throw new AnalysisException("computeResolvableCompilationUnit for non-Dart: " + source.getFullName());
            }
            DartEntryImpl dartEntryImpl = (dartEntry = this.cacheDartParseData(source, dartEntry, DartEntry.PARSED_UNIT)).getWritableCopy();
            CompilationUnit compilationUnit = dartEntryImpl.getResolvableCompilationUnit();
            if (compilationUnit == null) {
                throw new AnalysisException("Internal error: computeResolvableCompilationUnit could not parse " + source.getFullName(), dartEntry.getException());
            }
            this.cache.put(source, dartEntryImpl);
            return new ResolvableCompilationUnit(dartEntryImpl.getModificationTime(), compilationUnit);
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(Source source) {
        if (source == null) {
            return false;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.contentCache.getContents(source) != null) {
                return true;
            }
        }
        return source.exists();
    }

    @Override
    public AnalysisContext extractContext(SourceContainer sourceContainer) {
        return this.extractContextInto(sourceContainer, (InternalAnalysisContext)AnalysisEngine.getInstance().createAnalysisContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalAnalysisContext extractContextInto(SourceContainer sourceContainer, InternalAnalysisContext internalAnalysisContext) {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                Source source = entry.getKey();
                if (!sourceContainer.contains(source)) continue;
                arrayList.add(source);
                internalAnalysisContext.addSourceInfo(source, entry.getValue().getWritableCopy());
            }
        }
        return internalAnalysisContext;
    }

    @Override
    public AnalysisOptions getAnalysisOptions() {
        return this.options;
    }

    @Override
    public AngularApplication getAngularApplicationWithHtml(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            AngularApplication angularApplication = htmlEntry.getValue(HtmlEntry.ANGULAR_APPLICATION);
            if (angularApplication != null) {
                return angularApplication;
            }
            return htmlEntry.getValue(HtmlEntry.ANGULAR_ENTRY);
        }
        return null;
    }

    @Override
    public CompilationUnitElement getCompilationUnitElement(Source source, Source source2) {
        LibraryElement libraryElement = this.getLibraryElement(source2);
        if (libraryElement != null) {
            CompilationUnitElement compilationUnitElement = libraryElement.getDefiningCompilationUnit();
            if (((Object)compilationUnitElement.getSource()).equals(source)) {
                return compilationUnitElement;
            }
            for (CompilationUnitElement compilationUnitElement2 : libraryElement.getParts()) {
                if (!((Object)compilationUnitElement2.getSource()).equals(source)) continue;
                return compilationUnitElement2;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimestampedData<CharSequence> getContents(Source source) throws Exception {
        Object object = this.cacheLock;
        synchronized (object) {
            String string = this.contentCache.getContents(source);
            if (string != null) {
                return new TimestampedData<CharSequence>(this.contentCache.getModificationStamp(source), string);
            }
        }
        return source.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DartOmit
    public void getContentsToReceiver(Source source, Source.ContentReceiver contentReceiver) throws Exception {
        Object object = this.cacheLock;
        synchronized (object) {
            String string = this.contentCache.getContents(source);
            if (string != null) {
                contentReceiver.accept(string, this.contentCache.getModificationStamp(source));
                return;
            }
        }
        source.getContentsToReceiver(contentReceiver);
    }

    @Override
    public Element getElement(ElementLocation elementLocation) {
        try {
            String[] stringArray = ((ElementLocationImpl)elementLocation).getComponents();
            Source source = this.computeSourceFromEncoding(stringArray[0]);
            ElementImpl elementImpl = (ElementImpl)((Object)this.computeLibraryElement(source));
            for (int i = 1; i < stringArray.length; ++i) {
                if (elementImpl == null) {
                    return null;
                }
                elementImpl = elementImpl.getChild(stringArray[i]);
            }
            return elementImpl;
        }
        catch (AnalysisException analysisException) {
            return null;
        }
    }

    @Override
    public AnalysisErrorInfo getErrors(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof DartEntry) {
            DartEntry dartEntry = (DartEntry)sourceEntry;
            return new AnalysisErrorInfoImpl(dartEntry.getAllErrors(), dartEntry.getValue(SourceEntry.LINE_INFO));
        }
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            return new AnalysisErrorInfoImpl(htmlEntry.getAllErrors(), htmlEntry.getValue(SourceEntry.LINE_INFO));
        }
        return new AnalysisErrorInfoImpl(AnalysisError.NO_ERRORS, null);
    }

    @Override
    public HtmlElement getHtmlElement(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof HtmlEntry) {
            return ((HtmlEntry)sourceEntry).getValue(HtmlEntry.ELEMENT);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getHtmlFilesReferencing(Source source) {
        SourceKind sourceKind = this.getKindOf(source);
        if (sourceKind == null) {
            return Source.EMPTY_ARRAY;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            ArrayList<Source> arrayList = new ArrayList<Source>();
            switch (sourceKind) {
                default: {
                    for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                        Source[] sourceArray;
                        SourceEntry sourceEntry = entry.getValue();
                        if (sourceEntry.getKind() != SourceKind.HTML || !this.contains(sourceArray = ((HtmlEntry)sourceEntry).getValue(HtmlEntry.REFERENCED_LIBRARIES), source)) continue;
                        arrayList.add(entry.getKey());
                    }
                    break;
                }
                case PART: {
                    Source[] sourceArray = this.getLibrariesContaining(source);
                    for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                        Source[] sourceArray2;
                        SourceEntry sourceEntry = entry.getValue();
                        if (sourceEntry.getKind() != SourceKind.HTML || !this.containsAny(sourceArray2 = ((HtmlEntry)sourceEntry).getValue(HtmlEntry.REFERENCED_LIBRARIES), sourceArray)) continue;
                        arrayList.add(entry.getKey());
                    }
                }
            }
            if (arrayList.isEmpty()) {
                return Source.EMPTY_ARRAY;
            }
            return arrayList.toArray(new Source[arrayList.size()]);
        }
    }

    @Override
    public Source[] getHtmlSources() {
        return this.getSources(SourceKind.HTML);
    }

    @Override
    public SourceKind getKindOf(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry == null) {
            return SourceKind.UNKNOWN;
        }
        return sourceEntry.getKind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLaunchableClientLibrarySources() {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                Source source = entry.getKey();
                SourceEntry sourceEntry = entry.getValue();
                if (sourceEntry.getKind() != SourceKind.LIBRARY || source.isInSystemLibrary()) continue;
                arrayList.add(source);
            }
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLaunchableServerLibrarySources() {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                Source source = entry.getKey();
                SourceEntry sourceEntry = entry.getValue();
                if (sourceEntry.getKind() != SourceKind.LIBRARY || source.isInSystemLibrary()) continue;
                arrayList.add(source);
            }
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    @Override
    public Source[] getLibrariesContaining(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof DartEntry) {
            return ((DartEntry)sourceEntry).getValue(DartEntry.CONTAINING_LIBRARIES);
        }
        return Source.EMPTY_ARRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getLibrariesDependingOn(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            ArrayList<Source> arrayList = new ArrayList<Source>();
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                SourceEntry sourceEntry = entry.getValue();
                if (sourceEntry.getKind() != SourceKind.LIBRARY) continue;
                if (this.contains(((DartEntry)sourceEntry).getValue(DartEntry.EXPORTED_LIBRARIES), source)) {
                    arrayList.add(entry.getKey());
                }
                if (!this.contains(((DartEntry)sourceEntry).getValue(DartEntry.IMPORTED_LIBRARIES), source)) continue;
                arrayList.add(entry.getKey());
            }
            if (arrayList.isEmpty()) {
                return Source.EMPTY_ARRAY;
            }
            return arrayList.toArray(new Source[arrayList.size()]);
        }
    }

    @Override
    public Source[] getLibrariesReferencedFromHtml(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            return htmlEntry.getValue(HtmlEntry.REFERENCED_LIBRARIES);
        }
        return Source.EMPTY_ARRAY;
    }

    @Override
    public LibraryElement getLibraryElement(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof DartEntry) {
            return ((DartEntry)sourceEntry).getValue(DartEntry.ELEMENT);
        }
        return null;
    }

    @Override
    public Source[] getLibrarySources() {
        return this.getSources(SourceKind.LIBRARY);
    }

    @Override
    public LineInfo getLineInfo(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry != null) {
            return sourceEntry.getValue(SourceEntry.LINE_INFO);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModificationStamp(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            Long l = this.contentCache.getModificationStamp(source);
            if (l != null) {
                return l;
            }
        }
        return source.getModificationStamp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Namespace getPublicNamespace(LibraryElement libraryElement) {
        Source source = libraryElement.getDefiningCompilationUnit().getSource();
        DartEntry dartEntry = this.getReadableDartEntry(source);
        if (dartEntry == null) {
            return null;
        }
        Namespace namespace = null;
        if (dartEntry.getValue(DartEntry.ELEMENT) == libraryElement) {
            namespace = dartEntry.getValue(DartEntry.PUBLIC_NAMESPACE);
        }
        if (namespace == null) {
            NamespaceBuilder namespaceBuilder = new NamespaceBuilder();
            namespace = namespaceBuilder.createPublicNamespaceForLibrary(libraryElement);
            Object object = this.cacheLock;
            synchronized (object) {
                dartEntry = this.getReadableDartEntry(source);
                if (dartEntry == null) {
                    AnalysisEngine.getInstance().getLogger().logError("Could not compute the public namespace for " + libraryElement.getSource().getFullName(), new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName()));
                    return null;
                }
                if (dartEntry.getValue(DartEntry.ELEMENT) == libraryElement) {
                    DartEntryImpl dartEntryImpl = this.getReadableDartEntry(source).getWritableCopy();
                    dartEntryImpl.setValue(DartEntry.PUBLIC_NAMESPACE, namespace);
                    this.cache.put(source, dartEntryImpl);
                }
            }
        }
        return namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Source[] getRefactoringUnsafeSources() {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                SourceEntry sourceEntry = entry.getValue();
                if (!(sourceEntry instanceof DartEntry) || ((DartEntry)sourceEntry).isRefactoringSafe()) continue;
                arrayList.add(entry.getKey());
            }
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    @Override
    public CompilationUnit getResolvedCompilationUnit(Source source, LibraryElement libraryElement) {
        if (libraryElement == null) {
            return null;
        }
        return this.getResolvedCompilationUnit(source, libraryElement.getSource());
    }

    @Override
    public CompilationUnit getResolvedCompilationUnit(Source source, Source source2) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof DartEntry) {
            return ((DartEntry)sourceEntry).getValueInLibrary(DartEntry.RESOLVED_UNIT, source2);
        }
        return null;
    }

    @Override
    public HtmlUnit getResolvedHtmlUnit(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntryOrNull(source);
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            return htmlEntry.getValue(HtmlEntry.RESOLVED_UNIT);
        }
        return null;
    }

    @Override
    public SourceFactory getSourceFactory() {
        return this.sourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<Source> getSourcesNeedingProcessing() {
        HashSet<Source> hashSet = new HashSet<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            boolean bl = this.options.getHint();
            for (Source source : this.priorityOrder) {
                this.getSourcesNeedingProcessing(source, this.cache.get(source), true, bl, hashSet);
            }
            for (Map.Entry entry : this.cache.entrySet()) {
                this.getSourcesNeedingProcessing((Source)entry.getKey(), (SourceEntry)entry.getValue(), false, bl, hashSet);
            }
        }
        return new ArrayList<Source>(hashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalysisContentStatistics getStatistics() {
        boolean bl = this.options.getHint();
        AnalysisContentStatisticsImpl analysisContentStatisticsImpl = new AnalysisContentStatisticsImpl();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                Object object2;
                analysisContentStatisticsImpl.addSource(entry.getKey());
                SourceEntry sourceEntry = entry.getValue();
                if (sourceEntry instanceof DartEntry) {
                    Source[] sourceArray;
                    object2 = entry.getKey();
                    DartEntry dartEntry = (DartEntry)sourceEntry;
                    SourceKind sourceKind = dartEntry.getValue(DartEntry.SOURCE_KIND);
                    analysisContentStatisticsImpl.putCacheItem(dartEntry, SourceEntry.LINE_INFO);
                    analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.PARSE_ERRORS);
                    analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.PARSED_UNIT);
                    analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.SOURCE_KIND);
                    if (sourceKind == SourceKind.LIBRARY) {
                        analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.ELEMENT);
                        analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.EXPORTED_LIBRARIES);
                        analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.IMPORTED_LIBRARIES);
                        analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.INCLUDED_PARTS);
                        analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.IS_CLIENT);
                        analysisContentStatisticsImpl.putCacheItem(dartEntry, DartEntry.IS_LAUNCHABLE);
                    }
                    for (Source source : sourceArray = this.getLibrariesContaining((Source)object2)) {
                        analysisContentStatisticsImpl.putCacheItemInLibrary(dartEntry, source, DartEntry.RESOLUTION_ERRORS);
                        analysisContentStatisticsImpl.putCacheItemInLibrary(dartEntry, source, DartEntry.RESOLVED_UNIT);
                        if (!this.generateSdkErrors && object2.isInSystemLibrary()) continue;
                        analysisContentStatisticsImpl.putCacheItemInLibrary(dartEntry, source, DartEntry.VERIFICATION_ERRORS);
                        if (!bl) continue;
                        analysisContentStatisticsImpl.putCacheItemInLibrary(dartEntry, source, DartEntry.HINTS);
                    }
                    continue;
                }
                if (!(sourceEntry instanceof HtmlEntry)) continue;
                object2 = (HtmlEntry)sourceEntry;
                analysisContentStatisticsImpl.putCacheItem((SourceEntry)object2, SourceEntry.LINE_INFO);
                analysisContentStatisticsImpl.putCacheItem((SourceEntry)object2, HtmlEntry.PARSE_ERRORS);
                analysisContentStatisticsImpl.putCacheItem((SourceEntry)object2, HtmlEntry.PARSED_UNIT);
                analysisContentStatisticsImpl.putCacheItem((SourceEntry)object2, HtmlEntry.RESOLUTION_ERRORS);
                analysisContentStatisticsImpl.putCacheItem((SourceEntry)object2, HtmlEntry.RESOLVED_UNIT);
            }
        }
        return analysisContentStatisticsImpl;
    }

    @Override
    public TypeProvider getTypeProvider() throws AnalysisException {
        Source source = this.getSourceFactory().forUri("dart:core");
        return new TypeProviderImpl(this.computeLibraryElement(source));
    }

    @Override
    public boolean isClientLibrary(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntry(source);
        if (sourceEntry instanceof DartEntry) {
            DartEntry dartEntry = (DartEntry)sourceEntry;
            return dartEntry.getValue(DartEntry.IS_CLIENT) != false && dartEntry.getValue(DartEntry.IS_LAUNCHABLE) != false;
        }
        return false;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isServerLibrary(Source source) {
        SourceEntry sourceEntry = this.getReadableSourceEntry(source);
        if (sourceEntry instanceof DartEntry) {
            DartEntry dartEntry = (DartEntry)sourceEntry;
            return dartEntry.getValue(DartEntry.IS_CLIENT) == false && dartEntry.getValue(DartEntry.IS_LAUNCHABLE) != false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeContext(AnalysisContext analysisContext) {
        if (analysisContext instanceof InstrumentedAnalysisContextImpl) {
            analysisContext = ((InstrumentedAnalysisContextImpl)analysisContext).getBasis();
        }
        if (!(analysisContext instanceof AnalysisContextImpl)) {
            return;
        }
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : ((AnalysisContextImpl)analysisContext).cache.entrySet()) {
                Source source = entry.getKey();
                SourceEntry sourceEntry = this.getReadableSourceEntry(source);
                if (sourceEntry != null) continue;
                this.cache.put(source, entry.getValue().getWritableCopy());
            }
        }
    }

    @Override
    public CompilationUnit parseCompilationUnit(Source source) throws AnalysisException {
        return this.getDartParseData(source, DartEntry.PARSED_UNIT, null);
    }

    @Override
    public HtmlUnit parseHtmlUnit(Source source) throws AnalysisException {
        return this.getHtmlParseData(source, HtmlEntry.PARSED_UNIT, null);
    }

    @Override
    public AnalysisResult performAnalysisTask() {
        long l;
        long l2;
        AnalysisTask analysisTask;
        long l3;
        block5: {
            l3 = System.currentTimeMillis();
            analysisTask = this.getNextAnalysisTask();
            l2 = System.currentTimeMillis();
            if (analysisTask == null && this.validateCacheConsistency()) {
                analysisTask = this.getNextAnalysisTask();
            }
            if (analysisTask == null) {
                return new AnalysisResult(this.getChangeNotices(true), l2 - l3, null, -1L);
            }
            String string = analysisTask.toString();
            l = System.currentTimeMillis();
            try {
                analysisTask.perform(this.resultRecorder);
            }
            catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
                AnalysisEngine.getInstance().getLogger().logInformation("Could not perform analysis task: " + string, obsoleteSourceAnalysisException);
            }
            catch (AnalysisException analysisException) {
                if (analysisException.getCause() instanceof IOException) break block5;
                AnalysisEngine.getInstance().getLogger().logError("Internal error while performing the task: " + analysisTask, analysisException);
            }
        }
        long l4 = System.currentTimeMillis();
        return new AnalysisResult(this.getChangeNotices(false), l2 - l3, analysisTask.getClass().getName(), l4 - l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordLibraryElements(Map<Source, LibraryElement> map) {
        Object object = this.cacheLock;
        synchronized (object) {
            Source source = this.sourceFactory.forUri("dart:html");
            for (Map.Entry<Source, LibraryElement> entry : map.entrySet()) {
                Source source2 = entry.getKey();
                LibraryElement libraryElement = entry.getValue();
                DartEntry dartEntry = this.getReadableDartEntry(source2);
                if (dartEntry == null) continue;
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                this.recordElementData(dartEntry, dartEntryImpl, libraryElement, libraryElement.getSource(), source);
                this.cache.put(source2, dartEntryImpl);
            }
        }
    }

    @Override
    public CompilationUnit resolveCompilationUnit(Source source, LibraryElement libraryElement) throws AnalysisException {
        if (libraryElement == null) {
            return null;
        }
        return this.resolveCompilationUnit(source, libraryElement.getSource());
    }

    @Override
    public CompilationUnit resolveCompilationUnit(Source source, Source source2) throws AnalysisException {
        return this.getDartResolutionData(source, source2, DartEntry.RESOLVED_UNIT, null);
    }

    @Override
    public HtmlUnit resolveHtmlUnit(Source source) throws AnalysisException {
        this.computeHtmlElement(source);
        return this.parseHtmlUnit(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnalysisOptions(AnalysisOptions analysisOptions) {
        Object object = this.cacheLock;
        synchronized (object) {
            boolean bl = this.options.getAnalyzeFunctionBodies() != analysisOptions.getAnalyzeFunctionBodies() || this.options.getGenerateSdkErrors() != analysisOptions.getGenerateSdkErrors() || this.options.getDart2jsHint() != analysisOptions.getDart2jsHint() || this.options.getHint() && !analysisOptions.getHint() || this.options.getPreserveComments() != analysisOptions.getPreserveComments();
            int n = analysisOptions.getCacheSize();
            if (this.options.getCacheSize() != n) {
                this.options.setCacheSize(n);
                this.cache.setMaxCacheSize(n);
                int n2 = n - 4;
                if (this.priorityOrder.length > n2) {
                    Source[] sourceArray = new Source[n2];
                    System.arraycopy(this.priorityOrder, 0, sourceArray, 0, n2);
                    this.priorityOrder = sourceArray;
                }
            }
            this.options.setAnalyzeFunctionBodies(analysisOptions.getAnalyzeFunctionBodies());
            this.options.setGenerateSdkErrors(analysisOptions.getGenerateSdkErrors());
            this.options.setDart2jsHint(analysisOptions.getDart2jsHint());
            this.options.setHint(analysisOptions.getHint());
            this.options.setIncremental(analysisOptions.getIncremental());
            this.options.setPreserveComments(analysisOptions.getPreserveComments());
            this.generateSdkErrors = analysisOptions.getGenerateSdkErrors();
            if (bl) {
                this.invalidateAllResolutionInformation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnalysisPriorityOrder(List<Source> list) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (list == null || list.isEmpty()) {
                this.priorityOrder = Source.EMPTY_ARRAY;
            } else {
                while (list.remove(null)) {
                }
                if (list.isEmpty()) {
                    this.priorityOrder = Source.EMPTY_ARRAY;
                }
                int n = Math.min(list.size(), this.options.getCacheSize() - 4);
                this.priorityOrder = new Source[n];
                for (int i = 0; i < n; ++i) {
                    this.priorityOrder[i] = list.get(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChangedContents(Source source, String string, int n, int n2, int n3) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.recentTasks.clear();
            String string2 = this.contentCache.setContents(source, string);
            if (string != null) {
                if (!string.equals(string2)) {
                    if (this.options.getIncremental()) {
                        this.incrementalAnalysisCache = IncrementalAnalysisCache.update(this.incrementalAnalysisCache, source, string2, string, n, n2, n3, this.getReadableSourceEntry(source));
                    }
                    this.sourceChanged(source);
                    SourceEntry sourceEntry = this.cache.get(source);
                    if (sourceEntry != null) {
                        SourceEntryImpl sourceEntryImpl = sourceEntry.getWritableCopy();
                        sourceEntryImpl.setModificationTime(this.contentCache.getModificationStamp(source));
                        sourceEntryImpl.setValue(SourceEntry.CONTENT, string);
                        this.cache.put(source, sourceEntryImpl);
                    }
                }
            } else if (string2 != null) {
                this.incrementalAnalysisCache = IncrementalAnalysisCache.clear(this.incrementalAnalysisCache, source);
                this.sourceChanged(source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(Source source, String string) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.recentTasks.clear();
            String string2 = this.contentCache.setContents(source, string);
            if (string != null) {
                if (!string.equals(string2)) {
                    this.incrementalAnalysisCache = IncrementalAnalysisCache.clear(this.incrementalAnalysisCache, source);
                    this.sourceChanged(source);
                    SourceEntry sourceEntry = this.cache.get(source);
                    if (sourceEntry != null) {
                        SourceEntryImpl sourceEntryImpl = sourceEntry.getWritableCopy();
                        sourceEntryImpl.setModificationTime(this.contentCache.getModificationStamp(source));
                        sourceEntryImpl.setValue(SourceEntry.CONTENT, string);
                        this.cache.put(source, sourceEntryImpl);
                    }
                }
            } else if (string2 != null) {
                this.incrementalAnalysisCache = IncrementalAnalysisCache.clear(this.incrementalAnalysisCache, source);
                this.sourceChanged(source);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSourceFactory(SourceFactory sourceFactory) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.sourceFactory == sourceFactory) {
                return;
            }
            if (sourceFactory.getContext() != null) {
                throw new IllegalStateException("Source factories cannot be shared between contexts");
            }
            if (this.sourceFactory != null) {
                this.sourceFactory.setContext(null);
            }
            sourceFactory.setContext(this);
            this.sourceFactory = sourceFactory;
            this.coreLibrarySource = this.sourceFactory.forUri("dart:core");
            this.invalidateAllResolutionInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DartEntry recordResolveDartLibraryCycleTaskResults(ResolveDartLibraryCycleTask resolveDartLibraryCycleTask) throws AnalysisException {
        LibraryResolver2 libraryResolver2 = resolveDartLibraryCycleTask.getLibraryResolver();
        AnalysisException analysisException = resolveDartLibraryCycleTask.getException();
        DartEntry dartEntry = null;
        Source source = resolveDartLibraryCycleTask.getUnitSource();
        if (libraryResolver2 != null) {
            List<ResolvableLibrary> list = libraryResolver2.getResolvedLibraries();
            if (list == null) {
                dartEntry = this.getReadableDartEntry(source);
                if (dartEntry == null) {
                    throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
                }
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                dartEntryImpl.recordResolutionError();
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                this.cache.remove(source);
                if (analysisException != null) {
                    throw analysisException;
                }
                return dartEntryImpl;
            }
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.allModificationTimesMatch(list)) {
                    Source source2 = this.getSourceFactory().forUri("dart:html");
                    RecordingErrorListener recordingErrorListener = libraryResolver2.getErrorListener();
                    for (ResolvableLibrary resolvableLibrary : list) {
                        Source source3 = resolvableLibrary.getLibrarySource();
                        for (Source source4 : resolvableLibrary.getCompilationUnitSources()) {
                            CompilationUnit compilationUnit = resolvableLibrary.getAST(source4);
                            AnalysisError[] analysisErrorArray = recordingErrorListener.getErrorsForSource(source4);
                            LineInfo lineInfo = this.getLineInfo(source4);
                            DartEntry dartEntry2 = (DartEntry)this.cache.get(source4);
                            long l = this.getModificationStamp(source4);
                            if (dartEntry2.getModificationTime() != l) {
                                this.sourceChanged(source4);
                                dartEntry2 = this.getReadableDartEntry(source4);
                                if (dartEntry2 == null) {
                                    throw new AnalysisException("A Dart file became a non-Dart file: " + source4.getFullName());
                                }
                            }
                            DartEntryImpl dartEntryImpl = dartEntry2.getWritableCopy();
                            if (analysisException == null) {
                                dartEntryImpl.setValue(SourceEntry.LINE_INFO, lineInfo);
                                dartEntryImpl.setState(DartEntry.PARSED_UNIT, CacheState.FLUSHED);
                                dartEntryImpl.setValueInLibrary(DartEntry.RESOLVED_UNIT, source3, compilationUnit);
                                dartEntryImpl.setValueInLibrary(DartEntry.RESOLUTION_ERRORS, source3, analysisErrorArray);
                                if (((Object)source4).equals(source3)) {
                                    this.recordElementData(dartEntry2, dartEntryImpl, resolvableLibrary.getLibraryElement(), source3, source2);
                                }
                                this.cache.storedAst(source4);
                            } else {
                                dartEntryImpl.recordResolutionError();
                                this.cache.remove(source4);
                            }
                            dartEntryImpl.setException(analysisException);
                            this.cache.put(source4, dartEntryImpl);
                            if (!((Object)source4).equals(source3)) {
                                this.workManager.add(source4, SourcePriority.PRIORITY_PART);
                            }
                            if (((Object)source4).equals(source)) {
                                dartEntry = dartEntryImpl;
                            }
                            ChangeNoticeImpl changeNoticeImpl = this.getNotice(source4);
                            changeNoticeImpl.setCompilationUnit(compilationUnit);
                            changeNoticeImpl.setErrors(dartEntryImpl.getAllErrors(), lineInfo);
                        }
                    }
                } else {
                    PrintStringWriter printStringWriter = new PrintStringWriter();
                    printStringWriter.println("Library resolution results discarded for");
                    for (ResolvableLibrary resolvableLibrary : list) {
                        for (Source source5 : resolvableLibrary.getCompilationUnitSources()) {
                            DartEntry dartEntry3 = this.getReadableDartEntry(source5);
                            if (dartEntry3 != null) {
                                long l = resolvableLibrary.getModificationTime(source5);
                                printStringWriter.println("  " + this.debuggingString(source5) + "; sourceTime = " + this.getModificationStamp(source5) + ", resultTime = " + l + ", cacheTime = " + dartEntry3.getModificationTime());
                                DartEntryImpl dartEntryImpl = dartEntry3.getWritableCopy();
                                if (analysisException == null || l >= 0L) {
                                    dartEntryImpl.recordResolutionNotInProcess();
                                } else {
                                    dartEntryImpl.recordResolutionError();
                                    this.cache.remove(source5);
                                }
                                dartEntryImpl.setException(analysisException);
                                this.cache.put(source5, dartEntryImpl);
                                if (!((Object)source5).equals(source)) continue;
                                dartEntry = dartEntryImpl;
                                continue;
                            }
                            printStringWriter.println("  " + this.debuggingString(source5) + "; sourceTime = " + this.getModificationStamp(source5) + ", no entry");
                        }
                    }
                    this.logInformation(printStringWriter.toString());
                }
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        if (dartEntry == null && (dartEntry = this.getReadableDartEntry(source)) == null) {
            throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
        }
        return dartEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DartEntry recordResolveDartLibraryTaskResults(ResolveDartLibraryTask resolveDartLibraryTask) throws AnalysisException {
        LibraryResolver libraryResolver = resolveDartLibraryTask.getLibraryResolver();
        AnalysisException analysisException = resolveDartLibraryTask.getException();
        DartEntry dartEntry = null;
        Source source = resolveDartLibraryTask.getUnitSource();
        if (libraryResolver != null) {
            Set<Library> set = libraryResolver.getResolvedLibraries();
            if (set == null) {
                dartEntry = this.getReadableDartEntry(source);
                if (dartEntry == null) {
                    throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
                }
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                dartEntryImpl.recordResolutionError();
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                this.cache.remove(source);
                if (analysisException != null) {
                    throw analysisException;
                }
                return dartEntryImpl;
            }
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.allModificationTimesMatch(set)) {
                    Source source2 = this.getSourceFactory().forUri("dart:html");
                    RecordingErrorListener recordingErrorListener = libraryResolver.getErrorListener();
                    for (Library library : set) {
                        Source source3 = library.getLibrarySource();
                        for (Source source4 : library.getCompilationUnitSources()) {
                            CompilationUnit compilationUnit = library.getAST(source4);
                            AnalysisError[] analysisErrorArray = recordingErrorListener.getErrorsForSource(source4);
                            LineInfo lineInfo = this.getLineInfo(source4);
                            DartEntry dartEntry2 = (DartEntry)this.cache.get(source4);
                            long l = this.getModificationStamp(source4);
                            if (dartEntry2.getModificationTime() != l) {
                                this.sourceChanged(source4);
                                dartEntry2 = this.getReadableDartEntry(source4);
                                if (dartEntry2 == null) {
                                    throw new AnalysisException("A Dart file became a non-Dart file: " + source4.getFullName());
                                }
                            }
                            DartEntryImpl dartEntryImpl = dartEntry2.getWritableCopy();
                            if (analysisException == null) {
                                dartEntryImpl.setValue(SourceEntry.LINE_INFO, lineInfo);
                                dartEntryImpl.setState(DartEntry.PARSED_UNIT, CacheState.FLUSHED);
                                dartEntryImpl.setValueInLibrary(DartEntry.RESOLVED_UNIT, source3, compilationUnit);
                                dartEntryImpl.setValueInLibrary(DartEntry.RESOLUTION_ERRORS, source3, analysisErrorArray);
                                if (((Object)source4).equals(source3)) {
                                    this.recordElementData(dartEntry2, dartEntryImpl, library.getLibraryElement(), source3, source2);
                                }
                                this.cache.storedAst(source4);
                            } else {
                                dartEntryImpl.recordResolutionError();
                                this.cache.remove(source4);
                            }
                            dartEntryImpl.setException(analysisException);
                            this.cache.put(source4, dartEntryImpl);
                            if (!((Object)source4).equals(source3)) {
                                this.workManager.add(source4, SourcePriority.PRIORITY_PART);
                            }
                            if (((Object)source4).equals(source)) {
                                dartEntry = dartEntryImpl;
                            }
                            ChangeNoticeImpl changeNoticeImpl = this.getNotice(source4);
                            changeNoticeImpl.setCompilationUnit(compilationUnit);
                            changeNoticeImpl.setErrors(dartEntryImpl.getAllErrors(), lineInfo);
                        }
                    }
                } else {
                    PrintStringWriter printStringWriter = new PrintStringWriter();
                    printStringWriter.println("Library resolution results discarded for");
                    for (Library library : set) {
                        for (Source source5 : library.getCompilationUnitSources()) {
                            DartEntry dartEntry3 = this.getReadableDartEntry(source5);
                            if (dartEntry3 != null) {
                                long l = library.getModificationTime(source5);
                                printStringWriter.println("  " + this.debuggingString(source5) + "; sourceTime = " + this.getModificationStamp(source5) + ", resultTime = " + l + ", cacheTime = " + dartEntry3.getModificationTime());
                                DartEntryImpl dartEntryImpl = dartEntry3.getWritableCopy();
                                if (analysisException == null || l >= 0L) {
                                    dartEntryImpl.recordResolutionNotInProcess();
                                } else {
                                    dartEntryImpl.recordResolutionError();
                                    this.cache.remove(source5);
                                }
                                dartEntryImpl.setException(analysisException);
                                this.cache.put(source5, dartEntryImpl);
                                if (!((Object)source5).equals(source)) continue;
                                dartEntry = dartEntryImpl;
                                continue;
                            }
                            printStringWriter.println("  " + this.debuggingString(source5) + "; sourceTime = " + this.getModificationStamp(source5) + ", no entry");
                        }
                    }
                    this.logInformation(printStringWriter.toString());
                }
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        if (dartEntry == null && (dartEntry = this.getReadableDartEntry(source)) == null) {
            throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
        }
        return dartEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accessedAst(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cache.accessedAst(source);
        }
    }

    private void addSourcesInContainer(ArrayList<Source> arrayList, SourceContainer sourceContainer) {
        for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
            Source source = entry.getKey();
            if (!sourceContainer.contains(source)) continue;
            arrayList.add(source);
        }
    }

    private boolean allModificationTimesMatch(List<ResolvableLibrary> list) throws AnalysisException {
        boolean bl = true;
        for (ResolvableLibrary resolvableLibrary : list) {
            for (Source source : resolvableLibrary.getCompilationUnitSources()) {
                long l;
                DartEntry dartEntry = this.getReadableDartEntry(source);
                if (dartEntry == null) {
                    throw new AnalysisException("Internal error: attempting to resolve non-Dart file as a Dart file: " + source.getFullName());
                }
                long l2 = this.getModificationStamp(source);
                if (l2 == (l = resolvableLibrary.getModificationTime(source))) continue;
                this.sourceChanged(source);
                bl = false;
            }
        }
        return bl;
    }

    private boolean allModificationTimesMatch(Set<Library> set) throws AnalysisException {
        boolean bl = true;
        for (Library library : set) {
            for (Source source : library.getCompilationUnitSources()) {
                long l;
                DartEntry dartEntry = this.getReadableDartEntry(source);
                if (dartEntry == null) {
                    throw new AnalysisException("Internal error: attempting to resolve non-Dart file as a Dart file: " + source.getFullName());
                }
                long l2 = this.getModificationStamp(source);
                if (l2 == (l = library.getModificationTime(source))) continue;
                this.sourceChanged(source);
                bl = false;
            }
        }
        return bl;
    }

    private DartEntry cacheDartHintData(Source source, Source source2, DartEntry dartEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        CacheState cacheState = dartEntry.getStateInLibrary(dataDescriptor, source2);
        while (cacheState != CacheState.ERROR && cacheState != CacheState.VALID) {
            DartEntry dartEntry2 = this.getReadableDartEntry(source2);
            dartEntry2 = this.cacheDartResolutionData(source2, source2, dartEntry2, DartEntry.ELEMENT);
            LibraryElement libraryElement = dartEntry2.getValue(DartEntry.ELEMENT);
            CompilationUnitElement compilationUnitElement = libraryElement.getDefiningCompilationUnit();
            CompilationUnitElement[] compilationUnitElementArray = libraryElement.getParts();
            TimestampedData[] timestampedDataArray = new TimestampedData[compilationUnitElementArray.length + 1];
            timestampedDataArray[0] = this.getResolvedUnit(compilationUnitElement, source2);
            if (timestampedDataArray[0] == null) {
                Source source3 = compilationUnitElement.getSource();
                timestampedDataArray[0] = new TimestampedData<CompilationUnit>(this.getModificationStamp(source3), this.resolveCompilationUnit(source3, libraryElement));
            }
            for (int i = 0; i < compilationUnitElementArray.length; ++i) {
                timestampedDataArray[i + 1] = this.getResolvedUnit(compilationUnitElementArray[i], source2);
                if (timestampedDataArray[i + 1] != null) continue;
                Source source4 = compilationUnitElementArray[i].getSource();
                timestampedDataArray[i + 1] = new TimestampedData<CompilationUnit>(this.getModificationStamp(source4), this.resolveCompilationUnit(source4, libraryElement));
            }
            dartEntry = (DartEntry)new GenerateDartHintsTask(this, timestampedDataArray, this.getLibraryElement(source2)).perform(this.resultRecorder);
            cacheState = dartEntry.getStateInLibrary(dataDescriptor, source2);
        }
        return dartEntry;
    }

    private DartEntry cacheDartParseData(Source source, DartEntry dartEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        if (dataDescriptor == DartEntry.PARSED_UNIT && dartEntry.hasResolvableCompilationUnit()) {
            return dartEntry;
        }
        CacheState cacheState = dartEntry.getState(dataDescriptor);
        while (cacheState != CacheState.ERROR && cacheState != CacheState.VALID) {
            dartEntry = this.cacheDartScanData(source, dartEntry, DartEntry.TOKEN_STREAM);
            dartEntry = (DartEntry)new ParseDartTask(this, source, dartEntry.getModificationTime(), dartEntry.getValue(DartEntry.TOKEN_STREAM), dartEntry.getValue(SourceEntry.LINE_INFO)).perform(this.resultRecorder);
            cacheState = dartEntry.getState(dataDescriptor);
        }
        return dartEntry;
    }

    private DartEntry cacheDartResolutionData(Source source, Source source2, DartEntry dartEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        CacheState cacheState;
        CacheState cacheState2 = cacheState = dataDescriptor == DartEntry.ELEMENT ? dartEntry.getState(dataDescriptor) : dartEntry.getStateInLibrary(dataDescriptor, source2);
        while (cacheState != CacheState.ERROR && cacheState != CacheState.VALID) {
            dartEntry = (DartEntry)new ResolveDartLibraryTask(this, source, source2).perform(this.resultRecorder);
            cacheState = dataDescriptor == DartEntry.ELEMENT ? dartEntry.getState(dataDescriptor) : dartEntry.getStateInLibrary(dataDescriptor, source2);
        }
        return dartEntry;
    }

    private DartEntry cacheDartScanData(Source source, DartEntry dartEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        CacheState cacheState = dartEntry.getState(dataDescriptor);
        while (cacheState != CacheState.ERROR && cacheState != CacheState.VALID) {
            try {
                if (dartEntry.getState(SourceEntry.CONTENT) != CacheState.VALID) {
                    dartEntry = (DartEntry)new GetContentTask(this, source).perform(this.resultRecorder);
                }
                dartEntry = (DartEntry)new ScanDartTask(this, source, dartEntry.getModificationTime(), dartEntry.getValue(SourceEntry.CONTENT)).perform(this.resultRecorder);
            }
            catch (AnalysisException analysisException) {
                throw analysisException;
            }
            catch (Exception exception) {
                throw new AnalysisException(exception);
            }
            cacheState = dartEntry.getState(dataDescriptor);
        }
        return dartEntry;
    }

    private DartEntry cacheDartVerificationData(Source source, Source source2, DartEntry dartEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        CacheState cacheState = dartEntry.getStateInLibrary(dataDescriptor, source2);
        while (cacheState != CacheState.ERROR && cacheState != CacheState.VALID) {
            LibraryElement libraryElement = this.computeLibraryElement(source2);
            dartEntry = (DartEntry)new GenerateDartErrorsTask(this, source, dartEntry.getModificationTime(), this.resolveCompilationUnit(source, libraryElement), libraryElement).perform(this.resultRecorder);
            cacheState = dartEntry.getStateInLibrary(dataDescriptor, source2);
        }
        return dartEntry;
    }

    private HtmlEntry cacheHtmlParseData(Source source, HtmlEntry htmlEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        Object object;
        if (dataDescriptor == HtmlEntry.PARSED_UNIT && (object = htmlEntry.getAnyParsedUnit()) != null) {
            return htmlEntry;
        }
        object = htmlEntry.getState(dataDescriptor);
        while (object != CacheState.ERROR && object != CacheState.VALID) {
            try {
                if (htmlEntry.getState(SourceEntry.CONTENT) != CacheState.VALID) {
                    htmlEntry = (HtmlEntry)new GetContentTask(this, source).perform(this.resultRecorder);
                }
                htmlEntry = (HtmlEntry)new ParseHtmlTask(this, source, htmlEntry.getModificationTime(), htmlEntry.getValue(SourceEntry.CONTENT)).perform(this.resultRecorder);
            }
            catch (AnalysisException analysisException) {
                throw analysisException;
            }
            catch (Exception exception) {
                throw new AnalysisException(exception);
            }
            object = htmlEntry.getState(dataDescriptor);
        }
        return htmlEntry;
    }

    private HtmlEntry cacheHtmlResolutionData(Source source, HtmlEntry htmlEntry, DataDescriptor<?> dataDescriptor) throws AnalysisException {
        CacheState cacheState = htmlEntry.getState(dataDescriptor);
        while (cacheState != CacheState.ERROR && cacheState != CacheState.VALID) {
            htmlEntry = this.cacheHtmlParseData(source, htmlEntry, HtmlEntry.PARSED_UNIT);
            htmlEntry = (HtmlEntry)new ResolveHtmlTask(this, source, htmlEntry.getModificationTime(), htmlEntry.getValue(HtmlEntry.PARSED_UNIT)).perform(this.resultRecorder);
            cacheState = htmlEntry.getState(dataDescriptor);
        }
        return htmlEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source computeSourceFromEncoding(String string) {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.sourceFactory.fromEncoding(string);
        }
    }

    private boolean contains(Source[] sourceArray, Source source) {
        for (Source source2 : sourceArray) {
            if (!((Object)source2).equals(source)) continue;
            return true;
        }
        return false;
    }

    private boolean containsAny(Source[] sourceArray, Source[] sourceArray2) {
        for (Source source : sourceArray2) {
            if (!this.contains(sourceArray, source)) continue;
            return true;
        }
        return false;
    }

    private TaskData createGenerateDartErrorsTask(Source source, DartEntry dartEntry, Source source2, DartEntry dartEntry2) {
        if (dartEntry.getStateInLibrary(DartEntry.RESOLVED_UNIT, source2) != CacheState.VALID || dartEntry2.getState(DartEntry.ELEMENT) != CacheState.VALID) {
            return this.createResolveDartLibraryTask(source2, dartEntry2);
        }
        CompilationUnit compilationUnit = dartEntry.getValueInLibrary(DartEntry.RESOLVED_UNIT, source2);
        LibraryElement libraryElement = dartEntry2.getValue(DartEntry.ELEMENT);
        DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
        dartEntryImpl.setStateInLibrary(DartEntry.VERIFICATION_ERRORS, source2, CacheState.IN_PROCESS);
        this.cache.put(source, dartEntryImpl);
        return new TaskData(new GenerateDartErrorsTask(this, source, dartEntryImpl.getModificationTime(), compilationUnit, libraryElement), false);
    }

    private TaskData createGenerateDartHintsTask(Source source, DartEntry dartEntry, Source source2, DartEntry dartEntry2) {
        if (dartEntry2.getState(DartEntry.ELEMENT) != CacheState.VALID) {
            return this.createResolveDartLibraryTask(source2, dartEntry2);
        }
        LibraryElement libraryElement = dartEntry2.getValue(DartEntry.ELEMENT);
        CompilationUnitElement compilationUnitElement = libraryElement.getDefiningCompilationUnit();
        CompilationUnitElement[] compilationUnitElementArray = libraryElement.getParts();
        TimestampedData[] timestampedDataArray = new TimestampedData[compilationUnitElementArray.length + 1];
        timestampedDataArray[0] = this.getResolvedUnit(compilationUnitElement, source2);
        if (timestampedDataArray[0] == null) {
            return this.createResolveDartLibraryTask(source2, dartEntry2);
        }
        for (int i = 0; i < compilationUnitElementArray.length; ++i) {
            timestampedDataArray[i + 1] = this.getResolvedUnit(compilationUnitElementArray[i], source2);
            if (timestampedDataArray[i + 1] != null) continue;
            return this.createResolveDartLibraryTask(source2, dartEntry2);
        }
        DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
        dartEntryImpl.setStateInLibrary(DartEntry.HINTS, source2, CacheState.IN_PROCESS);
        this.cache.put(source, dartEntryImpl);
        return new TaskData(new GenerateDartHintsTask(this, timestampedDataArray, libraryElement), false);
    }

    private TaskData createGetContentTask(Source source, SourceEntry sourceEntry) {
        SourceEntryImpl sourceEntryImpl = sourceEntry.getWritableCopy();
        sourceEntryImpl.setState(SourceEntry.CONTENT, CacheState.IN_PROCESS);
        this.cache.put(source, sourceEntryImpl);
        return new TaskData(new GetContentTask(this, source), false);
    }

    private TaskData createParseDartTask(Source source, DartEntry dartEntry) {
        if (dartEntry.getState(DartEntry.TOKEN_STREAM) != CacheState.VALID || dartEntry.getState(SourceEntry.LINE_INFO) != CacheState.VALID) {
            return this.createScanDartTask(source, dartEntry);
        }
        Token token = dartEntry.getValue(DartEntry.TOKEN_STREAM);
        DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
        dartEntryImpl.setState(DartEntry.TOKEN_STREAM, CacheState.FLUSHED);
        dartEntryImpl.setState(DartEntry.PARSE_ERRORS, CacheState.IN_PROCESS);
        this.cache.put(source, dartEntryImpl);
        return new TaskData(new ParseDartTask(this, source, dartEntryImpl.getModificationTime(), token, dartEntry.getValue(SourceEntry.LINE_INFO)), false);
    }

    private TaskData createParseHtmlTask(Source source, HtmlEntry htmlEntry) {
        if (htmlEntry.getState(SourceEntry.CONTENT) != CacheState.VALID) {
            return this.createGetContentTask(source, htmlEntry);
        }
        CharSequence charSequence = htmlEntry.getValue(SourceEntry.CONTENT);
        HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
        htmlEntryImpl.setState(SourceEntry.CONTENT, CacheState.FLUSHED);
        htmlEntryImpl.setState(HtmlEntry.PARSE_ERRORS, CacheState.IN_PROCESS);
        this.cache.put(source, htmlEntryImpl);
        return new TaskData(new ParseHtmlTask(this, source, htmlEntryImpl.getModificationTime(), charSequence), false);
    }

    private TaskData createResolveAngularComponentTemplateTask(Source source, HtmlEntry htmlEntry) {
        if (htmlEntry.getState(HtmlEntry.RESOLVED_UNIT) != CacheState.VALID) {
            return this.createResolveHtmlTask(source, htmlEntry);
        }
        AngularApplication angularApplication = htmlEntry.getValue(HtmlEntry.ANGULAR_APPLICATION);
        AngularComponentElement angularComponentElement = htmlEntry.getValue(HtmlEntry.ANGULAR_COMPONENT);
        HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
        htmlEntryImpl.setState(HtmlEntry.ANGULAR_ERRORS, CacheState.IN_PROCESS);
        this.cache.put(source, htmlEntryImpl);
        return new TaskData(new ResolveAngularComponentTemplateTask(this, source, htmlEntryImpl.getModificationTime(), htmlEntryImpl.getValue(HtmlEntry.RESOLVED_UNIT), angularComponentElement, angularApplication), false);
    }

    private TaskData createResolveAngularEntryHtmlTask(Source source, HtmlEntry htmlEntry) {
        if (htmlEntry.getState(HtmlEntry.RESOLVED_UNIT) != CacheState.VALID) {
            return this.createResolveHtmlTask(source, htmlEntry);
        }
        HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
        htmlEntryImpl.setState(HtmlEntry.ANGULAR_ENTRY, CacheState.IN_PROCESS);
        this.cache.put(source, htmlEntryImpl);
        return new TaskData(new ResolveAngularEntryHtmlTask(this, source, htmlEntryImpl.getModificationTime(), htmlEntryImpl.getValue(HtmlEntry.RESOLVED_UNIT)), false);
    }

    private TaskData createResolveDartLibraryTask(Source source, DartEntry dartEntry) {
        try {
            CycleBuilder cycleBuilder = new CycleBuilder();
            cycleBuilder.computeCycleContaining(source);
            TaskData taskData = cycleBuilder.getTaskData();
            if (taskData != null) {
                return taskData;
            }
            return new TaskData(new ResolveDartLibraryCycleTask(this, source, source, cycleBuilder.getLibrariesInCycle()), false);
        }
        catch (AnalysisException analysisException) {
            AnalysisEngine.getInstance().getLogger().logError("Internal error trying to compute the next analysis task", analysisException);
            return new TaskData(null, false);
        }
    }

    private TaskData createResolveHtmlTask(Source source, HtmlEntry htmlEntry) {
        if (htmlEntry.getState(HtmlEntry.PARSED_UNIT) != CacheState.VALID) {
            return this.createParseHtmlTask(source, htmlEntry);
        }
        HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
        htmlEntryImpl.setState(HtmlEntry.RESOLVED_UNIT, CacheState.IN_PROCESS);
        this.cache.put(source, htmlEntryImpl);
        return new TaskData(new ResolveHtmlTask(this, source, htmlEntryImpl.getModificationTime(), htmlEntryImpl.getValue(HtmlEntry.PARSED_UNIT)), false);
    }

    private TaskData createScanDartTask(Source source, DartEntry dartEntry) {
        if (dartEntry.getState(SourceEntry.CONTENT) != CacheState.VALID) {
            return this.createGetContentTask(source, dartEntry);
        }
        CharSequence charSequence = dartEntry.getValue(SourceEntry.CONTENT);
        DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
        dartEntryImpl.setState(SourceEntry.CONTENT, CacheState.FLUSHED);
        dartEntryImpl.setState(DartEntry.SCAN_ERRORS, CacheState.IN_PROCESS);
        this.cache.put(source, dartEntryImpl);
        return new TaskData(new ScanDartTask(this, source, dartEntryImpl.getModificationTime(), charSequence), false);
    }

    private SourceEntry createSourceEntry(Source source, boolean bl) {
        String string = source.getShortName();
        if (AnalysisEngine.isHtmlFileName(string)) {
            HtmlEntryImpl htmlEntryImpl = new HtmlEntryImpl();
            htmlEntryImpl.setModificationTime(this.getModificationStamp(source));
            htmlEntryImpl.setExplicitlyAdded(bl);
            this.cache.put(source, htmlEntryImpl);
            return htmlEntryImpl;
        }
        DartEntryImpl dartEntryImpl = new DartEntryImpl();
        dartEntryImpl.setModificationTime(this.getModificationStamp(source));
        dartEntryImpl.setExplicitlyAdded(bl);
        this.cache.put(source, dartEntryImpl);
        return dartEntryImpl;
    }

    private String debuggingString(Source source) {
        return "'" + source.getFullName() + "' [" + this.getModificationStamp(source) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeNotice[] getChangeNotices(boolean bl) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.pendingNotices.isEmpty()) {
                if (bl) {
                    return null;
                }
                return ChangeNoticeImpl.EMPTY_ARRAY;
            }
            ChangeNotice[] changeNoticeArray = this.pendingNotices.values().toArray(new ChangeNotice[this.pendingNotices.size()]);
            this.pendingNotices.clear();
            return changeNoticeArray;
        }
    }

    private <E> E getDartHintData(Source source, Source source2, DartEntry dartEntry, DataDescriptor<E> dataDescriptor) throws AnalysisException {
        dartEntry = this.cacheDartHintData(source, source2, dartEntry, dataDescriptor);
        if (dataDescriptor == DartEntry.ELEMENT) {
            return dartEntry.getValue(dataDescriptor);
        }
        return dartEntry.getValueInLibrary(dataDescriptor, source2);
    }

    private <E> E getDartParseData(Source source, DartEntry dartEntry, DataDescriptor<E> dataDescriptor) throws AnalysisException {
        dartEntry = this.cacheDartParseData(source, dartEntry, dataDescriptor);
        if (dataDescriptor == DartEntry.PARSED_UNIT) {
            this.accessedAst(source);
            return (E)dartEntry.getAnyParsedCompilationUnit();
        }
        return dartEntry.getValue(dataDescriptor);
    }

    private <E> E getDartParseData(Source source, DataDescriptor<E> dataDescriptor, E e) throws AnalysisException {
        DartEntry dartEntry = this.getReadableDartEntry(source);
        if (dartEntry == null) {
            return e;
        }
        try {
            return this.getDartParseData(source, dartEntry, dataDescriptor);
        }
        catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
            AnalysisEngine.getInstance().getLogger().logInformation("Could not compute " + dataDescriptor.toString(), obsoleteSourceAnalysisException);
            return e;
        }
    }

    private <E> E getDartResolutionData(Source source, Source source2, DartEntry dartEntry, DataDescriptor<E> dataDescriptor) throws AnalysisException {
        dartEntry = this.cacheDartResolutionData(source, source2, dartEntry, dataDescriptor);
        if (dataDescriptor == DartEntry.ELEMENT) {
            return dartEntry.getValue(dataDescriptor);
        }
        if (dataDescriptor == DartEntry.RESOLVED_UNIT) {
            this.accessedAst(source);
        }
        return dartEntry.getValueInLibrary(dataDescriptor, source2);
    }

    private <E> E getDartResolutionData(Source source, Source source2, DataDescriptor<E> dataDescriptor, E e) throws AnalysisException {
        DartEntry dartEntry = this.getReadableDartEntry(source);
        if (dartEntry == null) {
            return e;
        }
        try {
            return this.getDartResolutionData(source, source2, dartEntry, dataDescriptor);
        }
        catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
            AnalysisEngine.getInstance().getLogger().logInformation("Could not compute " + dataDescriptor.toString(), obsoleteSourceAnalysisException);
            return e;
        }
    }

    private <E> E getDartScanData(Source source, DartEntry dartEntry, DataDescriptor<E> dataDescriptor) throws AnalysisException {
        dartEntry = this.cacheDartScanData(source, dartEntry, dataDescriptor);
        return dartEntry.getValue(dataDescriptor);
    }

    private <E> E getDartScanData(Source source, DataDescriptor<E> dataDescriptor, E e) throws AnalysisException {
        DartEntry dartEntry = this.getReadableDartEntry(source);
        if (dartEntry == null) {
            return e;
        }
        try {
            return this.getDartScanData(source, dartEntry, dataDescriptor);
        }
        catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
            AnalysisEngine.getInstance().getLogger().logInformation("Could not compute " + dataDescriptor.toString(), obsoleteSourceAnalysisException);
            return e;
        }
    }

    private <E> E getDartVerificationData(Source source, Source source2, DartEntry dartEntry, DataDescriptor<E> dataDescriptor) throws AnalysisException {
        dartEntry = this.cacheDartVerificationData(source, source2, dartEntry, dataDescriptor);
        return dartEntry.getValueInLibrary(dataDescriptor, source2);
    }

    private <E> E getHtmlParseData(Source source, DataDescriptor<E> dataDescriptor, E e) throws AnalysisException {
        HtmlEntry htmlEntry = this.getReadableHtmlEntry(source);
        if (htmlEntry == null) {
            return e;
        }
        htmlEntry = this.cacheHtmlParseData(source, htmlEntry, dataDescriptor);
        if (dataDescriptor == HtmlEntry.PARSED_UNIT) {
            this.accessedAst(source);
            return (E)htmlEntry.getAnyParsedUnit();
        }
        return htmlEntry.getValue(dataDescriptor);
    }

    private <E> E getHtmlResolutionData(Source source, DataDescriptor<E> dataDescriptor, E e) throws AnalysisException {
        HtmlEntry htmlEntry = this.getReadableHtmlEntry(source);
        if (htmlEntry == null) {
            return e;
        }
        try {
            return this.getHtmlResolutionData(source, htmlEntry, dataDescriptor);
        }
        catch (ObsoleteSourceAnalysisException obsoleteSourceAnalysisException) {
            AnalysisEngine.getInstance().getLogger().logInformation("Could not compute " + dataDescriptor.toString(), obsoleteSourceAnalysisException);
            return e;
        }
    }

    private <E> E getHtmlResolutionData(Source source, HtmlEntry htmlEntry, DataDescriptor<E> dataDescriptor) throws AnalysisException {
        htmlEntry = this.cacheHtmlResolutionData(source, htmlEntry, dataDescriptor);
        if (dataDescriptor == HtmlEntry.RESOLVED_UNIT) {
            this.accessedAst(source);
        }
        return htmlEntry.getValue(dataDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private AnalysisTask getNextAnalysisTask() {
        Object object = this.cacheLock;
        synchronized (object) {
            Object object2;
            Object object3;
            boolean bl = this.options.getHint();
            boolean bl2 = false;
            if (this.incrementalAnalysisCache != null && this.incrementalAnalysisCache.hasWork()) {
                IncrementalAnalysisTask incrementalAnalysisTask = new IncrementalAnalysisTask(this, this.incrementalAnalysisCache);
                this.incrementalAnalysisCache = null;
                return incrementalAnalysisTask;
            }
            for (Source source : this.priorityOrder) {
                TaskData object4 = this.getNextAnalysisTaskForSource(source, this.cache.get(source), true, bl);
                object3 = object4.getTask();
                if (object3 != null) {
                    return object3;
                }
                if (!object4.isBlocked()) continue;
                bl2 = true;
            }
            if (this.neededForResolution != null) {
                void var7_16;
                ArrayList<Source> arrayList = new ArrayList<Source>();
                for (Source source : this.neededForResolution) {
                    object3 = this.cache.get(source);
                    if (!(object3 instanceof DartEntry) || (object2 = (DartEntry)object3).hasResolvableCompilationUnit()) continue;
                    if (object2.getState(DartEntry.PARSED_UNIT) == CacheState.ERROR) {
                        arrayList.add(source);
                        continue;
                    }
                    TaskData taskData = this.createParseDartTask(source, (DartEntry)object2);
                    AnalysisTask analysisTask = taskData.getTask();
                    if (analysisTask != null) {
                        return analysisTask;
                    }
                    if (!taskData.isBlocked()) continue;
                    bl2 = true;
                }
                int n = arrayList.size();
                boolean n2 = false;
                while (var7_16 < n) {
                    this.neededForResolution.remove(arrayList.get((int)var7_16));
                    ++var7_16;
                }
            }
            ArrayList<Source> arrayList = new ArrayList<Source>();
            WorkManager.WorkIterator workIterator = this.workManager.iterator();
            while (workIterator.hasNext()) {
                Source source = workIterator.next();
                object3 = this.getNextAnalysisTaskForSource(source, this.cache.get(source), false, bl);
                object2 = ((TaskData)object3).getTask();
                if (object2 != null) {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        this.workManager.remove((Source)arrayList.get(i));
                    }
                    return object2;
                }
                if (((TaskData)object3).isBlocked()) {
                    bl2 = true;
                    continue;
                }
                arrayList.add(source);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.workManager.remove((Source)arrayList.get(i));
            }
            if (bl2) {
                return WaitForAsyncTask.getInstance();
            }
            return null;
        }
    }

    private TaskData getNextAnalysisTaskForSource(Source source, SourceEntry sourceEntry, boolean bl, boolean bl2) {
        if (sourceEntry == null) {
            return new TaskData(null, false);
        }
        CacheState cacheState = sourceEntry.getState(SourceEntry.CONTENT);
        if (cacheState == CacheState.INVALID) {
            return this.createGetContentTask(source, sourceEntry);
        }
        if (cacheState == CacheState.IN_PROCESS) {
            return new TaskData(null, true);
        }
        if (cacheState == CacheState.ERROR) {
            return new TaskData(null, false);
        }
        if (sourceEntry instanceof DartEntry) {
            Source[] sourceArray;
            DartEntry dartEntry = (DartEntry)sourceEntry;
            CacheState cacheState2 = dartEntry.getState(DartEntry.SCAN_ERRORS);
            if (cacheState2 == CacheState.INVALID || bl && cacheState2 == CacheState.FLUSHED) {
                return this.createScanDartTask(source, dartEntry);
            }
            CacheState cacheState3 = dartEntry.getState(DartEntry.PARSE_ERRORS);
            if (cacheState3 == CacheState.INVALID || bl && cacheState3 == CacheState.FLUSHED) {
                return this.createParseDartTask(source, dartEntry);
            }
            if (bl && cacheState3 != CacheState.ERROR && !dartEntry.hasResolvableCompilationUnit()) {
                return this.createParseDartTask(source, dartEntry);
            }
            SourceKind sourceKind = dartEntry.getValue(DartEntry.SOURCE_KIND);
            if (sourceKind == SourceKind.UNKNOWN) {
                return this.createParseDartTask(source, dartEntry);
            }
            if (sourceKind == SourceKind.LIBRARY && (sourceArray = dartEntry.getState(DartEntry.ELEMENT)) == CacheState.INVALID) {
                return this.createResolveDartLibraryTask(source, dartEntry);
            }
            for (Source source2 : sourceArray = dartEntry.getValue(DartEntry.CONTAINING_LIBRARIES)) {
                CacheState cacheState4;
                Object object;
                Object object2;
                SourceEntry sourceEntry2 = this.cache.get(source2);
                if (!(sourceEntry2 instanceof DartEntry)) continue;
                DartEntry dartEntry2 = (DartEntry)sourceEntry2;
                CacheState cacheState5 = dartEntry2.getState(DartEntry.ELEMENT);
                if (cacheState5 == CacheState.INVALID || bl && cacheState5 == CacheState.FLUSHED) {
                    object2 = dartEntry2.getWritableCopy();
                    object2.setState(DartEntry.ELEMENT, CacheState.IN_PROCESS);
                    this.cache.put(source2, (SourceEntry)object2);
                    return new TaskData(new ResolveDartLibraryTask(this, source, source2), false);
                }
                object2 = dartEntry.getStateInLibrary(DartEntry.RESOLVED_UNIT, source2);
                if (object2 == CacheState.INVALID || bl && object2 == CacheState.FLUSHED) {
                    object = dartEntry.getWritableCopy();
                    object.setStateInLibrary(DartEntry.RESOLVED_UNIT, source2, CacheState.IN_PROCESS);
                    this.cache.put(source, (SourceEntry)object);
                    return new TaskData(new ResolveDartLibraryTask(this, source, source2), false);
                }
                if (!this.generateSdkErrors && source.isInSystemLibrary()) continue;
                object = dartEntry.getStateInLibrary(DartEntry.VERIFICATION_ERRORS, source2);
                if (object == CacheState.INVALID || bl && object == CacheState.FLUSHED) {
                    return this.createGenerateDartErrorsTask(source, dartEntry, source2, dartEntry2);
                }
                if (!bl2 || (cacheState4 = dartEntry.getStateInLibrary(DartEntry.HINTS, source2)) != CacheState.INVALID && (!bl || cacheState4 != CacheState.FLUSHED)) continue;
                return this.createGenerateDartHintsTask(source, dartEntry, source2, dartEntry2);
            }
        } else if (sourceEntry instanceof HtmlEntry) {
            Object object;
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            CacheState cacheState6 = htmlEntry.getState(HtmlEntry.PARSE_ERRORS);
            if (cacheState6 == CacheState.INVALID || bl && cacheState6 == CacheState.FLUSHED) {
                return this.createParseHtmlTask(source, htmlEntry);
            }
            if (bl && cacheState6 != CacheState.ERROR && (object = htmlEntry.getAnyParsedUnit()) == null) {
                return this.createParseHtmlTask(source, htmlEntry);
            }
            object = htmlEntry.getState(HtmlEntry.RESOLVED_UNIT);
            if (object == CacheState.INVALID || bl && object == CacheState.FLUSHED) {
                return this.createResolveHtmlTask(source, htmlEntry);
            }
            if (this.options.getAnalyzeAngular()) {
                CacheState cacheState7 = htmlEntry.getState(HtmlEntry.ANGULAR_ENTRY);
                if (cacheState7 == CacheState.INVALID || bl && cacheState7 == CacheState.FLUSHED) {
                    return this.createResolveAngularEntryHtmlTask(source, htmlEntry);
                }
                CacheState cacheState8 = htmlEntry.getState(HtmlEntry.ANGULAR_ERRORS);
                if (cacheState8 == CacheState.INVALID || bl && cacheState8 == CacheState.FLUSHED) {
                    return this.createResolveAngularComponentTemplateTask(source, htmlEntry);
                }
            }
        }
        return new TaskData(null, false);
    }

    private ChangeNoticeImpl getNotice(Source source) {
        ChangeNoticeImpl changeNoticeImpl = this.pendingNotices.get(source);
        if (changeNoticeImpl == null) {
            changeNoticeImpl = new ChangeNoticeImpl(source);
            this.pendingNotices.put(source, changeNoticeImpl);
        }
        return changeNoticeImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry getReadableDartEntry(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                sourceEntry = this.createSourceEntry(source, false);
            }
            if (sourceEntry instanceof DartEntry) {
                return (DartEntry)sourceEntry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlEntry getReadableHtmlEntry(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                sourceEntry = this.createSourceEntry(source, false);
            }
            if (sourceEntry instanceof HtmlEntry) {
                return (HtmlEntry)sourceEntry;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceEntry getReadableSourceEntry(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                sourceEntry = this.createSourceEntry(source, false);
            }
            return sourceEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceEntry getReadableSourceEntryOrNull(Source source) {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.cache.get(source);
        }
    }

    private TimestampedData<CompilationUnit> getResolvedUnit(CompilationUnitElement compilationUnitElement, Source source) {
        DartEntry dartEntry;
        SourceEntry sourceEntry = this.cache.get(compilationUnitElement.getSource());
        if (sourceEntry instanceof DartEntry && (dartEntry = (DartEntry)sourceEntry).getStateInLibrary(DartEntry.RESOLVED_UNIT, source) == CacheState.VALID) {
            return new TimestampedData<CompilationUnit>(dartEntry.getModificationTime(), dartEntry.getValueInLibrary(DartEntry.RESOLVED_UNIT, source));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Source[] getSources(SourceKind sourceKind) {
        ArrayList<Source> arrayList = new ArrayList<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                if (entry.getValue().getKind() != sourceKind) continue;
                arrayList.add(entry.getKey());
            }
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    private void getSourcesNeedingProcessing(Source source, SourceEntry sourceEntry, boolean bl, boolean bl2, HashSet<Source> hashSet) {
        if (sourceEntry instanceof DartEntry) {
            DartEntry dartEntry = (DartEntry)sourceEntry;
            CacheState cacheState = dartEntry.getState(DartEntry.SCAN_ERRORS);
            if (cacheState == CacheState.INVALID || bl && cacheState == CacheState.FLUSHED) {
                hashSet.add(source);
                return;
            }
            CacheState cacheState2 = dartEntry.getState(DartEntry.PARSE_ERRORS);
            if (cacheState2 == CacheState.INVALID || bl && cacheState2 == CacheState.FLUSHED) {
                hashSet.add(source);
                return;
            }
            if (bl && !dartEntry.hasResolvableCompilationUnit()) {
                hashSet.add(source);
                return;
            }
            for (Source source2 : this.getLibrariesContaining(source)) {
                LibraryElement libraryElement;
                Object object;
                Object object2;
                SourceEntry sourceEntry2 = this.cache.get(source2);
                if (!(sourceEntry2 instanceof DartEntry)) continue;
                CacheState cacheState3 = sourceEntry2.getState(DartEntry.ELEMENT);
                if (cacheState3 == CacheState.INVALID || bl && cacheState3 == CacheState.FLUSHED) {
                    hashSet.add(source);
                    return;
                }
                CacheState cacheState4 = dartEntry.getStateInLibrary(DartEntry.RESOLVED_UNIT, source2);
                if ((cacheState4 == CacheState.INVALID || bl && cacheState4 == CacheState.FLUSHED) && (object2 = sourceEntry2.getValue(DartEntry.ELEMENT)) != null) {
                    hashSet.add(source);
                    return;
                }
                object2 = dartEntry.getStateInLibrary(DartEntry.VERIFICATION_ERRORS, source2);
                if ((object2 == CacheState.INVALID || bl && object2 == CacheState.FLUSHED) && (object = sourceEntry2.getValue(DartEntry.ELEMENT)) != null) {
                    hashSet.add(source);
                    return;
                }
                if (!bl2 || (object = dartEntry.getStateInLibrary(DartEntry.HINTS, source2)) != CacheState.INVALID && (!bl || object != CacheState.FLUSHED) || (libraryElement = sourceEntry2.getValue(DartEntry.ELEMENT)) == null) continue;
                hashSet.add(source);
                return;
            }
        } else if (sourceEntry instanceof HtmlEntry) {
            CacheState cacheState;
            HtmlEntry htmlEntry = (HtmlEntry)sourceEntry;
            CacheState cacheState5 = htmlEntry.getState(HtmlEntry.PARSED_UNIT);
            if (cacheState5 == CacheState.INVALID || bl && cacheState5 == CacheState.FLUSHED) {
                hashSet.add(source);
                return;
            }
            CacheState cacheState6 = htmlEntry.getState(HtmlEntry.RESOLVED_UNIT);
            if (cacheState6 == CacheState.INVALID || bl && cacheState6 == CacheState.FLUSHED) {
                hashSet.add(source);
                return;
            }
            if (this.options.getAnalyzeAngular() && ((cacheState = htmlEntry.getState(HtmlEntry.ANGULAR_ERRORS)) == CacheState.INVALID || bl && cacheState == CacheState.FLUSHED)) {
                AngularComponentElement angularComponentElement;
                AngularApplication angularApplication = htmlEntry.getValue(HtmlEntry.ANGULAR_ENTRY);
                if (angularApplication != null) {
                    hashSet.add(source);
                    return;
                }
                AngularApplication angularApplication2 = htmlEntry.getValue(HtmlEntry.ANGULAR_APPLICATION);
                if (angularApplication2 != null && (angularComponentElement = htmlEntry.getValue(HtmlEntry.ANGULAR_COMPONENT)) != null) {
                    hashSet.add(source);
                    return;
                }
            }
        }
    }

    private void invalidateAllResolutionInformation() {
        HashMap<Source, Source[]> hashMap = new HashMap<Source, Source[]>();
        for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
            SourceEntry sourceEntry;
            Source source = entry.getKey();
            SourceEntry sourceEntry2 = entry.getValue();
            if (sourceEntry2 instanceof HtmlEntry) {
                sourceEntry = ((HtmlEntry)sourceEntry2).getWritableCopy();
                ((HtmlEntryImpl)sourceEntry).invalidateAllResolutionInformation();
                entry.setValue(sourceEntry);
                continue;
            }
            if (!(sourceEntry2 instanceof DartEntry)) continue;
            sourceEntry = (DartEntry)sourceEntry2;
            hashMap.put(source, sourceEntry.getValue(DartEntry.INCLUDED_PARTS));
            DartEntryImpl dartEntryImpl = sourceEntry.getWritableCopy();
            dartEntryImpl.invalidateAllResolutionInformation();
            entry.setValue(dartEntryImpl);
            this.workManager.add(source, SourcePriority.UNKNOWN);
        }
        this.removeFromPartsUsingMap(hashMap);
    }

    private void invalidateAngularResolution(HtmlEntryImpl htmlEntryImpl) {
        Object object;
        SourceEntry sourceEntry;
        Object object2;
        AngularApplication angularApplication = htmlEntryImpl.getValue(HtmlEntry.ANGULAR_ENTRY);
        if (angularApplication == null) {
            return;
        }
        this.angularApplications.remove(angularApplication);
        htmlEntryImpl.setState(HtmlEntry.ANGULAR_ENTRY, CacheState.INVALID);
        AngularElement[] angularElementArray = angularApplication.getElements();
        Object[] objectArray = angularElementArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object3;
            AngularElement angularElement = objectArray[i];
            if (!(angularElement instanceof AngularHasTemplateElement) || (object2 = (object3 = (AngularHasTemplateElement)angularElement).getTemplateSource()) == null) continue;
            sourceEntry = this.getReadableHtmlEntry((Source)object2);
            object = sourceEntry.getWritableCopy();
            ((HtmlEntryImpl)object).setValue(HtmlEntry.ANGULAR_APPLICATION, null);
            ((HtmlEntryImpl)object).setValue(HtmlEntry.ANGULAR_COMPONENT, null);
            ((HtmlEntryImpl)object).setState(HtmlEntry.ANGULAR_ERRORS, CacheState.INVALID);
            this.cache.put((Source)object2, (SourceEntry)object);
            this.workManager.add((Source)object2, SourcePriority.HTML);
        }
        for (Object object3 : objectArray = angularApplication.getElementSources()) {
            object2 = this.getReadableDartEntry((Source)object3);
            sourceEntry = object2.getWritableCopy();
            ((DartEntryImpl)sourceEntry).setValue(DartEntry.ANGULAR_ERRORS, AnalysisError.NO_ERRORS);
            this.cache.put((Source)object3, sourceEntry);
            object = this.getNotice((Source)object3);
            ((ChangeNoticeImpl)object).setErrors(((DartEntryImpl)sourceEntry).getAllErrors(), object2.getValue(SourceEntry.LINE_INFO));
        }
    }

    private void invalidateLibraryResolution(Source source) {
        Source[] sourceArray;
        DartEntry dartEntry = this.getReadableDartEntry(source);
        if (dartEntry != null) {
            sourceArray = dartEntry.getValue(DartEntry.INCLUDED_PARTS);
            DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
            dartEntryImpl.invalidateAllResolutionInformation();
            this.cache.put(source, dartEntryImpl);
            this.workManager.add(source, SourcePriority.LIBRARY);
            for (Source source2 : sourceArray) {
                SourceEntry sourceEntry = this.cache.get(source2);
                if (!(sourceEntry instanceof DartEntry)) continue;
                DartEntryImpl dartEntryImpl2 = ((DartEntry)sourceEntry).getWritableCopy();
                dartEntryImpl2.invalidateAllResolutionInformation();
                this.cache.put(source2, dartEntryImpl2);
            }
        }
        sourceArray = Lists.newArrayList(this.angularApplications);
        for (AngularApplication angularApplication : sourceArray) {
            if (!angularApplication.dependsOn(source)) continue;
            Source source3 = angularApplication.getEntryPoint();
            HtmlEntry htmlEntry = this.getReadableHtmlEntry(source3);
            HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
            this.invalidateAngularResolution(htmlEntryImpl);
            this.cache.put(source3, htmlEntryImpl);
            this.workManager.add(source3, SourcePriority.HTML);
        }
    }

    private boolean isClient(LibraryElement libraryElement, Source source, HashSet<LibraryElement> hashSet) {
        if (hashSet.contains(libraryElement)) {
            return false;
        }
        if (((Object)libraryElement.getSource()).equals(source)) {
            return true;
        }
        hashSet.add(libraryElement);
        for (LibraryElement libraryElement2 : libraryElement.getImportedLibraries()) {
            if (!this.isClient(libraryElement2, source, hashSet)) continue;
            return true;
        }
        for (LibraryElement libraryElement2 : libraryElement.getExportedLibraries()) {
            if (!this.isClient(libraryElement2, source, hashSet)) continue;
            return true;
        }
        return false;
    }

    private void logInformation(String string) {
        AnalysisEngine.getInstance().getLogger().logInformation(string);
    }

    private void logInformation(String string, Throwable throwable) {
        if (throwable == null) {
            AnalysisEngine.getInstance().getLogger().logInformation(string);
        } else {
            AnalysisEngine.getInstance().getLogger().logInformation(string, throwable);
        }
    }

    private void recordAngularEntryPoint(HtmlEntryImpl htmlEntryImpl, ResolveAngularEntryHtmlTask resolveAngularEntryHtmlTask) throws AnalysisException {
        AngularApplication angularApplication = resolveAngularEntryHtmlTask.getApplication();
        if (angularApplication != null) {
            Object object;
            SourceEntry sourceEntry;
            Object object2;
            this.angularApplications.add(angularApplication);
            htmlEntryImpl.setValue(HtmlEntry.ANGULAR_ERRORS, resolveAngularEntryHtmlTask.getEntryErrors());
            AngularElement[] angularElementArray = angularApplication.getElements();
            Object[] objectArray = angularElementArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object3;
                AngularElement angularElement = objectArray[i];
                if (!(angularElement instanceof AngularHasTemplateElement) || (object2 = (object3 = (AngularHasTemplateElement)angularElement).getTemplateSource()) == null) continue;
                sourceEntry = this.getReadableHtmlEntry((Source)object2);
                object = sourceEntry.getWritableCopy();
                ((HtmlEntryImpl)object).setValue(HtmlEntry.ANGULAR_APPLICATION, angularApplication);
                if (object3 instanceof AngularComponentElement) {
                    AngularComponentElement angularComponentElement = (AngularComponentElement)object3;
                    ((HtmlEntryImpl)object).setValue(HtmlEntry.ANGULAR_COMPONENT, angularComponentElement);
                }
                ((HtmlEntryImpl)object).setState(HtmlEntry.ANGULAR_ERRORS, CacheState.INVALID);
                this.cache.put((Source)object2, (SourceEntry)object);
                this.workManager.add((Source)object2, SourcePriority.HTML);
            }
            for (Object object3 : objectArray = angularApplication.getElementSources()) {
                object2 = this.getReadableDartEntry((Source)object3);
                sourceEntry = object2.getWritableCopy();
                ((DartEntryImpl)sourceEntry).setValue(DartEntry.ANGULAR_ERRORS, resolveAngularEntryHtmlTask.getErrors((Source)object3));
                this.cache.put((Source)object3, sourceEntry);
                object = this.getNotice((Source)object3);
                ((ChangeNoticeImpl)object).setErrors(((DartEntryImpl)sourceEntry).getAllErrors(), this.computeLineInfo((Source)object3));
            }
        }
        htmlEntryImpl.setValue(HtmlEntry.ANGULAR_ENTRY, angularApplication);
    }

    private void recordElementData(DartEntry dartEntry, DartEntryImpl dartEntryImpl, LibraryElement libraryElement, Source source, Source source2) {
        dartEntryImpl.setValue(DartEntry.ELEMENT, libraryElement);
        dartEntryImpl.setValue(DartEntry.IS_LAUNCHABLE, libraryElement.getEntryPoint() != null);
        dartEntryImpl.setValue(DartEntry.IS_CLIENT, this.isClient(libraryElement, source2, new HashSet<LibraryElement>()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry recordGenerateDartErrorsTask(GenerateDartErrorsTask generateDartErrorsTask) throws AnalysisException {
        Source source = generateDartErrorsTask.getSource();
        Source source2 = generateDartErrorsTask.getLibraryElement().getSource();
        AnalysisException analysisException = generateDartErrorsTask.getException();
        DartEntry dartEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof DartEntry)) {
                throw new AnalysisException("Internal error: attempting to verify non-Dart file as a Dart file: " + source.getFullName());
            }
            dartEntry = (DartEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = generateDartErrorsTask.getModificationTime())) {
                if (dartEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    dartEntry = this.getReadableDartEntry(source);
                    if (dartEntry == null) {
                        throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
                    }
                }
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null) {
                    dartEntryImpl.setValueInLibrary(DartEntry.VERIFICATION_ERRORS, source2, generateDartErrorsTask.getErrors());
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setErrors(dartEntryImpl.getAllErrors(), dartEntryImpl.getValue(SourceEntry.LINE_INFO));
                } else {
                    dartEntryImpl.setStateInLibrary(DartEntry.VERIFICATION_ERRORS, source2, CacheState.ERROR);
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            } else {
                this.logInformation("Generated errors discarded for " + this.debuggingString(source) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + dartEntry.getModificationTime(), analysisException);
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    this.removeFromParts(source, dartEntry);
                    dartEntryImpl.invalidateAllInformation();
                    dartEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                    this.workManager.add(source, SourcePriority.UNKNOWN);
                } else {
                    dartEntryImpl.setStateInLibrary(DartEntry.VERIFICATION_ERRORS, source2, CacheState.ERROR);
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return dartEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry recordGenerateDartHintsTask(GenerateDartHintsTask generateDartHintsTask) throws AnalysisException {
        Source source = generateDartHintsTask.getLibraryElement().getSource();
        AnalysisException analysisException = generateDartHintsTask.getException();
        DartEntry dartEntry = null;
        HashMap<Source, TimestampedData<AnalysisError[]>> hashMap = generateDartHintsTask.getHintMap();
        if (hashMap == null) {
            Object object = this.cacheLock;
            synchronized (object) {
                SourceEntry sourceEntry = this.cache.get(source);
                if (sourceEntry == null) {
                    throw new ObsoleteSourceAnalysisException(source);
                }
                if (!(sourceEntry instanceof DartEntry)) {
                    throw new AnalysisException("Internal error: attempting to generate hints for non-Dart file as a Dart file: " + source.getFullName());
                }
                if (analysisException == null) {
                    analysisException = new AnalysisException("GenerateDartHintsTask returned a null hint map without throwing an exception: " + source.getFullName());
                }
                DartEntryImpl dartEntryImpl = ((DartEntry)sourceEntry).getWritableCopy();
                dartEntryImpl.setStateInLibrary(DartEntry.HINTS, source, CacheState.ERROR);
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
            }
            throw analysisException;
        }
        for (Map.Entry<Source, TimestampedData<AnalysisError[]>> entry : hashMap.entrySet()) {
            Source source2 = entry.getKey();
            TimestampedData<AnalysisError[]> timestampedData = entry.getValue();
            Object object = this.cacheLock;
            synchronized (object) {
                DartEntryImpl dartEntryImpl;
                long l;
                long l2;
                SourceEntry sourceEntry = this.cache.get(source2);
                if (!(sourceEntry instanceof DartEntry)) {
                    throw new AnalysisException("Internal error: attempting to parse non-Dart file as a Dart file: " + source2.getFullName());
                }
                DartEntry dartEntry2 = (DartEntry)sourceEntry;
                if (((Object)source2).equals(source)) {
                    dartEntry = dartEntry2;
                }
                if ((l2 = this.getModificationStamp(source2)) == (l = timestampedData.getModificationTime())) {
                    if (dartEntry2.getModificationTime() != l2) {
                        this.sourceChanged(source2);
                        dartEntry2 = this.getReadableDartEntry(source2);
                        if (dartEntry2 == null) {
                            throw new AnalysisException("A Dart file became a non-Dart file: " + source2.getFullName());
                        }
                    }
                    dartEntryImpl = dartEntry2.getWritableCopy();
                    if (analysisException == null) {
                        dartEntryImpl.setValueInLibrary(DartEntry.HINTS, source, timestampedData.getData());
                        ChangeNoticeImpl changeNoticeImpl = this.getNotice(source2);
                        changeNoticeImpl.setErrors(dartEntryImpl.getAllErrors(), dartEntryImpl.getValue(SourceEntry.LINE_INFO));
                    } else {
                        dartEntryImpl.setStateInLibrary(DartEntry.HINTS, source, CacheState.ERROR);
                    }
                    dartEntryImpl.setException(analysisException);
                    this.cache.put(source2, dartEntryImpl);
                    dartEntry2 = dartEntryImpl;
                } else {
                    this.logInformation("Generated hints discarded for " + this.debuggingString(source2) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + dartEntry2.getModificationTime(), analysisException);
                    if (dartEntry2.getStateInLibrary(DartEntry.HINTS, source) == CacheState.IN_PROCESS) {
                        dartEntryImpl = dartEntry2.getWritableCopy();
                        if (analysisException == null || l >= 0L) {
                            this.removeFromParts(source2, dartEntry2);
                            dartEntryImpl.invalidateAllInformation();
                            dartEntryImpl.setModificationTime(l2);
                            this.cache.removedAst(source2);
                            this.workManager.add(source2, SourcePriority.UNKNOWN);
                        } else {
                            dartEntryImpl.setStateInLibrary(DartEntry.HINTS, source, CacheState.ERROR);
                        }
                        dartEntryImpl.setException(analysisException);
                        this.cache.put(source2, dartEntryImpl);
                        dartEntry2 = dartEntryImpl;
                    }
                }
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return dartEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceEntry recordGetContentsTask(GetContentTask getContentTask) throws AnalysisException {
        if (!getContentTask.isComplete()) {
            return null;
        }
        Source source = getContentTask.getSource();
        AnalysisException analysisException = getContentTask.getException();
        SourceEntry sourceEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            SourceEntryImpl sourceEntryImpl = sourceEntry.getWritableCopy();
            if (analysisException == null) {
                sourceEntryImpl.setModificationTime(getContentTask.getModificationTime());
                sourceEntryImpl.setValue(SourceEntry.CONTENT, getContentTask.getContent());
            } else {
                sourceEntryImpl.setException(analysisException);
                sourceEntryImpl.recordContentError();
                this.workManager.remove(source);
            }
            this.cache.put(source, sourceEntryImpl);
            sourceEntry = sourceEntryImpl;
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return sourceEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry recordIncrementalAnalysisTaskResults(IncrementalAnalysisTask incrementalAnalysisTask) throws AnalysisException {
        Object object = this.cacheLock;
        synchronized (object) {
            CompilationUnit compilationUnit = incrementalAnalysisTask.getCompilationUnit();
            if (compilationUnit != null) {
                ChangeNoticeImpl changeNoticeImpl = this.getNotice(incrementalAnalysisTask.getSource());
                changeNoticeImpl.setCompilationUnit(compilationUnit);
                this.incrementalAnalysisCache = IncrementalAnalysisCache.cacheResult(incrementalAnalysisTask.getCache(), compilationUnit);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry recordParseDartTaskResults(ParseDartTask parseDartTask) throws AnalysisException {
        Source source = parseDartTask.getSource();
        AnalysisException analysisException = parseDartTask.getException();
        DartEntry dartEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof DartEntry)) {
                throw new AnalysisException("Internal error: attempting to parse non-Dart file as a Dart file: " + source.getFullName());
            }
            dartEntry = (DartEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = parseDartTask.getModificationTime())) {
                if (dartEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    dartEntry = this.getReadableDartEntry(source);
                    if (dartEntry == null) {
                        throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
                    }
                }
                this.removeFromParts(source, dartEntry);
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null) {
                    Source[] sourceArray;
                    if (parseDartTask.hasNonPartOfDirective()) {
                        dartEntryImpl.setValue(DartEntry.SOURCE_KIND, SourceKind.LIBRARY);
                        dartEntryImpl.setContainingLibrary(source);
                        this.workManager.add(source, SourcePriority.LIBRARY);
                    } else if (parseDartTask.hasPartOfDirective()) {
                        dartEntryImpl.setValue(DartEntry.SOURCE_KIND, SourceKind.PART);
                        dartEntryImpl.removeContainingLibrary(source);
                        this.workManager.add(source, SourcePriority.NORMAL_PART);
                    } else {
                        sourceArray = dartEntryImpl.getContainingLibraries();
                        if (sourceArray.size() > 1 || sourceArray.size() == 1 && !((Object)((Source)sourceArray.get(0))).equals(source)) {
                            dartEntryImpl.setValue(DartEntry.SOURCE_KIND, SourceKind.PART);
                            dartEntryImpl.removeContainingLibrary(source);
                            this.workManager.add(source, SourcePriority.NORMAL_PART);
                        } else {
                            dartEntryImpl.setValue(DartEntry.SOURCE_KIND, SourceKind.LIBRARY);
                            dartEntryImpl.setContainingLibrary(source);
                            this.workManager.add(source, SourcePriority.LIBRARY);
                        }
                    }
                    sourceArray = parseDartTask.getIncludedSources();
                    for (int i = 0; i < sourceArray.length; ++i) {
                        Source source2 = sourceArray[i];
                        DartEntry dartEntry2 = this.getReadableDartEntry(source2);
                        if (dartEntry2 == null || dartEntry2 == dartEntry) continue;
                        DartEntryImpl dartEntryImpl2 = dartEntry2.getWritableCopy();
                        dartEntryImpl2.addContainingLibrary(source);
                        this.cache.put(source2, dartEntryImpl2);
                    }
                    dartEntryImpl.setValue(DartEntry.PARSED_UNIT, parseDartTask.getCompilationUnit());
                    dartEntryImpl.setValue(DartEntry.PARSE_ERRORS, parseDartTask.getErrors());
                    dartEntryImpl.setValue(DartEntry.EXPORTED_LIBRARIES, parseDartTask.getExportedSources());
                    dartEntryImpl.setValue(DartEntry.IMPORTED_LIBRARIES, parseDartTask.getImportedSources());
                    dartEntryImpl.setValue(DartEntry.INCLUDED_PARTS, sourceArray);
                    this.cache.storedAst(source);
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setErrors(dartEntryImpl.getAllErrors(), parseDartTask.getLineInfo());
                    this.incrementalAnalysisCache = IncrementalAnalysisCache.verifyStructure(this.incrementalAnalysisCache, source, parseDartTask.getCompilationUnit());
                } else {
                    this.removeFromParts(source, dartEntry);
                    dartEntryImpl.recordParseError();
                    this.cache.removedAst(source);
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            } else {
                this.logInformation("Parse results discarded for " + this.debuggingString(source) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + dartEntry.getModificationTime(), analysisException);
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    this.removeFromParts(source, dartEntry);
                    dartEntryImpl.invalidateAllInformation();
                    dartEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                    this.workManager.add(source, SourcePriority.UNKNOWN);
                } else {
                    dartEntryImpl.recordParseError();
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return dartEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlEntry recordParseHtmlTaskResults(ParseHtmlTask parseHtmlTask) throws AnalysisException {
        Source source = parseHtmlTask.getSource();
        AnalysisException analysisException = parseHtmlTask.getException();
        HtmlEntry htmlEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof HtmlEntry)) {
                throw new AnalysisException("Internal error: attempting to parse non-HTML file as a HTML file: " + source.getFullName());
            }
            htmlEntry = (HtmlEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = parseHtmlTask.getModificationTime())) {
                if (htmlEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    htmlEntry = this.getReadableHtmlEntry(source);
                    if (htmlEntry == null) {
                        throw new AnalysisException("An HTML file became a non-HTML file: " + source.getFullName());
                    }
                }
                HtmlEntryImpl htmlEntryImpl = ((HtmlEntry)sourceEntry).getWritableCopy();
                if (analysisException == null) {
                    LineInfo lineInfo = parseHtmlTask.getLineInfo();
                    HtmlUnit htmlUnit = parseHtmlTask.getHtmlUnit();
                    htmlEntryImpl.setValue(SourceEntry.LINE_INFO, lineInfo);
                    htmlEntryImpl.setValue(HtmlEntry.PARSED_UNIT, htmlUnit);
                    htmlEntryImpl.setValue(HtmlEntry.PARSE_ERRORS, parseHtmlTask.getErrors());
                    htmlEntryImpl.setValue(HtmlEntry.REFERENCED_LIBRARIES, parseHtmlTask.getReferencedLibraries());
                    this.cache.storedAst(source);
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setErrors(htmlEntryImpl.getAllErrors(), lineInfo);
                } else {
                    htmlEntryImpl.recordParseError();
                    this.cache.removedAst(source);
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            } else {
                this.logInformation("Parse results discarded for " + this.debuggingString(source) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + htmlEntry.getModificationTime(), analysisException);
                HtmlEntryImpl htmlEntryImpl = ((HtmlEntry)sourceEntry).getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    htmlEntryImpl.invalidateAllInformation();
                    htmlEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                } else {
                    htmlEntryImpl.setState(SourceEntry.LINE_INFO, CacheState.ERROR);
                    htmlEntryImpl.setState(HtmlEntry.PARSED_UNIT, CacheState.ERROR);
                    htmlEntryImpl.setState(HtmlEntry.RESOLVED_UNIT, CacheState.ERROR);
                    htmlEntryImpl.setState(HtmlEntry.REFERENCED_LIBRARIES, CacheState.ERROR);
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return htmlEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlEntry recordResolveAngularComponentTemplateTaskResults(ResolveAngularComponentTemplateTask resolveAngularComponentTemplateTask) throws AnalysisException {
        Source source = resolveAngularComponentTemplateTask.getSource();
        AnalysisException analysisException = resolveAngularComponentTemplateTask.getException();
        HtmlEntry htmlEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof HtmlEntry)) {
                throw new AnalysisException("Internal error: attempting to resolve non-HTML file as an HTML file: " + source.getFullName());
            }
            htmlEntry = (HtmlEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = resolveAngularComponentTemplateTask.getModificationTime())) {
                if (htmlEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    htmlEntry = this.getReadableHtmlEntry(source);
                    if (htmlEntry == null) {
                        throw new AnalysisException("An HTML file became a non-HTML file: " + source.getFullName());
                    }
                }
                HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
                if (analysisException == null) {
                    htmlEntryImpl.setValue(HtmlEntry.ANGULAR_ERRORS, resolveAngularComponentTemplateTask.getResolutionErrors());
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setHtmlUnit(resolveAngularComponentTemplateTask.getResolvedUnit());
                    changeNoticeImpl.setErrors(htmlEntryImpl.getAllErrors(), htmlEntryImpl.getValue(SourceEntry.LINE_INFO));
                } else {
                    htmlEntryImpl.recordResolutionError();
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            } else {
                HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    htmlEntryImpl.invalidateAllInformation();
                    htmlEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                } else {
                    htmlEntryImpl.recordResolutionError();
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return htmlEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlEntry recordResolveAngularEntryHtmlTaskResults(ResolveAngularEntryHtmlTask resolveAngularEntryHtmlTask) throws AnalysisException {
        Source source = resolveAngularEntryHtmlTask.getSource();
        AnalysisException analysisException = resolveAngularEntryHtmlTask.getException();
        HtmlEntry htmlEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof HtmlEntry)) {
                throw new AnalysisException("Internal error: attempting to resolve non-HTML file as an HTML file: " + source.getFullName());
            }
            htmlEntry = (HtmlEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = resolveAngularEntryHtmlTask.getModificationTime())) {
                if (htmlEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    htmlEntry = this.getReadableHtmlEntry(source);
                    if (htmlEntry == null) {
                        throw new AnalysisException("An HTML file became a non-HTML file: " + source.getFullName());
                    }
                }
                HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
                if (analysisException == null) {
                    htmlEntryImpl.setValue(HtmlEntry.RESOLVED_UNIT, resolveAngularEntryHtmlTask.getResolvedUnit());
                    this.recordAngularEntryPoint(htmlEntryImpl, resolveAngularEntryHtmlTask);
                    this.cache.storedAst(source);
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setHtmlUnit(resolveAngularEntryHtmlTask.getResolvedUnit());
                    changeNoticeImpl.setErrors(htmlEntryImpl.getAllErrors(), htmlEntryImpl.getValue(SourceEntry.LINE_INFO));
                } else {
                    htmlEntryImpl.recordResolutionError();
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            } else {
                HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    htmlEntryImpl.invalidateAllInformation();
                    htmlEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                } else {
                    htmlEntryImpl.recordResolutionError();
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return htmlEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry recordResolveDartUnitTaskResults(ResolveDartUnitTask resolveDartUnitTask) throws AnalysisException {
        Source source = resolveDartUnitTask.getSource();
        Source source2 = resolveDartUnitTask.getLibrarySource();
        AnalysisException analysisException = resolveDartUnitTask.getException();
        DartEntry dartEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof DartEntry)) {
                throw new AnalysisException("Internal error: attempting to resolve non-Dart file as a Dart file: " + source.getFullName());
            }
            dartEntry = (DartEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = resolveDartUnitTask.getModificationTime())) {
                if (dartEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    dartEntry = this.getReadableDartEntry(source);
                    if (dartEntry == null) {
                        throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
                    }
                }
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null) {
                    dartEntryImpl.setValueInLibrary(DartEntry.RESOLVED_UNIT, source2, resolveDartUnitTask.getResolvedUnit());
                    this.cache.storedAst(source);
                } else {
                    dartEntryImpl.setStateInLibrary(DartEntry.RESOLVED_UNIT, source2, CacheState.ERROR);
                    this.cache.removedAst(source);
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            } else {
                this.logInformation("Resolution results discarded for " + this.debuggingString(source) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + dartEntry.getModificationTime(), analysisException);
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    this.removeFromParts(source, dartEntry);
                    dartEntryImpl.invalidateAllInformation();
                    dartEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                    this.workManager.add(source, SourcePriority.UNKNOWN);
                } else {
                    dartEntryImpl.setStateInLibrary(DartEntry.RESOLVED_UNIT, source2, CacheState.ERROR);
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return dartEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HtmlEntry recordResolveHtmlTaskResults(ResolveHtmlTask resolveHtmlTask) throws AnalysisException {
        Source source = resolveHtmlTask.getSource();
        AnalysisException analysisException = resolveHtmlTask.getException();
        HtmlEntry htmlEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof HtmlEntry)) {
                throw new AnalysisException("Internal error: attempting to resolve non-HTML file as an HTML file: " + source.getFullName());
            }
            htmlEntry = (HtmlEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = resolveHtmlTask.getModificationTime())) {
                if (htmlEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    htmlEntry = this.getReadableHtmlEntry(source);
                    if (htmlEntry == null) {
                        throw new AnalysisException("An HTML file became a non-HTML file: " + source.getFullName());
                    }
                }
                HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
                if (analysisException == null) {
                    htmlEntryImpl.setState(HtmlEntry.PARSED_UNIT, CacheState.FLUSHED);
                    htmlEntryImpl.setValue(HtmlEntry.RESOLVED_UNIT, resolveHtmlTask.getResolvedUnit());
                    htmlEntryImpl.setValue(HtmlEntry.ELEMENT, resolveHtmlTask.getElement());
                    htmlEntryImpl.setValue(HtmlEntry.RESOLUTION_ERRORS, resolveHtmlTask.getResolutionErrors());
                    this.cache.storedAst(source);
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setHtmlUnit(resolveHtmlTask.getResolvedUnit());
                    changeNoticeImpl.setErrors(htmlEntryImpl.getAllErrors(), htmlEntryImpl.getValue(SourceEntry.LINE_INFO));
                } else {
                    htmlEntryImpl.recordResolutionError();
                    this.cache.removedAst(source);
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            } else {
                this.logInformation("Resolution results discarded for " + this.debuggingString(source) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + htmlEntry.getModificationTime(), analysisException);
                HtmlEntryImpl htmlEntryImpl = htmlEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    htmlEntryImpl.invalidateAllInformation();
                    htmlEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                } else {
                    htmlEntryImpl.recordResolutionError();
                }
                htmlEntryImpl.setException(analysisException);
                this.cache.put(source, htmlEntryImpl);
                htmlEntry = htmlEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return htmlEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DartEntry recordScanDartTaskResults(ScanDartTask scanDartTask) throws AnalysisException {
        Source source = scanDartTask.getSource();
        AnalysisException analysisException = scanDartTask.getException();
        DartEntry dartEntry = null;
        Object object = this.cacheLock;
        synchronized (object) {
            long l;
            SourceEntry sourceEntry = this.cache.get(source);
            if (sourceEntry == null) {
                throw new ObsoleteSourceAnalysisException(source);
            }
            if (!(sourceEntry instanceof DartEntry)) {
                throw new AnalysisException("Internal error: attempting to parse non-Dart file as a Dart file: " + source.getFullName());
            }
            dartEntry = (DartEntry)sourceEntry;
            long l2 = this.getModificationStamp(source);
            if (l2 == (l = scanDartTask.getModificationTime())) {
                if (dartEntry.getModificationTime() != l2) {
                    this.sourceChanged(source);
                    dartEntry = this.getReadableDartEntry(source);
                    if (dartEntry == null) {
                        throw new AnalysisException("A Dart file became a non-Dart file: " + source.getFullName());
                    }
                }
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null) {
                    LineInfo lineInfo = scanDartTask.getLineInfo();
                    dartEntryImpl.setValue(SourceEntry.LINE_INFO, lineInfo);
                    dartEntryImpl.setValue(DartEntry.TOKEN_STREAM, scanDartTask.getTokenStream());
                    dartEntryImpl.setValue(DartEntry.SCAN_ERRORS, scanDartTask.getErrors());
                    this.cache.storedAst(source);
                    this.workManager.add(source, SourcePriority.NORMAL_PART);
                    ChangeNoticeImpl changeNoticeImpl = this.getNotice(source);
                    changeNoticeImpl.setErrors(dartEntry.getAllErrors(), lineInfo);
                } else {
                    this.removeFromParts(source, dartEntry);
                    dartEntryImpl.recordScanError();
                    this.cache.removedAst(source);
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            } else {
                this.logInformation("Scan results discarded for " + this.debuggingString(source) + "; sourceTime = " + l2 + ", resultTime = " + l + ", cacheTime = " + dartEntry.getModificationTime(), analysisException);
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                if (analysisException == null || l >= 0L) {
                    this.removeFromParts(source, dartEntry);
                    dartEntryImpl.invalidateAllInformation();
                    dartEntryImpl.setModificationTime(l2);
                    this.cache.removedAst(source);
                    this.workManager.add(source, SourcePriority.UNKNOWN);
                } else {
                    dartEntryImpl.recordScanError();
                }
                dartEntryImpl.setException(analysisException);
                this.cache.put(source, dartEntryImpl);
                dartEntry = dartEntryImpl;
            }
        }
        if (analysisException != null) {
            throw analysisException;
        }
        return dartEntry;
    }

    private void removeFromParts(Source source, DartEntry dartEntry) {
        Source[] sourceArray = dartEntry.getValue(DartEntry.INCLUDED_PARTS);
        for (int i = 0; i < sourceArray.length; ++i) {
            Source source2 = sourceArray[i];
            DartEntry dartEntry2 = this.getReadableDartEntry(source2);
            if (dartEntry2 == null || dartEntry2 == dartEntry) continue;
            DartEntryImpl dartEntryImpl = dartEntry2.getWritableCopy();
            dartEntryImpl.removeContainingLibrary(source);
            if (dartEntryImpl.getContainingLibraries().size() == 0 && !this.exists(source2)) {
                this.cache.remove(source2);
                continue;
            }
            this.cache.put(source2, dartEntryImpl);
        }
    }

    private void removeFromPartsUsingMap(HashMap<Source, Source[]> hashMap) {
        for (Map.Entry<Source, Source[]> entry : hashMap.entrySet()) {
            Source source = entry.getKey();
            Source[] sourceArray = entry.getValue();
            for (int i = 0; i < sourceArray.length; ++i) {
                DartEntry dartEntry;
                Source source2 = sourceArray[i];
                if (((Object)source2).equals(source) || (dartEntry = this.getReadableDartEntry(source2)) == null) continue;
                DartEntryImpl dartEntryImpl = dartEntry.getWritableCopy();
                dartEntryImpl.removeContainingLibrary(source);
                if (dartEntryImpl.getContainingLibraries().size() == 0 && !this.exists(source2)) {
                    this.cache.remove(source2);
                    continue;
                }
                this.cache.put(source2, dartEntryImpl);
            }
        }
    }

    private void removeFromPriorityOrder(Source source) {
        int n = this.priorityOrder.length;
        ArrayList<Source> arrayList = new ArrayList<Source>(n);
        for (int i = 0; i < n; ++i) {
            if (((Object)this.priorityOrder[i]).equals(source)) continue;
            arrayList.add(this.priorityOrder[i]);
        }
        if (arrayList.size() < n) {
            this.setAnalysisPriorityOrder(arrayList);
        }
    }

    private boolean sourceAvailable(Source source) {
        SourceEntry sourceEntry = this.cache.get(source);
        if (sourceEntry == null) {
            sourceEntry = this.createSourceEntry(source, true);
        } else {
            SourceEntryImpl sourceEntryImpl = sourceEntry.getWritableCopy();
            long l = this.getModificationStamp(source);
            sourceEntryImpl.setModificationTime(l);
            sourceEntryImpl.setExplicitlyAdded(true);
            this.cache.put(source, sourceEntryImpl);
        }
        if (sourceEntry instanceof HtmlEntry) {
            this.workManager.add(source, SourcePriority.HTML);
        } else {
            this.workManager.add(source, SourcePriority.UNKNOWN);
        }
        return sourceEntry instanceof DartEntry;
    }

    private void sourceChanged(Source source) {
        SourceEntry sourceEntry = this.cache.get(source);
        if (sourceEntry == null || sourceEntry.getModificationTime() == this.getModificationStamp(source)) {
            return;
        }
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntryImpl htmlEntryImpl = ((HtmlEntry)sourceEntry).getWritableCopy();
            htmlEntryImpl.setModificationTime(this.getModificationStamp(source));
            this.invalidateAngularResolution(htmlEntryImpl);
            htmlEntryImpl.invalidateAllInformation();
            this.cache.put(source, htmlEntryImpl);
            this.cache.removedAst(source);
            this.workManager.add(source, SourcePriority.HTML);
        } else if (sourceEntry instanceof DartEntry) {
            Source[] sourceArray = this.getLibrariesContaining(source);
            HashSet<Source> hashSet = new HashSet<Source>();
            for (Source source2 : sourceArray) {
                hashSet.add(source2);
                for (Source source3 : this.getLibrariesDependingOn(source2)) {
                    hashSet.add(source3);
                }
            }
            for (Source source4 : hashSet) {
                this.invalidateLibraryResolution(source4);
            }
            this.removeFromParts(source, (DartEntry)this.cache.get(source));
            DartEntryImpl dartEntryImpl = ((DartEntry)this.cache.get(source)).getWritableCopy();
            dartEntryImpl.setModificationTime(this.getModificationStamp(source));
            dartEntryImpl.invalidateAllInformation();
            this.cache.put(source, dartEntryImpl);
            this.cache.removedAst(source);
            this.workManager.add(source, SourcePriority.UNKNOWN);
        }
    }

    private void sourceRemoved(Source source) {
        SourceEntry sourceEntry = this.cache.get(source);
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntryImpl htmlEntryImpl = ((HtmlEntry)sourceEntry).getWritableCopy();
            this.invalidateAngularResolution(htmlEntryImpl);
        } else if (sourceEntry instanceof DartEntry) {
            HashSet<Source> hashSet = new HashSet<Source>();
            for (Source source2 : this.getLibrariesContaining(source)) {
                hashSet.add(source2);
                for (Source source3 : this.getLibrariesDependingOn(source2)) {
                    hashSet.add(source3);
                }
            }
            for (Source source4 : hashSet) {
                this.invalidateLibraryResolution(source4);
            }
        }
        this.cache.remove(source);
        this.workManager.remove(source);
        this.removeFromPriorityOrder(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateCacheConsistency() {
        long l = System.nanoTime();
        ArrayList<Source> arrayList = new ArrayList<Source>();
        ArrayList<Source> arrayList2 = new ArrayList<Source>();
        Object object = this.cacheLock;
        synchronized (object) {
            for (Map.Entry<Source, SourceEntry> entry : this.cache.entrySet()) {
                Source source = entry.getKey();
                SourceEntry object2 = entry.getValue();
                long l2 = this.getModificationStamp(source);
                if (l2 != object2.getModificationTime()) {
                    arrayList.add(source);
                }
                if (object2.getException() == null || this.exists(source)) continue;
                arrayList2.add(source);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.sourceChanged((Source)arrayList.get(i));
            }
        }
        long l3 = System.nanoTime();
        if (arrayList.size() > 0 || arrayList2.size() > 0) {
            PrintStringWriter printStringWriter = new PrintStringWriter();
            printStringWriter.print("Consistency check took ");
            printStringWriter.print((double)(l3 - l) / 1000000.0);
            printStringWriter.println(" ms and found");
            printStringWriter.print("  ");
            printStringWriter.print(arrayList.size());
            printStringWriter.println(" inconsistent entries");
            printStringWriter.print("  ");
            printStringWriter.print(arrayList2.size());
            printStringWriter.println(" missing sources");
            for (Source source : arrayList2) {
                printStringWriter.print("    ");
                printStringWriter.println(source.getFullName());
            }
            this.logInformation(printStringWriter.toString());
        }
        return arrayList.size() > 0;
    }

    private static class TaskData {
        private AnalysisTask task;
        private boolean blocked;

        public TaskData(AnalysisTask analysisTask, boolean bl) {
            this.task = analysisTask;
            this.blocked = bl;
        }

        public AnalysisTask getTask() {
            return this.task;
        }

        public boolean isBlocked() {
            return this.blocked;
        }

        public String toString() {
            if (this.task == null) {
                return "blocked: " + this.blocked;
            }
            return this.task.toString();
        }
    }

    private class CycleBuilder {
        private HashMap<Source, ResolvableLibrary> libraryMap = new HashMap();
        private DirectedGraph<ResolvableLibrary> dependencyGraph;
        private List<ResolvableLibrary> librariesInCycle;
        private TaskData taskData;

        public void computeCycleContaining(Source source) throws AnalysisException {
            ResolvableLibrary resolvableLibrary = this.createLibrary(source);
            this.dependencyGraph = new DirectedGraph();
            this.computeLibraryDependencies(resolvableLibrary);
            if (this.taskData != null) {
                return;
            }
            this.librariesInCycle = this.dependencyGraph.findCycleContaining(resolvableLibrary);
            this.ensureImportsAndExports();
            if (this.taskData != null) {
                AnalysisTask analysisTask = this.taskData.getTask();
                if (analysisTask instanceof ResolveDartLibraryTask) {
                    AnalysisContextImpl.this.workManager.addFirst(((ResolveDartLibraryTask)analysisTask).getLibrarySource(), SourcePriority.LIBRARY);
                }
                return;
            }
            this.computePartsInCycle(source);
            if (this.taskData != null) {
                return;
            }
            AnalysisContextImpl.this.neededForResolution = null;
        }

        public List<ResolvableLibrary> getLibrariesInCycle() {
            return this.librariesInCycle;
        }

        public TaskData getTaskData() {
            return this.taskData;
        }

        private void computeLibraryDependencies(ResolvableLibrary resolvableLibrary) {
            Source source = resolvableLibrary.getLibrarySource();
            DartEntry dartEntry = AnalysisContextImpl.this.getReadableDartEntry(source);
            Source[] sourceArray = this.getSources(source, dartEntry, DartEntry.IMPORTED_LIBRARIES);
            if (this.taskData != null) {
                return;
            }
            Source[] sourceArray2 = this.getSources(source, dartEntry, DartEntry.EXPORTED_LIBRARIES);
            if (this.taskData != null) {
                return;
            }
            this.computeLibraryDependenciesFromDirectives(resolvableLibrary, sourceArray, sourceArray2);
        }

        private void computeLibraryDependenciesFromDirectives(ResolvableLibrary resolvableLibrary, Source[] sourceArray, Source[] sourceArray2) {
            ResolvableLibrary resolvableLibrary2;
            Source source;
            int n;
            Object object;
            int n2 = sourceArray.length;
            if (n2 > 0) {
                object = new ArrayList();
                boolean bl = false;
                for (n = 0; n < n2; ++n) {
                    source = sourceArray[n];
                    if (((Object)source).equals(AnalysisContextImpl.this.coreLibrarySource)) {
                        bl = true;
                    }
                    if ((resolvableLibrary2 = this.libraryMap.get(source)) == null && (resolvableLibrary2 = this.createLibraryOrNull(source)) != null) {
                        this.computeLibraryDependencies(resolvableLibrary2);
                        if (this.taskData != null) {
                            return;
                        }
                    }
                    if (resolvableLibrary2 == null) continue;
                    ((ArrayList)object).add(resolvableLibrary2);
                    this.dependencyGraph.addEdge(resolvableLibrary, resolvableLibrary2);
                }
                resolvableLibrary.setExplicitlyImportsCore(bl);
                if (!bl && !((Object)AnalysisContextImpl.this.coreLibrarySource).equals(resolvableLibrary.getLibrarySource())) {
                    ResolvableLibrary resolvableLibrary3 = this.libraryMap.get(AnalysisContextImpl.this.coreLibrarySource);
                    if (resolvableLibrary3 == null && (resolvableLibrary3 = this.createLibraryOrNull(AnalysisContextImpl.this.coreLibrarySource)) != null) {
                        this.computeLibraryDependencies(resolvableLibrary3);
                        if (this.taskData != null) {
                            return;
                        }
                    }
                    if (resolvableLibrary3 != null) {
                        ((ArrayList)object).add(resolvableLibrary3);
                        this.dependencyGraph.addEdge(resolvableLibrary, resolvableLibrary3);
                    }
                }
                resolvableLibrary.setImportedLibraries(((ArrayList)object).toArray(new ResolvableLibrary[((ArrayList)object).size()]));
            } else {
                resolvableLibrary.setExplicitlyImportsCore(false);
                object = this.libraryMap.get(AnalysisContextImpl.this.coreLibrarySource);
                if (object == null && (object = this.createLibraryOrNull(AnalysisContextImpl.this.coreLibrarySource)) != null) {
                    this.computeLibraryDependencies((ResolvableLibrary)object);
                    if (this.taskData != null) {
                        return;
                    }
                }
                if (object != null) {
                    this.dependencyGraph.addEdge(resolvableLibrary, (ResolvableLibrary)object);
                    resolvableLibrary.setImportedLibraries(new ResolvableLibrary[]{object});
                }
            }
            int n3 = sourceArray2.length;
            if (n3 > 0) {
                ArrayList<ResolvableLibrary> arrayList = new ArrayList<ResolvableLibrary>(n3);
                for (n = 0; n < n3; ++n) {
                    source = sourceArray2[n];
                    resolvableLibrary2 = this.libraryMap.get(source);
                    if (resolvableLibrary2 == null && (resolvableLibrary2 = this.createLibraryOrNull(source)) != null) {
                        this.computeLibraryDependencies(resolvableLibrary2);
                        if (this.taskData != null) {
                            return;
                        }
                    }
                    if (resolvableLibrary2 == null) continue;
                    arrayList.add(resolvableLibrary2);
                    this.dependencyGraph.addEdge(resolvableLibrary, resolvableLibrary2);
                }
                resolvableLibrary.setExportedLibraries(arrayList.toArray(new ResolvableLibrary[arrayList.size()]));
            }
        }

        private void computePartsInCycle(Source source) {
            int n;
            int n2 = this.librariesInCycle.size();
            ArrayList<LibraryPair> arrayList = new ArrayList<LibraryPair>(n2);
            for (n = 0; n < n2; ++n) {
                ResolvableLibrary resolvableLibrary = this.librariesInCycle.get(n);
                arrayList.add(new LibraryPair(resolvableLibrary, this.ensurePartsInLibrary(resolvableLibrary)));
            }
            AnalysisContextImpl.this.neededForResolution = this.gatherSources(arrayList);
            if (this.taskData != null) {
                return;
            }
            for (n = 0; n < n2; ++n) {
                this.computePartsInLibrary(arrayList.get(n));
            }
        }

        private void computePartsInLibrary(LibraryPair libraryPair) {
            ResolvableLibrary resolvableLibrary = libraryPair.library;
            ArrayList<SourceEntryPair> arrayList = libraryPair.entryPairs;
            int n = arrayList.size();
            ResolvableCompilationUnit[] resolvableCompilationUnitArray = new ResolvableCompilationUnit[n];
            for (int i = 0; i < n; ++i) {
                SourceEntryPair sourceEntryPair = arrayList.get(i);
                Source source = sourceEntryPair.source;
                DartEntryImpl dartEntryImpl = sourceEntryPair.entry.getWritableCopy();
                resolvableCompilationUnitArray[i] = new ResolvableCompilationUnit(dartEntryImpl.getModificationTime(), dartEntryImpl.getResolvableCompilationUnit(), source);
                AnalysisContextImpl.this.cache.put(source, dartEntryImpl);
            }
            resolvableLibrary.setResolvableCompilationUnits(resolvableCompilationUnitArray);
        }

        private ResolvableLibrary createLibrary(Source source) {
            LibraryElementImpl libraryElementImpl;
            ResolvableLibrary resolvableLibrary = new ResolvableLibrary(source);
            SourceEntry sourceEntry = AnalysisContextImpl.this.cache.get(source);
            if (sourceEntry instanceof DartEntry && (libraryElementImpl = (LibraryElementImpl)sourceEntry.getValue(DartEntry.ELEMENT)) != null) {
                resolvableLibrary.setLibraryElement(libraryElementImpl);
            }
            this.libraryMap.put(source, resolvableLibrary);
            return resolvableLibrary;
        }

        private ResolvableLibrary createLibraryOrNull(Source source) {
            LibraryElementImpl libraryElementImpl;
            if (!AnalysisContextImpl.this.exists(source)) {
                return null;
            }
            ResolvableLibrary resolvableLibrary = new ResolvableLibrary(source);
            SourceEntry sourceEntry = AnalysisContextImpl.this.cache.get(source);
            if (sourceEntry instanceof DartEntry && (libraryElementImpl = (LibraryElementImpl)sourceEntry.getValue(DartEntry.ELEMENT)) != null) {
                resolvableLibrary.setLibraryElement(libraryElementImpl);
            }
            this.libraryMap.put(source, resolvableLibrary);
            return resolvableLibrary;
        }

        private void ensureExports(ResolvableLibrary resolvableLibrary, HashSet<Source> hashSet) {
            for (ResolvableLibrary resolvableLibrary2 : resolvableLibrary.getExports()) {
                if (this.librariesInCycle.contains(resolvableLibrary2) || !hashSet.add(resolvableLibrary2.getLibrarySource())) continue;
                if (resolvableLibrary2.getLibraryElement() == null) {
                    Source source = resolvableLibrary2.getLibrarySource();
                    AnalysisContextImpl.this.workManager.addFirst(source, SourcePriority.LIBRARY);
                    if (this.taskData != null) continue;
                    this.taskData = AnalysisContextImpl.this.createResolveDartLibraryTask(source, AnalysisContextImpl.this.getReadableDartEntry(source));
                    return;
                }
                this.ensureExports(resolvableLibrary2, hashSet);
                if (this.taskData == null) continue;
                return;
            }
        }

        private void ensureImports(ResolvableLibrary resolvableLibrary) {
            for (ResolvableLibrary resolvableLibrary2 : resolvableLibrary.getImports()) {
                if (this.librariesInCycle.contains(resolvableLibrary2) || resolvableLibrary2.getLibraryElement() != null) continue;
                Source source = resolvableLibrary2.getLibrarySource();
                AnalysisContextImpl.this.workManager.addFirst(source, SourcePriority.LIBRARY);
                if (this.taskData != null) continue;
                this.taskData = AnalysisContextImpl.this.createResolveDartLibraryTask(source, AnalysisContextImpl.this.getReadableDartEntry(source));
                return;
            }
        }

        private void ensureImportsAndExports() {
            HashSet<Source> hashSet = new HashSet<Source>();
            int n = this.librariesInCycle.size();
            for (int i = 0; i < n; ++i) {
                ResolvableLibrary resolvableLibrary = this.librariesInCycle.get(i);
                this.ensureImports(resolvableLibrary);
                if (this.taskData != null) {
                    return;
                }
                this.ensureExports(resolvableLibrary, hashSet);
                if (this.taskData == null) continue;
                return;
            }
        }

        private ArrayList<SourceEntryPair> ensurePartsInLibrary(ResolvableLibrary resolvableLibrary) {
            ArrayList<SourceEntryPair> arrayList = new ArrayList<SourceEntryPair>();
            Source source = resolvableLibrary.getLibrarySource();
            DartEntry dartEntry = AnalysisContextImpl.this.getReadableDartEntry(source);
            this.ensureResolvableCompilationUnit(source, dartEntry);
            arrayList.add(new SourceEntryPair(source, dartEntry));
            for (Source source2 : this.getSources(source, dartEntry, DartEntry.INCLUDED_PARTS)) {
                DartEntry dartEntry2 = AnalysisContextImpl.this.getReadableDartEntry(source2);
                if (dartEntry2 == null || dartEntry2.getState(DartEntry.PARSED_UNIT) == CacheState.ERROR) continue;
                this.ensureResolvableCompilationUnit(source2, dartEntry2);
                arrayList.add(new SourceEntryPair(source2, dartEntry2));
            }
            return arrayList;
        }

        private void ensureResolvableCompilationUnit(Source source, DartEntry dartEntry) {
            if (!dartEntry.hasResolvableCompilationUnit() && this.taskData == null) {
                this.taskData = AnalysisContextImpl.this.createParseDartTask(source, dartEntry);
            }
        }

        private HashSet<Source> gatherSources(ArrayList<LibraryPair> arrayList) {
            int n = arrayList.size();
            HashSet<Source> hashSet = new HashSet<Source>(n * 2);
            for (int i = 0; i < n; ++i) {
                ArrayList<SourceEntryPair> arrayList2 = arrayList.get((int)i).entryPairs;
                int n2 = arrayList2.size();
                for (int j = 0; j < n2; ++j) {
                    hashSet.add(arrayList2.get((int)j).source);
                }
            }
            return hashSet;
        }

        private Source[] getSources(Source source, DartEntry dartEntry, DataDescriptor<Source[]> dataDescriptor) {
            if (dartEntry == null) {
                return Source.EMPTY_ARRAY;
            }
            CacheState cacheState = dartEntry.getState(dataDescriptor);
            if (cacheState == CacheState.ERROR) {
                return Source.EMPTY_ARRAY;
            }
            if (cacheState != CacheState.VALID) {
                if (this.taskData == null) {
                    this.taskData = AnalysisContextImpl.this.createParseDartTask(source, dartEntry);
                }
                return Source.EMPTY_ARRAY;
            }
            return dartEntry.getValue(dataDescriptor);
        }

        private class SourceEntryPair {
            public Source source;
            public DartEntry entry;

            public SourceEntryPair(Source source, DartEntry dartEntry) {
                this.source = source;
                this.entry = dartEntry;
            }
        }

        private class LibraryPair {
            public ResolvableLibrary library;
            public ArrayList<SourceEntryPair> entryPairs;

            public LibraryPair(ResolvableLibrary resolvableLibrary, ArrayList<SourceEntryPair> arrayList) {
                this.library = resolvableLibrary;
                this.entryPairs = arrayList;
            }
        }
    }

    private class ContextRetentionPolicy
    implements CacheRetentionPolicy {
        private ContextRetentionPolicy() {
        }

        @Override
        public RetentionPriority getAstPriority(Source source, SourceEntry sourceEntry) {
            DartEntry dartEntry;
            int n = AnalysisContextImpl.this.priorityOrder.length;
            for (int i = 0; i < n; ++i) {
                if (!((Object)source).equals(AnalysisContextImpl.this.priorityOrder[i])) continue;
                return RetentionPriority.HIGH;
            }
            if (AnalysisContextImpl.this.neededForResolution != null && AnalysisContextImpl.this.neededForResolution.contains(source)) {
                return RetentionPriority.HIGH;
            }
            if (sourceEntry instanceof DartEntry && this.astIsNeeded(dartEntry = (DartEntry)sourceEntry)) {
                return RetentionPriority.MEDIUM;
            }
            return RetentionPriority.LOW;
        }

        private boolean astIsNeeded(DartEntry dartEntry) {
            return dartEntry.hasInvalidData(DartEntry.HINTS) || dartEntry.hasInvalidData(DartEntry.VERIFICATION_ERRORS) || dartEntry.hasInvalidData(DartEntry.RESOLUTION_ERRORS);
        }
    }

    private class AnalysisTaskResultRecorder
    implements AnalysisTaskVisitor<SourceEntry> {
        private AnalysisTaskResultRecorder() {
        }

        @Override
        public DartEntry visitGenerateDartErrorsTask(GenerateDartErrorsTask generateDartErrorsTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordGenerateDartErrorsTask(generateDartErrorsTask);
        }

        @Override
        public DartEntry visitGenerateDartHintsTask(GenerateDartHintsTask generateDartHintsTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordGenerateDartHintsTask(generateDartHintsTask);
        }

        @Override
        public SourceEntry visitGetContentTask(GetContentTask getContentTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordGetContentsTask(getContentTask);
        }

        @Override
        public DartEntry visitIncrementalAnalysisTask(IncrementalAnalysisTask incrementalAnalysisTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordIncrementalAnalysisTaskResults(incrementalAnalysisTask);
        }

        @Override
        public DartEntry visitParseDartTask(ParseDartTask parseDartTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordParseDartTaskResults(parseDartTask);
        }

        @Override
        public HtmlEntry visitParseHtmlTask(ParseHtmlTask parseHtmlTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordParseHtmlTaskResults(parseHtmlTask);
        }

        @Override
        public HtmlEntry visitResolveAngularComponentTemplateTask(ResolveAngularComponentTemplateTask resolveAngularComponentTemplateTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordResolveAngularComponentTemplateTaskResults(resolveAngularComponentTemplateTask);
        }

        @Override
        public HtmlEntry visitResolveAngularEntryHtmlTask(ResolveAngularEntryHtmlTask resolveAngularEntryHtmlTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordResolveAngularEntryHtmlTaskResults(resolveAngularEntryHtmlTask);
        }

        @Override
        public DartEntry visitResolveDartLibraryCycleTask(ResolveDartLibraryCycleTask resolveDartLibraryCycleTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordResolveDartLibraryCycleTaskResults(resolveDartLibraryCycleTask);
        }

        @Override
        public DartEntry visitResolveDartLibraryTask(ResolveDartLibraryTask resolveDartLibraryTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordResolveDartLibraryTaskResults(resolveDartLibraryTask);
        }

        @Override
        public DartEntry visitResolveDartUnitTask(ResolveDartUnitTask resolveDartUnitTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordResolveDartUnitTaskResults(resolveDartUnitTask);
        }

        @Override
        public HtmlEntry visitResolveHtmlTask(ResolveHtmlTask resolveHtmlTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordResolveHtmlTaskResults(resolveHtmlTask);
        }

        @Override
        public DartEntry visitScanDartTask(ScanDartTask scanDartTask) throws AnalysisException {
            return AnalysisContextImpl.this.recordScanDartTaskResults(scanDartTask);
        }
    }
}

