/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.context;

import com.google.dart.engine.context.AnalysisContentStatistics;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.internal.cache.CacheState;
import com.google.dart.engine.internal.cache.DartEntry;
import com.google.dart.engine.internal.cache.DataDescriptor;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class AnalysisContentStatisticsImpl
implements AnalysisContentStatistics {
    private final Map<String, AnalysisContentStatistics.CacheRow> dataMap = new HashMap<String, AnalysisContentStatistics.CacheRow>();
    private ArrayList<Source> sources = new ArrayList();
    private HashSet<AnalysisException> exceptions = new HashSet();

    public void addSource(Source source) {
        this.sources.add(source);
    }

    @Override
    public AnalysisContentStatistics.CacheRow[] getCacheRows() {
        Collection<AnalysisContentStatistics.CacheRow> collection = this.dataMap.values();
        return collection.toArray(new AnalysisContentStatistics.CacheRow[collection.size()]);
    }

    @Override
    public AnalysisException[] getExceptions() {
        return this.exceptions.toArray(new AnalysisException[this.exceptions.size()]);
    }

    @Override
    public Source[] getSources() {
        return this.sources.toArray(new Source[this.sources.size()]);
    }

    public void putCacheItem(SourceEntry sourceEntry, DataDescriptor<?> dataDescriptor) {
        this.internalPutCacheItem(sourceEntry, dataDescriptor, sourceEntry.getState(dataDescriptor));
    }

    public void putCacheItemInLibrary(DartEntry dartEntry, Source source, DataDescriptor<?> dataDescriptor) {
        this.internalPutCacheItem(dartEntry, dataDescriptor, dartEntry.getStateInLibrary(dataDescriptor, source));
    }

    private void internalPutCacheItem(SourceEntry sourceEntry, DataDescriptor<?> dataDescriptor, CacheState cacheState) {
        AnalysisException analysisException;
        String string = dataDescriptor.toString();
        CacheRowImpl cacheRowImpl = (CacheRowImpl)this.dataMap.get(string);
        if (cacheRowImpl == null) {
            cacheRowImpl = new CacheRowImpl(string);
            this.dataMap.put(string, cacheRowImpl);
        }
        cacheRowImpl.incState(cacheState);
        if (cacheState == CacheState.ERROR && (analysisException = sourceEntry.getException()) != null) {
            this.exceptions.add(analysisException);
        }
    }

    private static class CacheRowImpl
    implements AnalysisContentStatistics.CacheRow {
        private final String name;
        private int errorCount;
        private int flushedCount;
        private int inProcessCount;
        private int invalidCount;
        private int validCount;

        public CacheRowImpl(String string) {
            this.name = string;
        }

        public boolean equals(Object object) {
            return object instanceof CacheRowImpl && ((CacheRowImpl)object).name.equals(this.name);
        }

        @Override
        public int getErrorCount() {
            return this.errorCount;
        }

        @Override
        public int getFlushedCount() {
            return this.flushedCount;
        }

        @Override
        public int getInProcessCount() {
            return this.inProcessCount;
        }

        @Override
        public int getInvalidCount() {
            return this.invalidCount;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValidCount() {
            return this.validCount;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        void incState(CacheState cacheState) {
            if (cacheState == CacheState.ERROR) {
                ++this.errorCount;
            }
            if (cacheState == CacheState.FLUSHED) {
                ++this.flushedCount;
            }
            if (cacheState == CacheState.IN_PROCESS) {
                ++this.inProcessCount;
            }
            if (cacheState == CacheState.INVALID) {
                ++this.invalidCount;
            }
            if (cacheState == CacheState.VALID) {
                ++this.validCount;
            }
        }
    }
}

