/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.constant;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.internal.constant.ErrorResult;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.internal.object.EvaluationException;
import com.google.dart.engine.internal.resolver.TypeProvider;

public class ValidResult
extends EvaluationResultImpl {
    private final DartObjectImpl value;

    public ValidResult(DartObjectImpl dartObjectImpl) {
        this.value = dartObjectImpl;
    }

    @Override
    public EvaluationResultImpl add(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.addToValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl applyBooleanConversion(TypeProvider typeProvider, AstNode astNode) {
        try {
            return this.valueOf(this.value.convertToBool(typeProvider));
        }
        catch (EvaluationException evaluationException) {
            return this.error(astNode, evaluationException.getErrorCode());
        }
    }

    @Override
    public EvaluationResultImpl bitAnd(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.bitAndValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl bitNot(TypeProvider typeProvider, Expression expression) {
        try {
            return this.valueOf(this.value.bitNot(typeProvider));
        }
        catch (EvaluationException evaluationException) {
            return this.error(expression, evaluationException.getErrorCode());
        }
    }

    @Override
    public EvaluationResultImpl bitOr(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.bitOrValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl bitXor(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.bitXorValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl concatenate(TypeProvider typeProvider, Expression expression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.concatenateValid(typeProvider, expression, this);
    }

    @Override
    public EvaluationResultImpl divide(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.divideValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl equalEqual(TypeProvider typeProvider, Expression expression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.equalEqualValid(typeProvider, expression, this);
    }

    @Override
    public boolean equalValues(TypeProvider typeProvider, EvaluationResultImpl evaluationResultImpl) {
        if (!(evaluationResultImpl instanceof ValidResult)) {
            return false;
        }
        return this.value.equals(((ValidResult)evaluationResultImpl).value);
    }

    public DartObjectImpl getValue() {
        return this.value;
    }

    @Override
    public EvaluationResultImpl greaterThan(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.greaterThanValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl greaterThanOrEqual(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.greaterThanOrEqualValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl integerDivide(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.integerDivideValid(typeProvider, binaryExpression, this);
    }

    public boolean isBool() {
        return this.value.isBool();
    }

    public boolean isBoolNumStringOrNull() {
        return this.value.isBoolNumStringOrNull();
    }

    public boolean isFalse() {
        return this.value.isFalse();
    }

    public boolean isNull() {
        return this.value.isNull();
    }

    public boolean isTrue() {
        return this.value.isTrue();
    }

    public boolean isUserDefinedObject() {
        return this.value.isUserDefinedObject();
    }

    @Override
    public EvaluationResultImpl lessThan(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.lessThanValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl lessThanOrEqual(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.lessThanOrEqualValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl logicalAnd(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.logicalAndValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl logicalNot(TypeProvider typeProvider, Expression expression) {
        try {
            return this.valueOf(this.value.logicalNot(typeProvider));
        }
        catch (EvaluationException evaluationException) {
            return this.error(expression, evaluationException.getErrorCode());
        }
    }

    @Override
    public EvaluationResultImpl logicalOr(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.logicalOrValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl minus(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.minusValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl negated(TypeProvider typeProvider, Expression expression) {
        try {
            return this.valueOf(this.value.negated(typeProvider));
        }
        catch (EvaluationException evaluationException) {
            return this.error(expression, evaluationException.getErrorCode());
        }
    }

    @Override
    public EvaluationResultImpl notEqual(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.notEqualValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl performToString(TypeProvider typeProvider, AstNode astNode) {
        try {
            return this.valueOf(this.value.performToString(typeProvider));
        }
        catch (EvaluationException evaluationException) {
            return this.error(astNode, evaluationException.getErrorCode());
        }
    }

    @Override
    public EvaluationResultImpl remainder(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.remainderValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl shiftLeft(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.shiftLeftValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl shiftRight(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.shiftRightValid(typeProvider, binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl times(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.timesValid(typeProvider, binaryExpression, this);
    }

    public String toString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    @Override
    protected EvaluationResultImpl addToError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl addToValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().add(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl bitAndError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl bitAndValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().bitAnd(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl bitOrError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl bitOrValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().bitOr(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl bitXorError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl bitXorValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().bitXor(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl concatenateError(Expression expression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl concatenateValid(TypeProvider typeProvider, Expression expression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().concatenate(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(expression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl divideError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl divideValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().divide(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl equalEqualError(Expression expression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl equalEqualValid(TypeProvider typeProvider, Expression expression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().equalEqual(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(expression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl greaterThanError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl greaterThanOrEqualError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl greaterThanOrEqualValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().greaterThanOrEqual(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl greaterThanValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().greaterThan(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl integerDivideError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl integerDivideValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().integerDivide(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl lessThanError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl lessThanOrEqualError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl lessThanOrEqualValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().lessThanOrEqual(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl lessThanValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().lessThan(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl logicalAndError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl logicalAndValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().logicalAnd(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl logicalOrError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl logicalOrValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().logicalOr(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl minusError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl minusValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().minus(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl notEqualError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl notEqualValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().notEqual(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl remainderError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl remainderValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().remainder(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl shiftLeftError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl shiftLeftValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().shiftLeft(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl shiftRightError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl shiftRightValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().shiftRight(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    @Override
    protected EvaluationResultImpl timesError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return errorResult;
    }

    @Override
    protected EvaluationResultImpl timesValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        try {
            return this.valueOf(validResult.getValue().times(typeProvider, this.value));
        }
        catch (EvaluationException evaluationException) {
            return this.error(binaryExpression, evaluationException.getErrorCode());
        }
    }

    private ErrorResult error(AstNode astNode, ErrorCode errorCode) {
        return new ErrorResult(astNode, errorCode);
    }

    private ValidResult valueOf(DartObjectImpl dartObjectImpl) {
        return new ValidResult(dartObjectImpl);
    }
}

