/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.constant;

import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.utilities.collection.DirectedGraph;

public class ReferenceFinder
extends RecursiveAstVisitor<Void> {
    private VariableElement source;
    private DirectedGraph<VariableElement> referenceGraph;

    public ReferenceFinder(VariableElement variableElement, DirectedGraph<VariableElement> directedGraph) {
        this.source = variableElement;
        this.referenceGraph = directedGraph;
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        VariableElement variableElement;
        Element element = simpleIdentifier.getStaticElement();
        if (element instanceof PropertyAccessorElement) {
            element = ((PropertyAccessorElement)element).getVariable();
        }
        if (element instanceof VariableElement && (variableElement = (VariableElement)element).isConst()) {
            this.referenceGraph.addEdge(this.source, variableElement);
        }
        return null;
    }
}

