/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.constant;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.constant.ValidResult;
import com.google.dart.engine.internal.resolver.TypeProvider;
import java.util.ArrayList;

public class ErrorResult
extends EvaluationResultImpl {
    private ArrayList<ErrorData> errors = new ArrayList();

    public ErrorResult(AstNode astNode, ErrorCode errorCode) {
        this.errors.add(new ErrorData(astNode, errorCode));
    }

    public ErrorResult(ErrorResult errorResult, ErrorResult errorResult2) {
        this.errors.addAll(errorResult.errors);
        this.errors.addAll(errorResult2.errors);
    }

    @Override
    public EvaluationResultImpl add(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.addToError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl applyBooleanConversion(TypeProvider typeProvider, AstNode astNode) {
        return this;
    }

    @Override
    public EvaluationResultImpl bitAnd(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.bitAndError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl bitNot(TypeProvider typeProvider, Expression expression) {
        return this;
    }

    @Override
    public EvaluationResultImpl bitOr(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.bitOrError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl bitXor(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.bitXorError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl concatenate(TypeProvider typeProvider, Expression expression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.concatenateError(expression, this);
    }

    @Override
    public EvaluationResultImpl divide(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.divideError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl equalEqual(TypeProvider typeProvider, Expression expression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.equalEqualError(expression, this);
    }

    @Override
    public boolean equalValues(TypeProvider typeProvider, EvaluationResultImpl evaluationResultImpl) {
        return false;
    }

    public ArrayList<ErrorData> getErrorData() {
        return this.errors;
    }

    @Override
    public EvaluationResultImpl greaterThan(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.greaterThanError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl greaterThanOrEqual(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.greaterThanOrEqualError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl integerDivide(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.integerDivideError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl integerDivideValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    public EvaluationResultImpl lessThan(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.lessThanError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl lessThanOrEqual(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.lessThanOrEqualError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl logicalAnd(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.logicalAndError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl logicalNot(TypeProvider typeProvider, Expression expression) {
        return this;
    }

    @Override
    public EvaluationResultImpl logicalOr(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.logicalOrError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl minus(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.minusError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl negated(TypeProvider typeProvider, Expression expression) {
        return this;
    }

    @Override
    public EvaluationResultImpl notEqual(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.notEqualError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl performToString(TypeProvider typeProvider, AstNode astNode) {
        return this;
    }

    @Override
    public EvaluationResultImpl remainder(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.remainderError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl shiftLeft(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.shiftLeftError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl shiftRight(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.shiftRightError(binaryExpression, this);
    }

    @Override
    public EvaluationResultImpl times(TypeProvider typeProvider, BinaryExpression binaryExpression, EvaluationResultImpl evaluationResultImpl) {
        return evaluationResultImpl.timesError(binaryExpression, this);
    }

    @Override
    protected EvaluationResultImpl addToError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl addToValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl bitAndError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl bitAndValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl bitOrError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl bitOrValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl bitXorError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl bitXorValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl concatenateError(Expression expression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl concatenateValid(TypeProvider typeProvider, Expression expression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl divideError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl divideValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl equalEqualError(Expression expression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl equalEqualValid(TypeProvider typeProvider, Expression expression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl greaterThanError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl greaterThanOrEqualError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl greaterThanOrEqualValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl greaterThanValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl integerDivideError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl lessThanError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl lessThanOrEqualError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl lessThanOrEqualValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl lessThanValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl logicalAndError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl logicalAndValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl logicalOrError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl logicalOrValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl minusError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl minusValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl notEqualError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl notEqualValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl remainderError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl remainderValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl shiftLeftError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl shiftLeftValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl shiftRightError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl shiftRightValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    @Override
    protected EvaluationResultImpl timesError(BinaryExpression binaryExpression, ErrorResult errorResult) {
        return new ErrorResult(this, errorResult);
    }

    @Override
    protected EvaluationResultImpl timesValid(TypeProvider typeProvider, BinaryExpression binaryExpression, ValidResult validResult) {
        return this;
    }

    public static class ErrorData {
        private AstNode node;
        private ErrorCode errorCode;

        public ErrorData(AstNode astNode, ErrorCode errorCode) {
            this.node = astNode;
            this.errorCode = errorCode;
        }

        public ErrorCode getErrorCode() {
            return this.errorCode;
        }

        public AstNode getNode() {
            return this.node;
        }
    }
}

