/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.constant;

import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.InterpolationElement;
import com.google.dart.engine.ast.InterpolationExpression;
import com.google.dart.engine.ast.InterpolationString;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.visitor.UnifyingAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ExecutableElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FieldFormalParameterElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PrefixElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.error.CompileTimeErrorCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.internal.constant.ErrorResult;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.constant.ValidResult;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.object.BoolState;
import com.google.dart.engine.internal.object.DartObjectImpl;
import com.google.dart.engine.internal.object.DoubleState;
import com.google.dart.engine.internal.object.FunctionState;
import com.google.dart.engine.internal.object.GenericState;
import com.google.dart.engine.internal.object.InstanceState;
import com.google.dart.engine.internal.object.IntState;
import com.google.dart.engine.internal.object.ListState;
import com.google.dart.engine.internal.object.MapState;
import com.google.dart.engine.internal.object.NullState;
import com.google.dart.engine.internal.object.StringState;
import com.google.dart.engine.internal.object.SymbolState;
import com.google.dart.engine.internal.object.TypeState;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstantVisitor
extends UnifyingAstVisitor<EvaluationResultImpl> {
    private TypeProvider typeProvider;
    private DartObjectImpl nullObject;

    public ConstantVisitor(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    @Override
    public EvaluationResultImpl visitAdjacentStrings(AdjacentStrings adjacentStrings) {
        EvaluationResultImpl evaluationResultImpl = null;
        for (StringLiteral stringLiteral : adjacentStrings.getStrings()) {
            if (evaluationResultImpl == null) {
                evaluationResultImpl = stringLiteral.accept(this);
                continue;
            }
            evaluationResultImpl = evaluationResultImpl.concatenate(this.typeProvider, adjacentStrings, stringLiteral.accept(this));
        }
        return evaluationResultImpl;
    }

    @Override
    public EvaluationResultImpl visitBinaryExpression(BinaryExpression binaryExpression) {
        EvaluationResultImpl evaluationResultImpl = binaryExpression.getLeftOperand().accept(this);
        EvaluationResultImpl evaluationResultImpl2 = binaryExpression.getRightOperand().accept(this);
        TokenType tokenType = binaryExpression.getOperator().getType();
        if (tokenType != TokenType.BANG_EQ && tokenType != TokenType.EQ_EQ && (evaluationResultImpl instanceof ValidResult && ((ValidResult)evaluationResultImpl).isNull() || evaluationResultImpl2 instanceof ValidResult && ((ValidResult)evaluationResultImpl2).isNull())) {
            return this.error(binaryExpression, CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
        }
        switch (tokenType) {
            case AMPERSAND: {
                return evaluationResultImpl.bitAnd(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case AMPERSAND_AMPERSAND: {
                return evaluationResultImpl.logicalAnd(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case BANG_EQ: {
                return evaluationResultImpl.notEqual(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case BAR: {
                return evaluationResultImpl.bitOr(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case BAR_BAR: {
                return evaluationResultImpl.logicalOr(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case CARET: {
                return evaluationResultImpl.bitXor(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case EQ_EQ: {
                return evaluationResultImpl.equalEqual(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case GT: {
                return evaluationResultImpl.greaterThan(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case GT_EQ: {
                return evaluationResultImpl.greaterThanOrEqual(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case GT_GT: {
                return evaluationResultImpl.shiftRight(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case LT: {
                return evaluationResultImpl.lessThan(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case LT_EQ: {
                return evaluationResultImpl.lessThanOrEqual(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case LT_LT: {
                return evaluationResultImpl.shiftLeft(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case MINUS: {
                return evaluationResultImpl.minus(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case PERCENT: {
                return evaluationResultImpl.remainder(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case PLUS: {
                return evaluationResultImpl.add(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case STAR: {
                return evaluationResultImpl.times(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case SLASH: {
                return evaluationResultImpl.divide(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
            case TILDE_SLASH: {
                return evaluationResultImpl.integerDivide(this.typeProvider, binaryExpression, evaluationResultImpl2);
            }
        }
        return this.error(binaryExpression, null);
    }

    @Override
    public EvaluationResultImpl visitBooleanLiteral(BooleanLiteral booleanLiteral) {
        return this.valid(this.typeProvider.getBoolType(), BoolState.from(booleanLiteral.getValue()));
    }

    @Override
    public EvaluationResultImpl visitConditionalExpression(ConditionalExpression conditionalExpression) {
        Expression expression = conditionalExpression.getCondition();
        EvaluationResultImpl evaluationResultImpl = expression.accept(this);
        EvaluationResultImpl evaluationResultImpl2 = conditionalExpression.getThenExpression().accept(this);
        EvaluationResultImpl evaluationResultImpl3 = conditionalExpression.getElseExpression().accept(this);
        if (evaluationResultImpl instanceof ErrorResult) {
            return this.union(this.union((ErrorResult)evaluationResultImpl, evaluationResultImpl2), evaluationResultImpl3);
        }
        if (!((ValidResult)evaluationResultImpl).isBool()) {
            return new ErrorResult(expression, CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL);
        }
        if (evaluationResultImpl2 instanceof ErrorResult) {
            return this.union((ErrorResult)evaluationResultImpl2, evaluationResultImpl3);
        }
        if (evaluationResultImpl3 instanceof ErrorResult) {
            return evaluationResultImpl3;
        }
        if ((evaluationResultImpl = evaluationResultImpl.applyBooleanConversion(this.typeProvider, expression)) instanceof ErrorResult) {
            return evaluationResultImpl;
        }
        ValidResult validResult = (ValidResult)evaluationResultImpl;
        if (validResult.isTrue()) {
            return evaluationResultImpl2;
        }
        if (validResult.isFalse()) {
            return evaluationResultImpl3;
        }
        InterfaceType interfaceType = ((ValidResult)evaluationResultImpl2).getValue().getType();
        InterfaceType interfaceType2 = ((ValidResult)evaluationResultImpl3).getValue().getType();
        return this.validWithUnknownValue((InterfaceType)interfaceType.getLeastUpperBound(interfaceType2));
    }

    @Override
    public EvaluationResultImpl visitDoubleLiteral(DoubleLiteral doubleLiteral) {
        return this.valid(this.typeProvider.getDoubleType(), new DoubleState(doubleLiteral.getValue()));
    }

    @Override
    public EvaluationResultImpl visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        if (!instanceCreationExpression.isConst()) {
            return this.error(instanceCreationExpression, null);
        }
        ConstructorElement constructorElement = instanceCreationExpression.getStaticElement();
        if (constructorElement != null && constructorElement.isConst()) {
            Object object;
            Object object2;
            NodeList<Expression> nodeList = instanceCreationExpression.getArgumentList().getArguments();
            int n = nodeList.size();
            DartObjectImpl[] dartObjectImplArray = new DartObjectImpl[n];
            HashMap<String, DartObjectImpl> hashMap = new HashMap<String, DartObjectImpl>();
            for (int i = 0; i < n; ++i) {
                object2 = (Expression)nodeList.get(i);
                if (object2 instanceof NamedExpression) {
                    object = (ParameterElement[])object2;
                    String string = object.getName().getLabel().getName();
                    hashMap.put(string, this.valueOf(object.getExpression()));
                    dartObjectImplArray[i] = this.getNull();
                    continue;
                }
                dartObjectImplArray[i] = this.valueOf((Expression)object2);
            }
            InterfaceType interfaceType = (InterfaceType)constructorElement.getReturnType();
            if (interfaceType.getElement().getLibrary().isDartCore() && ((String)(object2 = interfaceType.getName())).equals("Symbol") && n == 1 && (object = dartObjectImplArray[0].getStringValue()) != null) {
                return this.valid(interfaceType, new SymbolState((String)object));
            }
            object2 = new HashMap<String, DartObjectImpl>();
            object = constructorElement.getParameters();
            int n2 = ((ParameterElement[])object).length;
            for (int i = 0; i < n2; ++i) {
                FieldElement fieldElement;
                ParameterElement parameterElement = object[i];
                if (!parameterElement.isInitializingFormal() || (fieldElement = ((FieldFormalParameterElement)parameterElement).getField()) == null) continue;
                String string = fieldElement.getName();
                if (parameterElement.getParameterKind() == ParameterKind.NAMED) {
                    DartObjectImpl dartObjectImpl = (DartObjectImpl)hashMap.get(parameterElement.getName());
                    if (dartObjectImpl == null) continue;
                    ((HashMap)object2).put((String)string, (DartObjectImpl)dartObjectImpl);
                    continue;
                }
                if (i >= n) continue;
                ((HashMap)object2).put((String)string, (DartObjectImpl)dartObjectImplArray[i]);
            }
            return this.valid(interfaceType, new GenericState((HashMap<String, DartObjectImpl>)object2));
        }
        return this.error(instanceCreationExpression, null);
    }

    @Override
    public EvaluationResultImpl visitIntegerLiteral(IntegerLiteral integerLiteral) {
        return this.valid(this.typeProvider.getIntType(), new IntState(integerLiteral.getValue()));
    }

    @Override
    public EvaluationResultImpl visitInterpolationExpression(InterpolationExpression interpolationExpression) {
        EvaluationResultImpl evaluationResultImpl = interpolationExpression.getExpression().accept(this);
        if (evaluationResultImpl instanceof ValidResult && !((ValidResult)evaluationResultImpl).isBoolNumStringOrNull()) {
            return this.error(interpolationExpression, CompileTimeErrorCode.CONST_EVAL_TYPE_BOOL_NUM_STRING);
        }
        return evaluationResultImpl.performToString(this.typeProvider, interpolationExpression);
    }

    @Override
    public EvaluationResultImpl visitInterpolationString(InterpolationString interpolationString) {
        return this.valid(this.typeProvider.getStringType(), new StringState(interpolationString.getValue()));
    }

    @Override
    public EvaluationResultImpl visitListLiteral(ListLiteral listLiteral) {
        if (listLiteral.getConstKeyword() == null) {
            return new ErrorResult(listLiteral, CompileTimeErrorCode.MISSING_CONST_IN_LIST_LITERAL);
        }
        ErrorResult errorResult = null;
        ArrayList<DartObjectImpl> arrayList = new ArrayList<DartObjectImpl>();
        for (Expression expression : listLiteral.getElements()) {
            EvaluationResultImpl evaluationResultImpl = expression.accept(this);
            errorResult = this.union(errorResult, evaluationResultImpl);
            if (!(evaluationResultImpl instanceof ValidResult)) continue;
            arrayList.add(((ValidResult)evaluationResultImpl).getValue());
        }
        if (errorResult != null) {
            return errorResult;
        }
        return this.valid(this.typeProvider.getListType(), new ListState(arrayList.toArray(new DartObjectImpl[arrayList.size()])));
    }

    @Override
    public EvaluationResultImpl visitMapLiteral(MapLiteral mapLiteral) {
        if (mapLiteral.getConstKeyword() == null) {
            return new ErrorResult(mapLiteral, CompileTimeErrorCode.MISSING_CONST_IN_MAP_LITERAL);
        }
        ErrorResult errorResult = null;
        HashMap<DartObjectImpl, DartObjectImpl> hashMap = new HashMap<DartObjectImpl, DartObjectImpl>();
        for (MapLiteralEntry mapLiteralEntry : mapLiteral.getEntries()) {
            EvaluationResultImpl evaluationResultImpl = mapLiteralEntry.getKey().accept(this);
            EvaluationResultImpl evaluationResultImpl2 = mapLiteralEntry.getValue().accept(this);
            errorResult = this.union(errorResult, evaluationResultImpl);
            errorResult = this.union(errorResult, evaluationResultImpl2);
            if (!(evaluationResultImpl instanceof ValidResult) || !(evaluationResultImpl2 instanceof ValidResult)) continue;
            hashMap.put(((ValidResult)evaluationResultImpl).getValue(), ((ValidResult)evaluationResultImpl2).getValue());
        }
        if (errorResult != null) {
            return errorResult;
        }
        return this.valid(this.typeProvider.getMapType(), new MapState(hashMap));
    }

    @Override
    public EvaluationResultImpl visitMethodInvocation(MethodInvocation methodInvocation) {
        LibraryElement libraryElement;
        Element element;
        NodeList<Expression> nodeList;
        FunctionElement functionElement;
        Element element2 = methodInvocation.getMethodName().getStaticElement();
        if (element2 instanceof FunctionElement && (functionElement = (FunctionElement)element2).getName().equals("identical") && (nodeList = methodInvocation.getArgumentList().getArguments()).size() == 2 && (element = functionElement.getEnclosingElement()) instanceof CompilationUnitElement && (libraryElement = ((CompilationUnitElement)element).getLibrary()).isDartCore()) {
            EvaluationResultImpl evaluationResultImpl = ((Expression)nodeList.get(0)).accept(this);
            EvaluationResultImpl evaluationResultImpl2 = ((Expression)nodeList.get(1)).accept(this);
            return evaluationResultImpl.equalEqual(this.typeProvider, methodInvocation, evaluationResultImpl2);
        }
        return this.error(methodInvocation, null);
    }

    @Override
    public EvaluationResultImpl visitNamedExpression(NamedExpression namedExpression) {
        return namedExpression.getExpression().accept(this);
    }

    @Override
    public EvaluationResultImpl visitNode(AstNode astNode) {
        return this.error(astNode, null);
    }

    @Override
    public EvaluationResultImpl visitNullLiteral(NullLiteral nullLiteral) {
        return new ValidResult(this.getNull());
    }

    @Override
    public EvaluationResultImpl visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        return parenthesizedExpression.getExpression().accept(this);
    }

    @Override
    public EvaluationResultImpl visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        EvaluationResultImpl evaluationResultImpl;
        SimpleIdentifier simpleIdentifier = prefixedIdentifier.getPrefix();
        Element element = simpleIdentifier.getStaticElement();
        if (!(element instanceof PrefixElement) && !((evaluationResultImpl = simpleIdentifier.accept(this)) instanceof ValidResult)) {
            return this.error(prefixedIdentifier, null);
        }
        return this.getConstantValue(prefixedIdentifier, prefixedIdentifier.getStaticElement());
    }

    @Override
    public EvaluationResultImpl visitPrefixExpression(PrefixExpression prefixExpression) {
        EvaluationResultImpl evaluationResultImpl = prefixExpression.getOperand().accept(this);
        if (evaluationResultImpl instanceof ValidResult && ((ValidResult)evaluationResultImpl).isNull()) {
            return this.error(prefixExpression, CompileTimeErrorCode.CONST_EVAL_THROWS_EXCEPTION);
        }
        switch (prefixExpression.getOperator().getType()) {
            case BANG: {
                return evaluationResultImpl.logicalNot(this.typeProvider, prefixExpression);
            }
            case TILDE: {
                return evaluationResultImpl.bitNot(this.typeProvider, prefixExpression);
            }
            case MINUS: {
                return evaluationResultImpl.negated(this.typeProvider, prefixExpression);
            }
        }
        return this.error(prefixExpression, null);
    }

    @Override
    public EvaluationResultImpl visitPropertyAccess(PropertyAccess propertyAccess) {
        return this.getConstantValue(propertyAccess, propertyAccess.getPropertyName().getStaticElement());
    }

    @Override
    public EvaluationResultImpl visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        return this.getConstantValue(simpleIdentifier, simpleIdentifier.getStaticElement());
    }

    @Override
    public EvaluationResultImpl visitSimpleStringLiteral(SimpleStringLiteral simpleStringLiteral) {
        return this.valid(this.typeProvider.getStringType(), new StringState(simpleStringLiteral.getValue()));
    }

    @Override
    public EvaluationResultImpl visitStringInterpolation(StringInterpolation stringInterpolation) {
        EvaluationResultImpl evaluationResultImpl = null;
        for (InterpolationElement interpolationElement : stringInterpolation.getElements()) {
            if (evaluationResultImpl == null) {
                evaluationResultImpl = interpolationElement.accept(this);
                continue;
            }
            evaluationResultImpl = evaluationResultImpl.concatenate(this.typeProvider, stringInterpolation, interpolationElement.accept(this));
        }
        return evaluationResultImpl;
    }

    @Override
    public EvaluationResultImpl visitSymbolLiteral(SymbolLiteral symbolLiteral) {
        StringBuilder stringBuilder = new StringBuilder();
        Token[] tokenArray = symbolLiteral.getComponents();
        for (int i = 0; i < tokenArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(tokenArray[i].getLexeme());
        }
        return this.valid(this.typeProvider.getSymbolType(), new SymbolState(stringBuilder.toString()));
    }

    private ErrorResult error(AstNode astNode, ErrorCode errorCode) {
        return new ErrorResult(astNode, errorCode == null ? CompileTimeErrorCode.INVALID_CONSTANT : errorCode);
    }

    private EvaluationResultImpl getConstantValue(AstNode astNode, Element element) {
        if (element instanceof PropertyAccessorElement) {
            element = ((PropertyAccessorElement)element).getVariable();
        }
        if (element instanceof VariableElementImpl) {
            VariableElementImpl variableElementImpl = (VariableElementImpl)element;
            EvaluationResultImpl evaluationResultImpl = variableElementImpl.getEvaluationResult();
            if (variableElementImpl.isConst() && evaluationResultImpl != null) {
                return evaluationResultImpl;
            }
        } else if (element instanceof ExecutableElement) {
            ExecutableElement executableElement = (ExecutableElement)element;
            if (executableElement.isStatic()) {
                return this.valid(this.typeProvider.getFunctionType(), new FunctionState(executableElement));
            }
        } else if (element instanceof ClassElement || element instanceof FunctionTypeAliasElement) {
            return this.valid(this.typeProvider.getTypeType(), new TypeState(element));
        }
        return this.error(astNode, null);
    }

    private DartObjectImpl getNull() {
        if (this.nullObject == null) {
            this.nullObject = new DartObjectImpl(this.typeProvider.getNullType(), NullState.NULL_STATE);
        }
        return this.nullObject;
    }

    private ErrorResult union(ErrorResult errorResult, EvaluationResultImpl evaluationResultImpl) {
        if (evaluationResultImpl instanceof ErrorResult) {
            if (errorResult != null) {
                return new ErrorResult(errorResult, (ErrorResult)evaluationResultImpl);
            }
            return (ErrorResult)evaluationResultImpl;
        }
        return errorResult;
    }

    private ValidResult valid(InterfaceType interfaceType, InstanceState instanceState) {
        return new ValidResult(new DartObjectImpl(interfaceType, instanceState));
    }

    private ValidResult validWithUnknownValue(InterfaceType interfaceType) {
        if (interfaceType.getElement().getLibrary().isDartCore()) {
            String string = interfaceType.getName();
            if (string.equals("bool")) {
                return this.valid(interfaceType, BoolState.UNKNOWN_VALUE);
            }
            if (string.equals("double")) {
                return this.valid(interfaceType, DoubleState.UNKNOWN_VALUE);
            }
            if (string.equals("int")) {
                return this.valid(interfaceType, IntState.UNKNOWN_VALUE);
            }
            if (string.equals("String")) {
                return this.valid(interfaceType, StringState.UNKNOWN_VALUE);
            }
        }
        return this.valid(interfaceType, GenericState.UNKNOWN_VALUE);
    }

    private DartObjectImpl valueOf(Expression expression) {
        EvaluationResultImpl evaluationResultImpl = expression.accept(this);
        if (evaluationResultImpl instanceof ValidResult) {
            return ((ValidResult)evaluationResultImpl).getValue();
        }
        return this.getNull();
    }
}

