/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.constant;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.internal.constant.ConstantFinder;
import com.google.dart.engine.internal.constant.ConstantVisitor;
import com.google.dart.engine.internal.constant.ErrorResult;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.constant.ReferenceFinder;
import com.google.dart.engine.internal.element.VariableElementImpl;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.collection.DirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConstantValueComputer {
    private TypeProvider typeProvider;
    private ConstantFinder constantFinder = new ConstantFinder();
    private DirectedGraph<VariableElement> referenceGraph = new DirectedGraph();
    private HashMap<VariableElement, VariableDeclaration> declarationMap;

    public ConstantValueComputer(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public void add(CompilationUnit compilationUnit) {
        compilationUnit.accept(this.constantFinder);
    }

    public void computeValues() {
        this.declarationMap = this.constantFinder.getVariableMap();
        for (Map.Entry<VariableElement, VariableDeclaration> list : this.declarationMap.entrySet()) {
            VariableElement variableElement = list.getKey();
            ReferenceFinder referenceFinder = new ReferenceFinder(variableElement, this.referenceGraph);
            this.referenceGraph.addNode(variableElement);
            list.getValue().getInitializer().accept(referenceFinder);
        }
        while (!this.referenceGraph.isEmpty()) {
            Object object = this.referenceGraph.removeSink();
            while (object != null) {
                this.computeValueFor((VariableElement)object);
                object = this.referenceGraph.removeSink();
            }
            if (this.referenceGraph.isEmpty()) continue;
            List<VariableElement> list = this.referenceGraph.findCycle();
            if (list == null) {
                AnalysisEngine.getInstance().getLogger().logError("Exiting constant value computer with " + this.referenceGraph.getNodeCount() + " variables that are neither sinks nor in a cycle");
                return;
            }
            for (VariableElement variableElement : list) {
                this.generateCycleError(list, variableElement);
            }
            this.referenceGraph.removeAllNodes(list);
        }
    }

    private void computeValueFor(VariableElement variableElement) {
        VariableDeclaration variableDeclaration = this.declarationMap.get(variableElement);
        if (variableDeclaration == null) {
            return;
        }
        EvaluationResultImpl evaluationResultImpl = variableDeclaration.getInitializer().accept(new ConstantVisitor(this.typeProvider));
        ((VariableElementImpl)variableElement).setEvaluationResult(evaluationResultImpl);
        if (evaluationResultImpl instanceof ErrorResult) {
            ArrayList<AnalysisError> arrayList = new ArrayList<AnalysisError>();
            for (ErrorResult.ErrorData errorData : ((ErrorResult)evaluationResultImpl).getErrorData()) {
                AstNode astNode = errorData.getNode();
                Source source = variableElement.getAncestor(CompilationUnitElement.class).getSource();
                arrayList.add(new AnalysisError(source, astNode.getOffset(), astNode.getLength(), errorData.getErrorCode(), new Object[0]));
            }
        }
    }

    private void generateCycleError(List<VariableElement> list, VariableElement variableElement) {
    }
}

