/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.cache;

import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.internal.cache.CacheState;
import com.google.dart.engine.internal.cache.DataDescriptor;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.utilities.collection.BooleanArray;
import com.google.dart.engine.utilities.source.LineInfo;

public abstract class SourceEntryImpl
implements SourceEntry {
    private long modificationTime;
    private int flags;
    private AnalysisException exception;
    private CacheState contentState = CacheState.INVALID;
    private CharSequence content;
    private CacheState lineInfoState = CacheState.INVALID;
    private LineInfo lineInfo;
    private static final int EXPLICITLY_ADDED_FLAG = 0;

    public void fixExceptionState() {
        if (this.hasErrorState()) {
            if (this.exception == null) {
                this.exception = new AnalysisException("State set to ERROR without setting an exception");
            }
        } else {
            this.exception = null;
        }
    }

    @Override
    public AnalysisException getException() {
        return this.exception;
    }

    @Override
    public boolean getExplicitlyAdded() {
        return this.getFlag(0);
    }

    @Override
    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public CacheState getState(DataDescriptor<?> dataDescriptor) {
        if (dataDescriptor == CONTENT) {
            return this.contentState;
        }
        if (dataDescriptor == LINE_INFO) {
            return this.lineInfoState;
        }
        throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
    }

    @Override
    public <E> E getValue(DataDescriptor<E> dataDescriptor) {
        if (dataDescriptor == CONTENT) {
            return (E)this.content;
        }
        if (dataDescriptor == LINE_INFO) {
            return (E)this.lineInfo;
        }
        throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
    }

    public void invalidateAllInformation() {
        this.content = null;
        this.contentState = CacheState.INVALID;
        this.lineInfo = null;
        this.lineInfoState = CacheState.INVALID;
    }

    public void recordContentError() {
        this.content = null;
        this.contentState = CacheState.ERROR;
    }

    public void setException(AnalysisException analysisException) {
        this.exception = analysisException;
    }

    public void setExplicitlyAdded(boolean bl) {
        this.setFlag(0, bl);
    }

    public void setModificationTime(long l) {
        this.modificationTime = l;
    }

    public void setState(DataDescriptor<?> dataDescriptor, CacheState cacheState) {
        if (dataDescriptor == CONTENT) {
            this.content = this.updatedValue(cacheState, this.content, null);
            this.contentState = cacheState;
        } else if (dataDescriptor == LINE_INFO) {
            this.lineInfo = this.updatedValue(cacheState, this.lineInfo, null);
            this.lineInfoState = cacheState;
        } else {
            throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
        }
    }

    public <E> void setValue(DataDescriptor<E> dataDescriptor, E e) {
        if (dataDescriptor == CONTENT) {
            this.content = (CharSequence)e;
            this.contentState = CacheState.VALID;
        } else if (dataDescriptor == LINE_INFO) {
            this.lineInfo = (LineInfo)e;
            this.lineInfoState = CacheState.VALID;
        } else {
            throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.writeOn(stringBuilder);
        return stringBuilder.toString();
    }

    protected void clearFlags(int ... nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.flags = BooleanArray.set(this.flags, nArray[i], false);
        }
    }

    protected void copyFrom(SourceEntryImpl sourceEntryImpl) {
        this.modificationTime = sourceEntryImpl.modificationTime;
        this.flags = sourceEntryImpl.flags;
        this.exception = sourceEntryImpl.exception;
        this.contentState = sourceEntryImpl.contentState;
        this.content = sourceEntryImpl.content;
        this.lineInfoState = sourceEntryImpl.lineInfoState;
        this.lineInfo = sourceEntryImpl.lineInfo;
    }

    protected boolean getFlag(int n) {
        return BooleanArray.get(this.flags, n);
    }

    protected boolean hasErrorState() {
        return this.contentState == CacheState.ERROR || this.lineInfoState == CacheState.ERROR;
    }

    protected void setFlag(int n, boolean bl) {
        this.flags = BooleanArray.set(this.flags, n, bl);
    }

    protected <E> E updatedValue(CacheState cacheState, E e, E e2) {
        if (cacheState == CacheState.VALID) {
            throw new IllegalArgumentException("Use setValue() to set the state to VALID");
        }
        if (cacheState == CacheState.IN_PROCESS) {
            return e;
        }
        return e2;
    }

    protected void writeOn(StringBuilder stringBuilder) {
        stringBuilder.append("time = ");
        stringBuilder.append(this.modificationTime);
        stringBuilder.append("; content = ");
        stringBuilder.append((Object)this.contentState);
        stringBuilder.append("; lineInfo = ");
        stringBuilder.append((Object)this.lineInfoState);
    }
}

