/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.cache;

import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.internal.cache.CacheState;
import com.google.dart.engine.internal.cache.DataDescriptor;
import com.google.dart.engine.internal.cache.HtmlEntry;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.internal.cache.SourceEntryImpl;
import com.google.dart.engine.internal.element.angular.AngularApplication;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceKind;
import java.util.ArrayList;

public class HtmlEntryImpl
extends SourceEntryImpl
implements HtmlEntry {
    private CacheState parsedUnitState = CacheState.INVALID;
    private HtmlUnit parsedUnit;
    private CacheState resolvedUnitState = CacheState.INVALID;
    private HtmlUnit resolvedUnit;
    private CacheState parseErrorsState = CacheState.INVALID;
    private AnalysisError[] parseErrors = AnalysisError.NO_ERRORS;
    private CacheState resolutionErrorsState = CacheState.INVALID;
    private AnalysisError[] resolutionErrors = AnalysisError.NO_ERRORS;
    private CacheState referencedLibrariesState = CacheState.INVALID;
    private Source[] referencedLibraries = Source.EMPTY_ARRAY;
    private CacheState elementState = CacheState.INVALID;
    private HtmlElement element;
    private CacheState angularApplicationState = CacheState.VALID;
    private AngularApplication angularApplication;
    private CacheState angularEntryState = CacheState.INVALID;
    private AngularApplication angularEntry = null;
    private CacheState angularComponentState = CacheState.VALID;
    private AngularComponentElement angularComponent = null;
    private CacheState angularErrorsState = CacheState.INVALID;
    private AnalysisError[] angularErrors = AnalysisError.NO_ERRORS;
    private CacheState hintsState = CacheState.INVALID;
    private AnalysisError[] hints = AnalysisError.NO_ERRORS;

    public void flushAstStructures() {
        if (this.parsedUnitState == CacheState.VALID) {
            this.parsedUnitState = CacheState.FLUSHED;
            this.parsedUnit = null;
        }
        if (this.resolvedUnitState == CacheState.VALID) {
            this.resolvedUnitState = CacheState.FLUSHED;
            this.resolvedUnit = null;
        }
        if (this.angularEntryState == CacheState.VALID) {
            this.angularEntryState = CacheState.FLUSHED;
        }
        if (this.angularErrorsState == CacheState.VALID) {
            this.angularErrorsState = CacheState.FLUSHED;
        }
    }

    @Override
    public AnalysisError[] getAllErrors() {
        ArrayList<AnalysisError> arrayList = new ArrayList<AnalysisError>();
        if (this.parseErrors != null) {
            for (AnalysisError analysisError : this.parseErrors) {
                arrayList.add(analysisError);
            }
        }
        if (this.resolutionErrors != null) {
            for (AnalysisError analysisError : this.resolutionErrors) {
                arrayList.add(analysisError);
            }
        }
        if (this.angularErrors != null) {
            for (AnalysisError analysisError : this.angularErrors) {
                arrayList.add(analysisError);
            }
        }
        if (this.hints != null) {
            for (AnalysisError analysisError : this.hints) {
                arrayList.add(analysisError);
            }
        }
        if (arrayList.size() == 0) {
            return AnalysisError.NO_ERRORS;
        }
        return arrayList.toArray(new AnalysisError[arrayList.size()]);
    }

    @Override
    public HtmlUnit getAnyParsedUnit() {
        if (this.parsedUnitState == CacheState.VALID) {
            return this.parsedUnit;
        }
        if (this.resolvedUnitState == CacheState.VALID) {
            return this.resolvedUnit;
        }
        return null;
    }

    @Override
    public SourceKind getKind() {
        return SourceKind.HTML;
    }

    @Override
    public CacheState getState(DataDescriptor<?> dataDescriptor) {
        if (dataDescriptor == ANGULAR_APPLICATION) {
            return this.angularApplicationState;
        }
        if (dataDescriptor == ANGULAR_COMPONENT) {
            return this.angularComponentState;
        }
        if (dataDescriptor == ANGULAR_ENTRY) {
            return this.angularEntryState;
        }
        if (dataDescriptor == ANGULAR_ERRORS) {
            return this.angularErrorsState;
        }
        if (dataDescriptor == ELEMENT) {
            return this.elementState;
        }
        if (dataDescriptor == PARSE_ERRORS) {
            return this.parseErrorsState;
        }
        if (dataDescriptor == PARSED_UNIT) {
            return this.parsedUnitState;
        }
        if (dataDescriptor == RESOLVED_UNIT) {
            return this.resolvedUnitState;
        }
        if (dataDescriptor == REFERENCED_LIBRARIES) {
            return this.referencedLibrariesState;
        }
        if (dataDescriptor == RESOLUTION_ERRORS) {
            return this.resolutionErrorsState;
        }
        if (dataDescriptor == HINTS) {
            return this.hintsState;
        }
        return super.getState(dataDescriptor);
    }

    @Override
    public <E> E getValue(DataDescriptor<E> dataDescriptor) {
        if (dataDescriptor == ANGULAR_APPLICATION) {
            return (E)this.angularApplication;
        }
        if (dataDescriptor == ANGULAR_COMPONENT) {
            return (E)this.angularComponent;
        }
        if (dataDescriptor == ANGULAR_ENTRY) {
            return (E)this.angularEntry;
        }
        if (dataDescriptor == ANGULAR_ERRORS) {
            return (E)this.angularErrors;
        }
        if (dataDescriptor == ELEMENT) {
            return (E)this.element;
        }
        if (dataDescriptor == PARSE_ERRORS) {
            return (E)this.parseErrors;
        }
        if (dataDescriptor == PARSED_UNIT) {
            return (E)this.parsedUnit;
        }
        if (dataDescriptor == RESOLVED_UNIT) {
            return (E)this.resolvedUnit;
        }
        if (dataDescriptor == REFERENCED_LIBRARIES) {
            return (E)this.referencedLibraries;
        }
        if (dataDescriptor == RESOLUTION_ERRORS) {
            return (E)this.resolutionErrors;
        }
        if (dataDescriptor == HINTS) {
            return (E)this.hints;
        }
        return super.getValue(dataDescriptor);
    }

    @Override
    public HtmlEntryImpl getWritableCopy() {
        HtmlEntryImpl htmlEntryImpl = new HtmlEntryImpl();
        htmlEntryImpl.copyFrom(this);
        return htmlEntryImpl;
    }

    @Override
    public void invalidateAllInformation() {
        super.invalidateAllInformation();
        this.parseErrors = AnalysisError.NO_ERRORS;
        this.parseErrorsState = CacheState.INVALID;
        this.parsedUnit = null;
        this.parsedUnitState = CacheState.INVALID;
        this.resolvedUnit = null;
        this.resolvedUnitState = CacheState.INVALID;
        this.referencedLibraries = Source.EMPTY_ARRAY;
        this.referencedLibrariesState = CacheState.INVALID;
        this.invalidateAllResolutionInformation();
    }

    public void invalidateAllResolutionInformation() {
        this.angularEntry = null;
        this.angularEntryState = CacheState.INVALID;
        this.angularErrors = AnalysisError.NO_ERRORS;
        this.angularErrorsState = CacheState.INVALID;
        this.element = null;
        this.elementState = CacheState.INVALID;
        this.resolutionErrors = AnalysisError.NO_ERRORS;
        this.resolutionErrorsState = CacheState.INVALID;
        this.hints = AnalysisError.NO_ERRORS;
        this.hintsState = CacheState.INVALID;
    }

    @Override
    public void recordContentError() {
        super.recordContentError();
        this.recordParseError();
    }

    public void recordParseError() {
        this.setState(SourceEntry.LINE_INFO, CacheState.ERROR);
        this.setState(HtmlEntry.PARSE_ERRORS, CacheState.ERROR);
        this.setState(HtmlEntry.PARSED_UNIT, CacheState.ERROR);
        this.setState(HtmlEntry.REFERENCED_LIBRARIES, CacheState.ERROR);
        this.recordResolutionError();
    }

    public void recordResolutionError() {
        this.setState(HtmlEntry.ANGULAR_ERRORS, CacheState.ERROR);
        this.setState(HtmlEntry.RESOLVED_UNIT, CacheState.ERROR);
        this.setState(HtmlEntry.ELEMENT, CacheState.ERROR);
        this.setState(HtmlEntry.RESOLUTION_ERRORS, CacheState.ERROR);
        this.setState(HtmlEntry.HINTS, CacheState.ERROR);
    }

    @Override
    public void setState(DataDescriptor<?> dataDescriptor, CacheState cacheState) {
        if (dataDescriptor == ANGULAR_APPLICATION) {
            this.angularApplication = this.updatedValue(cacheState, this.angularApplication, null);
            this.angularApplicationState = cacheState;
        } else if (dataDescriptor == ANGULAR_COMPONENT) {
            this.angularComponent = this.updatedValue(cacheState, this.angularComponent, null);
            this.angularComponentState = cacheState;
        } else if (dataDescriptor == ANGULAR_ENTRY) {
            this.angularEntry = this.updatedValue(cacheState, this.angularEntry, null);
            this.angularEntryState = cacheState;
        } else if (dataDescriptor == ANGULAR_ERRORS) {
            this.angularErrors = this.updatedValue(cacheState, this.angularErrors, null);
            this.angularErrorsState = cacheState;
        } else if (dataDescriptor == ELEMENT) {
            this.element = this.updatedValue(cacheState, this.element, null);
            this.elementState = cacheState;
        } else if (dataDescriptor == PARSE_ERRORS) {
            this.parseErrors = this.updatedValue(cacheState, this.parseErrors, null);
            this.parseErrorsState = cacheState;
        } else if (dataDescriptor == PARSED_UNIT) {
            this.parsedUnit = this.updatedValue(cacheState, this.parsedUnit, null);
            this.parsedUnitState = cacheState;
        } else if (dataDescriptor == RESOLVED_UNIT) {
            this.resolvedUnit = this.updatedValue(cacheState, this.resolvedUnit, null);
            this.resolvedUnitState = cacheState;
        } else if (dataDescriptor == REFERENCED_LIBRARIES) {
            this.referencedLibraries = this.updatedValue(cacheState, this.referencedLibraries, Source.EMPTY_ARRAY);
            this.referencedLibrariesState = cacheState;
        } else if (dataDescriptor == RESOLUTION_ERRORS) {
            this.resolutionErrors = this.updatedValue(cacheState, this.resolutionErrors, AnalysisError.NO_ERRORS);
            this.resolutionErrorsState = cacheState;
        } else if (dataDescriptor == HINTS) {
            this.hints = this.updatedValue(cacheState, this.hints, AnalysisError.NO_ERRORS);
            this.hintsState = cacheState;
        } else {
            super.setState(dataDescriptor, cacheState);
        }
    }

    @Override
    public <E> void setValue(DataDescriptor<E> dataDescriptor, E e) {
        if (dataDescriptor == ANGULAR_APPLICATION) {
            this.angularApplication = (AngularApplication)e;
            this.angularApplicationState = CacheState.VALID;
        } else if (dataDescriptor == ANGULAR_COMPONENT) {
            this.angularComponent = (AngularComponentElement)e;
            this.angularComponentState = CacheState.VALID;
        } else if (dataDescriptor == ANGULAR_ENTRY) {
            this.angularEntry = (AngularApplication)e;
            this.angularEntryState = CacheState.VALID;
        } else if (dataDescriptor == ANGULAR_ERRORS) {
            this.angularErrors = (AnalysisError[])e;
            this.angularErrorsState = CacheState.VALID;
        } else if (dataDescriptor == ELEMENT) {
            this.element = (HtmlElement)e;
            this.elementState = CacheState.VALID;
        } else if (dataDescriptor == PARSE_ERRORS) {
            this.parseErrors = (AnalysisError[])e;
            this.parseErrorsState = CacheState.VALID;
        } else if (dataDescriptor == PARSED_UNIT) {
            this.parsedUnit = (HtmlUnit)e;
            this.parsedUnitState = CacheState.VALID;
        } else if (dataDescriptor == RESOLVED_UNIT) {
            this.resolvedUnit = (HtmlUnit)e;
            this.resolvedUnitState = CacheState.VALID;
        } else if (dataDescriptor == REFERENCED_LIBRARIES) {
            this.referencedLibraries = e == null ? Source.EMPTY_ARRAY : (Source[])e;
            this.referencedLibrariesState = CacheState.VALID;
        } else if (dataDescriptor == RESOLUTION_ERRORS) {
            this.resolutionErrors = (AnalysisError[])e;
            this.resolutionErrorsState = CacheState.VALID;
        } else if (dataDescriptor == HINTS) {
            this.hints = (AnalysisError[])e;
            this.hintsState = CacheState.VALID;
        } else {
            super.setValue(dataDescriptor, e);
        }
    }

    @Override
    protected void copyFrom(SourceEntryImpl sourceEntryImpl) {
        super.copyFrom(sourceEntryImpl);
        HtmlEntryImpl htmlEntryImpl = (HtmlEntryImpl)sourceEntryImpl;
        this.angularApplicationState = htmlEntryImpl.angularApplicationState;
        this.angularApplication = htmlEntryImpl.angularApplication;
        this.angularComponentState = htmlEntryImpl.angularComponentState;
        this.angularComponent = htmlEntryImpl.angularComponent;
        this.angularEntryState = htmlEntryImpl.angularEntryState;
        this.angularEntry = htmlEntryImpl.angularEntry;
        this.angularErrorsState = htmlEntryImpl.angularErrorsState;
        this.angularErrors = htmlEntryImpl.angularErrors;
        this.parseErrorsState = htmlEntryImpl.parseErrorsState;
        this.parseErrors = htmlEntryImpl.parseErrors;
        this.parsedUnitState = htmlEntryImpl.parsedUnitState;
        this.parsedUnit = htmlEntryImpl.parsedUnit;
        this.resolvedUnitState = htmlEntryImpl.resolvedUnitState;
        this.resolvedUnit = htmlEntryImpl.resolvedUnit;
        this.referencedLibrariesState = htmlEntryImpl.referencedLibrariesState;
        this.referencedLibraries = htmlEntryImpl.referencedLibraries;
        this.resolutionErrors = htmlEntryImpl.resolutionErrors;
        this.resolutionErrorsState = htmlEntryImpl.resolutionErrorsState;
        this.elementState = htmlEntryImpl.elementState;
        this.element = htmlEntryImpl.element;
        this.hints = htmlEntryImpl.hints;
        this.hintsState = htmlEntryImpl.hintsState;
    }

    @Override
    protected boolean hasErrorState() {
        return super.hasErrorState() || this.parsedUnitState == CacheState.ERROR || this.resolvedUnitState == CacheState.ERROR || this.parseErrorsState == CacheState.ERROR || this.resolutionErrorsState == CacheState.ERROR || this.referencedLibrariesState == CacheState.ERROR || this.elementState == CacheState.ERROR || this.angularErrorsState == CacheState.ERROR || this.hintsState == CacheState.ERROR;
    }

    @Override
    protected void writeOn(StringBuilder stringBuilder) {
        stringBuilder.append("Html: ");
        super.writeOn(stringBuilder);
        stringBuilder.append("; parseErrors = ");
        stringBuilder.append((Object)this.parseErrorsState);
        stringBuilder.append("; parsedUnit = ");
        stringBuilder.append((Object)this.parsedUnitState);
        stringBuilder.append("; resolvedUnit = ");
        stringBuilder.append((Object)this.resolvedUnitState);
        stringBuilder.append("; resolutionErrors = ");
        stringBuilder.append((Object)this.resolutionErrorsState);
        stringBuilder.append("; referencedLibraries = ");
        stringBuilder.append((Object)this.referencedLibrariesState);
        stringBuilder.append("; element = ");
        stringBuilder.append((Object)this.elementState);
        stringBuilder.append("; angularApplication = ");
        stringBuilder.append((Object)this.angularApplicationState);
        stringBuilder.append("; angularComponent = ");
        stringBuilder.append((Object)this.angularComponentState);
        stringBuilder.append("; angularEntry = ");
        stringBuilder.append((Object)this.angularEntryState);
        stringBuilder.append("; angularErrors = ");
        stringBuilder.append((Object)this.angularErrorsState);
    }
}

