/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.cache;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.internal.cache.CacheState;
import com.google.dart.engine.internal.cache.DartEntry;
import com.google.dart.engine.internal.cache.DataDescriptor;
import com.google.dart.engine.internal.cache.SourceEntryImpl;
import com.google.dart.engine.internal.scope.Namespace;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.utilities.ast.AstCloner;
import com.google.dart.engine.utilities.collection.ListUtilities;
import java.util.ArrayList;
import java.util.List;

public class DartEntryImpl
extends SourceEntryImpl
implements DartEntry {
    private CacheState tokenStreamState = CacheState.INVALID;
    private Token tokenStream;
    private CacheState scanErrorsState = CacheState.INVALID;
    private AnalysisError[] scanErrors = AnalysisError.NO_ERRORS;
    private CacheState sourceKindState = CacheState.INVALID;
    private SourceKind sourceKind = SourceKind.UNKNOWN;
    private CacheState parsedUnitState = CacheState.INVALID;
    private boolean parsedUnitAccessed = false;
    private CompilationUnit parsedUnit;
    private CacheState parseErrorsState = CacheState.INVALID;
    private AnalysisError[] parseErrors = AnalysisError.NO_ERRORS;
    private CacheState importedLibrariesState = CacheState.INVALID;
    private Source[] importedLibraries = Source.EMPTY_ARRAY;
    private CacheState exportedLibrariesState = CacheState.INVALID;
    private Source[] exportedLibraries = Source.EMPTY_ARRAY;
    private CacheState includedPartsState = CacheState.INVALID;
    private Source[] includedParts = Source.EMPTY_ARRAY;
    private ArrayList<Source> containingLibraries = new ArrayList();
    private ResolutionState resolutionState = new ResolutionState();
    private CacheState elementState = CacheState.INVALID;
    private LibraryElement element;
    private CacheState publicNamespaceState = CacheState.INVALID;
    private Namespace publicNamespace;
    private CacheState clientServerState = CacheState.INVALID;
    private CacheState launchableState = CacheState.INVALID;
    private AnalysisError[] angularErrors = AnalysisError.NO_ERRORS;
    private static final int LAUNCHABLE_INDEX = 1;
    private static final int CLIENT_CODE_INDEX = 2;

    public void addContainingLibrary(Source source) {
        this.containingLibraries.add(source);
    }

    public void flushAstStructures() {
        if (this.tokenStreamState == CacheState.VALID) {
            this.tokenStreamState = CacheState.FLUSHED;
            this.tokenStream = null;
        }
        if (this.parsedUnitState == CacheState.VALID) {
            this.parsedUnitState = CacheState.FLUSHED;
            this.parsedUnitAccessed = false;
            this.parsedUnit = null;
        }
        this.resolutionState.flushAstStructures();
    }

    @Override
    public AnalysisError[] getAllErrors() {
        ArrayList arrayList = new ArrayList();
        ListUtilities.addAll(arrayList, this.scanErrors);
        ListUtilities.addAll(arrayList, this.parseErrors);
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            ListUtilities.addAll(arrayList, resolutionState.resolutionErrors);
            ListUtilities.addAll(arrayList, resolutionState.verificationErrors);
            ListUtilities.addAll(arrayList, resolutionState.hints);
            resolutionState = resolutionState.nextState;
        }
        ListUtilities.addAll(arrayList, this.angularErrors);
        if (arrayList.size() == 0) {
            return AnalysisError.NO_ERRORS;
        }
        return arrayList.toArray(new AnalysisError[arrayList.size()]);
    }

    @Override
    public CompilationUnit getAnyParsedCompilationUnit() {
        if (this.parsedUnitState == CacheState.VALID) {
            this.parsedUnitAccessed = true;
            return this.parsedUnit;
        }
        return this.getAnyResolvedCompilationUnit();
    }

    @Override
    public CompilationUnit getAnyResolvedCompilationUnit() {
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            if (resolutionState.resolvedUnitState == CacheState.VALID) {
                return resolutionState.resolvedUnit;
            }
            resolutionState = resolutionState.nextState;
        }
        return null;
    }

    public List<Source> getContainingLibraries() {
        return this.containingLibraries;
    }

    @Override
    public SourceKind getKind() {
        return this.sourceKind;
    }

    public Source[] getLibrariesContaining() {
        ResolutionState resolutionState = this.resolutionState;
        ArrayList<Source> arrayList = new ArrayList<Source>();
        while (resolutionState != null) {
            if (resolutionState.librarySource != null) {
                arrayList.add(resolutionState.librarySource);
            }
            resolutionState = resolutionState.nextState;
        }
        return arrayList.toArray(new Source[arrayList.size()]);
    }

    public CompilationUnit getResolvableCompilationUnit() {
        if (this.parsedUnitState == CacheState.VALID) {
            if (this.parsedUnitAccessed) {
                return (CompilationUnit)this.parsedUnit.accept(new AstCloner());
            }
            CompilationUnit compilationUnit = this.parsedUnit;
            this.parsedUnitState = CacheState.FLUSHED;
            this.parsedUnitAccessed = false;
            this.parsedUnit = null;
            return compilationUnit;
        }
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            if (resolutionState.resolvedUnitState == CacheState.VALID) {
                return (CompilationUnit)resolutionState.resolvedUnit.accept(new AstCloner());
            }
            resolutionState = resolutionState.nextState;
        }
        return null;
    }

    @Override
    public CacheState getState(DataDescriptor<?> dataDescriptor) {
        if (dataDescriptor == ELEMENT) {
            return this.elementState;
        }
        if (dataDescriptor == EXPORTED_LIBRARIES) {
            return this.exportedLibrariesState;
        }
        if (dataDescriptor == IMPORTED_LIBRARIES) {
            return this.importedLibrariesState;
        }
        if (dataDescriptor == INCLUDED_PARTS) {
            return this.includedPartsState;
        }
        if (dataDescriptor == IS_CLIENT) {
            return this.clientServerState;
        }
        if (dataDescriptor == IS_LAUNCHABLE) {
            return this.launchableState;
        }
        if (dataDescriptor == PARSE_ERRORS) {
            return this.parseErrorsState;
        }
        if (dataDescriptor == PARSED_UNIT) {
            return this.parsedUnitState;
        }
        if (dataDescriptor == PUBLIC_NAMESPACE) {
            return this.publicNamespaceState;
        }
        if (dataDescriptor == SCAN_ERRORS) {
            return this.scanErrorsState;
        }
        if (dataDescriptor == SOURCE_KIND) {
            return this.sourceKindState;
        }
        if (dataDescriptor == TOKEN_STREAM) {
            return this.tokenStreamState;
        }
        return super.getState(dataDescriptor);
    }

    @Override
    public CacheState getStateInLibrary(DataDescriptor<?> dataDescriptor, Source source) {
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            if (((Object)source).equals(resolutionState.librarySource)) {
                if (dataDescriptor == RESOLUTION_ERRORS) {
                    return resolutionState.resolutionErrorsState;
                }
                if (dataDescriptor == RESOLVED_UNIT) {
                    return resolutionState.resolvedUnitState;
                }
                if (dataDescriptor == VERIFICATION_ERRORS) {
                    return resolutionState.verificationErrorsState;
                }
                if (dataDescriptor == HINTS) {
                    return resolutionState.hintsState;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
            }
            resolutionState = resolutionState.nextState;
        }
        if (dataDescriptor == RESOLUTION_ERRORS || dataDescriptor == RESOLVED_UNIT || dataDescriptor == VERIFICATION_ERRORS || dataDescriptor == HINTS) {
            return CacheState.INVALID;
        }
        throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
    }

    @Override
    public <E> E getValue(DataDescriptor<E> dataDescriptor) {
        if (dataDescriptor == ANGULAR_ERRORS) {
            return (E)this.angularErrors;
        }
        if (dataDescriptor == CONTAINING_LIBRARIES) {
            return (E)this.containingLibraries.toArray(new Source[this.containingLibraries.size()]);
        }
        if (dataDescriptor == ELEMENT) {
            return (E)this.element;
        }
        if (dataDescriptor == EXPORTED_LIBRARIES) {
            return (E)this.exportedLibraries;
        }
        if (dataDescriptor == IMPORTED_LIBRARIES) {
            return (E)this.importedLibraries;
        }
        if (dataDescriptor == INCLUDED_PARTS) {
            return (E)this.includedParts;
        }
        if (dataDescriptor == IS_CLIENT) {
            return (E)Boolean.valueOf(this.getFlag(2));
        }
        if (dataDescriptor == IS_LAUNCHABLE) {
            return (E)Boolean.valueOf(this.getFlag(1));
        }
        if (dataDescriptor == PARSE_ERRORS) {
            return (E)this.parseErrors;
        }
        if (dataDescriptor == PARSED_UNIT) {
            this.parsedUnitAccessed = true;
            return (E)this.parsedUnit;
        }
        if (dataDescriptor == PUBLIC_NAMESPACE) {
            return (E)this.publicNamespace;
        }
        if (dataDescriptor == SCAN_ERRORS) {
            return (E)this.scanErrors;
        }
        if (dataDescriptor == SOURCE_KIND) {
            return (E)((Object)this.sourceKind);
        }
        if (dataDescriptor == TOKEN_STREAM) {
            return (E)this.tokenStream;
        }
        return super.getValue(dataDescriptor);
    }

    @Override
    public <E> E getValueInLibrary(DataDescriptor<E> dataDescriptor, Source source) {
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            if (((Object)source).equals(resolutionState.librarySource)) {
                if (dataDescriptor == RESOLUTION_ERRORS) {
                    return (E)resolutionState.resolutionErrors;
                }
                if (dataDescriptor == RESOLVED_UNIT) {
                    return (E)resolutionState.resolvedUnit;
                }
                if (dataDescriptor == VERIFICATION_ERRORS) {
                    return (E)resolutionState.verificationErrors;
                }
                if (dataDescriptor == HINTS) {
                    return (E)resolutionState.hints;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
            }
            resolutionState = resolutionState.nextState;
        }
        if (dataDescriptor == RESOLUTION_ERRORS || dataDescriptor == VERIFICATION_ERRORS || dataDescriptor == HINTS) {
            return (E)AnalysisError.NO_ERRORS;
        }
        if (dataDescriptor == RESOLVED_UNIT) {
            return null;
        }
        throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
    }

    @Override
    public DartEntryImpl getWritableCopy() {
        DartEntryImpl dartEntryImpl = new DartEntryImpl();
        dartEntryImpl.copyFrom(this);
        return dartEntryImpl;
    }

    @Override
    public boolean hasInvalidData(DataDescriptor<?> dataDescriptor) {
        if (dataDescriptor == ELEMENT) {
            return this.elementState == CacheState.INVALID;
        }
        if (dataDescriptor == EXPORTED_LIBRARIES) {
            return this.exportedLibrariesState == CacheState.INVALID;
        }
        if (dataDescriptor == IMPORTED_LIBRARIES) {
            return this.importedLibrariesState == CacheState.INVALID;
        }
        if (dataDescriptor == INCLUDED_PARTS) {
            return this.includedPartsState == CacheState.INVALID;
        }
        if (dataDescriptor == IS_CLIENT) {
            return this.clientServerState == CacheState.INVALID;
        }
        if (dataDescriptor == IS_LAUNCHABLE) {
            return this.launchableState == CacheState.INVALID;
        }
        if (dataDescriptor == PARSE_ERRORS) {
            return this.parseErrorsState == CacheState.INVALID;
        }
        if (dataDescriptor == PARSED_UNIT) {
            return this.parsedUnitState == CacheState.INVALID;
        }
        if (dataDescriptor == PUBLIC_NAMESPACE) {
            return this.publicNamespaceState == CacheState.INVALID;
        }
        if (dataDescriptor == SCAN_ERRORS) {
            return this.scanErrorsState == CacheState.INVALID;
        }
        if (dataDescriptor == SOURCE_KIND) {
            return this.sourceKindState == CacheState.INVALID;
        }
        if (dataDescriptor == TOKEN_STREAM) {
            return this.tokenStreamState == CacheState.INVALID;
        }
        if (dataDescriptor == RESOLUTION_ERRORS || dataDescriptor == RESOLVED_UNIT || dataDescriptor == VERIFICATION_ERRORS || dataDescriptor == HINTS) {
            ResolutionState resolutionState = this.resolutionState;
            while (resolutionState != null) {
                if (dataDescriptor == RESOLUTION_ERRORS) {
                    return resolutionState.resolutionErrorsState == CacheState.INVALID;
                }
                if (dataDescriptor == RESOLVED_UNIT) {
                    return resolutionState.resolvedUnitState == CacheState.INVALID;
                }
                if (dataDescriptor == VERIFICATION_ERRORS) {
                    return resolutionState.verificationErrorsState == CacheState.INVALID;
                }
                if (dataDescriptor != HINTS) continue;
                return resolutionState.hintsState == CacheState.INVALID;
            }
            return false;
        }
        return super.getState(dataDescriptor) == CacheState.INVALID;
    }

    @Override
    public boolean hasResolvableCompilationUnit() {
        if (this.parsedUnitState == CacheState.VALID) {
            return true;
        }
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            if (resolutionState.resolvedUnitState == CacheState.VALID) {
                return true;
            }
            resolutionState = resolutionState.nextState;
        }
        return false;
    }

    @Override
    public void invalidateAllInformation() {
        super.invalidateAllInformation();
        this.scanErrors = AnalysisError.NO_ERRORS;
        this.scanErrorsState = CacheState.INVALID;
        this.tokenStream = null;
        this.tokenStreamState = CacheState.INVALID;
        this.sourceKind = SourceKind.UNKNOWN;
        this.sourceKindState = CacheState.INVALID;
        this.parseErrors = AnalysisError.NO_ERRORS;
        this.parseErrorsState = CacheState.INVALID;
        this.parsedUnit = null;
        this.parsedUnitAccessed = false;
        this.parsedUnitState = CacheState.INVALID;
        this.importedLibraries = Source.EMPTY_ARRAY;
        this.importedLibrariesState = CacheState.INVALID;
        this.exportedLibraries = Source.EMPTY_ARRAY;
        this.exportedLibrariesState = CacheState.INVALID;
        this.includedParts = Source.EMPTY_ARRAY;
        this.includedPartsState = CacheState.INVALID;
        this.discardCachedResolutionInformation();
    }

    public void invalidateAllResolutionInformation() {
        if (this.parsedUnitState == CacheState.FLUSHED) {
            ResolutionState resolutionState = this.resolutionState;
            while (resolutionState != null) {
                if (resolutionState.resolvedUnitState == CacheState.VALID) {
                    this.parsedUnit = resolutionState.resolvedUnit;
                    this.parsedUnitAccessed = true;
                    this.parsedUnitState = CacheState.VALID;
                    break;
                }
                resolutionState = resolutionState.nextState;
            }
        }
        this.discardCachedResolutionInformation();
    }

    @Override
    public boolean isRefactoringSafe() {
        ResolutionState resolutionState = this.resolutionState;
        while (resolutionState != null) {
            CacheState cacheState = resolutionState.resolvedUnitState;
            if (cacheState != CacheState.VALID && cacheState != CacheState.FLUSHED) {
                return false;
            }
            resolutionState = resolutionState.nextState;
        }
        return true;
    }

    @Override
    public void recordContentError() {
        super.recordContentError();
        this.recordScanError();
    }

    public void recordParseError() {
        this.sourceKind = SourceKind.UNKNOWN;
        this.sourceKindState = CacheState.ERROR;
        this.parseErrors = AnalysisError.NO_ERRORS;
        this.parseErrorsState = CacheState.ERROR;
        this.parsedUnit = null;
        this.parsedUnitAccessed = false;
        this.parsedUnitState = CacheState.ERROR;
        this.exportedLibraries = Source.EMPTY_ARRAY;
        this.exportedLibrariesState = CacheState.ERROR;
        this.importedLibraries = Source.EMPTY_ARRAY;
        this.importedLibrariesState = CacheState.ERROR;
        this.includedParts = Source.EMPTY_ARRAY;
        this.includedPartsState = CacheState.ERROR;
        this.recordResolutionError();
    }

    public void recordParseInProcess() {
        if (this.sourceKindState != CacheState.VALID) {
            this.sourceKindState = CacheState.IN_PROCESS;
        }
        if (this.parseErrorsState != CacheState.VALID) {
            this.parseErrorsState = CacheState.IN_PROCESS;
        }
        if (this.parsedUnitState != CacheState.VALID) {
            this.parsedUnitState = CacheState.IN_PROCESS;
        }
        if (this.exportedLibrariesState != CacheState.VALID) {
            this.exportedLibrariesState = CacheState.IN_PROCESS;
        }
        if (this.importedLibrariesState != CacheState.VALID) {
            this.importedLibrariesState = CacheState.IN_PROCESS;
        }
        if (this.includedPartsState != CacheState.VALID) {
            this.includedPartsState = CacheState.IN_PROCESS;
        }
    }

    public void recordParseNotInProcess() {
        if (this.getState(LINE_INFO) == CacheState.IN_PROCESS) {
            this.setState(LINE_INFO, CacheState.INVALID);
        }
        if (this.sourceKindState == CacheState.IN_PROCESS) {
            this.sourceKindState = CacheState.INVALID;
        }
        if (this.parseErrorsState == CacheState.IN_PROCESS) {
            this.parseErrorsState = CacheState.INVALID;
        }
        if (this.parsedUnitState == CacheState.IN_PROCESS) {
            this.parsedUnitState = CacheState.INVALID;
        }
        if (this.exportedLibrariesState == CacheState.IN_PROCESS) {
            this.exportedLibrariesState = CacheState.INVALID;
        }
        if (this.importedLibrariesState == CacheState.IN_PROCESS) {
            this.importedLibrariesState = CacheState.INVALID;
        }
        if (this.includedPartsState == CacheState.IN_PROCESS) {
            this.includedPartsState = CacheState.INVALID;
        }
    }

    public void recordResolutionError() {
        this.element = null;
        this.elementState = CacheState.ERROR;
        this.clearFlags(1, 2);
        this.clientServerState = CacheState.ERROR;
        this.launchableState = CacheState.ERROR;
        this.publicNamespace = null;
        this.publicNamespaceState = CacheState.ERROR;
        this.resolutionState.recordResolutionError();
    }

    public void recordResolutionNotInProcess() {
        if (this.elementState == CacheState.IN_PROCESS) {
            this.elementState = CacheState.INVALID;
        }
        if (this.clientServerState == CacheState.IN_PROCESS) {
            this.clientServerState = CacheState.INVALID;
        }
        if (this.launchableState == CacheState.IN_PROCESS) {
            this.launchableState = CacheState.INVALID;
        }
        if (this.publicNamespaceState == CacheState.IN_PROCESS) {
            this.publicNamespaceState = CacheState.INVALID;
        }
        this.resolutionState.recordResolutionNotInProcess();
    }

    public void recordScanError() {
        this.setState(LINE_INFO, CacheState.ERROR);
        this.scanErrors = AnalysisError.NO_ERRORS;
        this.scanErrorsState = CacheState.ERROR;
        this.tokenStream = null;
        this.tokenStreamState = CacheState.ERROR;
        this.recordParseError();
    }

    public void recordScanInProcess() {
        if (this.getState(LINE_INFO) != CacheState.VALID) {
            this.setState(LINE_INFO, CacheState.IN_PROCESS);
        }
        if (this.scanErrorsState != CacheState.VALID) {
            this.scanErrorsState = CacheState.IN_PROCESS;
        }
        if (this.tokenStreamState != CacheState.VALID) {
            this.tokenStreamState = CacheState.IN_PROCESS;
        }
    }

    public void recordScanNotInProcess() {
        if (this.getState(LINE_INFO) == CacheState.IN_PROCESS) {
            this.setState(LINE_INFO, CacheState.INVALID);
        }
        if (this.scanErrorsState == CacheState.IN_PROCESS) {
            this.scanErrorsState = CacheState.INVALID;
        }
        if (this.tokenStreamState == CacheState.IN_PROCESS) {
            this.tokenStreamState = CacheState.INVALID;
        }
    }

    public void removeContainingLibrary(Source source) {
        this.containingLibraries.remove(source);
    }

    public void removeResolution(Source source) {
        if (source != null) {
            if (((Object)source).equals(this.resolutionState.librarySource)) {
                if (this.resolutionState.nextState == null) {
                    this.resolutionState.invalidateAllResolutionInformation();
                } else {
                    this.resolutionState = this.resolutionState.nextState;
                }
            } else {
                ResolutionState resolutionState = this.resolutionState;
                ResolutionState resolutionState2 = this.resolutionState.nextState;
                while (resolutionState2 != null) {
                    if (((Object)source).equals(resolutionState2.librarySource)) {
                        resolutionState.nextState = resolutionState2.nextState;
                        break;
                    }
                    resolutionState = resolutionState2;
                    resolutionState2 = resolutionState2.nextState;
                }
            }
        }
    }

    public void setContainingLibrary(Source source) {
        this.containingLibraries.clear();
        this.containingLibraries.add(source);
    }

    @Override
    public void setState(DataDescriptor<?> dataDescriptor, CacheState cacheState) {
        if (dataDescriptor == ELEMENT) {
            this.element = this.updatedValue(cacheState, this.element, null);
            this.elementState = cacheState;
        } else if (dataDescriptor == EXPORTED_LIBRARIES) {
            this.exportedLibraries = this.updatedValue(cacheState, this.exportedLibraries, Source.EMPTY_ARRAY);
            this.exportedLibrariesState = cacheState;
        } else if (dataDescriptor == IMPORTED_LIBRARIES) {
            this.importedLibraries = this.updatedValue(cacheState, this.importedLibraries, Source.EMPTY_ARRAY);
            this.importedLibrariesState = cacheState;
        } else if (dataDescriptor == INCLUDED_PARTS) {
            this.includedParts = this.updatedValue(cacheState, this.includedParts, Source.EMPTY_ARRAY);
            this.includedPartsState = cacheState;
        } else if (dataDescriptor == IS_CLIENT) {
            this.updateValueOfFlag(2, cacheState);
            this.clientServerState = cacheState;
        } else if (dataDescriptor == IS_LAUNCHABLE) {
            this.updateValueOfFlag(1, cacheState);
            this.launchableState = cacheState;
        } else if (dataDescriptor == PARSE_ERRORS) {
            this.parseErrors = this.updatedValue(cacheState, this.parseErrors, AnalysisError.NO_ERRORS);
            this.parseErrorsState = cacheState;
        } else if (dataDescriptor == PARSED_UNIT) {
            CompilationUnit compilationUnit = this.updatedValue(cacheState, this.parsedUnit, null);
            if (compilationUnit != this.parsedUnit) {
                this.parsedUnitAccessed = false;
            }
            this.parsedUnit = compilationUnit;
            this.parsedUnitState = cacheState;
        } else if (dataDescriptor == PUBLIC_NAMESPACE) {
            this.publicNamespace = this.updatedValue(cacheState, this.publicNamespace, null);
            this.publicNamespaceState = cacheState;
        } else if (dataDescriptor == SCAN_ERRORS) {
            this.scanErrors = this.updatedValue(cacheState, this.scanErrors, AnalysisError.NO_ERRORS);
            this.scanErrorsState = cacheState;
        } else if (dataDescriptor == SOURCE_KIND) {
            this.sourceKind = this.updatedValue(cacheState, this.sourceKind, SourceKind.UNKNOWN);
            this.sourceKindState = cacheState;
        } else if (dataDescriptor == TOKEN_STREAM) {
            this.tokenStream = this.updatedValue(cacheState, this.tokenStream, null);
            this.tokenStreamState = cacheState;
        } else {
            super.setState(dataDescriptor, cacheState);
        }
    }

    public void setStateInLibrary(DataDescriptor<?> dataDescriptor, Source source, CacheState cacheState) {
        ResolutionState resolutionState = this.getOrCreateResolutionState(source);
        if (dataDescriptor == RESOLUTION_ERRORS) {
            ResolutionState.access$002(resolutionState, this.updatedValue(cacheState, resolutionState.resolutionErrors, AnalysisError.NO_ERRORS));
            resolutionState.resolutionErrorsState = cacheState;
        } else if (dataDescriptor == RESOLVED_UNIT) {
            resolutionState.resolvedUnit = this.updatedValue(cacheState, resolutionState.resolvedUnit, null);
            resolutionState.resolvedUnitState = cacheState;
        } else if (dataDescriptor == VERIFICATION_ERRORS) {
            ResolutionState.access$102(resolutionState, this.updatedValue(cacheState, resolutionState.verificationErrors, AnalysisError.NO_ERRORS));
            resolutionState.verificationErrorsState = cacheState;
        } else if (dataDescriptor == HINTS) {
            ResolutionState.access$202(resolutionState, this.updatedValue(cacheState, resolutionState.hints, AnalysisError.NO_ERRORS));
            resolutionState.hintsState = cacheState;
        } else {
            throw new IllegalArgumentException("Invalid descriptor: " + dataDescriptor);
        }
    }

    @Override
    public <E> void setValue(DataDescriptor<E> dataDescriptor, E e) {
        if (dataDescriptor == ANGULAR_ERRORS) {
            this.angularErrors = e == null ? AnalysisError.NO_ERRORS : (AnalysisError[])e;
        } else if (dataDescriptor == ELEMENT) {
            this.element = (LibraryElement)e;
            this.elementState = CacheState.VALID;
        } else if (dataDescriptor == EXPORTED_LIBRARIES) {
            this.exportedLibraries = e == null ? Source.EMPTY_ARRAY : (Source[])e;
            this.exportedLibrariesState = CacheState.VALID;
        } else if (dataDescriptor == IMPORTED_LIBRARIES) {
            this.importedLibraries = e == null ? Source.EMPTY_ARRAY : (Source[])e;
            this.importedLibrariesState = CacheState.VALID;
        } else if (dataDescriptor == INCLUDED_PARTS) {
            this.includedParts = e == null ? Source.EMPTY_ARRAY : (Source[])e;
            this.includedPartsState = CacheState.VALID;
        } else if (dataDescriptor == IS_CLIENT) {
            this.setFlag(2, (Boolean)e);
            this.clientServerState = CacheState.VALID;
        } else if (dataDescriptor == IS_LAUNCHABLE) {
            this.setFlag(1, (Boolean)e);
            this.launchableState = CacheState.VALID;
        } else if (dataDescriptor == PARSE_ERRORS) {
            this.parseErrors = e == null ? AnalysisError.NO_ERRORS : (AnalysisError[])e;
            this.parseErrorsState = CacheState.VALID;
        } else if (dataDescriptor == PARSED_UNIT) {
            this.parsedUnit = (CompilationUnit)e;
            this.parsedUnitAccessed = false;
            this.parsedUnitState = CacheState.VALID;
        } else if (dataDescriptor == PUBLIC_NAMESPACE) {
            this.publicNamespace = (Namespace)e;
            this.publicNamespaceState = CacheState.VALID;
        } else if (dataDescriptor == SCAN_ERRORS) {
            this.scanErrors = e == null ? AnalysisError.NO_ERRORS : (AnalysisError[])e;
            this.scanErrorsState = CacheState.VALID;
        } else if (dataDescriptor == SOURCE_KIND) {
            this.sourceKind = (SourceKind)((Object)e);
            this.sourceKindState = CacheState.VALID;
        } else if (dataDescriptor == TOKEN_STREAM) {
            this.tokenStream = (Token)e;
            this.tokenStreamState = CacheState.VALID;
        } else {
            super.setValue(dataDescriptor, e);
        }
    }

    public <E> void setValueInLibrary(DataDescriptor<E> dataDescriptor, Source source, E e) {
        ResolutionState resolutionState = this.getOrCreateResolutionState(source);
        if (dataDescriptor == RESOLUTION_ERRORS) {
            ResolutionState.access$002(resolutionState, e == null ? AnalysisError.NO_ERRORS : (AnalysisError[])e);
            resolutionState.resolutionErrorsState = CacheState.VALID;
        } else if (dataDescriptor == RESOLVED_UNIT) {
            resolutionState.resolvedUnit = (CompilationUnit)e;
            resolutionState.resolvedUnitState = CacheState.VALID;
        } else if (dataDescriptor == VERIFICATION_ERRORS) {
            ResolutionState.access$102(resolutionState, e == null ? AnalysisError.NO_ERRORS : (AnalysisError[])e);
            resolutionState.verificationErrorsState = CacheState.VALID;
        } else if (dataDescriptor == HINTS) {
            ResolutionState.access$202(resolutionState, e == null ? AnalysisError.NO_ERRORS : (AnalysisError[])e);
            resolutionState.hintsState = CacheState.VALID;
        }
    }

    @Override
    protected void copyFrom(SourceEntryImpl sourceEntryImpl) {
        super.copyFrom(sourceEntryImpl);
        DartEntryImpl dartEntryImpl = (DartEntryImpl)sourceEntryImpl;
        this.scanErrorsState = dartEntryImpl.scanErrorsState;
        this.scanErrors = dartEntryImpl.scanErrors;
        this.tokenStreamState = dartEntryImpl.tokenStreamState;
        this.tokenStream = dartEntryImpl.tokenStream;
        this.sourceKindState = dartEntryImpl.sourceKindState;
        this.sourceKind = dartEntryImpl.sourceKind;
        this.parsedUnitState = dartEntryImpl.parsedUnitState;
        this.parsedUnit = dartEntryImpl.parsedUnit;
        this.parsedUnitAccessed = dartEntryImpl.parsedUnitAccessed;
        this.parseErrorsState = dartEntryImpl.parseErrorsState;
        this.parseErrors = dartEntryImpl.parseErrors;
        this.includedPartsState = dartEntryImpl.includedPartsState;
        this.includedParts = dartEntryImpl.includedParts;
        this.exportedLibrariesState = dartEntryImpl.exportedLibrariesState;
        this.exportedLibraries = dartEntryImpl.exportedLibraries;
        this.importedLibrariesState = dartEntryImpl.importedLibrariesState;
        this.importedLibraries = dartEntryImpl.importedLibraries;
        this.containingLibraries = new ArrayList<Source>(dartEntryImpl.containingLibraries);
        this.resolutionState.copyFrom(dartEntryImpl.resolutionState);
        this.elementState = dartEntryImpl.elementState;
        this.element = dartEntryImpl.element;
        this.publicNamespaceState = dartEntryImpl.publicNamespaceState;
        this.publicNamespace = dartEntryImpl.publicNamespace;
        this.clientServerState = dartEntryImpl.clientServerState;
        this.launchableState = dartEntryImpl.launchableState;
        this.angularErrors = dartEntryImpl.angularErrors;
    }

    @Override
    protected boolean hasErrorState() {
        return super.hasErrorState() || this.scanErrorsState == CacheState.ERROR || this.tokenStreamState == CacheState.ERROR || this.sourceKindState == CacheState.ERROR || this.parsedUnitState == CacheState.ERROR || this.parseErrorsState == CacheState.ERROR || this.importedLibrariesState == CacheState.ERROR || this.exportedLibrariesState == CacheState.ERROR || this.includedPartsState == CacheState.ERROR || this.elementState == CacheState.ERROR || this.publicNamespaceState == CacheState.ERROR || this.clientServerState == CacheState.ERROR || this.launchableState == CacheState.ERROR || this.resolutionState.hasErrorState();
    }

    @Override
    protected void writeOn(StringBuilder stringBuilder) {
        stringBuilder.append("Dart: ");
        super.writeOn(stringBuilder);
        stringBuilder.append("; tokenStream = ");
        stringBuilder.append((Object)this.tokenStreamState);
        stringBuilder.append("; scanErrors = ");
        stringBuilder.append((Object)this.scanErrorsState);
        stringBuilder.append("; sourceKind = ");
        stringBuilder.append((Object)this.sourceKindState);
        stringBuilder.append("; parsedUnit = ");
        stringBuilder.append((Object)this.parsedUnitState);
        stringBuilder.append(" (");
        stringBuilder.append(this.parsedUnitAccessed ? "T" : "F");
        stringBuilder.append("); parseErrors = ");
        stringBuilder.append((Object)this.parseErrorsState);
        stringBuilder.append("; exportedLibraries = ");
        stringBuilder.append((Object)this.exportedLibrariesState);
        stringBuilder.append("; importedLibraries = ");
        stringBuilder.append((Object)this.importedLibrariesState);
        stringBuilder.append("; includedParts = ");
        stringBuilder.append((Object)this.includedPartsState);
        stringBuilder.append("; element = ");
        stringBuilder.append((Object)this.elementState);
        stringBuilder.append("; publicNamespace = ");
        stringBuilder.append((Object)this.publicNamespaceState);
        stringBuilder.append("; clientServer = ");
        stringBuilder.append((Object)this.clientServerState);
        stringBuilder.append("; launchable = ");
        stringBuilder.append((Object)this.launchableState);
        this.resolutionState.writeOn(stringBuilder);
    }

    private void discardCachedResolutionInformation() {
        this.element = null;
        this.elementState = CacheState.INVALID;
        this.clearFlags(1, 2);
        this.clientServerState = CacheState.INVALID;
        this.launchableState = CacheState.INVALID;
        this.publicNamespace = null;
        this.publicNamespaceState = CacheState.INVALID;
        this.resolutionState.invalidateAllResolutionInformation();
    }

    private ResolutionState getOrCreateResolutionState(Source source) {
        ResolutionState resolutionState = this.resolutionState;
        if (resolutionState.librarySource == null) {
            resolutionState.librarySource = source;
            return resolutionState;
        }
        while (!((Object)resolutionState.librarySource).equals(source)) {
            if (resolutionState.nextState == null) {
                ResolutionState resolutionState2 = new ResolutionState();
                resolutionState2.librarySource = source;
                resolutionState.nextState = resolutionState2;
                return resolutionState2;
            }
            resolutionState = resolutionState.nextState;
        }
        return resolutionState;
    }

    private void updateValueOfFlag(int n, CacheState cacheState) {
        if (cacheState == CacheState.VALID) {
            throw new IllegalArgumentException("Use setValue() to set the state to VALID");
        }
        if (cacheState != CacheState.IN_PROCESS) {
            this.setFlag(n, false);
        }
    }

    private static class ResolutionState {
        private ResolutionState nextState;
        private Source librarySource;
        private CacheState resolvedUnitState = CacheState.INVALID;
        private CompilationUnit resolvedUnit;
        private CacheState resolutionErrorsState = CacheState.INVALID;
        private AnalysisError[] resolutionErrors = AnalysisError.NO_ERRORS;
        private CacheState verificationErrorsState = CacheState.INVALID;
        private AnalysisError[] verificationErrors = AnalysisError.NO_ERRORS;
        private CacheState hintsState = CacheState.INVALID;
        private AnalysisError[] hints = AnalysisError.NO_ERRORS;

        public void copyFrom(ResolutionState resolutionState) {
            this.librarySource = resolutionState.librarySource;
            this.resolvedUnitState = resolutionState.resolvedUnitState;
            this.resolvedUnit = resolutionState.resolvedUnit;
            this.resolutionErrorsState = resolutionState.resolutionErrorsState;
            this.resolutionErrors = resolutionState.resolutionErrors;
            this.verificationErrorsState = resolutionState.verificationErrorsState;
            this.verificationErrors = resolutionState.verificationErrors;
            this.hintsState = resolutionState.hintsState;
            this.hints = resolutionState.hints;
            if (resolutionState.nextState != null) {
                this.nextState = new ResolutionState();
                this.nextState.copyFrom(resolutionState.nextState);
            }
        }

        public void flushAstStructures() {
            if (this.resolvedUnitState == CacheState.VALID) {
                this.resolvedUnitState = CacheState.FLUSHED;
                this.resolvedUnit = null;
            }
            if (this.nextState != null) {
                this.nextState.flushAstStructures();
            }
        }

        public boolean hasErrorState() {
            return this.resolvedUnitState == CacheState.ERROR || this.resolutionErrorsState == CacheState.ERROR || this.verificationErrorsState == CacheState.ERROR || this.hintsState == CacheState.ERROR || this.nextState != null && this.nextState.hasErrorState();
        }

        public void invalidateAllResolutionInformation() {
            this.nextState = null;
            this.librarySource = null;
            this.resolvedUnitState = CacheState.INVALID;
            this.resolvedUnit = null;
            this.resolutionErrorsState = CacheState.INVALID;
            this.resolutionErrors = AnalysisError.NO_ERRORS;
            this.verificationErrorsState = CacheState.INVALID;
            this.verificationErrors = AnalysisError.NO_ERRORS;
            this.hintsState = CacheState.INVALID;
            this.hints = AnalysisError.NO_ERRORS;
        }

        public void recordResolutionError() {
            this.resolvedUnitState = CacheState.ERROR;
            this.resolvedUnit = null;
            this.resolutionErrorsState = CacheState.ERROR;
            this.resolutionErrors = AnalysisError.NO_ERRORS;
            this.verificationErrorsState = CacheState.ERROR;
            this.verificationErrors = AnalysisError.NO_ERRORS;
            this.hintsState = CacheState.ERROR;
            this.hints = AnalysisError.NO_ERRORS;
            if (this.nextState != null) {
                this.nextState.recordResolutionError();
            }
        }

        public void recordResolutionNotInProcess() {
            if (this.resolvedUnitState == CacheState.IN_PROCESS) {
                this.resolvedUnitState = CacheState.INVALID;
            }
            if (this.resolutionErrorsState == CacheState.IN_PROCESS) {
                this.resolutionErrorsState = CacheState.INVALID;
            }
            if (this.verificationErrorsState == CacheState.IN_PROCESS) {
                this.verificationErrorsState = CacheState.INVALID;
            }
            if (this.hintsState == CacheState.IN_PROCESS) {
                this.hintsState = CacheState.INVALID;
            }
            if (this.nextState != null) {
                this.nextState.recordResolutionNotInProcess();
            }
        }

        protected void writeOn(StringBuilder stringBuilder) {
            if (this.librarySource != null) {
                stringBuilder.append("; resolvedUnit = ");
                stringBuilder.append((Object)this.resolvedUnitState);
                stringBuilder.append("; resolutionErrors = ");
                stringBuilder.append((Object)this.resolutionErrorsState);
                stringBuilder.append("; verificationErrors = ");
                stringBuilder.append((Object)this.verificationErrorsState);
                stringBuilder.append("; hints = ");
                stringBuilder.append((Object)this.hintsState);
                if (this.nextState != null) {
                    this.nextState.writeOn(stringBuilder);
                }
            }
        }

        static /* synthetic */ AnalysisError[] access$002(ResolutionState resolutionState, AnalysisError[] analysisErrorArray) {
            resolutionState.resolutionErrors = analysisErrorArray;
            return analysisErrorArray;
        }

        static /* synthetic */ AnalysisError[] access$102(ResolutionState resolutionState, AnalysisError[] analysisErrorArray) {
            resolutionState.verificationErrors = analysisErrorArray;
            return analysisErrorArray;
        }

        static /* synthetic */ AnalysisError[] access$202(ResolutionState resolutionState, AnalysisError[] analysisErrorArray) {
            resolutionState.hints = analysisErrorArray;
            return analysisErrorArray;
        }
    }
}

