/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.cache;

import com.google.dart.engine.internal.cache.CacheRetentionPolicy;
import com.google.dart.engine.internal.cache.DartEntry;
import com.google.dart.engine.internal.cache.DartEntryImpl;
import com.google.dart.engine.internal.cache.HtmlEntry;
import com.google.dart.engine.internal.cache.HtmlEntryImpl;
import com.google.dart.engine.internal.cache.RetentionPriority;
import com.google.dart.engine.internal.cache.SourceEntry;
import com.google.dart.engine.internal.cache.SourceEntryImpl;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class AnalysisCache {
    private final HashMap<Source, SourceEntry> sourceMap = new HashMap();
    private int maxCacheSize;
    private CacheRetentionPolicy retentionPolicy;
    private ArrayList<Source> recentlyUsed;

    public AnalysisCache(int n, CacheRetentionPolicy cacheRetentionPolicy) {
        this.maxCacheSize = n;
        this.retentionPolicy = cacheRetentionPolicy;
        this.recentlyUsed = new ArrayList(n);
    }

    public void accessedAst(Source source) {
        if (this.recentlyUsed.remove(source)) {
            this.recentlyUsed.add(source);
            return;
        }
        while (this.recentlyUsed.size() >= this.maxCacheSize && this.flushAstFromCache()) {
        }
        this.recentlyUsed.add(source);
    }

    public Collection<Map.Entry<Source, SourceEntry>> entrySet() {
        return this.sourceMap.entrySet();
    }

    public SourceEntry get(Source source) {
        return this.sourceMap.get(source);
    }

    public void put(Source source, SourceEntry sourceEntry) {
        ((SourceEntryImpl)sourceEntry).fixExceptionState();
        this.sourceMap.put(source, sourceEntry);
    }

    public void remove(Source source) {
        this.recentlyUsed.remove(source);
        this.sourceMap.remove(source);
    }

    public void removedAst(Source source) {
        this.recentlyUsed.remove(source);
    }

    public void setMaxCacheSize(int n) {
        this.maxCacheSize = n;
        while (this.recentlyUsed.size() > this.maxCacheSize && this.flushAstFromCache()) {
        }
    }

    public int size() {
        return this.sourceMap.size();
    }

    public void storedAst(Source source) {
        if (this.recentlyUsed.contains(source)) {
            return;
        }
        while (this.recentlyUsed.size() >= this.maxCacheSize && this.flushAstFromCache()) {
        }
        this.recentlyUsed.add(source);
    }

    private boolean flushAstFromCache() {
        Source source = this.removeAstToFlush();
        if (source == null) {
            return false;
        }
        SourceEntry sourceEntry = this.sourceMap.get(source);
        if (sourceEntry instanceof HtmlEntry) {
            HtmlEntryImpl htmlEntryImpl = ((HtmlEntry)sourceEntry).getWritableCopy();
            htmlEntryImpl.flushAstStructures();
            this.sourceMap.put(source, htmlEntryImpl);
        } else if (sourceEntry instanceof DartEntry) {
            DartEntryImpl dartEntryImpl = ((DartEntry)sourceEntry).getWritableCopy();
            dartEntryImpl.flushAstStructures();
            this.sourceMap.put(source, dartEntryImpl);
        }
        return true;
    }

    private Source removeAstToFlush() {
        int n = -1;
        for (int i = 0; i < this.recentlyUsed.size(); ++i) {
            Source source = this.recentlyUsed.get(i);
            RetentionPriority retentionPriority = this.retentionPolicy.getAstPriority(source, this.sourceMap.get(source));
            if (retentionPriority == RetentionPriority.LOW) {
                return this.recentlyUsed.remove(i);
            }
            if (retentionPriority != RetentionPriority.MEDIUM || n >= 0) continue;
            n = i;
        }
        if (n < 0) {
            return null;
        }
        return this.recentlyUsed.remove(n);
    }
}

