/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.builder;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.HtmlScriptElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.HtmlWarningCode;
import com.google.dart.engine.html.ast.HtmlScriptTagNode;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.html.scanner.TokenType;
import com.google.dart.engine.internal.context.InternalAnalysisContext;
import com.google.dart.engine.internal.context.RecordingErrorListener;
import com.google.dart.engine.internal.element.EmbeddedHtmlScriptElementImpl;
import com.google.dart.engine.internal.element.ExternalHtmlScriptElementImpl;
import com.google.dart.engine.internal.element.HtmlElementImpl;
import com.google.dart.engine.internal.element.LibraryElementImpl;
import com.google.dart.engine.internal.resolver.Library;
import com.google.dart.engine.internal.resolver.LibraryResolver;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.io.UriUtilities;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class HtmlUnitBuilder
implements XmlVisitor<Void> {
    private static final String SRC = "src";
    private final InternalAnalysisContext context;
    private RecordingErrorListener errorListener;
    private long modificationStamp;
    private HtmlElementImpl htmlElement;
    private ArrayList<XmlTagNode> parentNodes;
    private ArrayList<HtmlScriptElement> scripts;
    private Set<Library> resolvedLibraries = new HashSet<Library>();

    public HtmlUnitBuilder(InternalAnalysisContext internalAnalysisContext) {
        this.context = internalAnalysisContext;
        this.errorListener = new RecordingErrorListener();
    }

    public HtmlElementImpl buildHtmlElement(Source source, long l, HtmlUnit htmlUnit) throws AnalysisException {
        this.modificationStamp = l;
        HtmlElementImpl htmlElementImpl = new HtmlElementImpl(this.context, source.getShortName());
        htmlElementImpl.setSource(source);
        this.htmlElement = htmlElementImpl;
        htmlUnit.accept(this);
        this.htmlElement = null;
        htmlUnit.setElement(htmlElementImpl);
        return htmlElementImpl;
    }

    public RecordingErrorListener getErrorListener() {
        return this.errorListener;
    }

    public Set<Library> getResolvedLibraries() {
        return this.resolvedLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitHtmlScriptTagNode(HtmlScriptTagNode htmlScriptTagNode) {
        block11: {
            if (this.parentNodes.contains(htmlScriptTagNode)) {
                return this.reportCircularity(htmlScriptTagNode);
            }
            this.parentNodes.add(htmlScriptTagNode);
            try {
                String string;
                Source source = this.htmlElement.getSource();
                XmlAttributeNode xmlAttributeNode = this.getScriptSourcePath(htmlScriptTagNode);
                String string2 = string = xmlAttributeNode == null ? null : xmlAttributeNode.getText();
                if (htmlScriptTagNode.getAttributeEnd().getType() == TokenType.GT && string == null) {
                    EmbeddedHtmlScriptElementImpl embeddedHtmlScriptElementImpl = new EmbeddedHtmlScriptElementImpl(htmlScriptTagNode);
                    try {
                        LibraryResolver libraryResolver = new LibraryResolver(this.context);
                        LibraryElementImpl libraryElementImpl = (LibraryElementImpl)libraryResolver.resolveEmbeddedLibrary(source, this.modificationStamp, htmlScriptTagNode.getScript(), true);
                        embeddedHtmlScriptElementImpl.setScriptLibrary(libraryElementImpl);
                        this.resolvedLibraries.addAll(libraryResolver.getResolvedLibraries());
                        this.errorListener.addAll(libraryResolver.getErrorListener());
                    }
                    catch (AnalysisException analysisException) {
                        AnalysisEngine.getInstance().getLogger().logError("Could not resolve script tag", analysisException);
                    }
                    htmlScriptTagNode.setScriptElement(embeddedHtmlScriptElementImpl);
                    this.scripts.add(embeddedHtmlScriptElementImpl);
                    break block11;
                }
                ExternalHtmlScriptElementImpl externalHtmlScriptElementImpl = new ExternalHtmlScriptElementImpl(htmlScriptTagNode);
                if (string != null) {
                    try {
                        string = UriUtilities.encode(string);
                        new URI(string);
                        Source source2 = this.context.getSourceFactory().resolveUri(source, string);
                        externalHtmlScriptElementImpl.setScriptSource(source2);
                        if (!this.context.exists(source2)) {
                            this.reportValueError(HtmlWarningCode.URI_DOES_NOT_EXIST, xmlAttributeNode, string);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.reportValueError(HtmlWarningCode.INVALID_URI, xmlAttributeNode, string);
                    }
                }
                htmlScriptTagNode.setScriptElement(externalHtmlScriptElementImpl);
                this.scripts.add(externalHtmlScriptElementImpl);
            }
            finally {
                this.parentNodes.remove(htmlScriptTagNode);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitHtmlUnit(HtmlUnit htmlUnit) {
        this.parentNodes = new ArrayList();
        this.scripts = new ArrayList();
        try {
            htmlUnit.visitChildren(this);
            this.htmlElement.setScripts(this.scripts.toArray(new HtmlScriptElement[this.scripts.size()]));
        }
        finally {
            this.scripts = null;
            this.parentNodes = null;
        }
        return null;
    }

    @Override
    public Void visitXmlAttributeNode(XmlAttributeNode xmlAttributeNode) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
        if (this.parentNodes.contains(xmlTagNode)) {
            return this.reportCircularity(xmlTagNode);
        }
        this.parentNodes.add(xmlTagNode);
        try {
            xmlTagNode.visitChildren(this);
        }
        finally {
            this.parentNodes.remove(xmlTagNode);
        }
        return null;
    }

    private XmlAttributeNode getScriptSourcePath(XmlTagNode xmlTagNode) {
        for (XmlAttributeNode xmlAttributeNode : xmlTagNode.getAttributes()) {
            if (!xmlAttributeNode.getName().equals(SRC)) continue;
            return xmlAttributeNode;
        }
        return null;
    }

    private Void reportCircularity(XmlTagNode xmlTagNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Found circularity in XML nodes: ");
        boolean bl = true;
        for (XmlTagNode xmlTagNode2 : this.parentNodes) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            String string = xmlTagNode2.getTag();
            if (xmlTagNode2 == xmlTagNode) {
                stringBuilder.append("*");
                stringBuilder.append(string);
                stringBuilder.append("*");
                continue;
            }
            stringBuilder.append(string);
        }
        AnalysisEngine.getInstance().getLogger().logError(stringBuilder.toString());
        return null;
    }

    private void reportErrorForOffset(ErrorCode errorCode, int n, int n2, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.htmlElement.getSource(), n, n2, errorCode, objectArray));
    }

    private void reportValueError(ErrorCode errorCode, XmlAttributeNode xmlAttributeNode, Object ... objectArray) {
        int n = xmlAttributeNode.getValueToken().getOffset() + 1;
        int n2 = xmlAttributeNode.getValueToken().getLength() - 2;
        this.reportErrorForOffset(errorCode, n, n2, objectArray);
    }
}

