/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.builder;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.FunctionTypeAliasElement;
import com.google.dart.engine.element.LabelElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.MethodElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TopLevelVariableElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.ConstructorElementImpl;
import com.google.dart.engine.internal.element.FieldElementImpl;
import com.google.dart.engine.internal.element.FunctionElementImpl;
import com.google.dart.engine.internal.element.FunctionTypeAliasElementImpl;
import com.google.dart.engine.internal.element.LabelElementImpl;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.MethodElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.TopLevelVariableElementImpl;
import com.google.dart.engine.internal.element.TypeParameterElementImpl;
import java.util.ArrayList;

public class ElementHolder {
    private ArrayList<PropertyAccessorElement> accessors;
    private ArrayList<ConstructorElement> constructors;
    private ArrayList<FieldElement> fields;
    private ArrayList<FunctionElement> functions;
    private ArrayList<LabelElement> labels;
    private ArrayList<VariableElement> localVariables;
    private ArrayList<MethodElement> methods;
    private ArrayList<ParameterElement> parameters;
    private ArrayList<TopLevelVariableElement> topLevelVariables;
    private ArrayList<ClassElement> types;
    private ArrayList<FunctionTypeAliasElement> typeAliases;
    private ArrayList<TypeParameterElement> typeParameters;

    public void addAccessor(PropertyAccessorElement propertyAccessorElement) {
        if (this.accessors == null) {
            this.accessors = new ArrayList();
        }
        this.accessors.add(propertyAccessorElement);
    }

    public void addConstructor(ConstructorElement constructorElement) {
        if (this.constructors == null) {
            this.constructors = new ArrayList();
        }
        this.constructors.add(constructorElement);
    }

    public void addField(FieldElement fieldElement) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(fieldElement);
    }

    public void addFunction(FunctionElement functionElement) {
        if (this.functions == null) {
            this.functions = new ArrayList();
        }
        this.functions.add(functionElement);
    }

    public void addLabel(LabelElement labelElement) {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        this.labels.add(labelElement);
    }

    public void addLocalVariable(LocalVariableElement localVariableElement) {
        if (this.localVariables == null) {
            this.localVariables = new ArrayList();
        }
        this.localVariables.add(localVariableElement);
    }

    public void addMethod(MethodElement methodElement) {
        if (this.methods == null) {
            this.methods = new ArrayList();
        }
        this.methods.add(methodElement);
    }

    public void addParameter(ParameterElement parameterElement) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(parameterElement);
    }

    public void addTopLevelVariable(TopLevelVariableElement topLevelVariableElement) {
        if (this.topLevelVariables == null) {
            this.topLevelVariables = new ArrayList();
        }
        this.topLevelVariables.add(topLevelVariableElement);
    }

    public void addType(ClassElement classElement) {
        if (this.types == null) {
            this.types = new ArrayList();
        }
        this.types.add(classElement);
    }

    public void addTypeAlias(FunctionTypeAliasElement functionTypeAliasElement) {
        if (this.typeAliases == null) {
            this.typeAliases = new ArrayList();
        }
        this.typeAliases.add(functionTypeAliasElement);
    }

    public void addTypeParameter(TypeParameterElement typeParameterElement) {
        if (this.typeParameters == null) {
            this.typeParameters = new ArrayList();
        }
        this.typeParameters.add(typeParameterElement);
    }

    public PropertyAccessorElement[] getAccessors() {
        if (this.accessors == null) {
            return PropertyAccessorElementImpl.EMPTY_ARRAY;
        }
        PropertyAccessorElement[] propertyAccessorElementArray = this.accessors.toArray(new PropertyAccessorElement[this.accessors.size()]);
        this.accessors = null;
        return propertyAccessorElementArray;
    }

    public ConstructorElement[] getConstructors() {
        if (this.constructors == null) {
            return ConstructorElementImpl.EMPTY_ARRAY;
        }
        ConstructorElement[] constructorElementArray = this.constructors.toArray(new ConstructorElement[this.constructors.size()]);
        this.constructors = null;
        return constructorElementArray;
    }

    public FieldElement getField(String string) {
        if (this.fields == null) {
            return null;
        }
        for (FieldElement fieldElement : this.fields) {
            if (!fieldElement.getName().equals(string)) continue;
            return fieldElement;
        }
        return null;
    }

    public FieldElement[] getFields() {
        if (this.fields == null) {
            return FieldElementImpl.EMPTY_ARRAY;
        }
        FieldElement[] fieldElementArray = this.fields.toArray(new FieldElement[this.fields.size()]);
        this.fields = null;
        return fieldElementArray;
    }

    public FieldElement[] getFieldsWithoutFlushing() {
        if (this.fields == null) {
            return FieldElementImpl.EMPTY_ARRAY;
        }
        FieldElement[] fieldElementArray = this.fields.toArray(new FieldElement[this.fields.size()]);
        return fieldElementArray;
    }

    public FunctionElement[] getFunctions() {
        if (this.functions == null) {
            return FunctionElementImpl.EMPTY_ARRAY;
        }
        FunctionElement[] functionElementArray = this.functions.toArray(new FunctionElement[this.functions.size()]);
        this.functions = null;
        return functionElementArray;
    }

    public LabelElement[] getLabels() {
        if (this.labels == null) {
            return LabelElementImpl.EMPTY_ARRAY;
        }
        LabelElement[] labelElementArray = this.labels.toArray(new LabelElement[this.labels.size()]);
        this.labels = null;
        return labelElementArray;
    }

    public LocalVariableElement[] getLocalVariables() {
        if (this.localVariables == null) {
            return LocalVariableElementImpl.EMPTY_ARRAY;
        }
        LocalVariableElement[] localVariableElementArray = this.localVariables.toArray(new LocalVariableElement[this.localVariables.size()]);
        this.localVariables = null;
        return localVariableElementArray;
    }

    public MethodElement[] getMethods() {
        if (this.methods == null) {
            return MethodElementImpl.EMPTY_ARRAY;
        }
        MethodElement[] methodElementArray = this.methods.toArray(new MethodElement[this.methods.size()]);
        this.methods = null;
        return methodElementArray;
    }

    public ParameterElement[] getParameters() {
        if (this.parameters == null) {
            return ParameterElementImpl.EMPTY_ARRAY;
        }
        ParameterElement[] parameterElementArray = this.parameters.toArray(new ParameterElement[this.parameters.size()]);
        this.parameters = null;
        return parameterElementArray;
    }

    public TopLevelVariableElement getTopLevelVariable(String string) {
        if (this.topLevelVariables == null) {
            return null;
        }
        for (TopLevelVariableElement topLevelVariableElement : this.topLevelVariables) {
            if (!topLevelVariableElement.getName().equals(string)) continue;
            return topLevelVariableElement;
        }
        return null;
    }

    public TopLevelVariableElement[] getTopLevelVariables() {
        if (this.topLevelVariables == null) {
            return TopLevelVariableElementImpl.EMPTY_ARRAY;
        }
        TopLevelVariableElement[] topLevelVariableElementArray = this.topLevelVariables.toArray(new TopLevelVariableElement[this.topLevelVariables.size()]);
        this.topLevelVariables = null;
        return topLevelVariableElementArray;
    }

    public FunctionTypeAliasElement[] getTypeAliases() {
        if (this.typeAliases == null) {
            return FunctionTypeAliasElementImpl.EMPTY_ARRAY;
        }
        FunctionTypeAliasElement[] functionTypeAliasElementArray = this.typeAliases.toArray(new FunctionTypeAliasElement[this.typeAliases.size()]);
        this.typeAliases = null;
        return functionTypeAliasElementArray;
    }

    public TypeParameterElement[] getTypeParameters() {
        if (this.typeParameters == null) {
            return TypeParameterElementImpl.EMPTY_ARRAY;
        }
        TypeParameterElement[] typeParameterElementArray = this.typeParameters.toArray(new TypeParameterElement[this.typeParameters.size()]);
        this.typeParameters = null;
        return typeParameterElementArray;
    }

    public ClassElement[] getTypes() {
        if (this.types == null) {
            return ClassElementImpl.EMPTY_ARRAY;
        }
        ClassElement[] classElementArray = this.types.toArray(new ClassElement[this.types.size()]);
        this.types = null;
        return classElementArray;
    }

    public void validate() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.accessors != null) {
            stringBuilder.append(this.accessors.size());
            stringBuilder.append(" accessors");
        }
        if (this.constructors != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.constructors.size());
            stringBuilder.append(" constructors");
        }
        if (this.fields != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.fields.size());
            stringBuilder.append(" fields");
        }
        if (this.functions != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.functions.size());
            stringBuilder.append(" functions");
        }
        if (this.labels != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.labels.size());
            stringBuilder.append(" labels");
        }
        if (this.localVariables != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.localVariables.size());
            stringBuilder.append(" local variables");
        }
        if (this.methods != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.methods.size());
            stringBuilder.append(" methods");
        }
        if (this.parameters != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.parameters.size());
            stringBuilder.append(" parameters");
        }
        if (this.topLevelVariables != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.topLevelVariables.size());
            stringBuilder.append(" top-level variables");
        }
        if (this.types != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.types.size());
            stringBuilder.append(" types");
        }
        if (this.typeAliases != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.typeAliases.size());
            stringBuilder.append(" type aliases");
        }
        if (this.typeParameters != null) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(this.typeParameters.size());
            stringBuilder.append(" type parameters");
        }
        if (stringBuilder.length() > 0) {
            AnalysisEngine.getInstance().getLogger().logError("Failed to capture elements: " + stringBuilder.toString());
        }
    }
}

