/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.builder;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.NormalFormalParameter;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.ast.visitor.UnifyingAstVisitor;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.FunctionElement;
import com.google.dart.engine.element.LocalVariableElement;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.TopLevelVariableElement;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.internal.builder.ElementHolder;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.ConstFieldElementImpl;
import com.google.dart.engine.internal.element.ConstLocalVariableElementImpl;
import com.google.dart.engine.internal.element.ConstTopLevelVariableElementImpl;
import com.google.dart.engine.internal.element.ConstructorElementImpl;
import com.google.dart.engine.internal.element.DefaultFieldFormalParameterElementImpl;
import com.google.dart.engine.internal.element.DefaultParameterElementImpl;
import com.google.dart.engine.internal.element.ElementImpl;
import com.google.dart.engine.internal.element.ExecutableElementImpl;
import com.google.dart.engine.internal.element.FieldElementImpl;
import com.google.dart.engine.internal.element.FieldFormalParameterElementImpl;
import com.google.dart.engine.internal.element.FunctionElementImpl;
import com.google.dart.engine.internal.element.FunctionTypeAliasElementImpl;
import com.google.dart.engine.internal.element.LabelElementImpl;
import com.google.dart.engine.internal.element.LocalVariableElementImpl;
import com.google.dart.engine.internal.element.MethodElementImpl;
import com.google.dart.engine.internal.element.ParameterElementImpl;
import com.google.dart.engine.internal.element.PropertyAccessorElementImpl;
import com.google.dart.engine.internal.element.PropertyInducingElementImpl;
import com.google.dart.engine.internal.element.TopLevelVariableElementImpl;
import com.google.dart.engine.internal.element.TypeParameterElementImpl;
import com.google.dart.engine.internal.type.FunctionTypeImpl;
import com.google.dart.engine.internal.type.InterfaceTypeImpl;
import com.google.dart.engine.internal.type.TypeParameterTypeImpl;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.scanner.TokenType;
import com.google.dart.engine.type.FunctionType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.util.ArrayList;
import java.util.HashMap;

public class ElementBuilder
extends RecursiveAstVisitor<Void> {
    private ElementHolder currentHolder;
    private boolean inFieldContext = false;
    private boolean inFunction = false;
    private boolean isValidMixin = false;
    private ArrayList<FunctionTypeImpl> functionTypesToFix = null;
    private HashMap<String, FieldElement> fieldMap;

    public ElementBuilder(ElementHolder elementHolder) {
        this.currentHolder = elementHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitBlock(Block block) {
        boolean bl = this.inFieldContext;
        this.inFieldContext = false;
        try {
            block.visitChildren(this);
        }
        finally {
            this.inFieldContext = bl;
        }
        return null;
    }

    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        SimpleIdentifier simpleIdentifier = catchClause.getExceptionParameter();
        if (simpleIdentifier != null) {
            LocalVariableElementImpl localVariableElementImpl = new LocalVariableElementImpl(simpleIdentifier);
            this.currentHolder.addLocalVariable(localVariableElementImpl);
            simpleIdentifier.setStaticElement(localVariableElementImpl);
            SimpleIdentifier simpleIdentifier2 = catchClause.getStackTraceParameter();
            if (simpleIdentifier2 != null) {
                LocalVariableElementImpl localVariableElementImpl2 = new LocalVariableElementImpl(simpleIdentifier2);
                this.currentHolder.addLocalVariable(localVariableElementImpl2);
                simpleIdentifier2.setStaticElement(localVariableElementImpl2);
            }
        }
        return (Void)super.visitCatchClause(catchClause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        Object object;
        ElementHolder elementHolder = new ElementHolder();
        this.isValidMixin = true;
        this.functionTypesToFix = new ArrayList();
        ElementHolder elementHolder2 = this.currentHolder;
        this.currentHolder = elementHolder;
        try {
            object = new ArrayList();
            classDeclaration.visitChildren(new UnifyingAstVisitor<Void>(){

                @Override
                public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
                    object.add(constructorDeclaration);
                    return null;
                }

                @Override
                public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
                    object.add(methodDeclaration);
                    return null;
                }

                @Override
                public Void visitNode(AstNode astNode) {
                    return astNode.accept(ElementBuilder.this);
                }
            });
            this.buildFieldMap(elementHolder.getFieldsWithoutFlushing());
            int n = ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                ((ClassMember)((ArrayList)object).get(i)).accept(this);
            }
        }
        finally {
            this.currentHolder = elementHolder2;
        }
        object = classDeclaration.getName();
        ClassElementImpl classElementImpl = new ClassElementImpl((Identifier)object);
        TypeParameterElement[] typeParameterElementArray = elementHolder.getTypeParameters();
        Type[] typeArray = this.createTypeParameterTypes(typeParameterElementArray);
        InterfaceTypeImpl interfaceTypeImpl = new InterfaceTypeImpl(classElementImpl);
        interfaceTypeImpl.setTypeArguments(typeArray);
        classElementImpl.setType(interfaceTypeImpl);
        ConstructorElement[] constructorElementArray = elementHolder.getConstructors();
        if (constructorElementArray.length == 0) {
            constructorElementArray = this.createDefaultConstructors(interfaceTypeImpl);
        }
        classElementImpl.setAbstract(classDeclaration.getAbstractKeyword() != null);
        classElementImpl.setAccessors(elementHolder.getAccessors());
        classElementImpl.setConstructors(constructorElementArray);
        classElementImpl.setFields(elementHolder.getFields());
        classElementImpl.setMethods(elementHolder.getMethods());
        classElementImpl.setTypeParameters(typeParameterElementArray);
        classElementImpl.setValidMixin(this.isValidMixin);
        int n = this.functionTypesToFix.size();
        for (int i = 0; i < n; ++i) {
            this.functionTypesToFix.get(i).setTypeArguments(typeArray);
        }
        this.functionTypesToFix = null;
        this.currentHolder.addType(classElementImpl);
        ((SimpleIdentifier)object).setStaticElement(classElementImpl);
        this.fieldMap = null;
        elementHolder.validate();
        return null;
    }

    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        ElementHolder elementHolder = new ElementHolder();
        this.functionTypesToFix = new ArrayList();
        this.visitChildren(elementHolder, classTypeAlias);
        SimpleIdentifier simpleIdentifier = classTypeAlias.getName();
        ClassElementImpl classElementImpl = new ClassElementImpl(simpleIdentifier);
        classElementImpl.setAbstract(classTypeAlias.getAbstractKeyword() != null);
        classElementImpl.setTypedef(true);
        TypeParameterElement[] typeParameterElementArray = elementHolder.getTypeParameters();
        classElementImpl.setTypeParameters(typeParameterElementArray);
        Type[] typeArray = this.createTypeParameterTypes(typeParameterElementArray);
        InterfaceTypeImpl interfaceTypeImpl = new InterfaceTypeImpl(classElementImpl);
        interfaceTypeImpl.setTypeArguments(typeArray);
        classElementImpl.setType(interfaceTypeImpl);
        classElementImpl.setConstructors(this.createDefaultConstructors(interfaceTypeImpl));
        for (FunctionTypeImpl functionTypeImpl : this.functionTypesToFix) {
            functionTypeImpl.setTypeArguments(typeArray);
        }
        this.functionTypesToFix = null;
        this.currentHolder.addType(classElementImpl);
        simpleIdentifier.setStaticElement(classElementImpl);
        elementHolder.validate();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        this.isValidMixin = false;
        ElementHolder elementHolder = new ElementHolder();
        boolean bl = this.inFunction;
        this.inFunction = true;
        try {
            this.visitChildren(elementHolder, constructorDeclaration);
        }
        finally {
            this.inFunction = bl;
        }
        SimpleIdentifier simpleIdentifier = constructorDeclaration.getName();
        ConstructorElementImpl constructorElementImpl = new ConstructorElementImpl(simpleIdentifier);
        if (constructorDeclaration.getFactoryKeyword() != null) {
            constructorElementImpl.setFactory(true);
        }
        constructorElementImpl.setFunctions(elementHolder.getFunctions());
        constructorElementImpl.setLabels(elementHolder.getLabels());
        constructorElementImpl.setLocalVariables(elementHolder.getLocalVariables());
        constructorElementImpl.setParameters(elementHolder.getParameters());
        constructorElementImpl.setConst(constructorDeclaration.getConstKeyword() != null);
        this.currentHolder.addConstructor(constructorElementImpl);
        constructorDeclaration.setElement(constructorElementImpl);
        if (simpleIdentifier == null) {
            Identifier identifier = constructorDeclaration.getReturnType();
            if (identifier != null) {
                constructorElementImpl.setNameOffset(identifier.getOffset());
            }
        } else {
            simpleIdentifier.setStaticElement(constructorElementImpl);
        }
        elementHolder.validate();
        return null;
    }

    @Override
    public Void visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        SimpleIdentifier simpleIdentifier = declaredIdentifier.getIdentifier();
        Token token = declaredIdentifier.getKeyword();
        LocalVariableElementImpl localVariableElementImpl = new LocalVariableElementImpl(simpleIdentifier);
        ForEachStatement forEachStatement = (ForEachStatement)declaredIdentifier.getParent();
        int n = declaredIdentifier.getOffset() + declaredIdentifier.getLength();
        int n2 = forEachStatement.getOffset() + forEachStatement.getLength();
        localVariableElementImpl.setVisibleRange(n, n2 - n - 1);
        localVariableElementImpl.setConst(this.matches(token, Keyword.CONST));
        localVariableElementImpl.setFinal(this.matches(token, Keyword.FINAL));
        this.currentHolder.addLocalVariable(localVariableElementImpl);
        simpleIdentifier.setStaticElement(localVariableElementImpl);
        return (Void)super.visitDeclaredIdentifier(declaredIdentifier);
    }

    @Override
    public Void visitDefaultFormalParameter(DefaultFormalParameter defaultFormalParameter) {
        Object object;
        ParameterElementImpl parameterElementImpl;
        ElementHolder elementHolder = new ElementHolder();
        NormalFormalParameter normalFormalParameter = defaultFormalParameter.getParameter();
        SimpleIdentifier simpleIdentifier = normalFormalParameter.getIdentifier();
        if (normalFormalParameter instanceof FieldFormalParameter) {
            parameterElementImpl = new DefaultFieldFormalParameterElementImpl(simpleIdentifier);
            Object object2 = object = this.fieldMap == null ? null : this.fieldMap.get(simpleIdentifier.getName());
            if (object != null) {
                ((DefaultFieldFormalParameterElementImpl)parameterElementImpl).setField((FieldElement)object);
            }
        } else {
            parameterElementImpl = new DefaultParameterElementImpl(simpleIdentifier);
        }
        parameterElementImpl.setConst(defaultFormalParameter.isConst());
        parameterElementImpl.setFinal(defaultFormalParameter.isFinal());
        parameterElementImpl.setParameterKind(defaultFormalParameter.getKind());
        object = defaultFormalParameter.getDefaultValue();
        if (object != null) {
            this.visit(elementHolder, (AstNode)object);
            FunctionElementImpl functionElementImpl = new FunctionElementImpl(((AstNode)object).getBeginToken().getOffset());
            functionElementImpl.setFunctions(elementHolder.getFunctions());
            functionElementImpl.setLabels(elementHolder.getLabels());
            functionElementImpl.setLocalVariables(elementHolder.getLocalVariables());
            functionElementImpl.setParameters(elementHolder.getParameters());
            functionElementImpl.setSynthetic(true);
            parameterElementImpl.setInitializer(functionElementImpl);
            parameterElementImpl.setDefaultValueRange(((AstNode)object).getOffset(), ((AstNode)object).getLength());
        }
        this.setParameterVisibleRange(defaultFormalParameter, parameterElementImpl);
        this.currentHolder.addParameter(parameterElementImpl);
        simpleIdentifier.setStaticElement(parameterElementImpl);
        normalFormalParameter.accept(this);
        elementHolder.validate();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        boolean bl = this.inFieldContext;
        this.inFieldContext = true;
        try {
            fieldDeclaration.visitChildren(this);
        }
        finally {
            this.inFieldContext = bl;
        }
        return null;
    }

    @Override
    public Void visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        Object object;
        if (!(fieldFormalParameter.getParent() instanceof DefaultFormalParameter)) {
            object = fieldFormalParameter.getIdentifier();
            FieldElement fieldElement = this.fieldMap == null ? null : this.fieldMap.get(((SimpleIdentifier)object).getName());
            FieldFormalParameterElementImpl fieldFormalParameterElementImpl = new FieldFormalParameterElementImpl((Identifier)object);
            fieldFormalParameterElementImpl.setConst(fieldFormalParameter.isConst());
            fieldFormalParameterElementImpl.setFinal(fieldFormalParameter.isFinal());
            fieldFormalParameterElementImpl.setParameterKind(fieldFormalParameter.getKind());
            if (fieldElement != null) {
                fieldFormalParameterElementImpl.setField(fieldElement);
            }
            this.currentHolder.addParameter(fieldFormalParameterElementImpl);
            ((SimpleIdentifier)object).setStaticElement(fieldFormalParameterElementImpl);
        }
        object = new ElementHolder();
        this.visitChildren((ElementHolder)object, fieldFormalParameter);
        ((ParameterElementImpl)fieldFormalParameter.getElement()).setParameters(((ElementHolder)object).getParameters());
        ((ElementHolder)object).validate();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        FunctionExpression functionExpression = functionDeclaration.getFunctionExpression();
        if (functionExpression != null) {
            ElementHolder elementHolder = new ElementHolder();
            boolean bl = this.inFunction;
            this.inFunction = true;
            try {
                this.visitChildren(elementHolder, functionExpression);
            }
            finally {
                this.inFunction = bl;
            }
            Token token = functionDeclaration.getPropertyKeyword();
            if (token == null) {
                Block block;
                SimpleIdentifier simpleIdentifier = functionDeclaration.getName();
                FunctionElementImpl functionElementImpl = new FunctionElementImpl(simpleIdentifier);
                functionElementImpl.setFunctions(elementHolder.getFunctions());
                functionElementImpl.setLabels(elementHolder.getLabels());
                functionElementImpl.setLocalVariables(elementHolder.getLocalVariables());
                functionElementImpl.setParameters(elementHolder.getParameters());
                if (this.inFunction && (block = functionDeclaration.getAncestor(Block.class)) != null) {
                    int n = functionDeclaration.getOffset() + functionDeclaration.getLength();
                    int n2 = block.getOffset() + block.getLength();
                    functionElementImpl.setVisibleRange(n, n2 - n - 1);
                }
                this.currentHolder.addFunction(functionElementImpl);
                functionExpression.setElement(functionElementImpl);
                simpleIdentifier.setStaticElement(functionElementImpl);
            } else {
                SimpleIdentifier simpleIdentifier = functionDeclaration.getName();
                if (simpleIdentifier == null) {
                    return null;
                }
                String string = simpleIdentifier.getName();
                TopLevelVariableElementImpl topLevelVariableElementImpl = (TopLevelVariableElementImpl)this.currentHolder.getTopLevelVariable(string);
                if (topLevelVariableElementImpl == null) {
                    topLevelVariableElementImpl = new TopLevelVariableElementImpl(functionDeclaration.getName().getName());
                    topLevelVariableElementImpl.setFinal(true);
                    topLevelVariableElementImpl.setSynthetic(true);
                    this.currentHolder.addTopLevelVariable(topLevelVariableElementImpl);
                }
                if (this.matches(token, Keyword.GET)) {
                    PropertyAccessorElementImpl propertyAccessorElementImpl = new PropertyAccessorElementImpl(simpleIdentifier);
                    propertyAccessorElementImpl.setFunctions(elementHolder.getFunctions());
                    propertyAccessorElementImpl.setLabels(elementHolder.getLabels());
                    propertyAccessorElementImpl.setLocalVariables(elementHolder.getLocalVariables());
                    propertyAccessorElementImpl.setVariable(topLevelVariableElementImpl);
                    propertyAccessorElementImpl.setGetter(true);
                    propertyAccessorElementImpl.setStatic(true);
                    topLevelVariableElementImpl.setGetter(propertyAccessorElementImpl);
                    this.currentHolder.addAccessor(propertyAccessorElementImpl);
                    functionExpression.setElement(propertyAccessorElementImpl);
                    simpleIdentifier.setStaticElement(propertyAccessorElementImpl);
                } else {
                    PropertyAccessorElementImpl propertyAccessorElementImpl = new PropertyAccessorElementImpl(simpleIdentifier);
                    propertyAccessorElementImpl.setFunctions(elementHolder.getFunctions());
                    propertyAccessorElementImpl.setLabels(elementHolder.getLabels());
                    propertyAccessorElementImpl.setLocalVariables(elementHolder.getLocalVariables());
                    propertyAccessorElementImpl.setParameters(elementHolder.getParameters());
                    propertyAccessorElementImpl.setVariable(topLevelVariableElementImpl);
                    propertyAccessorElementImpl.setSetter(true);
                    propertyAccessorElementImpl.setStatic(true);
                    topLevelVariableElementImpl.setSetter(propertyAccessorElementImpl);
                    topLevelVariableElementImpl.setFinal(false);
                    this.currentHolder.addAccessor(propertyAccessorElementImpl);
                    functionExpression.setElement(propertyAccessorElementImpl);
                    simpleIdentifier.setStaticElement(propertyAccessorElementImpl);
                }
            }
            elementHolder.validate();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        Object object;
        ElementHolder elementHolder = new ElementHolder();
        boolean bl = this.inFunction;
        this.inFunction = true;
        try {
            this.visitChildren(elementHolder, functionExpression);
        }
        finally {
            this.inFunction = bl;
        }
        FunctionElementImpl functionElementImpl = new FunctionElementImpl(functionExpression.getBeginToken().getOffset());
        functionElementImpl.setFunctions(elementHolder.getFunctions());
        functionElementImpl.setLabels(elementHolder.getLabels());
        functionElementImpl.setLocalVariables(elementHolder.getLocalVariables());
        functionElementImpl.setParameters(elementHolder.getParameters());
        if (this.inFunction && (object = functionExpression.getAncestor(Block.class)) != null) {
            int n = functionExpression.getOffset() + functionExpression.getLength();
            int n2 = ((AstNode)object).getOffset() + ((AstNode)object).getLength();
            functionElementImpl.setVisibleRange(n, n2 - n - 1);
        }
        object = new FunctionTypeImpl(functionElementImpl);
        if (this.functionTypesToFix != null) {
            this.functionTypesToFix.add((FunctionTypeImpl)object);
        }
        functionElementImpl.setType((FunctionType)object);
        this.currentHolder.addFunction(functionElementImpl);
        functionExpression.setElement(functionElementImpl);
        elementHolder.validate();
        return null;
    }

    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        ElementHolder elementHolder = new ElementHolder();
        this.visitChildren(elementHolder, functionTypeAlias);
        SimpleIdentifier simpleIdentifier = functionTypeAlias.getName();
        ParameterElement[] parameterElementArray = elementHolder.getParameters();
        TypeParameterElement[] typeParameterElementArray = elementHolder.getTypeParameters();
        FunctionTypeAliasElementImpl functionTypeAliasElementImpl = new FunctionTypeAliasElementImpl(simpleIdentifier);
        functionTypeAliasElementImpl.setParameters(parameterElementArray);
        functionTypeAliasElementImpl.setTypeParameters(typeParameterElementArray);
        FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(functionTypeAliasElementImpl);
        functionTypeImpl.setTypeArguments(this.createTypeParameterTypes(typeParameterElementArray));
        functionTypeAliasElementImpl.setType(functionTypeImpl);
        this.currentHolder.addTypeAlias(functionTypeAliasElementImpl);
        simpleIdentifier.setStaticElement(functionTypeAliasElementImpl);
        elementHolder.validate();
        return null;
    }

    @Override
    public Void visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        Object object;
        if (!(functionTypedFormalParameter.getParent() instanceof DefaultFormalParameter)) {
            object = functionTypedFormalParameter.getIdentifier();
            ParameterElementImpl parameterElementImpl = new ParameterElementImpl((Identifier)object);
            parameterElementImpl.setParameterKind(functionTypedFormalParameter.getKind());
            this.setParameterVisibleRange(functionTypedFormalParameter, parameterElementImpl);
            this.currentHolder.addParameter(parameterElementImpl);
            ((SimpleIdentifier)object).setStaticElement(parameterElementImpl);
        }
        object = new ElementHolder();
        this.visitChildren((ElementHolder)object, functionTypedFormalParameter);
        ((ParameterElementImpl)functionTypedFormalParameter.getElement()).setParameters(((ElementHolder)object).getParameters());
        ((ElementHolder)object).validate();
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatement labeledStatement) {
        boolean bl = labeledStatement.getStatement() instanceof SwitchStatement;
        for (Label label : labeledStatement.getLabels()) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            LabelElementImpl labelElementImpl = new LabelElementImpl(simpleIdentifier, bl, false);
            this.currentHolder.addLabel(labelElementImpl);
            simpleIdentifier.setStaticElement(labelElementImpl);
        }
        return (Void)super.visitLabeledStatement(labeledStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        ElementHolder elementHolder = new ElementHolder();
        boolean bl = this.inFunction;
        this.inFunction = true;
        try {
            this.visitChildren(elementHolder, methodDeclaration);
        }
        finally {
            this.inFunction = bl;
        }
        boolean bl2 = methodDeclaration.isStatic();
        Token token = methodDeclaration.getPropertyKeyword();
        if (token == null) {
            SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
            String string = simpleIdentifier.getName();
            if (string.equals(TokenType.MINUS.getLexeme()) && methodDeclaration.getParameters().getParameters().size() == 0) {
                string = "unary-";
            }
            MethodElementImpl methodElementImpl = new MethodElementImpl(string, simpleIdentifier.getOffset());
            methodElementImpl.setAbstract(methodDeclaration.isAbstract());
            methodElementImpl.setFunctions(elementHolder.getFunctions());
            methodElementImpl.setLabels(elementHolder.getLabels());
            methodElementImpl.setLocalVariables(elementHolder.getLocalVariables());
            methodElementImpl.setParameters(elementHolder.getParameters());
            methodElementImpl.setStatic(bl2);
            this.currentHolder.addMethod(methodElementImpl);
            simpleIdentifier.setStaticElement(methodElementImpl);
        } else {
            SimpleIdentifier simpleIdentifier = methodDeclaration.getName();
            String string = simpleIdentifier.getName();
            FieldElementImpl fieldElementImpl = (FieldElementImpl)this.currentHolder.getField(string);
            if (fieldElementImpl == null) {
                fieldElementImpl = new FieldElementImpl(methodDeclaration.getName().getName());
                fieldElementImpl.setFinal(true);
                fieldElementImpl.setStatic(bl2);
                fieldElementImpl.setSynthetic(true);
                this.currentHolder.addField(fieldElementImpl);
            }
            if (this.matches(token, Keyword.GET)) {
                PropertyAccessorElementImpl propertyAccessorElementImpl = new PropertyAccessorElementImpl(simpleIdentifier);
                propertyAccessorElementImpl.setFunctions(elementHolder.getFunctions());
                propertyAccessorElementImpl.setLabels(elementHolder.getLabels());
                propertyAccessorElementImpl.setLocalVariables(elementHolder.getLocalVariables());
                propertyAccessorElementImpl.setVariable(fieldElementImpl);
                propertyAccessorElementImpl.setAbstract(methodDeclaration.getBody() instanceof EmptyFunctionBody && methodDeclaration.getExternalKeyword() == null);
                propertyAccessorElementImpl.setGetter(true);
                propertyAccessorElementImpl.setStatic(bl2);
                fieldElementImpl.setGetter(propertyAccessorElementImpl);
                this.currentHolder.addAccessor(propertyAccessorElementImpl);
                simpleIdentifier.setStaticElement(propertyAccessorElementImpl);
            } else {
                PropertyAccessorElementImpl propertyAccessorElementImpl = new PropertyAccessorElementImpl(simpleIdentifier);
                propertyAccessorElementImpl.setFunctions(elementHolder.getFunctions());
                propertyAccessorElementImpl.setLabels(elementHolder.getLabels());
                propertyAccessorElementImpl.setLocalVariables(elementHolder.getLocalVariables());
                propertyAccessorElementImpl.setParameters(elementHolder.getParameters());
                propertyAccessorElementImpl.setVariable(fieldElementImpl);
                propertyAccessorElementImpl.setAbstract(methodDeclaration.getBody() instanceof EmptyFunctionBody && !this.matches(methodDeclaration.getExternalKeyword(), Keyword.EXTERNAL));
                propertyAccessorElementImpl.setSetter(true);
                propertyAccessorElementImpl.setStatic(bl2);
                fieldElementImpl.setSetter(propertyAccessorElementImpl);
                fieldElementImpl.setFinal(false);
                this.currentHolder.addAccessor(propertyAccessorElementImpl);
                simpleIdentifier.setStaticElement(propertyAccessorElementImpl);
            }
        }
        elementHolder.validate();
        return null;
    }

    @Override
    public Void visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        if (!(simpleFormalParameter.getParent() instanceof DefaultFormalParameter)) {
            SimpleIdentifier simpleIdentifier = simpleFormalParameter.getIdentifier();
            ParameterElementImpl parameterElementImpl = new ParameterElementImpl(simpleIdentifier);
            parameterElementImpl.setConst(simpleFormalParameter.isConst());
            parameterElementImpl.setFinal(simpleFormalParameter.isFinal());
            parameterElementImpl.setParameterKind(simpleFormalParameter.getKind());
            this.setParameterVisibleRange(simpleFormalParameter, parameterElementImpl);
            this.currentHolder.addParameter(parameterElementImpl);
            simpleIdentifier.setStaticElement(parameterElementImpl);
        }
        return (Void)super.visitSimpleFormalParameter(simpleFormalParameter);
    }

    @Override
    public Void visitSuperExpression(SuperExpression superExpression) {
        this.isValidMixin = false;
        return (Void)super.visitSuperExpression(superExpression);
    }

    @Override
    public Void visitSwitchCase(SwitchCase switchCase) {
        for (Label label : switchCase.getLabels()) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            LabelElementImpl labelElementImpl = new LabelElementImpl(simpleIdentifier, false, true);
            this.currentHolder.addLabel(labelElementImpl);
            simpleIdentifier.setStaticElement(labelElementImpl);
        }
        return (Void)super.visitSwitchCase(switchCase);
    }

    @Override
    public Void visitSwitchDefault(SwitchDefault switchDefault) {
        for (Label label : switchDefault.getLabels()) {
            SimpleIdentifier simpleIdentifier = label.getLabel();
            LabelElementImpl labelElementImpl = new LabelElementImpl(simpleIdentifier, false, true);
            this.currentHolder.addLabel(labelElementImpl);
            simpleIdentifier.setStaticElement(labelElementImpl);
        }
        return (Void)super.visitSwitchDefault(switchDefault);
    }

    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        SimpleIdentifier simpleIdentifier = typeParameter.getName();
        TypeParameterElementImpl typeParameterElementImpl = new TypeParameterElementImpl(simpleIdentifier);
        TypeParameterTypeImpl typeParameterTypeImpl = new TypeParameterTypeImpl(typeParameterElementImpl);
        typeParameterElementImpl.setType(typeParameterTypeImpl);
        this.currentHolder.addTypeParameter(typeParameterElementImpl);
        simpleIdentifier.setStaticElement(typeParameterElementImpl);
        return (Void)super.visitTypeParameter(typeParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        Object object;
        FieldElementImpl fieldElementImpl;
        ElementImpl elementImpl;
        Object object2;
        boolean bl;
        Token token = ((VariableDeclarationList)variableDeclaration.getParent()).getKeyword();
        boolean bl2 = this.matches(token, Keyword.CONST);
        boolean bl3 = this.matches(token, Keyword.FINAL);
        boolean bl4 = bl = variableDeclaration.getInitializer() != null;
        if (this.inFieldContext) {
            object2 = variableDeclaration.getName();
            elementImpl = bl2 && bl ? new ConstFieldElementImpl((Identifier)object2) : new FieldElementImpl((Identifier)object2);
            fieldElementImpl = elementImpl;
            this.currentHolder.addField((FieldElement)((Object)elementImpl));
            ((SimpleIdentifier)object2).setStaticElement(elementImpl);
        } else if (this.inFunction) {
            object2 = variableDeclaration.getName();
            elementImpl = bl2 && bl ? new ConstLocalVariableElementImpl((Identifier)object2) : new LocalVariableElementImpl((Identifier)object2);
            fieldElementImpl = elementImpl;
            object = variableDeclaration.getAncestor(Block.class);
            int n = variableDeclaration.getOffset() + variableDeclaration.getLength();
            int n2 = ((AstNode)object).getOffset() + ((AstNode)object).getLength();
            ((LocalVariableElementImpl)elementImpl).setVisibleRange(n, n2 - n - 1);
            this.currentHolder.addLocalVariable((LocalVariableElement)((Object)elementImpl));
            ((SimpleIdentifier)object2).setStaticElement(fieldElementImpl);
        } else {
            object2 = variableDeclaration.getName();
            elementImpl = bl2 && bl ? new ConstTopLevelVariableElementImpl((Identifier)object2) : new TopLevelVariableElementImpl((Identifier)object2);
            fieldElementImpl = elementImpl;
            this.currentHolder.addTopLevelVariable((TopLevelVariableElement)((Object)elementImpl));
            ((SimpleIdentifier)object2).setStaticElement(fieldElementImpl);
        }
        fieldElementImpl.setConst(bl2);
        fieldElementImpl.setFinal(bl3);
        if (bl) {
            object2 = new ElementHolder();
            boolean bl5 = this.inFieldContext;
            this.inFieldContext = false;
            try {
                this.visit((ElementHolder)object2, variableDeclaration.getInitializer());
            }
            finally {
                this.inFieldContext = bl5;
            }
            object = new FunctionElementImpl(variableDeclaration.getInitializer().getBeginToken().getOffset());
            ((ExecutableElementImpl)object).setFunctions(((ElementHolder)object2).getFunctions());
            ((ExecutableElementImpl)object).setLabels(((ElementHolder)object2).getLabels());
            ((ExecutableElementImpl)object).setLocalVariables(((ElementHolder)object2).getLocalVariables());
            ((ElementImpl)object).setSynthetic(true);
            fieldElementImpl.setInitializer((FunctionElement)object);
            ((ElementHolder)object2).validate();
        }
        if (fieldElementImpl instanceof PropertyInducingElementImpl) {
            object2 = fieldElementImpl;
            if (this.inFieldContext) {
                ((FieldElementImpl)object2).setStatic(this.matches(((FieldDeclaration)variableDeclaration.getParent().getParent()).getStaticKeyword(), Keyword.STATIC));
            }
            elementImpl = new PropertyAccessorElementImpl((PropertyInducingElementImpl)object2);
            ((PropertyAccessorElementImpl)elementImpl).setGetter(true);
            ((PropertyAccessorElementImpl)elementImpl).setStatic(object2.isStatic());
            this.currentHolder.addAccessor((PropertyAccessorElement)((Object)elementImpl));
            ((PropertyInducingElementImpl)object2).setGetter((PropertyAccessorElement)((Object)elementImpl));
            if (!bl3) {
                object = new PropertyAccessorElementImpl((PropertyInducingElementImpl)object2);
                ((PropertyAccessorElementImpl)object).setSetter(true);
                ((PropertyAccessorElementImpl)object).setStatic(object2.isStatic());
                ParameterElementImpl parameterElementImpl = new ParameterElementImpl("_" + ((ElementImpl)object2).getName(), ((ElementImpl)object2).getNameOffset());
                parameterElementImpl.setSynthetic(true);
                parameterElementImpl.setParameterKind(ParameterKind.REQUIRED);
                ((ExecutableElementImpl)object).setParameters(new ParameterElement[]{parameterElementImpl});
                this.currentHolder.addAccessor((PropertyAccessorElement)object);
                ((PropertyInducingElementImpl)object2).setSetter((PropertyAccessorElement)object);
            }
        }
        return null;
    }

    private void buildFieldMap(FieldElement[] fieldElementArray) {
        this.fieldMap = new HashMap();
        for (FieldElement fieldElement : fieldElementArray) {
            this.fieldMap.put(fieldElement.getName(), fieldElement);
        }
    }

    private ConstructorElement[] createDefaultConstructors(InterfaceTypeImpl interfaceTypeImpl) {
        ConstructorElementImpl constructorElementImpl = new ConstructorElementImpl(null);
        constructorElementImpl.setSynthetic(true);
        constructorElementImpl.setReturnType(interfaceTypeImpl);
        FunctionTypeImpl functionTypeImpl = new FunctionTypeImpl(constructorElementImpl);
        this.functionTypesToFix.add(functionTypeImpl);
        constructorElementImpl.setType(functionTypeImpl);
        return new ConstructorElement[]{constructorElementImpl};
    }

    private Type[] createTypeParameterTypes(TypeParameterElement[] typeParameterElementArray) {
        int n = typeParameterElementArray.length;
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            TypeParameterElementImpl typeParameterElementImpl = (TypeParameterElementImpl)typeParameterElementArray[i];
            TypeParameterTypeImpl typeParameterTypeImpl = new TypeParameterTypeImpl(typeParameterElementImpl);
            typeParameterElementImpl.setType(typeParameterTypeImpl);
            typeArray[i] = typeParameterTypeImpl;
        }
        return typeArray;
    }

    private FunctionBody getFunctionBody(FormalParameter formalParameter) {
        for (AstNode astNode = formalParameter.getParent(); astNode != null; astNode = astNode.getParent()) {
            if (astNode instanceof ConstructorDeclaration) {
                return ((ConstructorDeclaration)astNode).getBody();
            }
            if (astNode instanceof FunctionExpression) {
                return ((FunctionExpression)astNode).getBody();
            }
            if (!(astNode instanceof MethodDeclaration)) continue;
            return ((MethodDeclaration)astNode).getBody();
        }
        return null;
    }

    private boolean matches(Token token, Keyword keyword) {
        return token != null && token.getType() == TokenType.KEYWORD && ((KeywordToken)token).getKeyword() == keyword;
    }

    private void setParameterVisibleRange(FormalParameter formalParameter, ParameterElementImpl parameterElementImpl) {
        FunctionBody functionBody = this.getFunctionBody(formalParameter);
        if (functionBody != null) {
            parameterElementImpl.setVisibleRange(functionBody.getOffset(), functionBody.getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visit(ElementHolder elementHolder, AstNode astNode) {
        if (astNode != null) {
            ElementHolder elementHolder2 = this.currentHolder;
            this.currentHolder = elementHolder;
            try {
                astNode.accept(this);
            }
            finally {
                this.currentHolder = elementHolder2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitChildren(ElementHolder elementHolder, AstNode astNode) {
        if (astNode != null) {
            ElementHolder elementHolder2 = this.currentHolder;
            this.currentHolder = elementHolder;
            try {
                astNode.visitChildren(this);
            }
            finally {
                this.currentHolder = elementHolder2;
            }
        }
    }
}

