/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.internal.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassMember;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.CompilationUnitMember;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.visitor.RecursiveAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.ConstructorElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.element.PropertyAccessorElement;
import com.google.dart.engine.element.ToolkitObjectElement;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.element.angular.AngularComponentElement;
import com.google.dart.engine.element.angular.AngularDirectiveElement;
import com.google.dart.engine.element.angular.AngularElement;
import com.google.dart.engine.element.angular.AngularHasSelectorElement;
import com.google.dart.engine.element.angular.AngularPropertyElement;
import com.google.dart.engine.element.angular.AngularPropertyKind;
import com.google.dart.engine.element.angular.AngularScopePropertyElement;
import com.google.dart.engine.element.angular.AngularSelectorElement;
import com.google.dart.engine.element.angular.AngularViewElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.error.AngularCode;
import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.internal.element.ClassElementImpl;
import com.google.dart.engine.internal.element.CompilationUnitElementImpl;
import com.google.dart.engine.internal.element.angular.AngularComponentElementImpl;
import com.google.dart.engine.internal.element.angular.AngularControllerElementImpl;
import com.google.dart.engine.internal.element.angular.AngularDirectiveElementImpl;
import com.google.dart.engine.internal.element.angular.AngularFilterElementImpl;
import com.google.dart.engine.internal.element.angular.AngularHasClassSelectorElementImpl;
import com.google.dart.engine.internal.element.angular.AngularPropertyElementImpl;
import com.google.dart.engine.internal.element.angular.AngularScopePropertyElementImpl;
import com.google.dart.engine.internal.element.angular.AngularTagSelectorElementImpl;
import com.google.dart.engine.internal.element.angular.AngularViewElementImpl;
import com.google.dart.engine.internal.element.angular.HasAttributeSelectorElementImpl;
import com.google.dart.engine.internal.element.angular.IsTagHasAttributeSelectorElementImpl;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.type.InterfaceType;
import com.google.dart.engine.type.Type;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import com.google.dart.engine.utilities.general.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class AngularCompilationUnitBuilder {
    private static final String NG_COMPONENT = "NgComponent";
    private static final String NG_CONTROLLER = "NgController";
    private static final String NG_DIRECTIVE = "NgDirective";
    private static final String NG_FILTER = "NgFilter";
    private static final String NAME = "name";
    private static final String SELECTOR = "selector";
    private static final String PUBLISH_AS = "publishAs";
    private static final String TEMPLATE_URL = "templateUrl";
    private static final String CSS_URL = "cssUrl";
    private static final String NG_ATTR = "NgAttr";
    private static final String NG_CALLBACK = "NgCallback";
    private static final String NG_ONE_WAY = "NgOneWay";
    private static final String NG_ONE_WAY_ONE_TIME = "NgOneWayOneTime";
    private static final String NG_TWO_WAY = "NgTwoWay";
    private final AnalysisErrorListener errorListener;
    private final Source source;
    private CompilationUnit unit;
    private ClassDeclaration classDeclaration;
    private ClassElementImpl classElement;
    private List<ToolkitObjectElement> classToolkitObjects = Lists.newArrayList();
    private Annotation annotation;

    public static Element getElement(AstNode astNode, int n) {
        if (!(astNode instanceof SimpleStringLiteral)) {
            return null;
        }
        SimpleStringLiteral simpleStringLiteral = (SimpleStringLiteral)astNode;
        Object object = simpleStringLiteral.getToolkitElement();
        if (object instanceof AngularElement) {
            return object;
        }
        object = astNode.getAncestor(ClassDeclaration.class);
        if (object == null) {
            return null;
        }
        ClassElement classElement = ((ClassDeclaration)object).getElement();
        if (classElement == null) {
            return null;
        }
        for (ToolkitObjectElement toolkitObjectElement : classElement.getToolkitObjects()) {
            Object object2;
            AngularSelectorElement angularSelectorElement;
            AngularPropertyElement[] angularPropertyElementArray = AngularPropertyElement.EMPTY_ARRAY;
            if (toolkitObjectElement instanceof AngularElement && AngularCompilationUnitBuilder.isNameCoveredByLiteral(toolkitObjectElement, astNode)) {
                return toolkitObjectElement;
            }
            if (toolkitObjectElement instanceof AngularHasSelectorElement && AngularCompilationUnitBuilder.isNameCoveredByLiteral(angularSelectorElement = (object2 = (AngularPropertyElement[])toolkitObjectElement).getSelector(), astNode)) {
                return angularSelectorElement;
            }
            if (toolkitObjectElement instanceof AngularComponentElement) {
                object2 = (AngularComponentElement)toolkitObjectElement;
                angularPropertyElementArray = object2.getProperties();
            }
            if (toolkitObjectElement instanceof AngularDirectiveElement) {
                object2 = (AngularDirectiveElement)toolkitObjectElement;
                angularPropertyElementArray = object2.getProperties();
            }
            object2 = angularPropertyElementArray;
            int n2 = ((AngularPropertyElement[])object2).length;
            for (int i = 0; i < n2; ++i) {
                Object object3 = object2[i];
                if (AngularCompilationUnitBuilder.isNameCoveredByLiteral((Element)object3, astNode)) {
                    return object3;
                }
                FieldElement fieldElement = object3.getField();
                if (fieldElement == null) continue;
                int n3 = object3.getFieldNameOffset();
                int n4 = n3 + fieldElement.getName().length();
                if (astNode.getOffset() > n3 || n4 >= astNode.getEnd()) continue;
                return fieldElement;
            }
        }
        return null;
    }

    @VisibleForTesting
    public static AngularSelectorElement parseSelector(int n, String string) {
        int n2;
        if (StringUtilities.startsWithChar(string, 91) && StringUtilities.endsWithChar(string, 93)) {
            int n3 = n + 1;
            String string2 = string.substring(1, string.length() - 1);
            return new HasAttributeSelectorElementImpl(string2, n3);
        }
        if (StringUtilities.startsWithChar(string, 46)) {
            int n4 = n + 1;
            String string3 = string.substring(1, string.length());
            return new AngularHasClassSelectorElementImpl(string3, n4);
        }
        if (StringUtilities.endsWithChar(string, 93) && (n2 = StringUtilities.indexOf1(string, 0, 91)) != -1) {
            String string4 = string.substring(0, n2);
            String string5 = string.substring(n2 + 1, string.length() - 1);
            if (StringUtilities.isTagName(string4)) {
                return new IsTagHasAttributeSelectorElementImpl(string4, string5);
            }
        }
        if (StringUtilities.isTagName(string)) {
            return new AngularTagSelectorElementImpl(string, n);
        }
        return null;
    }

    private static FieldElement getOnlyFieldElement(FieldDeclaration fieldDeclaration) {
        NodeList<VariableDeclaration> nodeList = fieldDeclaration.getFields().getVariables();
        return (FieldElement)((VariableDeclaration)nodeList.get(0)).getElement();
    }

    private static SimpleStringLiteral getOnlySimpleStringLiteralArgument(Annotation annotation) {
        Expression expression;
        NodeList<Expression> nodeList;
        SimpleStringLiteral simpleStringLiteral = null;
        ArgumentList argumentList = annotation.getArguments();
        if (argumentList != null && (nodeList = argumentList.getArguments()).size() == 1 && (expression = (Expression)nodeList.get(0)) instanceof SimpleStringLiteral) {
            simpleStringLiteral = (SimpleStringLiteral)expression;
        }
        return simpleStringLiteral;
    }

    private static boolean isNameCoveredByLiteral(Element element, AstNode astNode) {
        String string;
        if (element != null && (string = element.getName()) != null) {
            int n = element.getNameOffset();
            int n2 = n + string.length();
            return astNode.getOffset() <= n && n2 < astNode.getEnd();
        }
        return false;
    }

    private static AngularSelectorElement parseSelectorFromString(SimpleStringLiteral simpleStringLiteral) {
        int n = simpleStringLiteral.getValueOffset();
        String string = simpleStringLiteral.getStringValue();
        return AngularCompilationUnitBuilder.parseSelector(n, string);
    }

    public AngularCompilationUnitBuilder(AnalysisErrorListener analysisErrorListener, Source source, CompilationUnit compilationUnit) {
        this.errorListener = analysisErrorListener;
        this.source = source;
        this.unit = compilationUnit;
    }

    public void build() {
        this.parseViews();
        for (CompilationUnitMember compilationUnitMember : this.unit.getDeclarations()) {
            if (!(compilationUnitMember instanceof ClassDeclaration)) continue;
            this.classDeclaration = (ClassDeclaration)compilationUnitMember;
            this.classElement = (ClassElementImpl)this.classDeclaration.getElement();
            this.classToolkitObjects.clear();
            NodeList<Annotation> nodeList = this.classDeclaration.getMetadata();
            for (Annotation annotation : nodeList) {
                if (annotation.getArguments() == null) continue;
                this.annotation = annotation;
                if (this.isAngularAnnotation(annotation, NG_FILTER)) {
                    this.parseNgFilter();
                    continue;
                }
                if (this.isAngularAnnotation(annotation, NG_COMPONENT)) {
                    this.parseNgComponent();
                    continue;
                }
                if (this.isAngularAnnotation(annotation, NG_CONTROLLER)) {
                    this.parseNgController();
                    continue;
                }
                if (!this.isAngularAnnotation(annotation, NG_DIRECTIVE)) continue;
                this.parseNgDirective();
            }
            if (this.classToolkitObjects.isEmpty()) continue;
            List<ToolkitObjectElement> list = this.classToolkitObjects;
            this.classElement.setToolkitObjects(list.toArray(new ToolkitObjectElement[list.size()]));
        }
    }

    private Expression getArgument(String string) {
        NodeList<Expression> nodeList = this.annotation.getArguments().getArguments();
        for (Expression expression : nodeList) {
            NamedExpression namedExpression;
            String string2;
            if (!(expression instanceof NamedExpression) || !string.equals(string2 = (namedExpression = (NamedExpression)expression).getName().getLabel().getName())) continue;
            return namedExpression.getExpression();
        }
        return null;
    }

    private String getStringArgument(String string) {
        return this.getStringLiteral(string).getValue();
    }

    private int getStringArgumentOffset(String string) {
        Expression expression = this.getArgument(string);
        return ((SimpleStringLiteral)expression).getValueOffset();
    }

    private SimpleStringLiteral getStringLiteral(String string) {
        Expression expression = this.getArgument(string);
        return (SimpleStringLiteral)expression;
    }

    private boolean hasStringArgument(String string) {
        Expression expression = this.getArgument(string);
        return expression instanceof SimpleStringLiteral;
    }

    private boolean isAngularAnnotation(Annotation annotation, String string) {
        Element element = annotation.getElement();
        if (element instanceof ConstructorElement) {
            ConstructorElement constructorElement = (ConstructorElement)element;
            return constructorElement.getReturnType().getDisplayName().equals(string);
        }
        return false;
    }

    private void parseNgComponent() {
        Object object;
        boolean bl = true;
        String string = null;
        int n = -1;
        if (this.hasStringArgument(PUBLISH_AS)) {
            string = this.getStringArgument(PUBLISH_AS);
            n = this.getStringArgumentOffset(PUBLISH_AS);
        }
        AngularSelectorElement angularSelectorElement = null;
        if (!this.hasStringArgument(SELECTOR)) {
            this.reportErrorForAnnotation(AngularCode.MISSING_SELECTOR, new Object[0]);
            bl = false;
        } else {
            object = this.getStringLiteral(SELECTOR);
            angularSelectorElement = AngularCompilationUnitBuilder.parseSelectorFromString((SimpleStringLiteral)object);
            if (angularSelectorElement == null) {
                this.reportErrorForArgument(SELECTOR, AngularCode.CANNOT_PARSE_SELECTOR, object);
                bl = false;
            }
        }
        object = null;
        int n2 = -1;
        if (this.hasStringArgument(TEMPLATE_URL)) {
            object = this.getStringArgument(TEMPLATE_URL);
            n2 = this.getStringArgumentOffset(TEMPLATE_URL);
        }
        String string2 = null;
        int n3 = -1;
        if (this.hasStringArgument(CSS_URL)) {
            string2 = this.getStringArgument(CSS_URL);
            n3 = this.getStringArgumentOffset(CSS_URL);
        }
        if (bl) {
            AngularComponentElementImpl angularComponentElementImpl = new AngularComponentElementImpl(string, n, this.annotation.getOffset());
            angularComponentElementImpl.setSelector(angularSelectorElement);
            angularComponentElementImpl.setTemplateUri((String)object);
            angularComponentElementImpl.setTemplateUriOffset(n2);
            angularComponentElementImpl.setStyleUri(string2);
            angularComponentElementImpl.setStyleUriOffset(n3);
            angularComponentElementImpl.setProperties(this.parseNgComponentProperties());
            angularComponentElementImpl.setScopeProperties(this.parseScopeProperties());
            this.classToolkitObjects.add(angularComponentElementImpl);
        }
    }

    private AngularPropertyElement[] parseNgComponentProperties() {
        ArrayList<AngularPropertyElement> arrayList = Lists.newArrayList();
        this.parseNgComponentProperties_fromMap(arrayList);
        this.parseNgComponentProperties_fromFields(arrayList);
        return arrayList.toArray(new AngularPropertyElement[arrayList.size()]);
    }

    private void parseNgComponentProperties_fromFields(List<AngularPropertyElement> list) {
        NodeList<ClassMember> nodeList = this.classDeclaration.getMembers();
        for (ClassMember classMember : nodeList) {
            if (!(classMember instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)classMember;
            for (Annotation annotation : fieldDeclaration.getMetadata()) {
                AngularPropertyKind angularPropertyKind = null;
                if (this.isAngularAnnotation(annotation, NG_ATTR)) {
                    angularPropertyKind = AngularPropertyKind.ATTR;
                } else if (this.isAngularAnnotation(annotation, NG_CALLBACK)) {
                    angularPropertyKind = AngularPropertyKind.CALLBACK;
                } else if (this.isAngularAnnotation(annotation, NG_ONE_WAY)) {
                    angularPropertyKind = AngularPropertyKind.ONE_WAY;
                } else if (this.isAngularAnnotation(annotation, NG_ONE_WAY_ONE_TIME)) {
                    angularPropertyKind = AngularPropertyKind.ONE_WAY_ONE_TIME;
                } else if (this.isAngularAnnotation(annotation, NG_TWO_WAY)) {
                    angularPropertyKind = AngularPropertyKind.TWO_WAY;
                }
                if (angularPropertyKind == null) continue;
                SimpleStringLiteral simpleStringLiteral = AngularCompilationUnitBuilder.getOnlySimpleStringLiteralArgument(annotation);
                FieldElement fieldElement = AngularCompilationUnitBuilder.getOnlyFieldElement(fieldDeclaration);
                if (simpleStringLiteral == null || fieldElement == null) continue;
                AngularPropertyElementImpl angularPropertyElementImpl = new AngularPropertyElementImpl(simpleStringLiteral.getValue(), simpleStringLiteral.getValueOffset());
                angularPropertyElementImpl.setField(fieldElement);
                angularPropertyElementImpl.setPropertyKind(angularPropertyKind);
                list.add(angularPropertyElementImpl);
            }
        }
    }

    private void parseNgComponentProperties_fromMap(List<AngularPropertyElement> list) {
        Expression expression = this.getArgument("map");
        if (expression == null) {
            return;
        }
        if (!(expression instanceof MapLiteral)) {
            this.reportErrorForNode(AngularCode.INVALID_PROPERTY_MAP, expression, new Object[0]);
            return;
        }
        MapLiteral mapLiteral = (MapLiteral)expression;
        for (MapLiteralEntry mapLiteralEntry : mapLiteral.getEntries()) {
            int n;
            AngularPropertyKind angularPropertyKind;
            Expression expression2 = mapLiteralEntry.getKey();
            if (!(expression2 instanceof SimpleStringLiteral)) {
                this.reportErrorForNode(AngularCode.INVALID_PROPERTY_NAME, expression2, new Object[0]);
                continue;
            }
            SimpleStringLiteral simpleStringLiteral = (SimpleStringLiteral)expression2;
            String string = simpleStringLiteral.getValue();
            int n2 = simpleStringLiteral.getValueOffset();
            Expression expression3 = mapLiteralEntry.getValue();
            if (!(expression3 instanceof SimpleStringLiteral)) {
                this.reportErrorForNode(AngularCode.INVALID_PROPERTY_SPEC, expression3, new Object[0]);
                continue;
            }
            SimpleStringLiteral simpleStringLiteral2 = (SimpleStringLiteral)expression3;
            String string2 = simpleStringLiteral2.getValue();
            if (StringUtilities.startsWithChar(string2, 64)) {
                angularPropertyKind = AngularPropertyKind.ATTR;
                n = 1;
            } else if (StringUtilities.startsWithChar(string2, 38)) {
                angularPropertyKind = AngularPropertyKind.CALLBACK;
                n = 1;
            } else if (StringUtilities.startsWith3(string2, 0, 61, 62, 33)) {
                angularPropertyKind = AngularPropertyKind.ONE_WAY_ONE_TIME;
                n = 3;
            } else if (StringUtilities.startsWith2(string2, 0, 61, 62)) {
                angularPropertyKind = AngularPropertyKind.ONE_WAY;
                n = 2;
            } else if (StringUtilities.startsWith3(string2, 0, 60, 61, 62)) {
                angularPropertyKind = AngularPropertyKind.TWO_WAY;
                n = 3;
            } else {
                this.reportErrorForNode(AngularCode.INVALID_PROPERTY_KIND, simpleStringLiteral2, string2);
                continue;
            }
            String string3 = string2.substring(n);
            n += simpleStringLiteral2.getValueOffset();
            PropertyAccessorElement propertyAccessorElement = this.classElement.getType().lookUpSetter(string3, this.classElement.getLibrary());
            if (propertyAccessorElement == null) {
                this.reportErrorForOffset(AngularCode.INVALID_PROPERTY_FIELD, n, string3.length(), string3);
                continue;
            }
            FieldElement fieldElement = (FieldElement)propertyAccessorElement.getVariable();
            AngularPropertyElementImpl angularPropertyElementImpl = new AngularPropertyElementImpl(string, n2);
            angularPropertyElementImpl.setField(fieldElement);
            angularPropertyElementImpl.setPropertyKind(angularPropertyKind);
            angularPropertyElementImpl.setFieldNameOffset(n);
            list.add(angularPropertyElementImpl);
        }
    }

    private void parseNgController() {
        Object object;
        boolean bl = true;
        if (!this.hasStringArgument(PUBLISH_AS)) {
            this.reportErrorForAnnotation(AngularCode.MISSING_PUBLISH_AS, new Object[0]);
            bl = false;
        }
        AngularSelectorElement angularSelectorElement = null;
        if (!this.hasStringArgument(SELECTOR)) {
            this.reportErrorForAnnotation(AngularCode.MISSING_SELECTOR, new Object[0]);
            bl = false;
        } else {
            object = this.getStringLiteral(SELECTOR);
            angularSelectorElement = AngularCompilationUnitBuilder.parseSelectorFromString((SimpleStringLiteral)object);
            if (angularSelectorElement == null) {
                this.reportErrorForArgument(SELECTOR, AngularCode.CANNOT_PARSE_SELECTOR, object);
                bl = false;
            }
        }
        if (bl) {
            object = this.getStringArgument(PUBLISH_AS);
            int n = this.getStringArgumentOffset(PUBLISH_AS);
            AngularControllerElementImpl angularControllerElementImpl = new AngularControllerElementImpl((String)object, n);
            angularControllerElementImpl.setSelector(angularSelectorElement);
            this.classToolkitObjects.add(angularControllerElementImpl);
        }
    }

    private void parseNgDirective() {
        boolean bl = true;
        AngularSelectorElement angularSelectorElement = null;
        if (!this.hasStringArgument(SELECTOR)) {
            this.reportErrorForAnnotation(AngularCode.MISSING_SELECTOR, new Object[0]);
            bl = false;
        } else {
            SimpleStringLiteral simpleStringLiteral = this.getStringLiteral(SELECTOR);
            angularSelectorElement = AngularCompilationUnitBuilder.parseSelectorFromString(simpleStringLiteral);
            if (angularSelectorElement == null) {
                this.reportErrorForArgument(SELECTOR, AngularCode.CANNOT_PARSE_SELECTOR, simpleStringLiteral);
                bl = false;
            }
        }
        if (bl) {
            int n = this.annotation.getOffset();
            AngularDirectiveElementImpl angularDirectiveElementImpl = new AngularDirectiveElementImpl(n);
            angularDirectiveElementImpl.setSelector(angularSelectorElement);
            angularDirectiveElementImpl.setProperties(this.parseNgComponentProperties());
            this.classToolkitObjects.add(angularDirectiveElementImpl);
        }
    }

    private void parseNgFilter() {
        boolean bl = true;
        if (!this.hasStringArgument(NAME)) {
            this.reportErrorForAnnotation(AngularCode.MISSING_NAME, new Object[0]);
            bl = false;
        }
        if (bl) {
            String string = this.getStringArgument(NAME);
            int n = this.getStringArgumentOffset(NAME);
            this.classToolkitObjects.add(new AngularFilterElementImpl(string, n));
        }
    }

    private AngularScopePropertyElement[] parseScopeProperties() {
        final ArrayList arrayList = Lists.newArrayList();
        this.classDeclaration.accept(new RecursiveAstVisitor<Void>(){

            @Override
            public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
                this.addProperty(assignmentExpression);
                return (Void)super.visitAssignmentExpression(assignmentExpression);
            }

            private void addProperty(AssignmentExpression assignmentExpression) {
                SimpleStringLiteral simpleStringLiteral = this.getNameNode(assignmentExpression.getLeftHandSide());
                if (simpleStringLiteral == null) {
                    return;
                }
                String string = simpleStringLiteral.getStringValue();
                if (this.hasPropertyWithName(string)) {
                    return;
                }
                int n = simpleStringLiteral.getValueOffset();
                AngularScopePropertyElementImpl angularScopePropertyElementImpl = new AngularScopePropertyElementImpl(string, n, assignmentExpression.getRightHandSide().getBestType());
                simpleStringLiteral.setToolkitElement(angularScopePropertyElementImpl);
                arrayList.add(angularScopePropertyElementImpl);
            }

            private SimpleStringLiteral getNameNode(Expression expression) {
                if (expression instanceof IndexExpression) {
                    IndexExpression indexExpression = (IndexExpression)expression;
                    Expression expression2 = indexExpression.getTarget();
                    Expression expression3 = indexExpression.getIndex();
                    if (expression3 instanceof SimpleStringLiteral && this.isContext(expression2)) {
                        return (SimpleStringLiteral)expression3;
                    }
                }
                return null;
            }

            private boolean hasPropertyWithName(String string) {
                for (AngularScopePropertyElement angularScopePropertyElement : arrayList) {
                    if (!angularScopePropertyElement.getName().equals(string)) continue;
                    return true;
                }
                return false;
            }

            private boolean isContext(Expression expression) {
                if (expression instanceof PrefixedIdentifier) {
                    PrefixedIdentifier prefixedIdentifier = (PrefixedIdentifier)expression;
                    SimpleIdentifier simpleIdentifier = prefixedIdentifier.getPrefix();
                    SimpleIdentifier simpleIdentifier2 = prefixedIdentifier.getIdentifier();
                    return ObjectUtilities.equals(simpleIdentifier2.getName(), "context") && this.isScope(simpleIdentifier);
                }
                return false;
            }

            private boolean isScope(Expression expression) {
                Type type;
                if (expression != null && (type = expression.getBestType()) instanceof InterfaceType) {
                    InterfaceType interfaceType = (InterfaceType)type;
                    return interfaceType.getName().equals("Scope");
                }
                return false;
            }
        });
        return arrayList.toArray(new AngularScopePropertyElement[arrayList.size()]);
    }

    private void parseViews() {
        final ArrayList arrayList = Lists.newArrayList();
        this.unit.accept(new RecursiveAstVisitor<Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocation methodInvocation) {
                this.addView(methodInvocation);
                return (Void)super.visitMethodInvocation(methodInvocation);
            }

            private void addView(MethodInvocation methodInvocation) {
                NodeList<Expression> nodeList = methodInvocation.getArgumentList().getArguments();
                if (nodeList.size() != 1) {
                    return;
                }
                Expression expression = (Expression)nodeList.get(0);
                if (!(expression instanceof SimpleStringLiteral)) {
                    return;
                }
                SimpleStringLiteral simpleStringLiteral = (SimpleStringLiteral)expression;
                if (methodInvocation.getRealTarget() != null) {
                    return;
                }
                if (!this.isViewFactory(methodInvocation.getMethodName())) {
                    return;
                }
                String string = simpleStringLiteral.getStringValue();
                int n = simpleStringLiteral.getValueOffset();
                arrayList.add(new AngularViewElementImpl(string, n));
            }

            private boolean isViewFactory(Expression expression) {
                VariableElement variableElement;
                Type type;
                SimpleIdentifier simpleIdentifier;
                Element element;
                if (expression instanceof SimpleIdentifier && (element = (simpleIdentifier = (SimpleIdentifier)expression).getStaticElement()) instanceof VariableElement && (type = (variableElement = (VariableElement)element).getType()) instanceof InterfaceType) {
                    InterfaceType interfaceType = (InterfaceType)type;
                    return interfaceType.getName().equals("ViewFactory");
                }
                return false;
            }
        });
        if (!arrayList.isEmpty()) {
            AngularViewElement[] angularViewElementArray = arrayList.toArray(new AngularViewElement[arrayList.size()]);
            ((CompilationUnitElementImpl)this.unit.getElement()).setAngularViews(angularViewElementArray);
        }
    }

    private void reportErrorForAnnotation(ErrorCode errorCode, Object ... objectArray) {
        this.reportErrorForNode(errorCode, this.annotation, objectArray);
    }

    private void reportErrorForArgument(String string, ErrorCode errorCode, Object ... objectArray) {
        Expression expression = this.getArgument(string);
        this.reportErrorForNode(errorCode, expression, objectArray);
    }

    private void reportErrorForNode(ErrorCode errorCode, AstNode astNode, Object ... objectArray) {
        int n = astNode.getOffset();
        int n2 = astNode.getLength();
        this.reportErrorForOffset(errorCode, n, n2, objectArray);
    }

    private void reportErrorForOffset(ErrorCode errorCode, int n, int n2, Object ... objectArray) {
        this.errorListener.onError(new AnalysisError(this.source, n, n2, errorCode, objectArray));
    }
}

