/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.scanner;

import com.google.dart.engine.html.scanner.TokenType;
import com.google.dart.engine.utilities.general.StringUtilities;

public class Token {
    private int offset;
    private Token previous;
    private Token next;
    private final TokenType type;
    private final String value;

    public Token(TokenType tokenType, int n) {
        this(tokenType, n, tokenType.getLexeme());
    }

    public Token(TokenType tokenType, int n, String string) {
        this.type = tokenType;
        this.value = StringUtilities.intern(string);
        this.offset = n;
    }

    public int getEnd() {
        return this.offset + this.getLength();
    }

    public int getLength() {
        return this.getLexeme().length();
    }

    public String getLexeme() {
        return this.value;
    }

    public Token getNext() {
        return this.next;
    }

    public int getOffset() {
        return this.offset;
    }

    public Token getPrevious() {
        return this.previous;
    }

    public TokenType getType() {
        return this.type;
    }

    public boolean isSynthetic() {
        return this.getLength() == 0;
    }

    public Token setNext(Token token) {
        this.next = token;
        token.setPrevious(this);
        return token;
    }

    public String toString() {
        return this.getLexeme();
    }

    private void setPrevious(Token token) {
        this.previous = token;
    }
}

