/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.scanner;

import com.google.dart.engine.html.scanner.AbstractScanner;
import com.google.dart.engine.source.Source;

public class StringScanner
extends AbstractScanner {
    private final CharSequence string;
    private final int stringLength;
    private int charOffset;

    public StringScanner(Source source, CharSequence charSequence) {
        super(source);
        this.string = charSequence;
        this.stringLength = charSequence.length();
        this.charOffset = -1;
    }

    @Override
    public int getOffset() {
        return this.charOffset;
    }

    public void setOffset(int n) {
        this.charOffset = n;
    }

    @Override
    protected int advance() {
        if (++this.charOffset < this.stringLength) {
            return this.string.charAt(this.charOffset);
        }
        this.charOffset = this.stringLength;
        return -1;
    }

    @Override
    protected String getString(int n, int n2) {
        return ((Object)this.string.subSequence(n, this.charOffset + 1 + n2)).toString();
    }

    @Override
    protected int peek() {
        if (this.charOffset + 1 < this.stringLength) {
            return this.string.charAt(this.charOffset + 1);
        }
        return -1;
    }
}

