/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.scanner;

import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.html.scanner.TokenType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.collection.IntList;
import com.google.dart.engine.utilities.general.StringUtilities;

public abstract class AbstractScanner {
    private static final String[] NO_PASS_THROUGH_ELEMENTS = new String[0];
    private final Source source;
    private Token tokens;
    private Token tail;
    private IntList lineStarts = new IntList();
    private String[] passThroughElements = NO_PASS_THROUGH_ELEMENTS;

    public AbstractScanner(Source source) {
        this.source = source;
        this.tokens = new Token(TokenType.EOF, -1);
        this.tokens.setNext(this.tokens);
        this.tail = this.tokens;
        this.recordStartOfLine();
    }

    public int[] getLineStarts() {
        return this.lineStarts.toArray();
    }

    public abstract int getOffset();

    public Source getSource() {
        return this.source;
    }

    public void setPassThroughElements(String[] stringArray) {
        this.passThroughElements = stringArray != null ? stringArray : NO_PASS_THROUGH_ELEMENTS;
    }

    public Token tokenize() {
        this.scan();
        this.appendEofToken();
        return this.firstToken();
    }

    protected abstract int advance();

    protected abstract String getString(int var1, int var2);

    protected abstract int peek();

    protected void recordStartOfLine() {
        this.lineStarts.add(this.getOffset());
    }

    private void appendEofToken() {
        Token token = new Token(TokenType.EOF, this.getOffset());
        token.setNext(token);
        this.tail = this.tail.setNext(token);
    }

    private Token emit(Token token) {
        this.tail.setNext(token);
        this.tail = token;
        return token;
    }

    private Token emitWithOffset(TokenType tokenType, int n) {
        return this.emit(new Token(tokenType, n));
    }

    private Token emitWithOffsetAndLength(TokenType tokenType, int n, int n2) {
        return this.emit(new Token(tokenType, n, this.getString(n, n2)));
    }

    private Token firstToken() {
        return this.tokens.getNext();
    }

    private int recordStartOfLineAndAdvance(int n) {
        if (n == 13) {
            n = this.advance();
            if (n == 10) {
                n = this.advance();
            }
            this.recordStartOfLine();
        } else if (n == 10) {
            n = this.advance();
            this.recordStartOfLine();
        } else {
            n = this.advance();
        }
        return n;
    }

    private void scan() {
        boolean bl = false;
        String string = null;
        int n = this.advance();
        block0: while (n >= 0) {
            int n2;
            int n3 = this.getOffset();
            if (n == 60) {
                n = this.advance();
                if (n == 33) {
                    n = this.advance();
                    if (n == 45 && this.peek() == 45) {
                        n = this.advance();
                        n2 = 1;
                        while (n >= 0) {
                            if (n == 45) {
                                ++n2;
                            } else {
                                if (n == 62 && n2 >= 2) {
                                    n = this.advance();
                                    break;
                                }
                                n2 = 0;
                            }
                            n = this.recordStartOfLineAndAdvance(n);
                        }
                        this.emitWithOffsetAndLength(TokenType.COMMENT, n3, -1);
                        if (this.tail.getLength() >= 7) continue;
                    }
                    while (n >= 0) {
                        if (n == 62) {
                            n = this.advance();
                            break;
                        }
                        n = this.recordStartOfLineAndAdvance(n);
                    }
                    this.emitWithOffsetAndLength(TokenType.DECLARATION, n3, -1);
                    if (StringUtilities.endsWithChar(this.tail.getLexeme(), 62)) continue;
                    continue;
                }
                if (n == 63) {
                    while (n >= 0) {
                        if (n == 63) {
                            n = this.advance();
                            if (n != 62) continue;
                            n = this.advance();
                            break;
                        }
                        n = this.recordStartOfLineAndAdvance(n);
                    }
                    this.emitWithOffsetAndLength(TokenType.DIRECTIVE, n3, -1);
                    if (this.tail.getLength() >= 4) continue;
                    continue;
                }
                if (n == 47) {
                    this.emitWithOffset(TokenType.LT_SLASH, n3);
                    bl = true;
                    n = this.advance();
                    continue;
                }
                bl = true;
                this.emitWithOffset(TokenType.LT, n3);
                while (Character.isWhitespace(n)) {
                    n = this.recordStartOfLineAndAdvance(n);
                }
                if (!Character.isLetterOrDigit(n)) continue;
                n2 = this.getOffset();
                n = this.advance();
                while (Character.isLetterOrDigit(n) || n == 45 || n == 95) {
                    n = this.advance();
                }
                this.emitWithOffsetAndLength(TokenType.TAG, n2, -1);
                String string2 = this.tail.getLexeme();
                for (String string3 : this.passThroughElements) {
                    if (!string3.equals(string2)) continue;
                    string = "</" + string3 + ">";
                    continue block0;
                }
                continue;
            }
            if (n == 62) {
                this.emitWithOffset(TokenType.GT, n3);
                bl = false;
                n = this.advance();
                if (string == null) continue;
                n2 = 0;
                int n4 = string.length();
                int n5 = string.charAt(0);
                int n6 = 0;
                int n7 = n5;
                while (n >= 0) {
                    if (n == n7) {
                        if (++n6 == n4) {
                            n2 = 1;
                            break;
                        }
                        n7 = string.charAt(n6);
                    } else if (n == n5) {
                        n6 = 1;
                        n7 = string.charAt(1);
                    } else {
                        n6 = 0;
                        n7 = n5;
                    }
                    n = this.recordStartOfLineAndAdvance(n);
                }
                if (n3 + 1 < this.getOffset()) {
                    if (n2 != 0) {
                        this.emitWithOffsetAndLength(TokenType.TEXT, n3 + 1, -n4);
                        this.emitWithOffset(TokenType.LT_SLASH, this.getOffset() - n4 + 1);
                        this.emitWithOffsetAndLength(TokenType.TAG, this.getOffset() - n4 + 3, -1);
                    } else {
                        this.emitWithOffsetAndLength(TokenType.TEXT, n3 + 1, -1);
                    }
                }
                string = null;
                continue;
            }
            if (n == 47 && this.peek() == 62) {
                this.advance();
                this.emitWithOffset(TokenType.SLASH_GT, n3);
                bl = false;
                n = this.advance();
                continue;
            }
            if (!bl) {
                n = this.recordStartOfLineAndAdvance(n);
                while (n != 60 && n >= 0) {
                    n = this.recordStartOfLineAndAdvance(n);
                }
                this.emitWithOffsetAndLength(TokenType.TEXT, n3, -1);
                continue;
            }
            if (n == 34 || n == 39) {
                n2 = n;
                n = this.advance();
                while (n >= 0) {
                    if (n == n2) {
                        n = this.advance();
                        break;
                    }
                    n = this.recordStartOfLineAndAdvance(n);
                }
                this.emitWithOffsetAndLength(TokenType.STRING, n3, -1);
                continue;
            }
            if (n == 61) {
                this.emitWithOffset(TokenType.EQ, n3);
                n = this.advance();
                continue;
            }
            if (Character.isWhitespace(n)) {
                while (Character.isWhitespace(n = this.recordStartOfLineAndAdvance(n))) {
                }
                continue;
            }
            if (Character.isLetterOrDigit(n)) {
                n = this.advance();
                while (Character.isLetterOrDigit(n) || n == 45 || n == 95) {
                    n = this.advance();
                }
                this.emitWithOffsetAndLength(TokenType.TAG, n3, -1);
                continue;
            }
            this.emitWithOffsetAndLength(TokenType.TEXT, n3, 0);
            n = this.advance();
        }
    }
}

