/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.parser;

import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.html.scanner.TokenType;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;
import java.util.List;

public class XmlParser {
    private final Source source;
    private Token currentToken;

    public XmlParser(Source source) {
        this.source = source;
    }

    public Source getSource() {
        return this.source;
    }

    protected XmlAttributeNode createAttributeNode(Token token, Token token2, Token token3) {
        return new XmlAttributeNode(token, token2, token3);
    }

    protected XmlTagNode createTagNode(Token token, Token token2, List<XmlAttributeNode> list, Token token3, List<XmlTagNode> list2, Token token4, Token token5, Token token6) {
        return new XmlTagNode(token, token2, list, token3, list2, token4, token5, token6);
    }

    protected boolean isSelfClosing(Token token) {
        return false;
    }

    protected List<XmlTagNode> parseTopTagNodes(Token token) {
        this.currentToken = token;
        ArrayList<XmlTagNode> arrayList = new ArrayList<XmlTagNode>();
        TokenType tokenType = this.currentToken.getType();
        while (tokenType != TokenType.EOF) {
            if (tokenType == TokenType.LT) {
                arrayList.add(this.parseTagNode());
            } else if (tokenType == TokenType.DECLARATION || tokenType == TokenType.DIRECTIVE || tokenType == TokenType.COMMENT) {
                this.currentToken = this.currentToken.getNext();
            } else {
                this.reportUnexpectedToken();
                this.currentToken = this.currentToken.getNext();
            }
            tokenType = this.currentToken.getType();
        }
        return arrayList;
    }

    Token getCurrentToken() {
        return this.currentToken;
    }

    private Token insertSyntheticToken(TokenType tokenType) {
        Token token = new Token(tokenType, this.currentToken.getOffset(), "");
        this.currentToken.getPrevious().setNext(token);
        token.setNext(this.currentToken);
        return token;
    }

    private XmlAttributeNode parseAttribute() {
        Token token;
        Token token2;
        Token token3 = this.currentToken;
        this.currentToken = this.currentToken.getNext();
        if (this.currentToken.getType() == TokenType.EQ) {
            token2 = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token2 = this.insertSyntheticToken(TokenType.EQ);
        }
        if (this.currentToken.getType() == TokenType.STRING) {
            token = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token = this.insertSyntheticToken(TokenType.STRING);
        }
        return this.createAttributeNode(token3, token2, token);
    }

    private List<XmlAttributeNode> parseAttributes() {
        TokenType tokenType = this.currentToken.getType();
        if (tokenType == TokenType.GT || tokenType == TokenType.SLASH_GT || tokenType == TokenType.EOF) {
            return XmlTagNode.NO_ATTRIBUTES;
        }
        ArrayList<XmlAttributeNode> arrayList = new ArrayList<XmlAttributeNode>();
        while (tokenType != TokenType.GT && tokenType != TokenType.SLASH_GT && tokenType != TokenType.EOF) {
            if (tokenType == TokenType.TAG) {
                arrayList.add(this.parseAttribute());
            } else {
                this.reportUnexpectedToken();
                this.currentToken = this.currentToken.getNext();
            }
            tokenType = this.currentToken.getType();
        }
        return arrayList;
    }

    private List<XmlTagNode> parseChildTagNodes() {
        TokenType tokenType = this.currentToken.getType();
        if (tokenType == TokenType.LT_SLASH || tokenType == TokenType.EOF) {
            return XmlTagNode.NO_TAG_NODES;
        }
        ArrayList<XmlTagNode> arrayList = new ArrayList<XmlTagNode>();
        while (tokenType != TokenType.LT_SLASH && tokenType != TokenType.EOF) {
            if (tokenType == TokenType.LT) {
                arrayList.add(this.parseTagNode());
            } else if (tokenType == TokenType.COMMENT) {
                this.currentToken = this.currentToken.getNext();
            } else {
                this.reportUnexpectedToken();
                this.currentToken = this.currentToken.getNext();
            }
            tokenType = this.currentToken.getType();
        }
        return arrayList;
    }

    private XmlTagNode parseTagNode() {
        Token token;
        Token token2;
        Token token3;
        Token token4;
        Token token5;
        Token token6 = this.currentToken;
        this.currentToken = this.currentToken.getNext();
        if (this.currentToken.getType() == TokenType.TAG) {
            token5 = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token5 = this.insertSyntheticToken(TokenType.TAG);
        }
        List<XmlAttributeNode> list = this.parseAttributes();
        if (this.currentToken.getType() == TokenType.GT || this.currentToken.getType() == TokenType.SLASH_GT) {
            token4 = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token4 = this.insertSyntheticToken(TokenType.SLASH_GT);
        }
        if (token4.getType() == TokenType.SLASH_GT || this.isSelfClosing(token5)) {
            return this.createTagNode(token6, token5, list, token4, XmlTagNode.NO_TAG_NODES, this.currentToken, null, token4);
        }
        List<XmlTagNode> list2 = this.parseChildTagNodes();
        if (this.currentToken.getType() == TokenType.LT_SLASH) {
            token3 = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token3 = this.insertSyntheticToken(TokenType.LT_SLASH);
        }
        if (this.currentToken.getType() == TokenType.TAG) {
            token2 = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token2 = this.insertSyntheticToken(TokenType.TAG);
        }
        if (this.currentToken.getType() == TokenType.GT) {
            token = this.currentToken;
            this.currentToken = this.currentToken.getNext();
        } else {
            this.reportUnexpectedToken();
            token = this.insertSyntheticToken(TokenType.GT);
        }
        return this.createTagNode(token6, token5, list, token4, list2, token3, token2, token);
    }

    private void reportUnexpectedToken() {
    }
}

