/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.parser;

import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.error.AnalysisErrorListener;
import com.google.dart.engine.html.ast.HtmlScriptTagNode;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.parser.XmlParser;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.parser.Parser;
import com.google.dart.engine.scanner.Scanner;
import com.google.dart.engine.scanner.SubSequenceReader;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HtmlParser
extends XmlParser {
    private LineInfo lineInfo;
    private AnalysisErrorListener errorListener;
    private static final String APPLICATION_DART_IN_DOUBLE_QUOTES = "\"application/dart\"";
    private static final String APPLICATION_DART_IN_SINGLE_QUOTES = "'application/dart'";
    private static final String SCRIPT = "script";
    private static final String TYPE = "type";
    public static Set<String> SELF_CLOSING = new HashSet<String>(Arrays.asList("area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "link", "meta", "param", "!"));

    public static Expression parseEmbeddedExpression(Source source, com.google.dart.engine.scanner.Token token, AnalysisErrorListener analysisErrorListener) {
        Parser parser = new Parser(source, analysisErrorListener);
        return parser.parseExpression(token);
    }

    public static com.google.dart.engine.scanner.Token scanDartSource(Source source, LineInfo lineInfo, String string, int n, AnalysisErrorListener analysisErrorListener) {
        LineInfo.Location location = lineInfo.getLocation(n);
        Scanner scanner = new Scanner(source, new SubSequenceReader(string, n), analysisErrorListener);
        scanner.setSourceStart(location.getLineNumber(), location.getColumnNumber());
        return scanner.tokenize();
    }

    public HtmlParser(Source source, AnalysisErrorListener analysisErrorListener) {
        super(source);
        this.errorListener = analysisErrorListener;
    }

    public HtmlUnit parse(Token token, LineInfo lineInfo) {
        this.lineInfo = lineInfo;
        List<XmlTagNode> list = this.parseTopTagNodes(token);
        return new HtmlUnit(token, list, this.getCurrentToken());
    }

    @Override
    protected XmlAttributeNode createAttributeNode(Token token, Token token2, Token token3) {
        return new XmlAttributeNode(token, token2, token3);
    }

    @Override
    protected XmlTagNode createTagNode(Token token, Token token2, List<XmlAttributeNode> list, Token token3, List<XmlTagNode> list2, Token token4, Token token5, Token token6) {
        if (this.isScriptNode(token2, list, list2)) {
            HtmlScriptTagNode htmlScriptTagNode = new HtmlScriptTagNode(token, token2, list, token3, list2, token4, token5, token6);
            String string = htmlScriptTagNode.getContent();
            int n = token3.getEnd();
            LineInfo.Location location = this.lineInfo.getLocation(n);
            Scanner scanner = new Scanner(this.getSource(), new SubSequenceReader(string, n), this.errorListener);
            scanner.setSourceStart(location.getLineNumber(), location.getColumnNumber());
            com.google.dart.engine.scanner.Token token7 = scanner.tokenize();
            Parser parser = new Parser(this.getSource(), this.errorListener);
            CompilationUnit compilationUnit = parser.parseCompilationUnit(token7);
            compilationUnit.setLineInfo(this.lineInfo);
            htmlScriptTagNode.setScript(compilationUnit);
            return htmlScriptTagNode;
        }
        return new XmlTagNode(token, token2, list, token3, list2, token4, token5, token6);
    }

    @Override
    protected boolean isSelfClosing(Token token) {
        return SELF_CLOSING.contains(token.getLexeme());
    }

    private boolean isScriptNode(Token token, List<XmlAttributeNode> list, List<XmlTagNode> list2) {
        if (list2.size() != 0 || !token.getLexeme().equals(SCRIPT)) {
            return false;
        }
        for (XmlAttributeNode xmlAttributeNode : list) {
            String string;
            Token token2;
            if (!xmlAttributeNode.getName().equals(TYPE) || (token2 = xmlAttributeNode.getValueToken()) == null || !(string = token2.getLexeme()).equals(APPLICATION_DART_IN_DOUBLE_QUOTES) && !string.equals(APPLICATION_DART_IN_SINGLE_QUOTES)) continue;
            return true;
        }
        return false;
    }
}

