/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast.visitor;

import com.google.dart.engine.html.ast.HtmlScriptTagNode;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.html.scanner.Token;
import java.io.PrintWriter;

public class ToSourceVisitor
implements XmlVisitor<Void> {
    private PrintWriter writer;

    public ToSourceVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    @Override
    public Void visitHtmlScriptTagNode(HtmlScriptTagNode htmlScriptTagNode) {
        return this.visitXmlTagNode(htmlScriptTagNode);
    }

    @Override
    public Void visitHtmlUnit(HtmlUnit htmlUnit) {
        for (XmlTagNode xmlTagNode : htmlUnit.getTagNodes()) {
            this.visit(xmlTagNode);
        }
        return null;
    }

    @Override
    public Void visitXmlAttributeNode(XmlAttributeNode xmlAttributeNode) {
        String string = xmlAttributeNode.getName();
        Token token = xmlAttributeNode.getValueToken();
        if (string.length() == 0) {
            this.writer.print("__");
        } else {
            this.writer.print(string);
        }
        this.writer.print("=");
        if (token == null) {
            this.writer.print("__");
        } else {
            this.writer.print(token.getLexeme());
        }
        return null;
    }

    @Override
    public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
        this.writer.print("<");
        String string = xmlTagNode.getTag();
        this.writer.print(string);
        for (XmlAttributeNode xmlNode : xmlTagNode.getAttributes()) {
            this.writer.print(" ");
            this.visit(xmlNode);
        }
        this.writer.print(xmlTagNode.getAttributeEnd().getLexeme());
        if (xmlTagNode.getClosingTag() != null) {
            for (XmlTagNode xmlTagNode2 : xmlTagNode.getTagNodes()) {
                this.visit(xmlTagNode2);
            }
            this.writer.print("</");
            this.writer.print(string);
            this.writer.print(">");
        }
        return null;
    }

    private void visit(XmlNode xmlNode) {
        if (xmlNode != null) {
            xmlNode.accept(this);
        }
    }
}

