/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast;

import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlExpression;
import com.google.dart.engine.html.ast.XmlNode;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.html.scanner.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XmlTagNode
extends XmlNode {
    public static final List<XmlAttributeNode> NO_ATTRIBUTES = Collections.unmodifiableList(new ArrayList());
    public static final List<XmlTagNode> NO_TAG_NODES = Collections.unmodifiableList(new ArrayList());
    private final Token nodeStart;
    private final Token tag;
    private List<XmlAttributeNode> attributes;
    private final Token attributeEnd;
    private final List<XmlTagNode> tagNodes;
    private final Token contentEnd;
    private final Token closingTag;
    private final Token nodeEnd;
    private XmlExpression[] expressions = XmlExpression.EMPTY_ARRAY;

    public XmlTagNode(Token token, Token token2, List<XmlAttributeNode> list, Token token3, List<XmlTagNode> list2, Token token4, Token token5, Token token6) {
        this.nodeStart = token;
        this.tag = token2;
        this.attributes = this.becomeParentOfAll(list, NO_ATTRIBUTES);
        this.attributeEnd = token3;
        this.tagNodes = this.becomeParentOfAll(list2, NO_TAG_NODES);
        this.contentEnd = token4;
        this.closingTag = token5;
        this.nodeEnd = token6;
    }

    @Override
    public <R> R accept(XmlVisitor<R> xmlVisitor) {
        return xmlVisitor.visitXmlTagNode(this);
    }

    public XmlAttributeNode getAttribute(String string) {
        for (XmlAttributeNode xmlAttributeNode : this.attributes) {
            if (!xmlAttributeNode.getName().equals(string)) continue;
            return xmlAttributeNode;
        }
        return null;
    }

    public Token getAttributeEnd() {
        return this.attributeEnd;
    }

    public List<XmlAttributeNode> getAttributes() {
        return this.attributes;
    }

    public String getAttributeText(String string) {
        XmlAttributeNode xmlAttributeNode = this.getAttribute(string);
        return xmlAttributeNode != null ? xmlAttributeNode.getText() : null;
    }

    @Override
    public Token getBeginToken() {
        return this.nodeStart;
    }

    public Token getClosingTag() {
        return this.closingTag;
    }

    public String getContent() {
        Token token = this.attributeEnd.getNext();
        if (token == this.contentEnd) {
            return "";
        }
        String string = token.getLexeme();
        if ((token = token.getNext()) == this.contentEnd) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (token != this.contentEnd) {
            stringBuilder.append(token.getLexeme());
            token = token.getNext();
        }
        return stringBuilder.toString();
    }

    public Token getContentEnd() {
        return this.contentEnd;
    }

    @Override
    public Token getEndToken() {
        if (this.nodeEnd != null) {
            return this.nodeEnd;
        }
        if (this.closingTag != null) {
            return this.closingTag;
        }
        if (this.contentEnd != null) {
            return this.contentEnd;
        }
        if (!this.tagNodes.isEmpty()) {
            return this.tagNodes.get(this.tagNodes.size() - 1).getEndToken();
        }
        if (this.attributeEnd != null) {
            return this.attributeEnd;
        }
        if (!this.attributes.isEmpty()) {
            return this.attributes.get(this.attributes.size() - 1).getEndToken();
        }
        return this.tag;
    }

    public XmlExpression[] getExpressions() {
        return this.expressions;
    }

    public Token getNodeEnd() {
        return this.nodeEnd;
    }

    public Token getNodeStart() {
        return this.nodeStart;
    }

    public String getTag() {
        return this.tag.getLexeme();
    }

    public List<XmlTagNode> getTagNodes() {
        return this.tagNodes;
    }

    public Token getTagToken() {
        return this.tag;
    }

    public void setExpressions(XmlExpression[] xmlExpressionArray) {
        this.expressions = xmlExpressionArray;
    }

    @Override
    public void visitChildren(XmlVisitor<?> xmlVisitor) {
        for (XmlAttributeNode xmlNode : this.attributes) {
            xmlNode.accept(xmlVisitor);
        }
        for (XmlTagNode xmlTagNode : this.tagNodes) {
            xmlTagNode.accept(xmlVisitor);
        }
    }
}

