/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.ToSourceVisitor;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.utilities.dart.ParameterKind;
import com.google.dart.engine.utilities.io.PrintStringWriter;
import com.google.dart.engine.utilities.translation.DartOmit;
import com.google.dart.engine.utilities.translation.DartOptional;
import java.util.ArrayList;
import java.util.List;

public abstract class XmlNode {
    private XmlNode parent;
    private Element element;

    public abstract <R> R accept(XmlVisitor<R> var1);

    public abstract Token getBeginToken();

    public Element getElement() {
        return this.element;
    }

    public int getEnd() {
        return this.getOffset() + this.getLength();
    }

    public abstract Token getEndToken();

    public int getLength() {
        Token token = this.getBeginToken();
        Token token2 = this.getEndToken();
        if (token == null || token2 == null) {
            return -1;
        }
        return token2.getOffset() + token2.getLength() - token.getOffset();
    }

    public int getOffset() {
        Token token = this.getBeginToken();
        if (token == null) {
            return -1;
        }
        return this.getBeginToken().getOffset();
    }

    public XmlNode getParent() {
        return this.parent;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public String toString() {
        PrintStringWriter printStringWriter = new PrintStringWriter();
        this.accept(new ToSourceVisitor(printStringWriter));
        return printStringWriter.toString();
    }

    public abstract void visitChildren(XmlVisitor<?> var1);

    protected <T extends XmlNode> T becomeParentOf(T t) {
        if (t != null) {
            T t2 = t;
            super.setParent(this);
        }
        return t;
    }

    @DartOmit
    protected final <T extends XmlNode> List<T> becomeParentOfAll(List<T> list) {
        return this.becomeParentOfAll(list, null);
    }

    protected final <T extends XmlNode> List<T> becomeParentOfAll(List<T> list, @DartOptional(kind=ParameterKind.NAMED) List<T> list2) {
        if ((list == null || list.isEmpty()) && list2 != null) {
            return list2;
        }
        if (list != null) {
            for (XmlNode xmlNode : list) {
                xmlNode.setParent(this);
            }
            return new ArrayList<T>(list);
        }
        return list;
    }

    private void appendIdentifier(StringBuilder stringBuilder, XmlNode xmlNode) {
        if (xmlNode instanceof XmlTagNode) {
            stringBuilder.append(((XmlTagNode)xmlNode).getTag());
        } else if (xmlNode instanceof XmlAttributeNode) {
            stringBuilder.append(((XmlAttributeNode)xmlNode).getName());
        } else {
            stringBuilder.append("htmlUnit");
        }
    }

    private String buildRecursiveStructureMessage(XmlNode xmlNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Attempt to create recursive structure: ");
        for (XmlNode xmlNode2 = xmlNode; xmlNode2 != null; xmlNode2 = xmlNode2.getParent()) {
            if (xmlNode2 != xmlNode) {
                stringBuilder.append(" -> ");
            }
            if (xmlNode2 == this) {
                stringBuilder.append('*');
                this.appendIdentifier(stringBuilder, xmlNode2);
                stringBuilder.append('*');
                continue;
            }
            this.appendIdentifier(stringBuilder, xmlNode2);
        }
        return stringBuilder.toString();
    }

    private void setParent(XmlNode xmlNode) {
        for (XmlNode xmlNode2 = xmlNode; xmlNode2 != null; xmlNode2 = xmlNode2.getParent()) {
            if (xmlNode2 != this) continue;
            AnalysisEngine.getInstance().getLogger().logError("Circular structure while setting an XML node's parent", new IllegalArgumentException(this.buildRecursiveStructureMessage(xmlNode)));
            return;
        }
        this.parent = xmlNode;
    }
}

