/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast;

import com.google.dart.engine.html.ast.XmlExpression;
import com.google.dart.engine.html.ast.XmlNode;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.html.scanner.Token;

public class XmlAttributeNode
extends XmlNode {
    private final Token name;
    private final Token equals;
    private final Token value;
    private XmlExpression[] expressions = XmlExpression.EMPTY_ARRAY;

    public XmlAttributeNode(Token token, Token token2, Token token3) {
        this.name = token;
        this.equals = token2;
        this.value = token3;
    }

    @Override
    public <R> R accept(XmlVisitor<R> xmlVisitor) {
        return xmlVisitor.visitXmlAttributeNode(this);
    }

    @Override
    public Token getBeginToken() {
        return this.name;
    }

    @Override
    public Token getEndToken() {
        return this.value;
    }

    public Token getEquals() {
        return this.equals;
    }

    public XmlExpression[] getExpressions() {
        return this.expressions;
    }

    public String getName() {
        return this.name.getLexeme();
    }

    public Token getNameToken() {
        return this.name;
    }

    public String getText() {
        if (this.value == null) {
            return null;
        }
        String string = this.value.getLexeme();
        int n = string.length();
        if (n > 0) {
            if (string.charAt(0) == '\"') {
                if (n > 1 && string.charAt(n - 1) == '\"') {
                    return string.substring(1, n - 1);
                }
                return string.substring(1);
            }
            if (string.charAt(0) == '\'') {
                if (n > 1 && string.charAt(n - 1) == '\'') {
                    return string.substring(1, n - 1);
                }
                return string.substring(1);
            }
        }
        return string;
    }

    public Token getValueToken() {
        return this.value;
    }

    public void setExpressions(XmlExpression[] xmlExpressionArray) {
        this.expressions = xmlExpressionArray;
    }

    @Override
    public void visitChildren(XmlVisitor<?> xmlVisitor) {
    }
}

