/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.visitor.ElementLocator;
import com.google.dart.engine.ast.visitor.NodeLocator;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.html.ast.XmlExpression;

public class RawXmlExpression
extends XmlExpression {
    private final Expression expression;

    public RawXmlExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public int getEnd() {
        return this.expression.getEnd();
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public int getLength() {
        return this.expression.getLength();
    }

    @Override
    public int getOffset() {
        return this.expression.getOffset();
    }

    @Override
    public XmlExpression.Reference getReference(int n) {
        AstNode astNode = new NodeLocator(n).searchWithin(this.expression);
        if (astNode != null) {
            Element element = ElementLocator.locate(astNode);
            return new XmlExpression.Reference(element, astNode.getOffset(), astNode.getLength());
        }
        return null;
    }
}

