/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.visitor.ElementLocator;
import com.google.dart.engine.ast.visitor.NodeLocator;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.angular.AngularElement;
import com.google.dart.engine.html.ast.HtmlUnit;
import com.google.dart.engine.html.ast.XmlAttributeNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.RecursiveXmlVisitor;
import com.google.dart.engine.html.scanner.Token;
import com.google.dart.engine.internal.html.angular.AngularHtmlUnitResolver;
import com.google.dart.engine.internal.html.angular.ExpressionVisitor;

public class HtmlUnitUtils {
    public static XmlAttributeNode getAttributeNode(HtmlUnit htmlUnit, final int n) {
        if (htmlUnit == null) {
            return null;
        }
        final XmlAttributeNode[] xmlAttributeNodeArray = new XmlAttributeNode[]{null};
        try {
            htmlUnit.accept(new RecursiveXmlVisitor<Void>(){

                @Override
                public Void visitXmlAttributeNode(XmlAttributeNode xmlAttributeNode) {
                    Token token = xmlAttributeNode.getNameToken();
                    if (token.getOffset() <= n && n <= token.getEnd()) {
                        xmlAttributeNodeArray[0] = xmlAttributeNode;
                        throw new FoundAttributeNodeError();
                    }
                    return (Void)super.visitXmlAttributeNode(xmlAttributeNode);
                }
            });
        }
        catch (FoundAttributeNodeError foundAttributeNodeError) {
            return xmlAttributeNodeArray[0];
        }
        return null;
    }

    public static Element getElement(Expression expression) {
        if (expression == null) {
            return null;
        }
        return ElementLocator.locate(expression);
    }

    public static Element getElementAtOffset(HtmlUnit htmlUnit, int n) {
        Expression expression = HtmlUnitUtils.getExpression(htmlUnit, n);
        return HtmlUnitUtils.getElement(expression);
    }

    public static Element getElementToOpen(HtmlUnit htmlUnit, Expression expression) {
        Element element = HtmlUnitUtils.getElement(expression);
        AngularElement angularElement = AngularHtmlUnitResolver.getAngularElement(element);
        if (angularElement != null) {
            return angularElement;
        }
        return element;
    }

    public static XmlTagNode getEnclosingTagNode(HtmlUnit htmlUnit, final int n) {
        if (htmlUnit == null) {
            return null;
        }
        final XmlTagNode[] xmlTagNodeArray = new XmlTagNode[]{null};
        try {
            htmlUnit.accept(new RecursiveXmlVisitor<Void>(){

                @Override
                public Void visitXmlTagNode(XmlTagNode xmlTagNode) {
                    if (xmlTagNode.getOffset() <= n && n < xmlTagNode.getEnd()) {
                        xmlTagNodeArray[0] = xmlTagNode;
                        super.visitXmlTagNode(xmlTagNode);
                        throw new FoundTagNodeError();
                    }
                    return null;
                }
            });
        }
        catch (FoundTagNodeError foundTagNodeError) {
            return xmlTagNodeArray[0];
        }
        return null;
    }

    public static Expression getExpression(HtmlUnit htmlUnit, final int n) {
        if (htmlUnit == null) {
            return null;
        }
        final Expression[] expressionArray = new Expression[]{null};
        try {
            htmlUnit.accept(new ExpressionVisitor(){

                @Override
                public void visitExpression(Expression expression) {
                    Expression expression2 = HtmlUnitUtils.getExpressionAt(expression, n);
                    if (expression2 != null) {
                        expressionArray[0] = expression2;
                        throw new FoundExpressionError();
                    }
                }
            });
        }
        catch (FoundExpressionError foundExpressionError) {
            return expressionArray[0];
        }
        return null;
    }

    public static XmlTagNode getTagNode(HtmlUnit htmlUnit, int n) {
        XmlTagNode xmlTagNode = HtmlUnitUtils.getEnclosingTagNode(htmlUnit, n);
        if (xmlTagNode == null) {
            return null;
        }
        Token token = xmlTagNode.getTagToken();
        if (token.getOffset() <= n && n <= token.getEnd()) {
            return xmlTagNode;
        }
        Token token2 = xmlTagNode.getClosingTag();
        if (token2 != null && token2.getOffset() <= n && n <= token2.getEnd()) {
            return xmlTagNode;
        }
        return null;
    }

    private static Expression getExpressionAt(AstNode astNode, int n) {
        AstNode astNode2;
        if (astNode.getOffset() <= n && n <= astNode.getEnd() && (astNode2 = new NodeLocator(n).searchWithin(astNode)) instanceof Expression) {
            return (Expression)astNode2;
        }
        return null;
    }

    private static class FoundTagNodeError
    extends Error {
        private FoundTagNodeError() {
        }
    }

    private static class FoundExpressionError
    extends Error {
        private FoundExpressionError() {
        }
    }

    private static class FoundAttributeNodeError
    extends Error {
        private FoundAttributeNodeError() {
        }
    }
}

