/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.html.ast;

import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.HtmlElement;
import com.google.dart.engine.html.ast.XmlNode;
import com.google.dart.engine.html.ast.XmlTagNode;
import com.google.dart.engine.html.ast.visitor.XmlVisitor;
import com.google.dart.engine.html.scanner.Token;
import java.util.List;

public class HtmlUnit
extends XmlNode {
    private final Token beginToken;
    private final Token endToken;
    private final List<XmlTagNode> tagNodes;

    public HtmlUnit(Token token, List<XmlTagNode> list, Token token2) {
        this.beginToken = token;
        this.tagNodes = this.becomeParentOfAll(list);
        this.endToken = token2;
    }

    @Override
    public <R> R accept(XmlVisitor<R> xmlVisitor) {
        return xmlVisitor.visitHtmlUnit(this);
    }

    @Override
    public Token getBeginToken() {
        return this.beginToken;
    }

    @Override
    public HtmlElement getElement() {
        return (HtmlElement)super.getElement();
    }

    @Override
    public Token getEndToken() {
        return this.endToken;
    }

    public List<XmlTagNode> getTagNodes() {
        return this.tagNodes;
    }

    @Override
    public void setElement(Element element) {
        if (element != null && !(element instanceof HtmlElement)) {
            throw new IllegalArgumentException("HtmlElement expected, but " + element.getClass() + " given");
        }
        super.setElement(element);
    }

    @Override
    public void visitChildren(XmlVisitor<?> xmlVisitor) {
        for (XmlTagNode xmlTagNode : this.tagNodes) {
            xmlTagNode.accept(xmlVisitor);
        }
    }
}

