/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.error;

import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;

public enum StaticWarningCode implements ErrorCode
{
    AMBIGUOUS_IMPORT("The type '%s' is defined in the libraries '%s' and '%s'"),
    ARGUMENT_TYPE_NOT_ASSIGNABLE("The argument type '%s' cannot be assigned to the parameter type '%s'"),
    ASSIGNMENT_TO_CONST("Constant variables cannot be assigned a value"),
    ASSIGNMENT_TO_FINAL("'%s' cannot be used as a setter, it is final"),
    ASSIGNMENT_TO_METHOD("Methods cannot be assigned a value"),
    CASE_BLOCK_NOT_TERMINATED("The last statement of the 'case' should be 'break', 'continue', 'return' or 'throw'"),
    CAST_TO_NON_TYPE("The name '%s' is not a type and cannot be used in an 'as' expression"),
    CONCRETE_CLASS_WITH_ABSTRACT_MEMBER("'%s' must have a method body because '%s' is not abstract"),
    CONFLICTING_DART_IMPORT("Element '%s' from SDK library '%s' is implicitly hidden by '%s'"),
    CONFLICTING_INSTANCE_GETTER_AND_SUPERCLASS_MEMBER("Superclass '%s' declares static member with the same name"),
    CONFLICTING_INSTANCE_METHOD_SETTER("Class '%s' declares instance method '%s', but also has a setter with the same name from '%s'"),
    CONFLICTING_INSTANCE_METHOD_SETTER2("Class '%s' declares the setter '%s', but also has an instance method in the same class"),
    CONFLICTING_INSTANCE_SETTER_AND_SUPERCLASS_MEMBER("Superclass '%s' declares static member with the same name"),
    CONFLICTING_STATIC_GETTER_AND_INSTANCE_SETTER("Class '%s' declares non-static setter with the same name"),
    CONFLICTING_STATIC_SETTER_AND_INSTANCE_MEMBER("Class '%s' declares non-static member with the same name"),
    CONST_WITH_ABSTRACT_CLASS("Abstract classes cannot be created with a 'const' expression"),
    EQUAL_KEYS_IN_MAP("Keys in a map cannot be equal"),
    EXPORT_DUPLICATED_LIBRARY_NAME("The exported libraries '%s' and '%s' should not have the same name '%s'"),
    EXTRA_POSITIONAL_ARGUMENTS("%d positional arguments expected, but %d found"),
    FIELD_INITIALIZED_IN_INITIALIZER_AND_DECLARATION("Values cannot be set in the constructor if they are final, and have already been set"),
    FINAL_INITIALIZED_IN_DECLARATION_AND_CONSTRUCTOR("'%s' is final and was given a value when it was declared, so it cannot be set to a new value"),
    FIELD_INITIALIZER_NOT_ASSIGNABLE("The initializer type '%s' cannot be assigned to the field type '%s'"),
    FIELD_INITIALIZING_FORMAL_NOT_ASSIGNABLE("The parameter type '%s' is incompatable with the field type '%s'"),
    FINAL_NOT_INITIALIZED("The final variable '%s' must be initialized"),
    FUNCTION_WITHOUT_CALL("Concrete classes that implement Function must implement the method call()"),
    IMPORT_DUPLICATED_LIBRARY_NAME("The imported libraries '%s' and '%s' should not have the same name '%s'"),
    INCONSISTENT_METHOD_INHERITANCE_GETTER_AND_METHOD("'%s' is inherited as a getter and also a method"),
    INSTANCE_METHOD_NAME_COLLIDES_WITH_SUPERCLASS_STATIC("'%s' collides with a static member in the superclass '%s'"),
    INVALID_GETTER_OVERRIDE_RETURN_TYPE("The return type '%s' is not assignable to '%s' as required by the getter it is overriding from '%s'"),
    INVALID_METHOD_OVERRIDE_NAMED_PARAM_TYPE("The parameter type '%s' is not assignable to '%s' as required by the method it is overriding from '%s'"),
    INVALID_METHOD_OVERRIDE_NORMAL_PARAM_TYPE("The parameter type '%s' is not assignable to '%s' as required by the method it is overriding from '%s'"),
    INVALID_METHOD_OVERRIDE_OPTIONAL_PARAM_TYPE("The parameter type '%s' is not assignable to '%s' as required by the method it is overriding from '%s'"),
    INVALID_METHOD_OVERRIDE_RETURN_TYPE("The return type '%s' is not assignable to '%s' as required by the method it is overriding from '%s'"),
    INVALID_OVERRIDE_DIFFERENT_DEFAULT_VALUES_NAMED("Parameters cannot override default values, this method overrides '%s.%s' where '%s' has a different value"),
    INVALID_OVERRIDE_DIFFERENT_DEFAULT_VALUES_POSITIONAL("Parameters cannot override default values, this method overrides '%s.%s' where this positional parameter has a different value"),
    INVALID_OVERRIDE_NAMED("Missing the named parameter '%s' to match the overridden method from '%s'"),
    INVALID_OVERRIDE_POSITIONAL("Must have at least %d parameters to match the overridden method from '%s'"),
    INVALID_OVERRIDE_REQUIRED("Must have %d required parameters or less to match the overridden method from '%s'"),
    INVALID_SETTER_OVERRIDE_NORMAL_PARAM_TYPE("The parameter type '%s' is not assignable to '%s' as required by the setter it is overriding from '%s'"),
    LIST_ELEMENT_TYPE_NOT_ASSIGNABLE("The element type '%s' cannot be assigned to the list type '%s'"),
    MAP_KEY_TYPE_NOT_ASSIGNABLE("The element type '%s' cannot be assigned to the map key type '%s'"),
    MAP_VALUE_TYPE_NOT_ASSIGNABLE("The element type '%s' cannot be assigned to the map value type '%s'"),
    MISMATCHED_GETTER_AND_SETTER_TYPES("The parameter type for setter '%s' is '%s' which is not assignable to its getter (of type '%s')"),
    MISMATCHED_GETTER_AND_SETTER_TYPES_FROM_SUPERTYPE("The parameter type for setter '%s' is '%s' which is not assignable to its getter (of type '%s'), from superclass '%s'"),
    MIXED_RETURN_TYPES("Methods and functions cannot use return both with and without values"),
    NEW_WITH_ABSTRACT_CLASS("Abstract classes cannot be created with a 'new' expression"),
    NEW_WITH_INVALID_TYPE_PARAMETERS("The type '%s' is declared with %d type parameters, but %d type arguments were given"),
    NEW_WITH_NON_TYPE("The name '%s' is not a class"),
    NEW_WITH_UNDEFINED_CONSTRUCTOR("The class '%s' does not have a constructor '%s'"),
    NEW_WITH_UNDEFINED_CONSTRUCTOR_DEFAULT("The class '%s' does not have a default constructor"),
    NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_FIVE_PLUS("Missing concrete implementation of '%s', '%s', '%s', '%s' and %d more"),
    NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_FOUR("Missing concrete implementation of '%s', '%s', '%s' and '%s'"),
    NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_ONE("Missing concrete implementation of '%s'"),
    NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_THREE("Missing concrete implementation of '%s', '%s' and '%s'"),
    NON_ABSTRACT_CLASS_INHERITS_ABSTRACT_MEMBER_TWO("Missing concrete implementation of '%s' and '%s'"),
    NON_TYPE_IN_CATCH_CLAUSE("The name '%s' is not a type and cannot be used in an on-catch clause"),
    NON_VOID_RETURN_FOR_OPERATOR("The return type of the operator []= must be 'void'"),
    NON_VOID_RETURN_FOR_SETTER("The return type of the setter must be 'void'"),
    NOT_A_TYPE("%s is not a type"),
    NOT_ENOUGH_REQUIRED_ARGUMENTS("%d required argument(s) expected, but %d found"),
    PART_OF_DIFFERENT_LIBRARY("Expected this library to be part of '%s', not '%s'"),
    REDIRECT_TO_INVALID_FUNCTION_TYPE("The redirected constructor '%s' has incompatible parameters with '%s'"),
    REDIRECT_TO_INVALID_RETURN_TYPE("The return type '%s' of the redirected constructor is not assignable to '%s'"),
    REDIRECT_TO_MISSING_CONSTRUCTOR("The constructor '%s' could not be found in '%s'"),
    REDIRECT_TO_NON_CLASS("The name '%s' is not a type and cannot be used in a redirected constructor"),
    RETURN_WITHOUT_VALUE("Missing return value after 'return'"),
    STATIC_ACCESS_TO_INSTANCE_MEMBER("Instance member '%s' cannot be accessed using static access"),
    SWITCH_EXPRESSION_NOT_ASSIGNABLE("Type '%s' of the switch expression is not assignable to the type '%s' of case expressions"),
    TYPE_TEST_NON_TYPE("The name '%s' is not a type and cannot be used in an 'is' expression"),
    TYPE_PARAMETER_REFERENCED_BY_STATIC("Static members cannot reference type parameters"),
    UNDEFINED_CLASS("Undefined class '%s'"),
    UNDEFINED_CLASS_BOOLEAN("Undefined class 'boolean'; did you mean 'bool'?"),
    UNDEFINED_GETTER("There is no such getter '%s' in '%s'"),
    UNDEFINED_IDENTIFIER("Undefined name '%s'"),
    UNDEFINED_NAMED_PARAMETER("The named parameter '%s' is not defined"),
    UNDEFINED_SETTER("There is no such setter '%s' in '%s'"),
    UNDEFINED_STATIC_METHOD_OR_GETTER("There is no such static method, getter or setter '%s' in '%s'"),
    VOID_RETURN_FOR_GETTER("The return type of the getter must not be 'void'");

    private final String message;
    public String correction;

    private StaticWarningCode(String string2) {
        this.message = string2;
    }

    private StaticWarningCode(String string2, String string3) {
        this.message = string2;
        this.correction = string3;
    }

    @Override
    public String getCorrection() {
        return this.correction;
    }

    @Override
    public ErrorSeverity getErrorSeverity() {
        return ErrorType.STATIC_WARNING.getSeverity();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ErrorType getType() {
        return ErrorType.STATIC_WARNING;
    }
}

