/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.error;

import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;

public enum StaticTypeWarningCode implements ErrorCode
{
    EXPECTED_ONE_LIST_TYPE_ARGUMENTS("List literal requires exactly one type arguments or none, but %d found"),
    EXPECTED_TWO_MAP_TYPE_ARGUMENTS("Map literal requires exactly two type arguments or none, but %d found"),
    INACCESSIBLE_SETTER(""),
    INCONSISTENT_METHOD_INHERITANCE("'%s' is inherited by at least two interfaces inconsistently, from %s"),
    INSTANCE_ACCESS_TO_STATIC_MEMBER("Static member '%s' cannot be accessed using instance access"),
    INVALID_ASSIGNMENT("A value of type '%s' cannot be assigned to a variable of type '%s'"),
    INVOCATION_OF_NON_FUNCTION("'%s' is not a method"),
    INVOCATION_OF_NON_FUNCTION_EXPRESSION("Cannot invoke a non-function"),
    NON_BOOL_CONDITION("Conditions must have a static type of 'bool'"),
    NON_BOOL_EXPRESSION("Assertions must be on either a 'bool' or '() -> bool'"),
    NON_BOOL_NEGATION_EXPRESSION("Negation argument must have a static type of 'bool'"),
    NON_TYPE_AS_TYPE_ARGUMENT("The name '%s' is not a type and cannot be used as a parameterized type"),
    RETURN_OF_INVALID_TYPE("The return type '%s' is not a '%s', as defined by the method '%s'"),
    TYPE_ARGUMENT_NOT_MATCHING_BOUNDS("'%s' does not extend '%s'"),
    TYPE_PARAMETER_SUPERTYPE_OF_ITS_BOUND("'%s' cannot be a supertype of its upper bound"),
    UNDEFINED_GETTER("There is no such getter '%s' in '%s'"),
    UNDEFINED_METHOD("The method '%s' is not defined for the class '%s'"),
    UNDEFINED_OPERATOR("There is no such operator '%s' in '%s'"),
    UNDEFINED_SETTER("There is no such setter '%s' in '%s'"),
    UNDEFINED_SUPER_METHOD("There is no such method '%s' in '%s'"),
    UNQUALIFIED_REFERENCE_TO_NON_LOCAL_STATIC_MEMBER("Static members from supertypes must be qualified by the name of the defining type"),
    WRONG_NUMBER_OF_TYPE_ARGUMENTS("The type '%s' is declared with %d type parameters, but %d type arguments were given");

    private final String message;
    public String correction;

    private StaticTypeWarningCode(String string2) {
        this.message = string2;
    }

    private StaticTypeWarningCode(String string2, String string3) {
        this.message = string2;
        this.correction = string3;
    }

    @Override
    public String getCorrection() {
        return this.correction;
    }

    @Override
    public ErrorSeverity getErrorSeverity() {
        return ErrorType.STATIC_TYPE_WARNING.getSeverity();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ErrorType getType() {
        return ErrorType.STATIC_TYPE_WARNING;
    }
}

