/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.error;

import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;
import com.google.dart.engine.error.StaticTypeWarningCode;
import com.google.dart.engine.error.StaticWarningCode;

public enum HintCode implements ErrorCode
{
    ARGUMENT_TYPE_NOT_ASSIGNABLE(StaticWarningCode.ARGUMENT_TYPE_NOT_ASSIGNABLE.getMessage()),
    DEAD_CODE("Dead code"),
    DEAD_CODE_CATCH_FOLLOWING_CATCH("Dead code, catch clauses after a 'catch (e)' or an 'on Object catch (e)' are never reached"),
    DEAD_CODE_ON_CATCH_SUBTYPE("Dead code, this on-catch block will never be executed since '%s' is a subtype of '%s'"),
    DEPRECATED_MEMBER_USE("'%s' is deprecated"),
    DUPLICATE_IMPORT("Duplicate import"),
    DIVISION_OPTIMIZATION("The operator x ~/ y is more efficient than (x / y).toInt()"),
    IS_DOUBLE("When compiled to JS, this test might return true when the left hand side is an int"),
    IS_INT("When compiled to JS, this test might return true when the left hand side is a double"),
    IS_NOT_DOUBLE("When compiled to JS, this test might return false when the left hand side is an int"),
    IS_NOT_INT("When compiled to JS, this test might return false when the left hand side is a double"),
    MISSING_RETURN("This function declares a return type of '%s', but does not end with a return statement", "Either add a return statement or change the return type to 'void'"),
    OVERRIDE_ON_NON_OVERRIDING_GETTER("Getter does not override an inherited getter"),
    OVERRIDE_ON_NON_OVERRIDING_METHOD("Method does not override an inherited method"),
    OVERRIDE_ON_NON_OVERRIDING_SETTER("Setter does not override an inherited setter"),
    OVERRIDDING_PRIVATE_MEMBER("The %s '%s' does not override the definition from '%s' because it is private and in a different library"),
    OVERRIDE_EQUALS_BUT_NOT_HASH_CODE("The class '%s' overrides 'operator==', but not 'get hashCode'"),
    TYPE_CHECK_IS_NOT_NULL("Tests for non-null should be done with '!= null'"),
    TYPE_CHECK_IS_NULL("Tests for null should be done with '== null'"),
    UNDEFINED_GETTER(StaticTypeWarningCode.UNDEFINED_GETTER.getMessage()),
    UNDEFINED_METHOD(StaticTypeWarningCode.UNDEFINED_METHOD.getMessage()),
    UNDEFINED_OPERATOR(StaticTypeWarningCode.UNDEFINED_OPERATOR.getMessage()),
    UNDEFINED_SETTER(StaticTypeWarningCode.UNDEFINED_SETTER.getMessage()),
    UNNECESSARY_CAST("Unnecessary cast"),
    UNNECESSARY_TYPE_CHECK_FALSE("Unnecessary type check, the result is always false"),
    UNNECESSARY_TYPE_CHECK_TRUE("Unnecessary type check, the result is always true"),
    UNUSED_IMPORT("Unused import"),
    USE_OF_VOID_RESULT("The result of '%s' is being used, even though it is declared to be 'void'");

    private final String message;
    public String correction;

    private HintCode(String string2) {
        this.message = string2;
    }

    private HintCode(String string2, String string3) {
        this.message = string2;
        this.correction = string3;
    }

    @Override
    public String getCorrection() {
        return this.correction;
    }

    @Override
    public ErrorSeverity getErrorSeverity() {
        return ErrorType.HINT.getSeverity();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ErrorType getType() {
        return ErrorType.HINT;
    }
}

