/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.error;

import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;

public enum CompileTimeErrorCode implements ErrorCode
{
    AMBIGUOUS_EXPORT("The element '%s' is defined in the libraries '%s' and '%s'"),
    ARGUMENT_DEFINITION_TEST_NON_PARAMETER("'%s' is not a parameter"),
    BUILT_IN_IDENTIFIER_AS_TYPE("The built-in identifier '%s' cannot be as a type"),
    BUILT_IN_IDENTIFIER_AS_TYPE_NAME("The built-in identifier '%s' cannot be used as a type name"),
    BUILT_IN_IDENTIFIER_AS_TYPEDEF_NAME("The built-in identifier '%s' cannot be used as a type alias name"),
    BUILT_IN_IDENTIFIER_AS_TYPE_PARAMETER_NAME("The built-in identifier '%s' cannot be used as a type parameter name"),
    CASE_EXPRESSION_TYPE_IMPLEMENTS_EQUALS("The switch case expression type '%s' cannot override the == operator"),
    COMPILE_TIME_CONSTANT_RAISES_EXCEPTION(""),
    CONFLICTING_GETTER_AND_METHOD("Class '%s' cannot have both getter '%s.%s' and method with the same name"),
    CONFLICTING_METHOD_AND_GETTER("Class '%s' cannot have both method '%s.%s' and getter with the same name"),
    CONFLICTING_CONSTRUCTOR_NAME_AND_FIELD("'%s' cannot be used to name a constructor and a field in this class"),
    CONFLICTING_CONSTRUCTOR_NAME_AND_METHOD("'%s' cannot be used to name a constructor and a method in this class"),
    CONFLICTING_TYPE_VARIABLE_AND_CLASS("'%s' cannot be used to name a type varaible in a class with the same name"),
    CONFLICTING_TYPE_VARIABLE_AND_MEMBER("'%s' cannot be used to name a type varaible and member in this class"),
    CONST_CONSTRUCTOR_THROWS_EXCEPTION("'const' constructors cannot throw exceptions"),
    CONST_CONSTRUCTOR_WITH_NON_CONST_SUPER("Constant constructor cannot call non-constant super constructor"),
    CONST_CONSTRUCTOR_WITH_NON_FINAL_FIELD("Cannot define the 'const' constructor for a class with non-final fields"),
    CONST_FIELD_INITIALIZER_NOT_ASSIGNABLE("The initializer type '%s' cannot be assigned to the field type '%s'"),
    CONST_FORMAL_PARAMETER("Parameters cannot be 'const'"),
    CONST_INITIALIZED_WITH_NON_CONSTANT_VALUE("'const' variables must be constant value"),
    CONST_INSTANCE_FIELD("Only static fields can be declared as 'const'"),
    CONST_MAP_KEY_EXPRESSION_TYPE_IMPLEMENTS_EQUALS("The constant map entry key expression type '%s' cannot override the == operator"),
    CONST_NOT_INITIALIZED("The const variable '%s' must be initialized"),
    CONST_EVAL_TYPE_BOOL("An expression of type 'bool' was expected"),
    CONST_EVAL_TYPE_BOOL_NUM_STRING("An expression of type 'bool', 'num', 'String' or 'null' was expected"),
    CONST_EVAL_TYPE_INT("An expression of type 'int' was expected"),
    CONST_EVAL_TYPE_NUM("An expression of type 'num' was expected"),
    CONST_EVAL_THROWS_EXCEPTION("Evaluation of this constant expression causes exception"),
    CONST_EVAL_THROWS_IDBZE("Evaluation of this constant expression throws IntegerDivisionByZeroException"),
    CONST_WITH_INVALID_TYPE_PARAMETERS("The type '%s' is declared with %d type parameters, but %d type arguments were given"),
    CONST_WITH_NON_CONST("The constructor being called is not a 'const' constructor"),
    CONST_WITH_NON_CONSTANT_ARGUMENT("Arguments of a constant creation must be constant expressions"),
    CONST_WITH_NON_TYPE("The name '%s' is not a class"),
    CONST_WITH_TYPE_PARAMETERS("The constant creation cannot use a type parameter"),
    CONST_WITH_UNDEFINED_CONSTRUCTOR("The class '%s' does not have a constant constructor '%s'"),
    CONST_WITH_UNDEFINED_CONSTRUCTOR_DEFAULT("The class '%s' does not have a default constant constructor"),
    DEFAULT_VALUE_IN_FUNCTION_TYPE_ALIAS("Default values aren't allowed in typedefs"),
    DEFAULT_VALUE_IN_FUNCTION_TYPED_PARAMETER("Default values aren't allowed in function type parameters"),
    DEFAULT_VALUE_IN_REDIRECTING_FACTORY_CONSTRUCTOR("Default values aren't allowed in factory constructors that redirect to another constructor"),
    DUPLICATE_CONSTRUCTOR_DEFAULT("The default constructor is already defined"),
    DUPLICATE_CONSTRUCTOR_NAME("The constructor with name '%s' is already defined"),
    DUPLICATE_DEFINITION("The name '%s' is already defined"),
    DUPLICATE_DEFINITION_INHERITANCE("The name '%s' is already defined in '%s'"),
    DUPLICATE_NAMED_ARGUMENT("The argument for the named parameter '%s' was already specified"),
    EXPORT_INTERNAL_LIBRARY("The library '%s' is internal and cannot be exported"),
    EXPORT_OF_NON_LIBRARY("The exported library '%s' must not have a part-of directive"),
    EXTENDS_NON_CLASS("Classes can only extend other classes"),
    EXTENDS_DISALLOWED_CLASS("Classes cannot extend '%s'"),
    EXTRA_POSITIONAL_ARGUMENTS("%d positional arguments expected, but %d found"),
    FIELD_INITIALIZED_BY_MULTIPLE_INITIALIZERS("The field '%s' cannot be initialized twice in the same constructor"),
    FIELD_INITIALIZED_IN_PARAMETER_AND_INITIALIZER("Fields cannot be initialized in both the parameter list and the initializers"),
    FINAL_INITIALIZED_MULTIPLE_TIMES("'%s' is a final field and so can only be set once"),
    FIELD_INITIALIZER_FACTORY_CONSTRUCTOR("Initializing formal fields cannot be used in factory constructors"),
    FIELD_INITIALIZER_OUTSIDE_CONSTRUCTOR("Initializing formal fields can only be used in constructors"),
    FIELD_INITIALIZER_REDIRECTING_CONSTRUCTOR("The redirecting constructor cannot have a field initializer"),
    GETTER_AND_METHOD_WITH_SAME_NAME("'%s' cannot be used to name a getter, there is already a method with the same name"),
    IMPLEMENTS_DISALLOWED_CLASS("Classes cannot implement '%s'"),
    IMPLEMENTS_DYNAMIC("Classes cannot implement 'dynamic'"),
    IMPLEMENTS_NON_CLASS("Classes can only implement other classes"),
    IMPLEMENTS_REPEATED("'%s' can only be implemented once"),
    IMPLEMENTS_SUPER_CLASS("'%s' cannot be used in both 'extends' and 'implements' clauses"),
    IMPLICIT_THIS_REFERENCE_IN_INITIALIZER("Only static members can be accessed in initializers"),
    IMPORT_INTERNAL_LIBRARY("The library '%s' is internal and cannot be imported"),
    IMPORT_OF_NON_LIBRARY("The imported library '%s' must not have a part-of directive"),
    INCONSISTENT_CASE_EXPRESSION_TYPES("Case expressions must have the same types, '%s' is not a %s'"),
    INITIALIZER_FOR_NON_EXISTANT_FIELD("'%s' is not a variable in the enclosing class"),
    INITIALIZER_FOR_STATIC_FIELD("'%s' is a static variable in the enclosing class, variables initialized in a constructor cannot be static"),
    INITIALIZING_FORMAL_FOR_NON_EXISTANT_FIELD("'%s' is not a variable in the enclosing class"),
    INITIALIZING_FORMAL_FOR_STATIC_FIELD("'%s' is a static variable in the enclosing class, variables initialized in a constructor cannot be static"),
    INSTANCE_MEMBER_ACCESS_FROM_STATIC("Instance member cannot be accessed from static method"),
    INVALID_ANNOTATION("Annotation can be only constant variable or constant constructor invocation"),
    INVALID_CONSTANT("Invalid constant value"),
    INVALID_CONSTRUCTOR_NAME("Invalid constructor name"),
    INVALID_FACTORY_NAME_NOT_A_CLASS("The name of the immediately enclosing class expected"),
    INVALID_REFERENCE_TO_THIS("Invalid reference to 'this' expression"),
    INVALID_TYPE_ARGUMENT_IN_CONST_LIST("Constant list literals cannot include a type parameter as a type argument, such as '%s'"),
    INVALID_TYPE_ARGUMENT_IN_CONST_MAP("Constant map literals cannot include a type parameter as a type argument, such as '%s'"),
    INVALID_URI("Invalid URI syntax: '%s'"),
    LABEL_IN_OUTER_SCOPE("Cannot reference label '%s' declared in an outer method"),
    LABEL_UNDEFINED("Cannot reference undefined label '%s'"),
    LIST_ELEMENT_TYPE_NOT_ASSIGNABLE("The element type '%s' cannot be assigned to the list type '%s'"),
    MAP_KEY_TYPE_NOT_ASSIGNABLE("The element type '%s' cannot be assigned to the map key type '%s'"),
    MAP_VALUE_TYPE_NOT_ASSIGNABLE("The element type '%s' cannot be assigned to the map value type '%s'"),
    MEMBER_WITH_CLASS_NAME("Class members cannot have the same name as the enclosing class"),
    METHOD_AND_GETTER_WITH_SAME_NAME("'%s' cannot be used to name a method, there is already a getter with the same name"),
    MISSING_CONST_IN_LIST_LITERAL("List literals must be prefixed with 'const' when used as a constant expression"),
    MISSING_CONST_IN_MAP_LITERAL("Map literals must be prefixed with 'const' when used as a constant expression"),
    MIXIN_DECLARES_CONSTRUCTOR("The class '%s' cannot be used as a mixin because it declares a constructor"),
    MIXIN_INHERITS_FROM_NOT_OBJECT("The class '%s' cannot be used as a mixin because it extends a class other than Object"),
    MIXIN_OF_DISALLOWED_CLASS("Classes cannot mixin '%s'"),
    MIXIN_OF_NON_CLASS("Classes can only mixin other classes"),
    MIXIN_REFERENCES_SUPER("The class '%s' cannot be used as a mixin because it references 'super'"),
    MIXIN_WITH_NON_CLASS_SUPERCLASS("Mixin can only be applied to class"),
    MULTIPLE_REDIRECTING_CONSTRUCTOR_INVOCATIONS("Constructor may have at most one 'this' redirection"),
    MULTIPLE_SUPER_INITIALIZERS("Constructor may have at most one 'super' initializer"),
    NO_ANNOTATION_CONSTRUCTOR_ARGUMENTS("Annotation creation must have arguments"),
    NO_DEFAULT_SUPER_CONSTRUCTOR_EXPLICIT("The class '%s' does not have a default constructor"),
    NO_DEFAULT_SUPER_CONSTRUCTOR_IMPLICIT("The class '%s' does not have a default constructor"),
    NON_CONST_MAP_AS_EXPRESSION_STATEMENT("A non-constant map literal without type arguments cannot be used as an expression statement"),
    NON_CONSTANT_CASE_EXPRESSION("Case expressions must be constant"),
    NON_CONSTANT_DEFAULT_VALUE("Default values of an optional parameter must be constant"),
    NON_CONSTANT_LIST_ELEMENT("'const' lists must have all constant values"),
    NON_CONSTANT_MAP_KEY("The keys in a map must be constant"),
    NON_CONSTANT_MAP_VALUE("The values in a 'const' map must be constant"),
    NON_CONSTANT_ANNOTATION_CONSTRUCTOR("Annotation creation can use only 'const' constructor"),
    NON_CONSTANT_VALUE_IN_INITIALIZER("Initializer expressions in constant constructors must be constants"),
    NOT_ENOUGH_REQUIRED_ARGUMENTS("%d required argument(s) expected, but %d found"),
    NON_GENERATIVE_CONSTRUCTOR("The generative constructor '%s' expected, but factory found"),
    OBJECT_CANNOT_EXTEND_ANOTHER_CLASS(""),
    OPTIONAL_PARAMETER_IN_OPERATOR("Optional parameters are not allowed when defining an operator"),
    PART_OF_NON_PART("The included part '%s' must have a part-of directive"),
    PREFIX_COLLIDES_WITH_TOP_LEVEL_MEMBER("The name '%s' is already used as an import prefix and cannot be used to name a top-level element"),
    PRIVATE_OPTIONAL_PARAMETER("Named optional parameters cannot start with an underscore"),
    RECURSIVE_COMPILE_TIME_CONSTANT(""),
    RECURSIVE_CONSTRUCTOR_REDIRECT("Cycle in redirecting generative constructors"),
    RECURSIVE_FACTORY_REDIRECT("Cycle in redirecting factory constructors"),
    RECURSIVE_INTERFACE_INHERITANCE("'%s' cannot be a superinterface of itself: %s"),
    RECURSIVE_INTERFACE_INHERITANCE_BASE_CASE_EXTENDS("'%s' cannot extend itself"),
    RECURSIVE_INTERFACE_INHERITANCE_BASE_CASE_IMPLEMENTS("'%s' cannot implement itself"),
    REDIRECT_TO_MISSING_CONSTRUCTOR("The constructor '%s' could not be found in '%s'"),
    REDIRECT_TO_NON_CLASS("The name '%s' is not a type and cannot be used in a redirected constructor"),
    REDIRECT_TO_NON_CONST_CONSTRUCTOR("Constant factory constructor cannot delegate to a non-constant constructor"),
    REFERENCED_BEFORE_DECLARATION("Local variables cannot be referenced before they are declared"),
    RETHROW_OUTSIDE_CATCH("rethrow must be inside of a catch clause"),
    RETURN_IN_GENERATIVE_CONSTRUCTOR("Constructors cannot return a value"),
    SUPER_IN_INVALID_CONTEXT("Invalid context for 'super' invocation"),
    SUPER_IN_REDIRECTING_CONSTRUCTOR("The redirecting constructor cannot have a 'super' initializer"),
    SUPER_INITIALIZER_IN_OBJECT(""),
    TYPE_ARGUMENT_NOT_MATCHING_BOUNDS("'%s' does not extend '%s'"),
    TYPE_ALIAS_CANNOT_REFERENCE_ITSELF("Type alias cannot reference itself directly or recursively via another typedef"),
    UNDEFINED_CLASS("Undefined class '%s'"),
    UNDEFINED_CONSTRUCTOR_IN_INITIALIZER("The class '%s' does not have a generative constructor '%s'"),
    UNDEFINED_CONSTRUCTOR_IN_INITIALIZER_DEFAULT("The class '%s' does not have a default generative constructor"),
    UNDEFINED_FUNCTION("The function '%s' is not defined"),
    UNDEFINED_NAMED_PARAMETER("The named parameter '%s' is not defined"),
    URI_DOES_NOT_EXIST("Target of URI does not exist: '%s'"),
    URI_WITH_INTERPOLATION("URIs cannot use string interpolation"),
    WRONG_NUMBER_OF_PARAMETERS_FOR_OPERATOR("Operator '%s' should declare exactly %d parameter(s), but %d found"),
    WRONG_NUMBER_OF_PARAMETERS_FOR_OPERATOR_MINUS("Operator '-' should declare 0 or 1 parameter, but %d found"),
    WRONG_NUMBER_OF_PARAMETERS_FOR_SETTER("Setters should declare exactly one required parameter");

    private final String message;
    public String correction;

    private CompileTimeErrorCode(String string2) {
        this.message = string2;
    }

    private CompileTimeErrorCode(String string2, String string3) {
        this.message = string2;
        this.correction = string3;
    }

    @Override
    public String getCorrection() {
        return this.correction;
    }

    @Override
    public ErrorSeverity getErrorSeverity() {
        return ErrorType.COMPILE_TIME_ERROR.getSeverity();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public ErrorType getType() {
        return ErrorType.COMPILE_TIME_ERROR;
    }
}

