/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.error;

import com.google.dart.engine.error.ErrorCode;
import com.google.dart.engine.error.ErrorProperty;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.ObjectUtilities;
import java.util.Comparator;

public class AnalysisError {
    public static final AnalysisError[] NO_ERRORS = new AnalysisError[0];
    public static final Comparator<AnalysisError> FILE_COMPARATOR = new Comparator<AnalysisError>(){

        @Override
        public int compare(AnalysisError analysisError, AnalysisError analysisError2) {
            return analysisError.getSource().getShortName().compareTo(analysisError2.getSource().getShortName());
        }
    };
    public static final Comparator<AnalysisError> ERROR_CODE_COMPARATOR = new Comparator<AnalysisError>(){

        @Override
        public int compare(AnalysisError analysisError, AnalysisError analysisError2) {
            ErrorCode errorCode = analysisError.getErrorCode();
            ErrorCode errorCode2 = analysisError2.getErrorCode();
            ErrorSeverity errorSeverity = errorCode.getErrorSeverity();
            ErrorSeverity errorSeverity2 = errorCode2.getErrorSeverity();
            ErrorType errorType = errorCode.getType();
            ErrorType errorType2 = errorCode2.getType();
            if (errorSeverity.equals((Object)errorSeverity2)) {
                return errorType.compareTo(errorType2);
            }
            return errorSeverity2.compareTo(errorSeverity);
        }
    };
    private ErrorCode errorCode;
    private String message;
    private String correction;
    private Source source;
    private int offset = 0;
    private int length = 0;
    private boolean isStaticOnly = false;

    public AnalysisError(Source source, ErrorCode errorCode, Object ... objectArray) {
        this.source = source;
        this.errorCode = errorCode;
        this.message = String.format(errorCode.getMessage(), objectArray);
    }

    public AnalysisError(Source source, int n, int n2, ErrorCode errorCode, Object ... objectArray) {
        this.source = source;
        this.offset = n;
        this.length = n2;
        this.errorCode = errorCode;
        this.message = String.format(errorCode.getMessage(), objectArray);
        String string = errorCode.getCorrection();
        if (string != null) {
            this.correction = String.format(string, objectArray);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AnalysisError)) {
            return false;
        }
        AnalysisError analysisError = (AnalysisError)object;
        if (this.errorCode != analysisError.errorCode) {
            return false;
        }
        if (this.offset != analysisError.offset || this.length != analysisError.length) {
            return false;
        }
        if (this.isStaticOnly != analysisError.isStaticOnly) {
            return false;
        }
        if (!ObjectUtilities.equals(this.message, analysisError.message)) {
            return false;
        }
        return ObjectUtilities.equals(this.source, analysisError.source);
    }

    public String getCorrection() {
        return this.correction;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public int getLength() {
        return this.length;
    }

    public String getMessage() {
        return this.message;
    }

    public int getOffset() {
        return this.offset;
    }

    public Object getProperty(ErrorProperty errorProperty) {
        return null;
    }

    public Source getSource() {
        return this.source;
    }

    public int hashCode() {
        int n = this.offset;
        n ^= this.message != null ? this.message.hashCode() : 0;
        return n ^= this.source != null ? ((Object)this.source).hashCode() : 0;
    }

    public boolean isStaticOnly() {
        return this.isStaticOnly;
    }

    public void setIsStaticOnly(boolean bl) {
        this.isStaticOnly = bl;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.source != null ? this.source.getFullName() : "<unknown source>");
        stringBuilder.append("(");
        stringBuilder.append(this.offset);
        stringBuilder.append("..");
        stringBuilder.append(this.offset + this.length - 1);
        stringBuilder.append("): ");
        stringBuilder.append(this.message);
        return stringBuilder.toString();
    }
}

