/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.element;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.element.ElementKind;
import com.google.dart.engine.element.ElementLocation;
import com.google.dart.engine.element.ElementVisitor;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.source.Source;
import java.util.Comparator;

public interface Element {
    public static final String RIGHT_ARROW = " \u2192 ";
    public static final Comparator<Element> SORT_BY_OFFSET = new Comparator<Element>(){

        @Override
        public int compare(Element element, Element element2) {
            return element.getNameOffset() - element2.getNameOffset();
        }
    };

    public <R> R accept(ElementVisitor<R> var1);

    public String computeDocumentationComment() throws AnalysisException;

    public <E extends Element> E getAncestor(Class<E> var1);

    public AnalysisContext getContext();

    public String getDisplayName();

    public Element getEnclosingElement();

    public ElementKind getKind();

    public LibraryElement getLibrary();

    public ElementLocation getLocation();

    public ElementAnnotation[] getMetadata();

    public String getName();

    public int getNameOffset();

    public AstNode getNode() throws AnalysisException;

    public Source getSource();

    public CompilationUnit getUnit() throws AnalysisException;

    public boolean isAccessibleIn(LibraryElement var1);

    public boolean isDeprecated();

    public boolean isOverride();

    public boolean isPrivate();

    public boolean isPublic();

    public boolean isSynthetic();

    public void visitChildren(ElementVisitor<?> var1);
}

