/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.context;

import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceContainer;
import java.util.ArrayList;
import java.util.List;

public class ChangeSet {
    private ArrayList<Source> added = new ArrayList();
    private ArrayList<Source> changed = new ArrayList();
    private ArrayList<Source> removed = new ArrayList();
    private ArrayList<SourceContainer> removedContainers = new ArrayList();

    public void addedSource(Source source) {
        this.added.add(source);
    }

    public void changedSource(Source source) {
        this.changed.add(source);
    }

    public List<Source> getAddedSources() {
        return this.added;
    }

    public List<Source> getChangedSources() {
        return this.changed;
    }

    public List<SourceContainer> getRemovedContainers() {
        return this.removedContainers;
    }

    public List<Source> getRemovedSources() {
        return this.removed;
    }

    public boolean isEmpty() {
        return this.added.isEmpty() && this.changed.isEmpty() && this.removed.isEmpty() && this.removedContainers.isEmpty();
    }

    public void removedContainer(SourceContainer sourceContainer) {
        if (sourceContainer != null) {
            this.removedContainers.add(sourceContainer);
        }
    }

    public void removedSource(Source source) {
        if (source != null) {
            this.removed.add(source);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.appendSources(stringBuilder, this.added, false, "added");
        bl = this.appendSources(stringBuilder, this.changed, bl, "changed");
        this.appendSources(stringBuilder, this.removed, bl, "removed");
        int n = this.removedContainers.size();
        if (n > 0) {
            if (this.removed.isEmpty()) {
                if (bl) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append("removed: from ");
                stringBuilder.append(n);
                stringBuilder.append(" containers");
            } else {
                stringBuilder.append(", and more from ");
                stringBuilder.append(n);
                stringBuilder.append(" containers");
            }
        }
        return stringBuilder.toString();
    }

    private boolean appendSources(StringBuilder stringBuilder, ArrayList<Source> arrayList, boolean bl, String string) {
        if (arrayList.isEmpty()) {
            return bl;
        }
        if (bl) {
            stringBuilder.append("; ");
        }
        stringBuilder.append(string);
        String string2 = " ";
        for (Source source : arrayList) {
            stringBuilder.append(string2);
            stringBuilder.append(source.getFullName());
            string2 = ", ";
        }
        return true;
    }
}

