/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.constant;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.constant.EvaluationResult;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.internal.constant.ConstantVisitor;
import com.google.dart.engine.internal.constant.ErrorResult;
import com.google.dart.engine.internal.constant.EvaluationResultImpl;
import com.google.dart.engine.internal.constant.ValidResult;
import com.google.dart.engine.internal.resolver.TypeProvider;
import com.google.dart.engine.source.Source;
import java.util.ArrayList;

public class ConstantEvaluator {
    private Source source;
    private TypeProvider typeProvider;

    public ConstantEvaluator(Source source, TypeProvider typeProvider) {
        this.source = source;
        this.typeProvider = typeProvider;
    }

    public EvaluationResult evaluate(Expression expression) {
        EvaluationResultImpl evaluationResultImpl = expression.accept(new ConstantVisitor(this.typeProvider));
        if (evaluationResultImpl instanceof ValidResult) {
            return EvaluationResult.forValue(((ValidResult)evaluationResultImpl).getValue());
        }
        ArrayList<AnalysisError> arrayList = new ArrayList<AnalysisError>();
        for (ErrorResult.ErrorData errorData : ((ErrorResult)evaluationResultImpl).getErrorData()) {
            AstNode astNode = errorData.getNode();
            arrayList.add(new AnalysisError(this.source, astNode.getOffset(), astNode.getLength(), errorData.getErrorCode(), new Object[0]));
        }
        return EvaluationResult.forErrors(arrayList.toArray(new AnalysisError[arrayList.size()]));
    }
}

