/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast.visitor;

import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.ArgumentDefinitionTest;
import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AsExpression;
import com.google.dart.engine.ast.AssertStatement;
import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.BlockFunctionBody;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.BreakStatement;
import com.google.dart.engine.ast.CascadeExpression;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.ClassTypeAlias;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.CommentReference;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConditionalExpression;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorFieldInitializer;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.ContinueStatement;
import com.google.dart.engine.ast.DeclaredIdentifier;
import com.google.dart.engine.ast.DefaultFormalParameter;
import com.google.dart.engine.ast.Directive;
import com.google.dart.engine.ast.DoStatement;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.EmptyFunctionBody;
import com.google.dart.engine.ast.EmptyStatement;
import com.google.dart.engine.ast.ExportDirective;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.ExpressionFunctionBody;
import com.google.dart.engine.ast.ExpressionStatement;
import com.google.dart.engine.ast.ExtendsClause;
import com.google.dart.engine.ast.FieldDeclaration;
import com.google.dart.engine.ast.FieldFormalParameter;
import com.google.dart.engine.ast.ForEachStatement;
import com.google.dart.engine.ast.ForStatement;
import com.google.dart.engine.ast.FormalParameter;
import com.google.dart.engine.ast.FormalParameterList;
import com.google.dart.engine.ast.FunctionBody;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.FunctionDeclarationStatement;
import com.google.dart.engine.ast.FunctionExpression;
import com.google.dart.engine.ast.FunctionExpressionInvocation;
import com.google.dart.engine.ast.FunctionTypeAlias;
import com.google.dart.engine.ast.FunctionTypedFormalParameter;
import com.google.dart.engine.ast.HideCombinator;
import com.google.dart.engine.ast.IfStatement;
import com.google.dart.engine.ast.ImplementsClause;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.InterpolationExpression;
import com.google.dart.engine.ast.InterpolationString;
import com.google.dart.engine.ast.IsExpression;
import com.google.dart.engine.ast.Label;
import com.google.dart.engine.ast.LabeledStatement;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NamedExpression;
import com.google.dart.engine.ast.NativeClause;
import com.google.dart.engine.ast.NativeFunctionBody;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PartDirective;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.RedirectingConstructorInvocation;
import com.google.dart.engine.ast.RethrowExpression;
import com.google.dart.engine.ast.ReturnStatement;
import com.google.dart.engine.ast.ScriptTag;
import com.google.dart.engine.ast.ShowCombinator;
import com.google.dart.engine.ast.SimpleFormalParameter;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.SuperConstructorInvocation;
import com.google.dart.engine.ast.SuperExpression;
import com.google.dart.engine.ast.SwitchCase;
import com.google.dart.engine.ast.SwitchDefault;
import com.google.dart.engine.ast.SwitchStatement;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.ThisExpression;
import com.google.dart.engine.ast.ThrowExpression;
import com.google.dart.engine.ast.TopLevelVariableDeclaration;
import com.google.dart.engine.ast.TryStatement;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.TypeParameter;
import com.google.dart.engine.ast.TypeParameterList;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.ast.VariableDeclarationStatement;
import com.google.dart.engine.ast.WhileStatement;
import com.google.dart.engine.ast.WithClause;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.utilities.dart.ParameterKind;
import java.io.PrintWriter;

public class ToSourceVisitor
implements AstVisitor<Void> {
    private PrintWriter writer;

    public ToSourceVisitor(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    @Override
    public Void visitAdjacentStrings(AdjacentStrings adjacentStrings) {
        this.visitNodeListWithSeparator(adjacentStrings.getStrings(), " ");
        return null;
    }

    @Override
    public Void visitAnnotation(Annotation annotation) {
        this.writer.print('@');
        this.visitNode(annotation.getName());
        this.visitNodeWithPrefix(".", annotation.getConstructorName());
        this.visitNode(annotation.getArguments());
        return null;
    }

    @Override
    public Void visitArgumentDefinitionTest(ArgumentDefinitionTest argumentDefinitionTest) {
        this.writer.print('?');
        this.visitNode(argumentDefinitionTest.getIdentifier());
        return null;
    }

    @Override
    public Void visitArgumentList(ArgumentList argumentList) {
        this.writer.print('(');
        this.visitNodeListWithSeparator(argumentList.getArguments(), ", ");
        this.writer.print(')');
        return null;
    }

    @Override
    public Void visitAsExpression(AsExpression asExpression) {
        this.visitNode(asExpression.getExpression());
        this.writer.print(" as ");
        this.visitNode(asExpression.getType());
        return null;
    }

    @Override
    public Void visitAssertStatement(AssertStatement assertStatement) {
        this.writer.print("assert (");
        this.visitNode(assertStatement.getCondition());
        this.writer.print(");");
        return null;
    }

    @Override
    public Void visitAssignmentExpression(AssignmentExpression assignmentExpression) {
        this.visitNode(assignmentExpression.getLeftHandSide());
        this.writer.print(' ');
        this.writer.print(assignmentExpression.getOperator().getLexeme());
        this.writer.print(' ');
        this.visitNode(assignmentExpression.getRightHandSide());
        return null;
    }

    @Override
    public Void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.visitNode(binaryExpression.getLeftOperand());
        this.writer.print(' ');
        this.writer.print(binaryExpression.getOperator().getLexeme());
        this.writer.print(' ');
        this.visitNode(binaryExpression.getRightOperand());
        return null;
    }

    @Override
    public Void visitBlock(Block block) {
        this.writer.print('{');
        this.visitNodeListWithSeparator(block.getStatements(), " ");
        this.writer.print('}');
        return null;
    }

    @Override
    public Void visitBlockFunctionBody(BlockFunctionBody blockFunctionBody) {
        this.visitNode(blockFunctionBody.getBlock());
        return null;
    }

    @Override
    public Void visitBooleanLiteral(BooleanLiteral booleanLiteral) {
        this.writer.print(booleanLiteral.getLiteral().getLexeme());
        return null;
    }

    @Override
    public Void visitBreakStatement(BreakStatement breakStatement) {
        this.writer.print("break");
        this.visitNodeWithPrefix(" ", breakStatement.getLabel());
        this.writer.print(";");
        return null;
    }

    @Override
    public Void visitCascadeExpression(CascadeExpression cascadeExpression) {
        this.visitNode(cascadeExpression.getTarget());
        this.visitNodeList(cascadeExpression.getCascadeSections());
        return null;
    }

    @Override
    public Void visitCatchClause(CatchClause catchClause) {
        this.visitNodeWithPrefix("on ", catchClause.getExceptionType());
        if (catchClause.getCatchKeyword() != null) {
            if (catchClause.getExceptionType() != null) {
                this.writer.print(' ');
            }
            this.writer.print("catch (");
            this.visitNode(catchClause.getExceptionParameter());
            this.visitNodeWithPrefix(", ", catchClause.getStackTraceParameter());
            this.writer.print(") ");
        } else {
            this.writer.print(" ");
        }
        this.visitNode(catchClause.getBody());
        return null;
    }

    @Override
    public Void visitClassDeclaration(ClassDeclaration classDeclaration) {
        this.visitNodeListWithSeparatorAndSuffix(classDeclaration.getMetadata(), " ", " ");
        this.visitTokenWithSuffix(classDeclaration.getAbstractKeyword(), " ");
        this.writer.print("class ");
        this.visitNode(classDeclaration.getName());
        this.visitNode(classDeclaration.getTypeParameters());
        this.visitNodeWithPrefix(" ", classDeclaration.getExtendsClause());
        this.visitNodeWithPrefix(" ", classDeclaration.getWithClause());
        this.visitNodeWithPrefix(" ", classDeclaration.getImplementsClause());
        this.writer.print(" {");
        this.visitNodeListWithSeparator(classDeclaration.getMembers(), " ");
        this.writer.print("}");
        return null;
    }

    @Override
    public Void visitClassTypeAlias(ClassTypeAlias classTypeAlias) {
        this.visitNodeListWithSeparatorAndSuffix(classTypeAlias.getMetadata(), " ", " ");
        if (classTypeAlias.getAbstractKeyword() != null) {
            this.writer.print("abstract ");
        }
        this.writer.print("class ");
        this.visitNode(classTypeAlias.getName());
        this.visitNode(classTypeAlias.getTypeParameters());
        this.writer.print(" = ");
        this.visitNode(classTypeAlias.getSuperclass());
        this.visitNodeWithPrefix(" ", classTypeAlias.getWithClause());
        this.visitNodeWithPrefix(" ", classTypeAlias.getImplementsClause());
        this.writer.print(";");
        return null;
    }

    @Override
    public Void visitComment(Comment comment) {
        return null;
    }

    @Override
    public Void visitCommentReference(CommentReference commentReference) {
        return null;
    }

    @Override
    public Void visitCompilationUnit(CompilationUnit compilationUnit) {
        ScriptTag scriptTag = compilationUnit.getScriptTag();
        NodeList<Directive> nodeList = compilationUnit.getDirectives();
        this.visitNode(scriptTag);
        String string = scriptTag == null ? "" : " ";
        this.visitNodeListWithSeparatorAndPrefix(string, nodeList, " ");
        string = scriptTag == null && nodeList.isEmpty() ? "" : " ";
        this.visitNodeListWithSeparatorAndPrefix(string, compilationUnit.getDeclarations(), " ");
        return null;
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        this.visitNode(conditionalExpression.getCondition());
        this.writer.print(" ? ");
        this.visitNode(conditionalExpression.getThenExpression());
        this.writer.print(" : ");
        this.visitNode(conditionalExpression.getElseExpression());
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
        this.visitNodeListWithSeparatorAndSuffix(constructorDeclaration.getMetadata(), " ", " ");
        this.visitTokenWithSuffix(constructorDeclaration.getExternalKeyword(), " ");
        this.visitTokenWithSuffix(constructorDeclaration.getConstKeyword(), " ");
        this.visitTokenWithSuffix(constructorDeclaration.getFactoryKeyword(), " ");
        this.visitNode(constructorDeclaration.getReturnType());
        this.visitNodeWithPrefix(".", constructorDeclaration.getName());
        this.visitNode(constructorDeclaration.getParameters());
        this.visitNodeListWithSeparatorAndPrefix(" : ", constructorDeclaration.getInitializers(), ", ");
        this.visitNodeWithPrefix(" = ", constructorDeclaration.getRedirectedConstructor());
        this.visitFunctionWithPrefix(" ", constructorDeclaration.getBody());
        return null;
    }

    @Override
    public Void visitConstructorFieldInitializer(ConstructorFieldInitializer constructorFieldInitializer) {
        this.visitTokenWithSuffix(constructorFieldInitializer.getKeyword(), ".");
        this.visitNode(constructorFieldInitializer.getFieldName());
        this.writer.print(" = ");
        this.visitNode(constructorFieldInitializer.getExpression());
        return null;
    }

    @Override
    public Void visitConstructorName(ConstructorName constructorName) {
        this.visitNode(constructorName.getType());
        this.visitNodeWithPrefix(".", constructorName.getName());
        return null;
    }

    @Override
    public Void visitContinueStatement(ContinueStatement continueStatement) {
        this.writer.print("continue");
        this.visitNodeWithPrefix(" ", continueStatement.getLabel());
        this.writer.print(";");
        return null;
    }

    @Override
    public Void visitDeclaredIdentifier(DeclaredIdentifier declaredIdentifier) {
        this.visitNodeListWithSeparatorAndSuffix(declaredIdentifier.getMetadata(), " ", " ");
        this.visitTokenWithSuffix(declaredIdentifier.getKeyword(), " ");
        this.visitNodeWithSuffix(declaredIdentifier.getType(), " ");
        this.visitNode(declaredIdentifier.getIdentifier());
        return null;
    }

    @Override
    public Void visitDefaultFormalParameter(DefaultFormalParameter defaultFormalParameter) {
        this.visitNode(defaultFormalParameter.getParameter());
        if (defaultFormalParameter.getSeparator() != null) {
            this.writer.print(" ");
            this.writer.print(defaultFormalParameter.getSeparator().getLexeme());
            this.visitNodeWithPrefix(" ", defaultFormalParameter.getDefaultValue());
        }
        return null;
    }

    @Override
    public Void visitDoStatement(DoStatement doStatement) {
        this.writer.print("do ");
        this.visitNode(doStatement.getBody());
        this.writer.print(" while (");
        this.visitNode(doStatement.getCondition());
        this.writer.print(");");
        return null;
    }

    @Override
    public Void visitDoubleLiteral(DoubleLiteral doubleLiteral) {
        this.writer.print(doubleLiteral.getLiteral().getLexeme());
        return null;
    }

    @Override
    public Void visitEmptyFunctionBody(EmptyFunctionBody emptyFunctionBody) {
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitEmptyStatement(EmptyStatement emptyStatement) {
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitExportDirective(ExportDirective exportDirective) {
        this.visitNodeListWithSeparatorAndSuffix(exportDirective.getMetadata(), " ", " ");
        this.writer.print("export ");
        this.visitNode(exportDirective.getUri());
        this.visitNodeListWithSeparatorAndPrefix(" ", exportDirective.getCombinators(), " ");
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitExpressionFunctionBody(ExpressionFunctionBody expressionFunctionBody) {
        this.writer.print("=> ");
        this.visitNode(expressionFunctionBody.getExpression());
        if (expressionFunctionBody.getSemicolon() != null) {
            this.writer.print(';');
        }
        return null;
    }

    @Override
    public Void visitExpressionStatement(ExpressionStatement expressionStatement) {
        this.visitNode(expressionStatement.getExpression());
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitExtendsClause(ExtendsClause extendsClause) {
        this.writer.print("extends ");
        this.visitNode(extendsClause.getSuperclass());
        return null;
    }

    @Override
    public Void visitFieldDeclaration(FieldDeclaration fieldDeclaration) {
        this.visitNodeListWithSeparatorAndSuffix(fieldDeclaration.getMetadata(), " ", " ");
        this.visitTokenWithSuffix(fieldDeclaration.getStaticKeyword(), " ");
        this.visitNode(fieldDeclaration.getFields());
        this.writer.print(";");
        return null;
    }

    @Override
    public Void visitFieldFormalParameter(FieldFormalParameter fieldFormalParameter) {
        this.visitTokenWithSuffix(fieldFormalParameter.getKeyword(), " ");
        this.visitNodeWithSuffix(fieldFormalParameter.getType(), " ");
        this.writer.print("this.");
        this.visitNode(fieldFormalParameter.getIdentifier());
        this.visitNode(fieldFormalParameter.getParameters());
        return null;
    }

    @Override
    public Void visitForEachStatement(ForEachStatement forEachStatement) {
        DeclaredIdentifier declaredIdentifier = forEachStatement.getLoopVariable();
        this.writer.print("for (");
        if (declaredIdentifier == null) {
            this.visitNode(forEachStatement.getIdentifier());
        } else {
            this.visitNode(declaredIdentifier);
        }
        this.writer.print(" in ");
        this.visitNode(forEachStatement.getIterator());
        this.writer.print(") ");
        this.visitNode(forEachStatement.getBody());
        return null;
    }

    @Override
    public Void visitFormalParameterList(FormalParameterList formalParameterList) {
        String string = null;
        this.writer.print('(');
        NodeList<FormalParameter> nodeList = formalParameterList.getParameters();
        int n = nodeList.size();
        for (int i = 0; i < n; ++i) {
            FormalParameter formalParameter = (FormalParameter)nodeList.get(i);
            if (i > 0) {
                this.writer.print(", ");
            }
            if (string == null && formalParameter instanceof DefaultFormalParameter) {
                if (formalParameter.getKind() == ParameterKind.NAMED) {
                    string = "}";
                    this.writer.print('{');
                } else {
                    string = "]";
                    this.writer.print('[');
                }
            }
            formalParameter.accept(this);
        }
        if (string != null) {
            this.writer.print(string);
        }
        this.writer.print(')');
        return null;
    }

    @Override
    public Void visitForStatement(ForStatement forStatement) {
        Expression expression = forStatement.getInitialization();
        this.writer.print("for (");
        if (expression != null) {
            this.visitNode(expression);
        } else {
            this.visitNode(forStatement.getVariables());
        }
        this.writer.print(";");
        this.visitNodeWithPrefix(" ", forStatement.getCondition());
        this.writer.print(";");
        this.visitNodeListWithSeparatorAndPrefix(" ", forStatement.getUpdaters(), ", ");
        this.writer.print(") ");
        this.visitNode(forStatement.getBody());
        return null;
    }

    @Override
    public Void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
        this.visitNodeListWithSeparatorAndSuffix(functionDeclaration.getMetadata(), " ", " ");
        this.visitNodeWithSuffix(functionDeclaration.getReturnType(), " ");
        this.visitTokenWithSuffix(functionDeclaration.getPropertyKeyword(), " ");
        this.visitNode(functionDeclaration.getName());
        this.visitNode(functionDeclaration.getFunctionExpression());
        return null;
    }

    @Override
    public Void visitFunctionDeclarationStatement(FunctionDeclarationStatement functionDeclarationStatement) {
        this.visitNode(functionDeclarationStatement.getFunctionDeclaration());
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitFunctionExpression(FunctionExpression functionExpression) {
        this.visitNode(functionExpression.getParameters());
        this.writer.print(' ');
        this.visitNode(functionExpression.getBody());
        return null;
    }

    @Override
    public Void visitFunctionExpressionInvocation(FunctionExpressionInvocation functionExpressionInvocation) {
        this.visitNode(functionExpressionInvocation.getFunction());
        this.visitNode(functionExpressionInvocation.getArgumentList());
        return null;
    }

    @Override
    public Void visitFunctionTypeAlias(FunctionTypeAlias functionTypeAlias) {
        this.visitNodeListWithSeparatorAndSuffix(functionTypeAlias.getMetadata(), " ", " ");
        this.writer.print("typedef ");
        this.visitNodeWithSuffix(functionTypeAlias.getReturnType(), " ");
        this.visitNode(functionTypeAlias.getName());
        this.visitNode(functionTypeAlias.getTypeParameters());
        this.visitNode(functionTypeAlias.getParameters());
        this.writer.print(";");
        return null;
    }

    @Override
    public Void visitFunctionTypedFormalParameter(FunctionTypedFormalParameter functionTypedFormalParameter) {
        this.visitNodeWithSuffix(functionTypedFormalParameter.getReturnType(), " ");
        this.visitNode(functionTypedFormalParameter.getIdentifier());
        this.visitNode(functionTypedFormalParameter.getParameters());
        return null;
    }

    @Override
    public Void visitHideCombinator(HideCombinator hideCombinator) {
        this.writer.print("hide ");
        this.visitNodeListWithSeparator(hideCombinator.getHiddenNames(), ", ");
        return null;
    }

    @Override
    public Void visitIfStatement(IfStatement ifStatement) {
        this.writer.print("if (");
        this.visitNode(ifStatement.getCondition());
        this.writer.print(") ");
        this.visitNode(ifStatement.getThenStatement());
        this.visitNodeWithPrefix(" else ", ifStatement.getElseStatement());
        return null;
    }

    @Override
    public Void visitImplementsClause(ImplementsClause implementsClause) {
        this.writer.print("implements ");
        this.visitNodeListWithSeparator(implementsClause.getInterfaces(), ", ");
        return null;
    }

    @Override
    public Void visitImportDirective(ImportDirective importDirective) {
        this.visitNodeListWithSeparatorAndSuffix(importDirective.getMetadata(), " ", " ");
        this.writer.print("import ");
        this.visitNode(importDirective.getUri());
        this.visitNodeWithPrefix(" as ", importDirective.getPrefix());
        this.visitNodeListWithSeparatorAndPrefix(" ", importDirective.getCombinators(), " ");
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitIndexExpression(IndexExpression indexExpression) {
        if (indexExpression.isCascaded()) {
            this.writer.print("..");
        } else {
            this.visitNode(indexExpression.getTarget());
        }
        this.writer.print('[');
        this.visitNode(indexExpression.getIndex());
        this.writer.print(']');
        return null;
    }

    @Override
    public Void visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
        this.visitTokenWithSuffix(instanceCreationExpression.getKeyword(), " ");
        this.visitNode(instanceCreationExpression.getConstructorName());
        this.visitNode(instanceCreationExpression.getArgumentList());
        return null;
    }

    @Override
    public Void visitIntegerLiteral(IntegerLiteral integerLiteral) {
        this.writer.print(integerLiteral.getLiteral().getLexeme());
        return null;
    }

    @Override
    public Void visitInterpolationExpression(InterpolationExpression interpolationExpression) {
        if (interpolationExpression.getRightBracket() != null) {
            this.writer.print("${");
            this.visitNode(interpolationExpression.getExpression());
            this.writer.print("}");
        } else {
            this.writer.print("$");
            this.visitNode(interpolationExpression.getExpression());
        }
        return null;
    }

    @Override
    public Void visitInterpolationString(InterpolationString interpolationString) {
        this.writer.print(interpolationString.getContents().getLexeme());
        return null;
    }

    @Override
    public Void visitIsExpression(IsExpression isExpression) {
        this.visitNode(isExpression.getExpression());
        if (isExpression.getNotOperator() == null) {
            this.writer.print(" is ");
        } else {
            this.writer.print(" is! ");
        }
        this.visitNode(isExpression.getType());
        return null;
    }

    @Override
    public Void visitLabel(Label label) {
        this.visitNode(label.getLabel());
        this.writer.print(":");
        return null;
    }

    @Override
    public Void visitLabeledStatement(LabeledStatement labeledStatement) {
        this.visitNodeListWithSeparatorAndSuffix(labeledStatement.getLabels(), " ", " ");
        this.visitNode(labeledStatement.getStatement());
        return null;
    }

    @Override
    public Void visitLibraryDirective(LibraryDirective libraryDirective) {
        this.visitNodeListWithSeparatorAndSuffix(libraryDirective.getMetadata(), " ", " ");
        this.writer.print("library ");
        this.visitNode(libraryDirective.getName());
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitLibraryIdentifier(LibraryIdentifier libraryIdentifier) {
        this.writer.print(libraryIdentifier.getName());
        return null;
    }

    @Override
    public Void visitListLiteral(ListLiteral listLiteral) {
        if (listLiteral.getConstKeyword() != null) {
            this.writer.print(listLiteral.getConstKeyword().getLexeme());
            this.writer.print(' ');
        }
        this.visitNodeWithSuffix(listLiteral.getTypeArguments(), " ");
        this.writer.print("[");
        this.visitNodeListWithSeparator(listLiteral.getElements(), ", ");
        this.writer.print("]");
        return null;
    }

    @Override
    public Void visitMapLiteral(MapLiteral mapLiteral) {
        if (mapLiteral.getConstKeyword() != null) {
            this.writer.print(mapLiteral.getConstKeyword().getLexeme());
            this.writer.print(' ');
        }
        this.visitNodeWithSuffix(mapLiteral.getTypeArguments(), " ");
        this.writer.print("{");
        this.visitNodeListWithSeparator(mapLiteral.getEntries(), ", ");
        this.writer.print("}");
        return null;
    }

    @Override
    public Void visitMapLiteralEntry(MapLiteralEntry mapLiteralEntry) {
        this.visitNode(mapLiteralEntry.getKey());
        this.writer.print(" : ");
        this.visitNode(mapLiteralEntry.getValue());
        return null;
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration methodDeclaration) {
        this.visitNodeListWithSeparatorAndSuffix(methodDeclaration.getMetadata(), " ", " ");
        this.visitTokenWithSuffix(methodDeclaration.getExternalKeyword(), " ");
        this.visitTokenWithSuffix(methodDeclaration.getModifierKeyword(), " ");
        this.visitNodeWithSuffix(methodDeclaration.getReturnType(), " ");
        this.visitTokenWithSuffix(methodDeclaration.getPropertyKeyword(), " ");
        this.visitTokenWithSuffix(methodDeclaration.getOperatorKeyword(), " ");
        this.visitNode(methodDeclaration.getName());
        if (!methodDeclaration.isGetter()) {
            this.visitNode(methodDeclaration.getParameters());
        }
        this.visitFunctionWithPrefix(" ", methodDeclaration.getBody());
        return null;
    }

    @Override
    public Void visitMethodInvocation(MethodInvocation methodInvocation) {
        if (methodInvocation.isCascaded()) {
            this.writer.print("..");
        } else {
            this.visitNodeWithSuffix(methodInvocation.getTarget(), ".");
        }
        this.visitNode(methodInvocation.getMethodName());
        this.visitNode(methodInvocation.getArgumentList());
        return null;
    }

    @Override
    public Void visitNamedExpression(NamedExpression namedExpression) {
        this.visitNode(namedExpression.getName());
        this.visitNodeWithPrefix(" ", namedExpression.getExpression());
        return null;
    }

    @Override
    public Void visitNativeClause(NativeClause nativeClause) {
        this.writer.print("native ");
        this.visitNode(nativeClause.getName());
        return null;
    }

    @Override
    public Void visitNativeFunctionBody(NativeFunctionBody nativeFunctionBody) {
        this.writer.print("native ");
        this.visitNode(nativeFunctionBody.getStringLiteral());
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitNullLiteral(NullLiteral nullLiteral) {
        this.writer.print("null");
        return null;
    }

    @Override
    public Void visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        this.writer.print('(');
        this.visitNode(parenthesizedExpression.getExpression());
        this.writer.print(')');
        return null;
    }

    @Override
    public Void visitPartDirective(PartDirective partDirective) {
        this.visitNodeListWithSeparatorAndSuffix(partDirective.getMetadata(), " ", " ");
        this.writer.print("part ");
        this.visitNode(partDirective.getUri());
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitPartOfDirective(PartOfDirective partOfDirective) {
        this.visitNodeListWithSeparatorAndSuffix(partOfDirective.getMetadata(), " ", " ");
        this.writer.print("part of ");
        this.visitNode(partOfDirective.getLibraryName());
        this.writer.print(';');
        return null;
    }

    @Override
    public Void visitPostfixExpression(PostfixExpression postfixExpression) {
        this.visitNode(postfixExpression.getOperand());
        this.writer.print(postfixExpression.getOperator().getLexeme());
        return null;
    }

    @Override
    public Void visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        this.visitNode(prefixedIdentifier.getPrefix());
        this.writer.print('.');
        this.visitNode(prefixedIdentifier.getIdentifier());
        return null;
    }

    @Override
    public Void visitPrefixExpression(PrefixExpression prefixExpression) {
        this.writer.print(prefixExpression.getOperator().getLexeme());
        this.visitNode(prefixExpression.getOperand());
        return null;
    }

    @Override
    public Void visitPropertyAccess(PropertyAccess propertyAccess) {
        if (propertyAccess.isCascaded()) {
            this.writer.print("..");
        } else {
            this.visitNode(propertyAccess.getTarget());
            this.writer.print('.');
        }
        this.visitNode(propertyAccess.getPropertyName());
        return null;
    }

    @Override
    public Void visitRedirectingConstructorInvocation(RedirectingConstructorInvocation redirectingConstructorInvocation) {
        this.writer.print("this");
        this.visitNodeWithPrefix(".", redirectingConstructorInvocation.getConstructorName());
        this.visitNode(redirectingConstructorInvocation.getArgumentList());
        return null;
    }

    @Override
    public Void visitRethrowExpression(RethrowExpression rethrowExpression) {
        this.writer.print("rethrow");
        return null;
    }

    @Override
    public Void visitReturnStatement(ReturnStatement returnStatement) {
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            this.writer.print("return;");
        } else {
            this.writer.print("return ");
            expression.accept(this);
            this.writer.print(";");
        }
        return null;
    }

    @Override
    public Void visitScriptTag(ScriptTag scriptTag) {
        this.writer.print(scriptTag.getScriptTag().getLexeme());
        return null;
    }

    @Override
    public Void visitShowCombinator(ShowCombinator showCombinator) {
        this.writer.print("show ");
        this.visitNodeListWithSeparator(showCombinator.getShownNames(), ", ");
        return null;
    }

    @Override
    public Void visitSimpleFormalParameter(SimpleFormalParameter simpleFormalParameter) {
        this.visitTokenWithSuffix(simpleFormalParameter.getKeyword(), " ");
        this.visitNodeWithSuffix(simpleFormalParameter.getType(), " ");
        this.visitNode(simpleFormalParameter.getIdentifier());
        return null;
    }

    @Override
    public Void visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        this.writer.print(simpleIdentifier.getToken().getLexeme());
        return null;
    }

    @Override
    public Void visitSimpleStringLiteral(SimpleStringLiteral simpleStringLiteral) {
        this.writer.print(simpleStringLiteral.getLiteral().getLexeme());
        return null;
    }

    @Override
    public Void visitStringInterpolation(StringInterpolation stringInterpolation) {
        this.visitNodeList(stringInterpolation.getElements());
        return null;
    }

    @Override
    public Void visitSuperConstructorInvocation(SuperConstructorInvocation superConstructorInvocation) {
        this.writer.print("super");
        this.visitNodeWithPrefix(".", superConstructorInvocation.getConstructorName());
        this.visitNode(superConstructorInvocation.getArgumentList());
        return null;
    }

    @Override
    public Void visitSuperExpression(SuperExpression superExpression) {
        this.writer.print("super");
        return null;
    }

    @Override
    public Void visitSwitchCase(SwitchCase switchCase) {
        this.visitNodeListWithSeparatorAndSuffix(switchCase.getLabels(), " ", " ");
        this.writer.print("case ");
        this.visitNode(switchCase.getExpression());
        this.writer.print(": ");
        this.visitNodeListWithSeparator(switchCase.getStatements(), " ");
        return null;
    }

    @Override
    public Void visitSwitchDefault(SwitchDefault switchDefault) {
        this.visitNodeListWithSeparatorAndSuffix(switchDefault.getLabels(), " ", " ");
        this.writer.print("default: ");
        this.visitNodeListWithSeparator(switchDefault.getStatements(), " ");
        return null;
    }

    @Override
    public Void visitSwitchStatement(SwitchStatement switchStatement) {
        this.writer.print("switch (");
        this.visitNode(switchStatement.getExpression());
        this.writer.print(") {");
        this.visitNodeListWithSeparator(switchStatement.getMembers(), " ");
        this.writer.print("}");
        return null;
    }

    @Override
    public Void visitSymbolLiteral(SymbolLiteral symbolLiteral) {
        this.writer.print("#");
        Token[] tokenArray = symbolLiteral.getComponents();
        for (int i = 0; i < tokenArray.length; ++i) {
            if (i > 0) {
                this.writer.print(".");
            }
            this.writer.print(tokenArray[i].getLexeme());
        }
        return null;
    }

    @Override
    public Void visitThisExpression(ThisExpression thisExpression) {
        this.writer.print("this");
        return null;
    }

    @Override
    public Void visitThrowExpression(ThrowExpression throwExpression) {
        this.writer.print("throw ");
        this.visitNode(throwExpression.getExpression());
        return null;
    }

    @Override
    public Void visitTopLevelVariableDeclaration(TopLevelVariableDeclaration topLevelVariableDeclaration) {
        this.visitNodeWithSuffix(topLevelVariableDeclaration.getVariables(), ";");
        return null;
    }

    @Override
    public Void visitTryStatement(TryStatement tryStatement) {
        this.writer.print("try ");
        this.visitNode(tryStatement.getBody());
        this.visitNodeListWithSeparatorAndPrefix(" ", tryStatement.getCatchClauses(), " ");
        this.visitNodeWithPrefix(" finally ", tryStatement.getFinallyBlock());
        return null;
    }

    @Override
    public Void visitTypeArgumentList(TypeArgumentList typeArgumentList) {
        this.writer.print('<');
        this.visitNodeListWithSeparator(typeArgumentList.getArguments(), ", ");
        this.writer.print('>');
        return null;
    }

    @Override
    public Void visitTypeName(TypeName typeName) {
        this.visitNode(typeName.getName());
        this.visitNode(typeName.getTypeArguments());
        return null;
    }

    @Override
    public Void visitTypeParameter(TypeParameter typeParameter) {
        this.visitNodeListWithSeparatorAndSuffix(typeParameter.getMetadata(), " ", " ");
        this.visitNode(typeParameter.getName());
        this.visitNodeWithPrefix(" extends ", typeParameter.getBound());
        return null;
    }

    @Override
    public Void visitTypeParameterList(TypeParameterList typeParameterList) {
        this.writer.print('<');
        this.visitNodeListWithSeparator(typeParameterList.getTypeParameters(), ", ");
        this.writer.print('>');
        return null;
    }

    @Override
    public Void visitVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.visitNodeListWithSeparatorAndSuffix(variableDeclaration.getMetadata(), " ", " ");
        this.visitNode(variableDeclaration.getName());
        this.visitNodeWithPrefix(" = ", variableDeclaration.getInitializer());
        return null;
    }

    @Override
    public Void visitVariableDeclarationList(VariableDeclarationList variableDeclarationList) {
        this.visitNodeListWithSeparatorAndSuffix(variableDeclarationList.getMetadata(), " ", " ");
        this.visitTokenWithSuffix(variableDeclarationList.getKeyword(), " ");
        this.visitNodeWithSuffix(variableDeclarationList.getType(), " ");
        this.visitNodeListWithSeparator(variableDeclarationList.getVariables(), ", ");
        return null;
    }

    @Override
    public Void visitVariableDeclarationStatement(VariableDeclarationStatement variableDeclarationStatement) {
        this.visitNode(variableDeclarationStatement.getVariables());
        this.writer.print(";");
        return null;
    }

    @Override
    public Void visitWhileStatement(WhileStatement whileStatement) {
        this.writer.print("while (");
        this.visitNode(whileStatement.getCondition());
        this.writer.print(") ");
        this.visitNode(whileStatement.getBody());
        return null;
    }

    @Override
    public Void visitWithClause(WithClause withClause) {
        this.writer.print("with ");
        this.visitNodeListWithSeparator(withClause.getMixinTypes(), ", ");
        return null;
    }

    private void visitFunctionWithPrefix(String string, FunctionBody functionBody) {
        if (!(functionBody instanceof EmptyFunctionBody)) {
            this.writer.print(string);
        }
        this.visitNode(functionBody);
    }

    private void visitNode(AstNode astNode) {
        if (astNode != null) {
            astNode.accept(this);
        }
    }

    private void visitNodeList(NodeList<? extends AstNode> nodeList) {
        this.visitNodeListWithSeparator(nodeList, "");
    }

    private void visitNodeListWithSeparator(NodeList<? extends AstNode> nodeList, String string) {
        if (nodeList != null) {
            int n = nodeList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.writer.print(string);
                }
                ((AstNode)nodeList.get(i)).accept(this);
            }
        }
    }

    private void visitNodeListWithSeparatorAndPrefix(String string, NodeList<? extends AstNode> nodeList, String string2) {
        int n;
        if (nodeList != null && (n = nodeList.size()) > 0) {
            this.writer.print(string);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.writer.print(string2);
                }
                ((AstNode)nodeList.get(i)).accept(this);
            }
        }
    }

    private void visitNodeListWithSeparatorAndSuffix(NodeList<? extends AstNode> nodeList, String string, String string2) {
        int n;
        if (nodeList != null && (n = nodeList.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.writer.print(string);
                }
                ((AstNode)nodeList.get(i)).accept(this);
            }
            this.writer.print(string2);
        }
    }

    private void visitNodeWithPrefix(String string, AstNode astNode) {
        if (astNode != null) {
            this.writer.print(string);
            astNode.accept(this);
        }
    }

    private void visitNodeWithSuffix(AstNode astNode, String string) {
        if (astNode != null) {
            astNode.accept(this);
            this.writer.print(string);
        }
    }

    private void visitTokenWithSuffix(Token token, String string) {
        if (token != null) {
            this.writer.print(token.getLexeme());
            this.writer.print(string);
        }
    }
}

