/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast.visitor;

import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.visitor.UnifyingAstVisitor;

public class NodeLocator
extends UnifyingAstVisitor<Void> {
    private final int startOffset;
    private final int endOffset;
    private AstNode foundNode;

    public NodeLocator(int n) {
        this(n, n);
    }

    public NodeLocator(int n, int n2) {
        this.startOffset = n;
        this.endOffset = n2;
    }

    public AstNode getFoundNode() {
        return this.foundNode;
    }

    public AstNode searchWithin(AstNode astNode) {
        if (astNode == null) {
            return null;
        }
        try {
            astNode.accept(this);
        }
        catch (NodeFoundException nodeFoundException) {
        }
        catch (Exception exception) {
            AnalysisEngine.getInstance().getLogger().logInformation("Unable to locate element at offset (" + this.startOffset + " - " + this.endOffset + ")", exception);
            return null;
        }
        return this.foundNode;
    }

    @Override
    public Void visitNode(AstNode astNode) {
        int n = astNode.getOffset();
        int n2 = n + astNode.getLength();
        if (n2 < this.startOffset) {
            return null;
        }
        if (n > this.endOffset) {
            return null;
        }
        try {
            astNode.visitChildren(this);
        }
        catch (NodeFoundException nodeFoundException) {
            throw nodeFoundException;
        }
        catch (Exception exception) {
            AnalysisEngine.getInstance().getLogger().logInformation("Exception caught while traversing an AST structure.", exception);
        }
        if (n <= this.startOffset && this.endOffset <= n2) {
            this.foundNode = astNode;
            throw new NodeFoundException();
        }
        return null;
    }

    private class NodeFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private NodeFoundException() {
        }
    }
}

