/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast.visitor;

import com.google.dart.engine.ast.AssignmentExpression;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.ClassDeclaration;
import com.google.dart.engine.ast.CompilationUnit;
import com.google.dart.engine.ast.ConstructorDeclaration;
import com.google.dart.engine.ast.ConstructorName;
import com.google.dart.engine.ast.FunctionDeclaration;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.ImportDirective;
import com.google.dart.engine.ast.IndexExpression;
import com.google.dart.engine.ast.InstanceCreationExpression;
import com.google.dart.engine.ast.LibraryDirective;
import com.google.dart.engine.ast.LibraryIdentifier;
import com.google.dart.engine.ast.MethodDeclaration;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.PartOfDirective;
import com.google.dart.engine.ast.PostfixExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.UriBasedDirective;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import com.google.dart.engine.element.ClassElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.internal.builder.AngularCompilationUnitBuilder;

public class ElementLocator {
    public static Element locate(AstNode astNode) {
        ElementMapper elementMapper = new ElementMapper();
        return astNode.accept(elementMapper);
    }

    public static Element locateWithOffset(AstNode astNode, int n) {
        Element element = ElementLocator.locate(astNode);
        if (element != null) {
            return element;
        }
        element = AngularCompilationUnitBuilder.getElement(astNode, n);
        if (element != null) {
            return element;
        }
        return null;
    }

    private ElementLocator() {
    }

    private static final class ElementMapper
    extends GeneralizingAstVisitor<Element> {
        private ElementMapper() {
        }

        @Override
        public Element visitAssignmentExpression(AssignmentExpression assignmentExpression) {
            return assignmentExpression.getBestElement();
        }

        @Override
        public Element visitBinaryExpression(BinaryExpression binaryExpression) {
            return binaryExpression.getBestElement();
        }

        @Override
        public Element visitClassDeclaration(ClassDeclaration classDeclaration) {
            return classDeclaration.getElement();
        }

        @Override
        public Element visitCompilationUnit(CompilationUnit compilationUnit) {
            return compilationUnit.getElement();
        }

        @Override
        public Element visitConstructorDeclaration(ConstructorDeclaration constructorDeclaration) {
            return constructorDeclaration.getElement();
        }

        @Override
        public Element visitFunctionDeclaration(FunctionDeclaration functionDeclaration) {
            return functionDeclaration.getElement();
        }

        @Override
        public Element visitIdentifier(Identifier identifier) {
            Object object;
            AstNode astNode = identifier.getParent();
            Object object2 = astNode;
            if (object2 instanceof PrefixedIdentifier && ((PrefixedIdentifier)(object = (PrefixedIdentifier)object2)).getIdentifier() == identifier) {
                object2 = ((AstNode)object).getParent();
            }
            if (object2 instanceof TypeName && ((AstNode)(object = (TypeName)object2)).getParent() instanceof ConstructorName) {
                ConstructorName constructorName = (ConstructorName)((AstNode)object).getParent();
                return constructorName.getStaticElement();
            }
            if (astNode instanceof ConstructorDeclaration && (object = ((ConstructorDeclaration)(object2 = (ConstructorDeclaration)astNode)).getReturnType()) == identifier) {
                SimpleIdentifier simpleIdentifier = ((ConstructorDeclaration)object2).getName();
                if (simpleIdentifier != null) {
                    return simpleIdentifier.getBestElement();
                }
                Element element = identifier.getBestElement();
                if (element instanceof ClassElement) {
                    return ((ClassElement)element).getUnnamedConstructor();
                }
            }
            if (astNode instanceof LibraryIdentifier && (object2 = ((LibraryIdentifier)astNode).getParent()) instanceof PartOfDirective && (object = ((PartOfDirective)object2).getElement()) instanceof LibraryElement) {
                return ((LibraryElement)object).getDefiningCompilationUnit();
            }
            object2 = identifier.getBestElement();
            if (object2 == null) {
                object2 = identifier.getStaticElement();
            }
            return object2;
        }

        @Override
        public Element visitImportDirective(ImportDirective importDirective) {
            return importDirective.getElement();
        }

        @Override
        public Element visitIndexExpression(IndexExpression indexExpression) {
            return indexExpression.getBestElement();
        }

        @Override
        public Element visitInstanceCreationExpression(InstanceCreationExpression instanceCreationExpression) {
            return instanceCreationExpression.getStaticElement();
        }

        @Override
        public Element visitLibraryDirective(LibraryDirective libraryDirective) {
            return libraryDirective.getElement();
        }

        @Override
        public Element visitMethodDeclaration(MethodDeclaration methodDeclaration) {
            return methodDeclaration.getElement();
        }

        @Override
        public Element visitMethodInvocation(MethodInvocation methodInvocation) {
            return methodInvocation.getMethodName().getBestElement();
        }

        @Override
        public Element visitPostfixExpression(PostfixExpression postfixExpression) {
            return postfixExpression.getBestElement();
        }

        @Override
        public Element visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
            return prefixedIdentifier.getBestElement();
        }

        @Override
        public Element visitPrefixExpression(PrefixExpression prefixExpression) {
            return prefixExpression.getBestElement();
        }

        @Override
        public Element visitStringLiteral(StringLiteral stringLiteral) {
            AstNode astNode = stringLiteral.getParent();
            if (astNode instanceof UriBasedDirective) {
                return ((UriBasedDirective)astNode).getUriElement();
            }
            return null;
        }

        @Override
        public Element visitVariableDeclaration(VariableDeclaration variableDeclaration) {
            return variableDeclaration.getElement();
        }
    }
}

