/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast.visitor;

import com.google.dart.engine.ast.AdjacentStrings;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.BinaryExpression;
import com.google.dart.engine.ast.BooleanLiteral;
import com.google.dart.engine.ast.DoubleLiteral;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.IntegerLiteral;
import com.google.dart.engine.ast.InterpolationElement;
import com.google.dart.engine.ast.InterpolationExpression;
import com.google.dart.engine.ast.InterpolationString;
import com.google.dart.engine.ast.ListLiteral;
import com.google.dart.engine.ast.MapLiteral;
import com.google.dart.engine.ast.MapLiteralEntry;
import com.google.dart.engine.ast.MethodInvocation;
import com.google.dart.engine.ast.NullLiteral;
import com.google.dart.engine.ast.ParenthesizedExpression;
import com.google.dart.engine.ast.PrefixExpression;
import com.google.dart.engine.ast.PrefixedIdentifier;
import com.google.dart.engine.ast.PropertyAccess;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.SimpleStringLiteral;
import com.google.dart.engine.ast.StringInterpolation;
import com.google.dart.engine.ast.StringLiteral;
import com.google.dart.engine.ast.SymbolLiteral;
import com.google.dart.engine.ast.visitor.GeneralizingAstVisitor;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.FieldElement;
import com.google.dart.engine.scanner.Token;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstantEvaluator
extends GeneralizingAstVisitor<Object> {
    public static final Object NOT_A_CONSTANT = new Object();

    @Override
    public Object visitAdjacentStrings(AdjacentStrings adjacentStrings) {
        StringBuilder stringBuilder = new StringBuilder();
        for (StringLiteral stringLiteral : adjacentStrings.getStrings()) {
            Object object = stringLiteral.accept(this);
            if (object == NOT_A_CONSTANT) {
                return object;
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object visitBinaryExpression(BinaryExpression binaryExpression) {
        Object object = binaryExpression.getLeftOperand().accept(this);
        if (object == NOT_A_CONSTANT) {
            return object;
        }
        Object object2 = binaryExpression.getRightOperand().accept(this);
        if (object2 == NOT_A_CONSTANT) {
            return object2;
        }
        switch (binaryExpression.getOperator().getType()) {
            case AMPERSAND: {
                if (!(object instanceof BigInteger) || !(object2 instanceof BigInteger)) break;
                return ((BigInteger)object).and((BigInteger)object2);
            }
            case AMPERSAND_AMPERSAND: {
                if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) break;
                return (Boolean)object != false && (Boolean)object2 != false;
            }
            case BANG_EQ: {
                if (object instanceof Boolean && object2 instanceof Boolean) {
                    return ((Boolean)object).booleanValue() != ((Boolean)object2).booleanValue();
                }
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return !((BigInteger)object).equals(object2);
                }
                if (object instanceof Double && object2 instanceof Double) {
                    return !((Double)object).equals(object2);
                }
                if (!(object instanceof String) || !(object2 instanceof String)) break;
                return !((String)object).equals(object2);
            }
            case BAR: {
                if (!(object instanceof BigInteger) || !(object2 instanceof BigInteger)) break;
                return ((BigInteger)object).or((BigInteger)object2);
            }
            case BAR_BAR: {
                if (!(object instanceof Boolean) || !(object2 instanceof Boolean)) break;
                return (Boolean)object != false || (Boolean)object2 != false;
            }
            case CARET: {
                if (!(object instanceof BigInteger) || !(object2 instanceof BigInteger)) break;
                return ((BigInteger)object).xor((BigInteger)object2);
            }
            case EQ_EQ: {
                if (object instanceof Boolean && object2 instanceof Boolean) {
                    return ((Boolean)object).booleanValue() == ((Boolean)object2).booleanValue();
                }
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).equals(object2);
                }
                if (object instanceof Double && object2 instanceof Double) {
                    return ((Double)object).equals(object2);
                }
                if (!(object instanceof String) || !(object2 instanceof String)) break;
                return ((String)object).equals(object2);
            }
            case GT: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).compareTo((BigInteger)object2) > 0;
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return ((Double)object).compareTo((Double)object2) > 0;
            }
            case GT_EQ: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).compareTo((BigInteger)object2) >= 0;
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return ((Double)object).compareTo((Double)object2) >= 0;
            }
            case GT_GT: {
                if (!(object instanceof BigInteger) || !(object2 instanceof BigInteger)) break;
                return ((BigInteger)object).shiftRight(((BigInteger)object2).intValue());
            }
            case LT: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).compareTo((BigInteger)object2) < 0;
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return ((Double)object).compareTo((Double)object2) < 0;
            }
            case LT_EQ: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).compareTo((BigInteger)object2) <= 0;
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return ((Double)object).compareTo((Double)object2) <= 0;
            }
            case LT_LT: {
                if (!(object instanceof BigInteger) || !(object2 instanceof BigInteger)) break;
                return ((BigInteger)object).shiftLeft(((BigInteger)object2).intValue());
            }
            case MINUS: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).subtract((BigInteger)object2);
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return (Double)object - (Double)object2;
            }
            case PERCENT: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).remainder((BigInteger)object2);
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return (Double)object % (Double)object2;
            }
            case PLUS: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).add((BigInteger)object2);
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return (Double)object + (Double)object2;
            }
            case STAR: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    return ((BigInteger)object).multiply((BigInteger)object2);
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return (Double)object * (Double)object2;
            }
            case SLASH: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    if (!object2.equals(BigInteger.ZERO)) {
                        return ((BigInteger)object).divide((BigInteger)object2);
                    }
                    return ((BigInteger)object).doubleValue() / ((BigInteger)object2).doubleValue();
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return (Double)object / (Double)object2;
            }
            case TILDE_SLASH: {
                if (object instanceof BigInteger && object2 instanceof BigInteger) {
                    if (!object2.equals(BigInteger.ZERO)) {
                        return ((BigInteger)object).divide((BigInteger)object2);
                    }
                    return BigInteger.ZERO;
                }
                if (!(object instanceof Double) || !(object2 instanceof Double)) break;
                return BigInteger.valueOf(Double.valueOf(Math.floor((Double)object / (Double)object2)).longValue());
            }
        }
        return this.visitExpression(binaryExpression);
    }

    @Override
    public Object visitBooleanLiteral(BooleanLiteral booleanLiteral) {
        return booleanLiteral.getValue() ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visitDoubleLiteral(DoubleLiteral doubleLiteral) {
        return doubleLiteral.getValue();
    }

    @Override
    public Object visitIntegerLiteral(IntegerLiteral integerLiteral) {
        return integerLiteral.getValue();
    }

    @Override
    public Object visitInterpolationExpression(InterpolationExpression interpolationExpression) {
        Object object = interpolationExpression.getExpression().accept(this);
        if (object == null || object instanceof Boolean || object instanceof String || object instanceof BigInteger || object instanceof Double) {
            return object;
        }
        return NOT_A_CONSTANT;
    }

    @Override
    public Object visitInterpolationString(InterpolationString interpolationString) {
        return interpolationString.getValue();
    }

    @Override
    public Object visitListLiteral(ListLiteral listLiteral) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Expression expression : listLiteral.getElements()) {
            Object object = expression.accept(this);
            if (object == NOT_A_CONSTANT) {
                return object;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    @Override
    public Object visitMapLiteral(MapLiteral mapLiteral) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (MapLiteralEntry mapLiteralEntry : mapLiteral.getEntries()) {
            Object object = mapLiteralEntry.getKey().accept(this);
            Object object2 = mapLiteralEntry.getValue().accept(this);
            if (!(object instanceof String) || object2 == NOT_A_CONSTANT) {
                return NOT_A_CONSTANT;
            }
            hashMap.put((String)object, object2);
        }
        return hashMap;
    }

    @Override
    public Object visitMethodInvocation(MethodInvocation methodInvocation) {
        return this.visitNode(methodInvocation);
    }

    @Override
    public Object visitNode(AstNode astNode) {
        return NOT_A_CONSTANT;
    }

    @Override
    public Object visitNullLiteral(NullLiteral nullLiteral) {
        return null;
    }

    @Override
    public Object visitParenthesizedExpression(ParenthesizedExpression parenthesizedExpression) {
        return parenthesizedExpression.getExpression().accept(this);
    }

    @Override
    public Object visitPrefixedIdentifier(PrefixedIdentifier prefixedIdentifier) {
        return this.getConstantValue(null);
    }

    @Override
    public Object visitPrefixExpression(PrefixExpression prefixExpression) {
        Object object = prefixExpression.getOperand().accept(this);
        if (object == NOT_A_CONSTANT) {
            return object;
        }
        switch (prefixExpression.getOperator().getType()) {
            case BANG: {
                if (object == Boolean.TRUE) {
                    return Boolean.FALSE;
                }
                if (object != Boolean.FALSE) break;
                return Boolean.TRUE;
            }
            case TILDE: {
                if (!(object instanceof BigInteger)) break;
                return ((BigInteger)object).not();
            }
            case MINUS: {
                if (object == null) {
                    return null;
                }
                if (object instanceof BigInteger) {
                    return ((BigInteger)object).negate();
                }
                if (!(object instanceof Double)) break;
                return -((Double)object).doubleValue();
            }
        }
        return NOT_A_CONSTANT;
    }

    @Override
    public Object visitPropertyAccess(PropertyAccess propertyAccess) {
        return this.getConstantValue(null);
    }

    @Override
    public Object visitSimpleIdentifier(SimpleIdentifier simpleIdentifier) {
        return this.getConstantValue(null);
    }

    @Override
    public Object visitSimpleStringLiteral(SimpleStringLiteral simpleStringLiteral) {
        return simpleStringLiteral.getValue();
    }

    @Override
    public Object visitStringInterpolation(StringInterpolation stringInterpolation) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InterpolationElement interpolationElement : stringInterpolation.getElements()) {
            Object object = interpolationElement.accept(this);
            if (object == NOT_A_CONSTANT) {
                return object;
            }
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    @Override
    public Object visitSymbolLiteral(SymbolLiteral symbolLiteral) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : symbolLiteral.getComponents()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(token.getLexeme());
        }
        return stringBuilder.toString();
    }

    private Object getConstantValue(Element element) {
        FieldElement fieldElement;
        if (!(element instanceof FieldElement) || !(fieldElement = (FieldElement)element).isStatic() || fieldElement.isConst()) {
            // empty if block
        }
        return NOT_A_CONSTANT;
    }
}

