/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.scanner.Token;

public class WhileStatement
extends Statement {
    private Token keyword;
    private Token leftParenthesis;
    private Expression condition;
    private Token rightParenthesis;
    private Statement body;

    public WhileStatement(Token token, Token token2, Expression expression, Token token3, Statement statement) {
        this.keyword = token;
        this.leftParenthesis = token2;
        this.condition = this.becomeParentOf(expression);
        this.rightParenthesis = token3;
        this.body = this.becomeParentOf(statement);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitWhileStatement(this);
    }

    @Override
    public Token getBeginToken() {
        return this.keyword;
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public Token getEndToken() {
        return this.body.getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public void setBody(Statement statement) {
        this.body = this.becomeParentOf(statement);
    }

    public void setCondition(Expression expression) {
        this.condition = this.becomeParentOf(expression);
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.condition, astVisitor);
        this.safelyVisitChild(this.body, astVisitor);
    }
}

