/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AnnotatedNode;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.ast.VariableDeclaration;
import com.google.dart.engine.scanner.Keyword;
import com.google.dart.engine.scanner.KeywordToken;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class VariableDeclarationList
extends AnnotatedNode {
    private Token keyword;
    private TypeName type;
    private NodeList<VariableDeclaration> variables = new NodeList(this);

    public VariableDeclarationList(Comment comment, List<Annotation> list, Token token, TypeName typeName, List<VariableDeclaration> list2) {
        super(comment, list);
        this.keyword = token;
        this.type = this.becomeParentOf(typeName);
        this.variables.addAll(list2);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitVariableDeclarationList(this);
    }

    @Override
    public Token getEndToken() {
        return this.variables.getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public TypeName getType() {
        return this.type;
    }

    public NodeList<VariableDeclaration> getVariables() {
        return this.variables;
    }

    public boolean isConst() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.CONST;
    }

    public boolean isFinal() {
        return this.keyword instanceof KeywordToken && ((KeywordToken)this.keyword).getKeyword() == Keyword.FINAL;
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setType(TypeName typeName) {
        this.type = this.becomeParentOf(typeName);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.type, astVisitor);
        this.variables.accept(astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        if (this.keyword != null) {
            return this.keyword;
        }
        if (this.type != null) {
            return this.type.getBeginToken();
        }
        return this.variables.getBeginToken();
    }
}

