/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AnnotatedNode;
import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.VariableDeclarationList;
import com.google.dart.engine.element.VariableElement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class VariableDeclaration
extends Declaration {
    private SimpleIdentifier name;
    private Token equals;
    private Expression initializer;

    public VariableDeclaration(Comment comment, List<Annotation> list, SimpleIdentifier simpleIdentifier, Token token, Expression expression) {
        super(comment, list);
        this.name = this.becomeParentOf(simpleIdentifier);
        this.equals = token;
        this.initializer = this.becomeParentOf(expression);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitVariableDeclaration(this);
    }

    @Override
    public Comment getDocumentationComment() {
        AstNode astNode;
        Comment comment = super.getDocumentationComment();
        if (comment == null && this.getParent() != null && this.getParent().getParent() != null && (astNode = this.getParent().getParent()) instanceof AnnotatedNode) {
            return ((AnnotatedNode)astNode).getDocumentationComment();
        }
        return comment;
    }

    @Override
    public VariableElement getElement() {
        return this.name != null ? (VariableElement)this.name.getStaticElement() : null;
    }

    @Override
    public Token getEndToken() {
        if (this.initializer != null) {
            return this.initializer.getEndToken();
        }
        return this.name.getEndToken();
    }

    public Token getEquals() {
        return this.equals;
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public boolean isConst() {
        AstNode astNode = this.getParent();
        return astNode instanceof VariableDeclarationList && ((VariableDeclarationList)astNode).isConst();
    }

    public boolean isFinal() {
        AstNode astNode = this.getParent();
        return astNode instanceof VariableDeclarationList && ((VariableDeclarationList)astNode).isFinal();
    }

    public void setEquals(Token token) {
        this.equals = token;
    }

    public void setInitializer(Expression expression) {
        this.initializer = this.becomeParentOf(expression);
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.initializer, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        return this.name.getBeginToken();
    }
}

