/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.Declaration;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.ast.TypeName;
import com.google.dart.engine.element.TypeParameterElement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class TypeParameter
extends Declaration {
    private SimpleIdentifier name;
    private Token keyword;
    private TypeName bound;

    public TypeParameter(Comment comment, List<Annotation> list, SimpleIdentifier simpleIdentifier, Token token, TypeName typeName) {
        super(comment, list);
        this.name = this.becomeParentOf(simpleIdentifier);
        this.keyword = token;
        this.bound = this.becomeParentOf(typeName);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitTypeParameter(this);
    }

    public TypeName getBound() {
        return this.bound;
    }

    @Override
    public TypeParameterElement getElement() {
        return this.name != null ? (TypeParameterElement)this.name.getStaticElement() : null;
    }

    @Override
    public Token getEndToken() {
        if (this.bound == null) {
            return this.name.getEndToken();
        }
        return this.bound.getEndToken();
    }

    public Token getKeyword() {
        return this.keyword;
    }

    public SimpleIdentifier getName() {
        return this.name;
    }

    public void setBound(TypeName typeName) {
        this.bound = this.becomeParentOf(typeName);
    }

    public void setKeyword(Token token) {
        this.keyword = token;
    }

    public void setName(SimpleIdentifier simpleIdentifier) {
        this.name = this.becomeParentOf(simpleIdentifier);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        super.visitChildren(astVisitor);
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.bound, astVisitor);
    }

    @Override
    protected Token getFirstTokenAfterCommentAndMetadata() {
        return this.name.getBeginToken();
    }
}

