/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.TypeArgumentList;
import com.google.dart.engine.scanner.Token;
import com.google.dart.engine.type.Type;

public class TypeName
extends AstNode {
    private Identifier name;
    private TypeArgumentList typeArguments;
    private Type type;

    public TypeName(Identifier identifier, TypeArgumentList typeArgumentList) {
        this.name = this.becomeParentOf(identifier);
        this.typeArguments = this.becomeParentOf(typeArgumentList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitTypeName(this);
    }

    @Override
    public Token getBeginToken() {
        return this.name.getBeginToken();
    }

    @Override
    public Token getEndToken() {
        if (this.typeArguments != null) {
            return this.typeArguments.getEndToken();
        }
        return this.name.getEndToken();
    }

    public Identifier getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public TypeArgumentList getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public boolean isSynthetic() {
        return this.name.isSynthetic() && this.typeArguments == null;
    }

    public void setName(Identifier identifier) {
        this.name = this.becomeParentOf(identifier);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setTypeArguments(TypeArgumentList typeArgumentList) {
        this.typeArguments = this.becomeParentOf(typeArgumentList);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.typeArguments, astVisitor);
    }
}

