/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Block;
import com.google.dart.engine.ast.CatchClause;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.ast.Statement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class TryStatement
extends Statement {
    private Token tryKeyword;
    private Block body;
    private NodeList<CatchClause> catchClauses = new NodeList(this);
    private Token finallyKeyword;
    private Block finallyBlock;

    public TryStatement(Token token, Block block, List<CatchClause> list, Token token2, Block block2) {
        this.tryKeyword = token;
        this.body = this.becomeParentOf(block);
        this.catchClauses.addAll(list);
        this.finallyKeyword = token2;
        this.finallyBlock = this.becomeParentOf(block2);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitTryStatement(this);
    }

    @Override
    public Token getBeginToken() {
        return this.tryKeyword;
    }

    public Block getBody() {
        return this.body;
    }

    public NodeList<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    @Override
    public Token getEndToken() {
        if (this.finallyBlock != null) {
            return this.finallyBlock.getEndToken();
        }
        if (this.finallyKeyword != null) {
            return this.finallyKeyword;
        }
        if (!this.catchClauses.isEmpty()) {
            return this.catchClauses.getEndToken();
        }
        return this.body.getEndToken();
    }

    public Block getFinallyBlock() {
        return this.finallyBlock;
    }

    public Token getFinallyKeyword() {
        return this.finallyKeyword;
    }

    public Token getTryKeyword() {
        return this.tryKeyword;
    }

    public void setBody(Block block) {
        this.body = this.becomeParentOf(block);
    }

    public void setFinallyBlock(Block block) {
        this.finallyBlock = this.becomeParentOf(block);
    }

    public void setFinallyKeyword(Token token) {
        this.finallyKeyword = token;
    }

    public void setTryKeyword(Token token) {
        this.tryKeyword = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.body, astVisitor);
        this.catchClauses.accept(astVisitor);
        this.safelyVisitChild(this.finallyBlock, astVisitor);
    }
}

